/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.db.hb.PersonCorrelation;

public class PersonCorrelationFilterFactory {
    public static final int MODE_AND = 1;
    public static final int MODE_OR = 1;

    public static FilterCriteria createFilterStatus(String correlationStatus) {
        return new CorrelationStatusFilter(correlationStatus);
    }

    public static FilterCriteria createFilterStationNumber(String stationNumber) {
        return new CorrelationStationNumberFilter(stationNumber);
    }

    public static FilterCriteria createFilterStationNumber(String[] stationNumbers) {
        return new CorrelationStationNumberFilter(stationNumbers);
    }

    public static FilterCriteria createFilterIdType(String typeCode) {
        return new CorrelationIdTypeFilter(typeCode);
    }

    public static FilterCriteria createFilterIdType(Long typeId) {
        return new CorrelationIdTypeFilter(typeId);
    }

    public static FilterCriteria createFilterAltkey1(String altKey1) {
        return new CorrelationAltkey1Filter(altKey1);
    }

    private static class CorrelationAltkey1Filter
    implements FilterCriteria {
        private String altkey1;
        private boolean inverse;

        CorrelationAltkey1Filter(String altkey1) {
            this(altkey1, false);
        }

        CorrelationAltkey1Filter(String altkey1, boolean inverse) {
            this.altkey1 = altkey1;
            this.inverse = inverse;
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonCorrelation) {
                PersonCorrelation correlation = (PersonCorrelation)obj;
                String dbValue = correlation.getAltKey1();
                if (dbValue == null) {
                    dbValue = "";
                }
                boolean isMatch = this.altkey1.equalsIgnoreCase(dbValue);
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class CorrelationIdTypeFilter
    implements FilterCriteria {
        private Long identifierTypeId;
        private String IdTypeCode = "";
        private boolean inverse = false;

        CorrelationIdTypeFilter(Long typeId, boolean inverse) {
            this.identifierTypeId = typeId;
            this.inverse = inverse;
        }

        CorrelationIdTypeFilter(String checkIdTypeCode, boolean inverse) {
            this.IdTypeCode = checkIdTypeCode;
        }

        public CorrelationIdTypeFilter(Long typeId) {
            this(typeId, false);
        }

        public CorrelationIdTypeFilter(String checkIdTypeCode) {
            this(checkIdTypeCode, false);
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = false;
            if (obj != null && obj instanceof PersonCorrelation) {
                PersonCorrelation correlation = (PersonCorrelation)obj;
                if (this.IdTypeCode != null && this.IdTypeCode.length() > 0) {
                    isMatch = this.IdTypeCode.equalsIgnoreCase(correlation.getIdentifierType().getCode());
                } else {
                    boolean bl = isMatch = correlation.getIdentifierTypeId().longValue() == this.identifierTypeId.longValue();
                }
            }
            if (this.inverse) {
                return !isMatch;
            }
            return isMatch;
        }
    }

    private static class CorrelationStationNumberFilter
    implements FilterCriteria {
        private String[] stationNumberList;
        private boolean inverse;

        CorrelationStationNumberFilter(String[] stationNumberList, boolean inverse) {
            this.stationNumberList = stationNumberList;
            this.inverse = inverse;
        }

        CorrelationStationNumberFilter(String stationNumber, boolean inverse) {
            this.stationNumberList = new String[1];
            this.stationNumberList[0] = stationNumber;
            this.inverse = inverse;
        }

        CorrelationStationNumberFilter(String[] stationNumberList) {
            this(stationNumberList, false);
        }

        CorrelationStationNumberFilter(String stationNumber) {
            this(stationNumber, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonCorrelation) {
                PersonCorrelation correlation = (PersonCorrelation)obj;
                boolean isMatch = false;
                int i = 0;
                while (i < this.stationNumberList.length) {
                    if (correlation.getSystemOfInterest() != null && correlation.getSystemOfInterest().getSiteCode() != null && (isMatch = correlation.getSystemOfInterest().getSiteCode().equals(this.stationNumberList[i]))) break;
                    ++i;
                }
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class CorrelationStatusFilter
    implements FilterCriteria {
        private String correlationStatus;
        private boolean inverse;

        CorrelationStatusFilter(String correlationStatus) {
            this(correlationStatus, false);
        }

        CorrelationStatusFilter(String correlationStatus, boolean inverse) {
            this.correlationStatus = correlationStatus;
            this.inverse = inverse;
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonCorrelation) {
                PersonCorrelation correlation = (PersonCorrelation)obj;
                String dbValue = correlation.getStatus();
                if (dbValue == null) {
                    dbValue = "";
                }
                boolean isMatch = this.correlationStatus.equalsIgnoreCase(dbValue);
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }
}

