/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.common.ICorrelationCategory;
import gov.va.med.person.idmgmt.common.IPersonCorrelation;
import gov.va.med.person.idmgmt.common.IPersonTrait;
import gov.va.med.person.idmgmt.common.IPersonVPID;
import gov.va.med.person.idmgmt.common.ISystemOfInterest;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.CorrelationCategory;
import gov.va.med.person.idmgmt.db.hb.PersonTrait;
import gov.va.med.person.idmgmt.db.hb.PersonVPID;
import gov.va.med.person.idmgmt.sds.IdmAssigningAuthority;
import gov.va.med.person.idmgmt.sds.SDSDelegate;
import gov.va.med.person.idmgmt.util.IConstants;
import gov.va.med.term.access.IdentifierType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonCorrelation
extends AbstractEntity
implements IPersonCorrelation {
    private static final long serialVersionUID = 1L;
    private String status;
    private Byte externalInd;
    private String altKey1;
    private String altKey2;
    private String altKey3;
    private String altKey4;
    private String altKey5;
    private Long identifierTypeId;
    private Long assigningAuthorityId;
    private IdmAssigningAuthority idmAA;
    private String probScore = "";
    private PersonVPID personVPID;
    private ISystemOfInterest systemOfInterest;
    private PersonTrait personTrait;
    private PersonCorrelation survivingCorrelation;
    private Set personCategoriesStore = new HashSet();
    private IdentifierType identifierType;
    private static final ICorrelationCategory[] PERSON_CATEGORIES_TEMPLATE = new ICorrelationCategory[0];
    private transient ICorrelationCategory[] personCategories;
    private String sourceApplication;
    private Byte idTheftRecordFlag;
    private String idTypeCode;
    private String AAOID;
    private String AFOID;
    private static final int ALTKEY_DEFAULT_MAX_LENGTH = 20;

    public String getSourceApplication() {
        return this.sourceApplication;
    }

    public void setSourceApplication(String sourceApplication) {
        this.sourceApplication = sourceApplication;
    }

    @Override
    public Byte getIdTheftRecordFlag() {
        return this.idTheftRecordFlag;
    }

    @Override
    public void setIdTheftRecordFlag(Byte idTheftRecordFlag) {
        this.idTheftRecordFlag = idTheftRecordFlag;
    }

    public void setIdTheftRecord(boolean isIdTheftRecord) {
        this.idTheftRecordFlag = isIdTheftRecord ? IConstants.ONE : IConstants.ZERO;
    }

    @Override
    public boolean isIdTheftRecord() {
        return IConstants.ONE.equals(this.idTheftRecordFlag);
    }

    public String getIdTypeCode() {
        return this.idTypeCode;
    }

    public void setIdTypeCode(String idTypeCode) {
        this.idTypeCode = idTypeCode;
    }

    public String getAAOID() {
        return this.AAOID;
    }

    public void setAAOID(String aaoid) {
        this.AAOID = aaoid;
    }

    @Override
    public String getAFOID() {
        return this.AFOID;
    }

    @Override
    public void setAFOID(String AFOID) {
        this.AFOID = AFOID;
    }

    public void setProbScore(String probScore) {
        this.probScore = probScore;
    }

    public String getProbScore() {
        return this.probScore;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void setExternalInd(Byte externalInd) {
        this.externalInd = externalInd;
    }

    public void setExternalInd(boolean b) {
        this.externalInd = b ? IConstants.ONE : IConstants.ZERO;
    }

    @Override
    public boolean isExternal() {
        return IConstants.ONE.equals(this.externalInd);
    }

    @Override
    public String getAltKey1() {
        return this.altKey1;
    }

    @Override
    public void setAltKey1(String altKey1) {
        this.altKey1 = altKey1;
    }

    @Override
    public String getAltKey2() {
        return this.altKey2;
    }

    @Override
    public void setAltKey2(String altKey2) {
        this.altKey2 = altKey2;
    }

    @Override
    public String getAltKey3() {
        return this.altKey3;
    }

    @Override
    public void setAltKey3(String altKey3) {
        this.altKey3 = altKey3;
    }

    @Override
    public String getAltKey4() {
        return this.altKey4;
    }

    @Override
    public void setAltKey4(String altKey4) {
        String adjustedAltKey4 = altKey4;
        if (altKey4 != null && altKey4.length() > 20) {
            adjustedAltKey4 = altKey4.substring(0, 20);
        }
        this.altKey4 = adjustedAltKey4;
    }

    @Override
    public String getAltKey5() {
        return this.altKey5;
    }

    @Override
    public void setAltKey5(String altKey5) {
        String adjustedAltKey5 = altKey5;
        if (altKey5 != null && altKey5.length() > 20) {
            adjustedAltKey5 = altKey5.substring(0, 20);
        }
        this.altKey5 = adjustedAltKey5;
    }

    @Override
    public Long getIdentifierTypeId() {
        return this.identifierTypeId;
    }

    @Override
    public void setIdentifierTypeId(Long identifierTypeId) {
        this.identifierTypeId = identifierTypeId;
        this.identifierType = null;
    }

    @Override
    public Long getAssigningAuthorityId() {
        return this.assigningAuthorityId;
    }

    @Override
    public void setAssigningAuthorityId(Long assigningAuthorityId) {
        this.assigningAuthorityId = assigningAuthorityId;
    }

    @Override
    public IPersonVPID getPersonVPID() {
        return this.personVPID;
    }

    @Override
    public void setPersonVPID(IPersonVPID personVPID) {
        this.personVPID = (PersonVPID)personVPID;
    }

    @Override
    public ISystemOfInterest getSystemOfInterest() {
        return this.systemOfInterest;
    }

    @Override
    public void setSystemOfInterest(ISystemOfInterest systemOfInterest) {
        this.systemOfInterest = systemOfInterest;
    }

    @Override
    public IPersonTrait getPersonTrait() {
        return this.personTrait;
    }

    @Override
    public void setPersonTrait(IPersonTrait personTrait) {
        this.personTrait = (PersonTrait)personTrait;
    }

    @Override
    public PersonCorrelation getSurvivingCorrelation() {
        return this.survivingCorrelation;
    }

    @Override
    public void setSurvivingCorrelation(PersonCorrelation survivingCorrelation) {
        this.survivingCorrelation = survivingCorrelation;
    }

    @Override
    public Set getPersonCategoriesStore() {
        return this.personCategoriesStore;
    }

    @Override
    public void setPersonCategoriesStore(Set personCategoriesStore) {
        this.personCategoriesStore = personCategoriesStore;
    }

    @Override
    public ICorrelationCategory[] getPersonCategories() {
        return (ICorrelationCategory[])this.personCategories().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICorrelationCategory[] personCategories() {
        if (this.personCategoriesStore != null) {
            Set set = this.personCategoriesStore;
            synchronized (set) {
                if (this.personCategories == null) {
                    Object[] temp = this.personCategoriesStore.toArray(PERSON_CATEGORIES_TEMPLATE);
                    Arrays.sort(temp);
                    this.personCategories = temp;
                }
            }
            return this.personCategories;
        }
        return PERSON_CATEGORIES_TEMPLATE;
    }

    @Override
    public Byte getExternalInd() {
        return this.externalInd;
    }

    @Override
    public Boolean getActive() {
        return "A".equals(this.getStatus());
    }

    public void setIdentifierType(IdentifierType value) {
        this.identifierType = value;
        this.identifierTypeId = value == null ? null : value.getId();
    }

    @Override
    public IdentifierType getIdentifierType() {
        if (this.identifierType == null && this.identifierTypeId != null) {
            this.identifierType = IdentifierType.factory.obtainFromKeyValue(this.identifierTypeId);
        }
        return this.identifierType;
    }

    @Override
    public IdmAssigningAuthority getIdmAssigningAuthority() {
        if (this.idmAA == null || this.idmAA.getCode() == null || this.idmAA.getCode().trim().length() == 0) {
            if (this.assigningAuthorityId == null) {
                String aaCode = "UNKNOWN";
                if (this.getAAOID() != null) {
                    aaCode = this.getAAOID();
                } else if (this.getAuditInfo() != null) {
                    aaCode = this.getAuditInfo().getCreatedBy();
                }
                this.idmAA = new IdmAssigningAuthority(aaCode);
                this.idmAA.setCodeSource(IdmAssigningAuthority.CODE_SOURCE_IDM);
            } else {
                this.idmAA = SDSDelegate.getAssigningAuthorityByKeyValue(this.assigningAuthorityId);
                this.idmAA.setCodeSource(IdmAssigningAuthority.CODE_SOURCE_SDS);
            }
        }
        return this.idmAA;
    }

    public void setIdmAssigningAuthorityCode(String idmAACode) {
        this.idmAA = SDSDelegate.getAssigningAuthorityByCode(idmAACode);
        if (this.idmAA != null) {
            this.setAssigningAuthorityId(this.idmAA.getId());
        } else {
            this.idmAA = new IdmAssigningAuthority(idmAACode);
            this.idmAA.setCodeSource(IdmAssigningAuthority.CODE_SOURCE_IDM);
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    public int compareTo(Object o) {
        int result = 0;
        PersonCorrelation other = (PersonCorrelation)o;
        String value = this.getStatus();
        String otherValue = other.getStatus();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public boolean equals(Object o) {
        int x = this.compareTo(o);
        return x == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersonCategory(CorrelationCategory category) {
        Set set = this.personCategoriesStore;
        synchronized (set) {
            this.personCategoriesStore.add(category);
            this.personCategories = null;
        }
    }

    public void onSave() {
        this.personVPID.setPersonCorrelation(this.personTrait, this);
        if (this.personTrait != null) {
            this.personTrait.setCorrelation(this.personVPID, this);
        }
    }
}

