/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.common.IPerson;
import gov.va.med.person.idmgmt.common.IPersonClassDetail;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.Person;
import gov.va.med.person.idmgmt.sds.IdmInstitution;
import gov.va.med.person.idmgmt.sds.SDSDelegate;
import gov.va.med.term.access.PersonClass;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonClassDetail
extends AbstractEntity
implements IPersonClassDetail {
    private static final long serialVersionUID = 1L;
    private Long institutionId;
    private Long personClassId;
    private Date effective;
    private Date expiration;
    private Person person;
    private IdmInstitution idmInstitution;
    private PersonClass personClass;

    public Long getInstitutionId() {
        return this.institutionId;
    }

    @Override
    public void setInstitutionId(Long institutionId) {
        this.institutionId = institutionId;
        this.idmInstitution = null;
    }

    @Override
    public String getSiteCode() {
        String siteCode = null;
        if (this.institutionId != null) {
            if (this.idmInstitution == null) {
                this.idmInstitution = SDSDelegate.getInstitutionByKeyValue(this.institutionId);
            }
            siteCode = this.idmInstitution.getStationNumber();
        } else {
            siteCode = this.getAuditInfo().getCreatedBy();
        }
        return siteCode;
    }

    @Override
    public Long getPersonClassId() {
        return this.personClassId;
    }

    @Override
    public void setPersonClassId(Long personClassId) {
        this.personClassId = personClassId;
        this.personClass = null;
    }

    @Override
    public Date getEffective() {
        return this.effective;
    }

    @Override
    public void setEffective(Date effective) {
        this.effective = effective;
    }

    @Override
    public Date getExpiration() {
        return this.expiration;
    }

    @Override
    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    @Override
    public IPerson getPerson() {
        return this.person;
    }

    @Override
    public void setPerson(IPerson person) {
        this.person = (Person)person;
    }

    public void setPersonClass(PersonClass value) {
        this.personClass = value;
        this.personClassId = value != null ? value.getId() : null;
    }

    @Override
    public PersonClass getPersonClass() {
        if (this.personClass == null && this.personClassId != null) {
            this.personClass = PersonClass.factory.obtainFromKeyValue(this.personClassId);
        }
        return this.personClass;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    public void onSave() {
        this.person.addPersonClassDetail(this);
    }
}

