/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.common.IPersonAddressHistory;
import gov.va.med.person.idmgmt.db.hb.PersonAddressHistory;
import java.sql.Timestamp;

public class PersonAddressHistoryFilterFactory {
    public static FilterCriteria createFilterTypeId(Long typeId) {
        return new AddressTypeIdFilter(typeId);
    }

    public static FilterCriteria createFilterActiveHistory() {
        return new ActiveAddressFilter(new Timestamp(System.currentTimeMillis()));
    }

    private static class ActiveAddressFilter
    implements FilterCriteria {
        private Timestamp timestamp;
        private boolean inverse;

        ActiveAddressFilter(Timestamp timestamp, boolean inverse) {
            this.inverse = inverse;
            this.timestamp = timestamp;
        }

        ActiveAddressFilter(Timestamp timestamp) {
            this(timestamp, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof IPersonAddressHistory) {
                boolean isMatch;
                IPersonAddressHistory history = (IPersonAddressHistory)obj;
                boolean bl = isMatch = (history.getEffectiveDate().before(this.timestamp) || history.getEffectiveDate().equals(this.timestamp)) && this.timestamp.before(history.getExpirationDate());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class AddressTypeIdFilter
    implements FilterCriteria {
        private Long addressTypeId;
        private boolean inverse;

        AddressTypeIdFilter(Long addressTypeId, boolean inverse) {
            this.inverse = inverse;
            this.addressTypeId = addressTypeId;
        }

        AddressTypeIdFilter(Long addressTypeId) {
            this(addressTypeId, false);
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = false;
            if (obj != null && obj instanceof PersonAddressHistory) {
                PersonAddressHistory history = (PersonAddressHistory)obj;
                if (history == null) {
                    isMatch = false;
                } else {
                    boolean bl = isMatch = this.addressTypeId.longValue() == history.getAddressTypeId().longValue();
                }
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }
}

