/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.db.hb.PersonAddress;
import gov.va.med.person.idmgmt.db.hb.PersonAddressHistory;
import gov.va.med.term.access.AddressType;

public class PersonAddressFilterFactory {
    public static FilterCriteria createFilterActive() {
        return new ActiveFilter();
    }

    public static FilterCriteria createFilterExpired() {
        return new ActiveFilter(true);
    }

    public static FilterCriteria createFilterPermBad() {
        return new PermanentFilter();
    }

    public static FilterCriteria createFilterTypeId(Long typeId) {
        return new AddressTypeIdFilter(typeId);
    }

    private static class ActiveFilter
    implements FilterCriteria {
        private boolean inverse;

        ActiveFilter(boolean inverse) {
            this.inverse = inverse;
        }

        ActiveFilter() {
            this(false);
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = true;
            if (obj != null && obj instanceof PersonAddress) {
                PersonAddress address = (PersonAddress)obj;
                PersonAddressHistory history = (PersonAddressHistory)address.getActiveHistory();
                isMatch = history == null ? false : history.isActive();
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class AddressTypeIdFilter
    implements FilterCriteria {
        private Long addressTypeId;
        private boolean inverse;

        AddressTypeIdFilter(Long addressTypeId, boolean inverse) {
            this.inverse = inverse;
            this.addressTypeId = addressTypeId;
        }

        AddressTypeIdFilter(Long addressTypeId) {
            this(addressTypeId, false);
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = false;
            if (obj != null && obj instanceof PersonAddress) {
                PersonAddress address = (PersonAddress)obj;
                PersonAddressHistory history = (PersonAddressHistory)address.getActiveHistory();
                if (history == null) {
                    isMatch = false;
                } else {
                    boolean bl = isMatch = this.addressTypeId.longValue() == history.getAddressTypeId().longValue();
                }
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class PermanentFilter
    implements FilterCriteria {
        private long badAddress = AddressType.factory.obtainByCode("P").getId();
        private long permAddress = AddressType.factory.obtainByCode("BA").getId();

        PermanentFilter() {
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = true;
            if (obj != null && obj instanceof PersonAddress) {
                long addressTypeId;
                PersonAddress address = (PersonAddress)obj;
                PersonAddressHistory history = (PersonAddressHistory)address.getActiveHistory();
                isMatch = history == null ? false : (addressTypeId = history.getAddressTypeId().longValue()) == this.badAddress || addressTypeId == this.permAddress;
                return isMatch;
            }
            return false;
        }
    }
}

