/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.CollectionFilter;
import gov.va.med.person.idmgmt.common.IPersonAddress;
import gov.va.med.person.idmgmt.common.IPersonAddressHistory;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.Equivalent;
import gov.va.med.person.idmgmt.db.hb.PersonAddressHistory;
import gov.va.med.person.idmgmt.db.hb.PersonAddressHistoryFilterFactory;
import gov.va.med.person.idmgmt.db.hb.PersonTrait;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonAddress
extends AbstractEntity
implements IPersonAddress {
    static final long serialVersionUID = 2844062094681443299L;
    private PersonTrait personTrait;
    private Set<PersonAddressHistory> historyStore = new HashSet<PersonAddressHistory>();
    private transient IPersonAddressHistory[] history;
    private IPersonAddressHistory activeHistory;
    private static final IPersonAddressHistory[] HISTORY_TEMPLATE = new IPersonAddressHistory[0];

    public PersonTrait getPersonTrait() {
        return this.personTrait;
    }

    public void setPersonTrait(PersonTrait personTrait) {
        this.personTrait = personTrait;
    }

    @Override
    public Set<PersonAddressHistory> getHistoryStore() {
        return this.historyStore;
    }

    @Override
    public void setHistoryStore(Set<PersonAddressHistory> historyStore) {
        this.historyStore = historyStore;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("personTraitId", (Object)this.personTrait).append("version", (Object)this.getVersion()).append("AuditInfo", (Object)this.getAuditInfo()).toString();
    }

    public void onSave() {
        this.personTrait.addAddress(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(PersonAddressHistory value) {
        Set<PersonAddressHistory> set = this.historyStore;
        synchronized (set) {
            this.historyStore.add(value);
            this.history = null;
            this.activeHistory = null;
        }
    }

    @Override
    public IPersonAddressHistory[] getHistory() {
        return (IPersonAddressHistory[])this.history().clone();
    }

    @Override
    public boolean isActive(Timestamp when) {
        IPersonAddressHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].isActive();
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersonAddressHistory[] history() {
        if (this.historyStore != null) {
            Set<PersonAddressHistory> set = this.historyStore;
            synchronized (set) {
                if (this.history == null) {
                    IPersonAddressHistory[] temp = this.historyStore.toArray(HISTORY_TEMPLATE);
                    this.history = temp;
                }
            }
            return this.history;
        }
        return HISTORY_TEMPLATE;
    }

    public IPersonAddressHistory getAddress() {
        return this.getAddress(PersonAddress.getToday());
    }

    public IPersonAddressHistory getAddress(Timestamp when) {
        IPersonAddressHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i];
            }
            ++i;
        }
        return null;
    }

    public IPersonAddressHistory getActiveHistory() {
        if (this.activeHistory == null) {
            CollectionFilter cf = new CollectionFilter();
            cf.addFilterCriteria(PersonAddressHistoryFilterFactory.createFilterActiveHistory());
            Iterator itr = cf.filterCopy(this.historyStore).iterator();
            if (itr.hasNext()) {
                this.activeHistory = (IPersonAddressHistory)itr.next();
            }
        }
        return this.activeHistory;
    }

    public boolean equals(Object obj) {
        boolean isEqual = true;
        isEqual = obj == null || !(obj instanceof PersonAddress) ? false : (((PersonAddress)obj).getActiveHistory() == null || this.getActiveHistory() == null ? super.equals(obj) : this.isEquivalent((PersonAddress)obj));
        return isEqual;
    }

    public int hashCode() {
        PersonAddressHistory history = (PersonAddressHistory)this.getActiveHistory();
        if (history == null) {
            return super.hashCode();
        }
        return new HashCodeBuilder(23, 41).appendSuper(135).append((Object)history.getAddrLine1()).append((Object)history.getAddrLine2()).append((Object)history.getAddrLine3()).append((Object)history.getCity()).append((Object)history.getZip()).append((Object)history.getAddressTypeId()).toHashCode();
    }

    private boolean isEquivalent(PersonAddress address) {
        return Equivalent.isEquivalent(this.getActiveHistory().getAddrLine1(), address.getActiveHistory().getAddrLine1()) && Equivalent.isEquivalent(this.getActiveHistory().getAddrLine2(), address.getActiveHistory().getAddrLine2()) && Equivalent.isEquivalent(this.getActiveHistory().getAddrLine3(), address.getActiveHistory().getAddrLine3()) && Equivalent.isEquivalent(this.getActiveHistory().getCity(), address.getActiveHistory().getCity()) && Equivalent.isEquivalent(this.getActiveHistory().getZip(), address.getActiveHistory().getZip()) && Equivalent.isEquivalent(this.getActiveHistory().getAddressTypeId(), address.getActiveHistory().getAddressTypeId());
    }

    public Long getAddressTypeId() {
        try {
            return this.getActiveHistory().getAddressTypeId();
        }
        catch (Exception e) {
            return null;
        }
    }
}

