/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.db.hb.CorrelationCategory;

public class CorrelationCategoryFilterFactory {
    public static FilterCriteria createFilterName(String name) {
        return new NameFilter(name);
    }

    public static FilterCriteria createFilterCategoryId(Long categoryId) {
        return new CategoryIdFilter(categoryId);
    }

    private static class CategoryIdFilter
    implements FilterCriteria {
        private boolean inverse;
        private Long categoryId;

        CategoryIdFilter(Long categoryId) {
            this(categoryId, false);
        }

        CategoryIdFilter(Long categoryId, boolean inverse) {
            this.categoryId = categoryId;
            this.inverse = inverse;
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = false;
            if (obj != null && obj instanceof CorrelationCategory) {
                CorrelationCategory category = (CorrelationCategory)obj;
                isMatch = this.categoryId.equals(category.getCategoryId());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class NameFilter
    implements FilterCriteria {
        private boolean inverse;
        private String name;

        NameFilter(String name) {
            this(name, false);
        }

        NameFilter(String name, boolean inverse) {
            this.name = name;
            this.inverse = inverse;
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = false;
            if (obj != null && obj instanceof CorrelationCategory) {
                CorrelationCategory category = (CorrelationCategory)obj;
                isMatch = this.name.equalsIgnoreCase(category.getName());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }
}

