/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.common.IdentityExceptionType;
import gov.va.med.person.idmgmt.db.HbPSDaoFactory;
import gov.va.med.person.idmgmt.db.IActiveCorrelationDAO;
import gov.va.med.person.idmgmt.db.IAddressDAO;
import gov.va.med.person.idmgmt.db.IAddressHistoryDAO;
import gov.va.med.person.idmgmt.db.ICorrelationCategoryDAO;
import gov.va.med.person.idmgmt.db.ICorrelationDAO;
import gov.va.med.person.idmgmt.db.IEventDAO;
import gov.va.med.person.idmgmt.db.IExceptionDao;
import gov.va.med.person.idmgmt.db.IIdsAppDAO;
import gov.va.med.person.idmgmt.db.IMessageLogDAO;
import gov.va.med.person.idmgmt.db.INameDAO;
import gov.va.med.person.idmgmt.db.INameHistoryDAO;
import gov.va.med.person.idmgmt.db.INpiDAO;
import gov.va.med.person.idmgmt.db.INpiHistoryDAO;
import gov.va.med.person.idmgmt.db.IPersonClassDetailDAO;
import gov.va.med.person.idmgmt.db.IPersonDAO;
import gov.va.med.person.idmgmt.db.IPhoneDAO;
import gov.va.med.person.idmgmt.db.IPhoneHistoryDAO;
import gov.va.med.person.idmgmt.db.ISearchDAO;
import gov.va.med.person.idmgmt.db.ISsnDAO;
import gov.va.med.person.idmgmt.db.ISsnHistoryDAO;
import gov.va.med.person.idmgmt.db.ISystemOfInterestDAO;
import gov.va.med.person.idmgmt.db.ITraitDAO;
import gov.va.med.person.idmgmt.db.ITraitHistoryDAO;
import gov.va.med.person.idmgmt.db.IVerificationDAO;
import gov.va.med.person.idmgmt.db.IVpidDAO;
import gov.va.med.person.idmgmt.db.IVpidSeqGenerator;
import gov.va.med.person.idmgmt.db.hb.ChangeType;
import gov.va.med.person.idmgmt.db.hb.VerificationLevel;
import gov.va.med.person.idmgmt.db.hb.VirtualTableType;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.maint.event.Queue;
import gov.va.med.person.idmgmt.util.PSIMSettings;
import gov.va.med.term.access.IdentityEventType;
import gov.va.med.term.access.IdentityExceptionTypeGroup;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import org.apache.log4j.Logger;

public abstract class PSDaoFactory {
    private static final Logger logger = Logger.getLogger(PSDaoFactory.class);
    private static PSDaoFactory factory;
    private static Class configKey;
    private final HashMap daoMap = new HashMap();
    private final HashMap implMap = new HashMap();
    private final Properties properties = PSIMSettings.getInstance().getPropertiesFor(configKey);

    static {
        configKey = PSDaoFactory.class;
    }

    public static void setConfigKey(Class clazz) {
        configKey = clazz;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    public static PSDaoFactory instance() {
        if (factory == null) {
            factory = PSDaoFactory.createFactory();
        }
        return factory;
    }

    protected static PSDaoFactory createFactory() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***PSDaoFactory.createFactory ");
        }
        if (factory == null) {
            String adrDsType = PSIMSettings.getInstance().getValue(PSDaoFactory.class, "adr-dstype", "hibernate");
            if (adrDsType.equalsIgnoreCase("hibernate")) {
                factory = PSDaoFactory.createHbDaoFactory();
            } else {
                throw new IllegalArgumentException("No DaoFactory for adr-dstype=" + adrDsType);
            }
        }
        return factory;
    }

    private static HbPSDaoFactory createHbDaoFactory() {
        try {
            return new HbPSDaoFactory();
        }
        catch (HibernateException e) {
            logger.error((Object)"Failed to create HbPSDaoFactory.", (Throwable)e);
            throw new DataAccessException("Failed to create HbPSDaoFactory.", (Exception)((Object)e));
        }
    }

    protected Object getDao(Class type) {
        Object dao = this.daoMap.get(type);
        if (dao == null) {
            dao = this.createDao(type);
            this.daoMap.put(type, dao);
        }
        return dao;
    }

    protected Object createDao(Class type) {
        Class daoClass = this.getImplementorFor(type);
        try {
            Object dao = daoClass.newInstance();
            logger.info((Object)("Create DAO " + type.getName() + "->" + daoClass.getName()));
            return dao;
        }
        catch (InstantiationException e) {
            logger.error((Object)"InstantiationException caught!", (Throwable)e);
            throw new DataAccessException("Failed to create DAO " + type, e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"IllegalAccessException caught!", (Throwable)e);
            throw new DataAccessException("Failed to create DAO " + type, e);
        }
    }

    protected Class getImplementorFor(Class type) {
        Class daoClass = (Class)this.implMap.get(type);
        if (daoClass == null) {
            throw new IllegalArgumentException("No implementation found for DAO type: " + type);
        }
        return daoClass;
    }

    protected void setImplementor(Class type, Class impl) {
        this.implMap.put(type, impl);
    }

    public IVpidDAO getVpidDAO() {
        return (IVpidDAO)this.getDao(IVpidDAO.class);
    }

    public ICorrelationDAO getCorrelationDAO() {
        return (ICorrelationDAO)this.getDao(ICorrelationDAO.class);
    }

    public ICorrelationCategoryDAO getCorrelationCategoryDAO() {
        return (ICorrelationCategoryDAO)this.getDao(ICorrelationCategoryDAO.class);
    }

    public IPhoneDAO getPhoneDAO() {
        return (IPhoneDAO)this.getDao(IPhoneDAO.class);
    }

    public IPhoneHistoryDAO getPhoneHistoryDAO() {
        return (IPhoneHistoryDAO)this.getDao(IPhoneHistoryDAO.class);
    }

    public IAddressDAO getAddressDAO() {
        return (IAddressDAO)this.getDao(IAddressDAO.class);
    }

    public IAddressHistoryDAO getAddressHistoryDAO() {
        return (IAddressHistoryDAO)this.getDao(IAddressHistoryDAO.class);
    }

    public INameDAO getNameDAO() {
        return (INameDAO)this.getDao(INameDAO.class);
    }

    public INameHistoryDAO getNameHistoryDAO() {
        return (INameHistoryDAO)this.getDao(INameHistoryDAO.class);
    }

    public ITraitDAO getTraitDAO() {
        return (ITraitDAO)this.getDao(ITraitDAO.class);
    }

    public ISearchDAO getSearchDAO() {
        return (ISearchDAO)this.getDao(ISearchDAO.class);
    }

    public ITraitHistoryDAO getTraitHistoryDAO() {
        return (ITraitHistoryDAO)this.getDao(ITraitHistoryDAO.class);
    }

    public INpiDAO getNpiDAO() {
        return (INpiDAO)this.getDao(INpiDAO.class);
    }

    public INpiHistoryDAO getNpiHistoryDAO() {
        return (INpiHistoryDAO)this.getDao(INpiHistoryDAO.class);
    }

    public ISsnDAO getSsnDAO() {
        return (ISsnDAO)this.getDao(ISsnDAO.class);
    }

    public ISsnHistoryDAO getSsnHistoryDAO() {
        return (ISsnHistoryDAO)this.getDao(ISsnHistoryDAO.class);
    }

    public IPersonClassDetailDAO getPersonClassDetailDAO() {
        return (IPersonClassDetailDAO)this.getDao(IPersonClassDetailDAO.class);
    }

    public IVerificationDAO getVerificationDAO() {
        return (IVerificationDAO)this.getDao(IVerificationDAO.class);
    }

    public IPersonDAO getPersonDAO() {
        return (IPersonDAO)this.getDao(IPersonDAO.class);
    }

    public ISystemOfInterestDAO getSystemOfInterestDAO() {
        return (ISystemOfInterestDAO)this.getDao(ISystemOfInterestDAO.class);
    }

    public IActiveCorrelationDAO getActiveCorrelationDAO() {
        return (IActiveCorrelationDAO)this.getDao(IActiveCorrelationDAO.class);
    }

    public IMessageLogDAO getMessageLogDAO() {
        return (IMessageLogDAO)this.getDao(IMessageLogDAO.class);
    }

    public IEventDAO getEventDAO() {
        return (IEventDAO)this.getDao(IEventDAO.class);
    }

    public IIdsAppDAO getIdsAppDAO() {
        return (IIdsAppDAO)this.getDao(IIdsAppDAO.class);
    }

    public IExceptionDao getExceptionDAO() {
        return (IExceptionDao)this.getDao(IExceptionDao.class);
    }

    public abstract TransactionManager getTransactionManager();

    public abstract void beginTransaction();

    public abstract void setAuditInfo(String var1);

    public abstract String getAuditInfo();

    public abstract void addSessionInfo(String var1);

    public abstract Vector getSessionInfo();

    public abstract void commitTransaction();

    public abstract void rollbackTransaction();

    public abstract void close();

    public abstract IVpidSeqGenerator getVpidSeqGenerator();

    public abstract VirtualTableType[] obtainVirtualTableType();

    public abstract ChangeType[] obtainChangeType();

    public abstract VerificationLevel[] obtainVerificationLevel();

    public abstract Queue[] obtainQueue();

    public abstract IdentityEventType[] obtainIdentityEventType();

    public abstract IdentityExceptionType[] obtainIdentityExceptionType();

    public abstract IdentityExceptionTypeGroup[] obtainIdentityExceptionTypeGroup();
}

