/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.db.IVpidSeqGenerator;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.person.idmgmt.util.StringAndCollectionTools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Properties;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.transaction.TransactionManagerLookup;
import org.apache.log4j.Logger;

class HbVpidSeqGenerator
implements IVpidSeqGenerator {
    private static final Logger logger = Logger.getLogger(HbVpidSeqGenerator.class);
    private static final String tableName = "PS_VPID_SEQ";
    private static final String columnName = "NEXT_INT";
    private final String query;
    private final String update;
    private TransactionManagerLookup transactionManagerLookup;
    private static final String FAILED_MSG = "Failed to generate sequence.";
    private static final String EXCEPTION_MSG = "Exception caught!";

    public HbVpidSeqGenerator() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" HbVpidSeqGenerator <init>");
        }
        this.query = "SELECT next_int FROM PS_VPID_SEQ";
        this.update = "UPDATE PS_VPID_SEQ SET NEXT_INT = ? where NEXT_INT = ?";
        this.configureTransactionManagerLookup();
    }

    @Override
    public synchronized String next() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" HbVpidSeqGenerator next() - start");
        }
        try {
            long next = this.isContainerManagedTransactions() ? this.getNextValue() : this.getNextValueNoCmt();
            String result = new DecimalFormat("0000000000000000").format(next);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("next() - end: " + result));
            }
            return result;
        }
        catch (HibernateException e) {
            logger.error((Object)FAILED_MSG, (Throwable)e);
            throw new DataAccessException(FAILED_MSG, (Exception)((Object)e));
        }
        catch (SQLException e) {
            logger.error((Object)FAILED_MSG, (Throwable)e);
            throw new DataAccessException(FAILED_MSG, e);
        }
    }

    private boolean isContainerManagedTransactions() {
        return HBSessionFactory.isContainerManagedTransactions();
    }

    private long getNextValue() throws HibernateException {
        Session session = HBSessionFactory.openSession();
        TransactionManager tm = this.getTransactionManager();
        Transaction surroundingTransaction = null;
        Connection connection = null;
        long result = 0L;
        try {
            try {
                surroundingTransaction = tm.suspend();
                tm.begin();
                connection = session.connection();
                result = this.readNextValue(connection);
                long sequence = result + 1L;
                this.updateNextValue(connection, result, sequence);
                tm.commit();
            }
            catch (SQLException sqle) {
                throw new DataAccessException("Could not get or update next value", sqle);
            }
            catch (Exception e) {
                try {
                    tm.rollback();
                    throw new DataAccessException(e);
                }
                catch (SystemException e1) {
                    throw new DataAccessException((Exception)((Object)e1));
                }
            }
        }
        finally {
            this.closeConnection(session.close());
            this.resume(tm, surroundingTransaction);
        }
        return result;
    }

    private long getNextValueNoCmt() throws HibernateException, SQLException {
        Session session = HBSessionFactory.openSession();
        Connection conn = session.connection();
        try {
            int result;
            int rows;
            conn.setAutoCommit(false);
            do {
                PreparedStatement qps = conn.prepareStatement(this.query);
                try {
                    try {
                        ResultSet rs = qps.executeQuery();
                        if (!rs.next()) {
                            String err = "could not read a hi value - you need to populate the table: PS_VPID_SEQ";
                            logger.error((Object)"could not read a hi value - you need to populate the table: PS_VPID_SEQ");
                            throw new DataAccessException("could not read a hi value - you need to populate the table: PS_VPID_SEQ");
                        }
                        result = rs.getInt(1);
                        rs.close();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)"could not read a hi value", (Throwable)sqle);
                        throw new DataAccessException(sqle);
                    }
                }
                finally {
                    qps.close();
                }
                PreparedStatement ups = conn.prepareStatement(this.update);
                try {
                    try {
                        ups.setInt(1, result + 1);
                        ups.setInt(2, result);
                        rows = ups.executeUpdate();
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)"could not update hi value in: PS_VPID_SEQ", (Throwable)sqle);
                        throw new DataAccessException(sqle);
                    }
                }
                finally {
                    ups.close();
                }
            } while (rows == 0);
            conn.commit();
            long l = result;
            return l;
        }
        finally {
            this.closeConnection(session.close());
        }
    }

    private TransactionManager getTransactionManager() {
        try {
            return this.transactionManagerLookup.getTransactionManager(new Properties());
        }
        catch (HibernateException e) {
            logger.error((Object)"Exception caught in HbVpidSeqGenerator.getTransactionManager.", (Throwable)e);
            throw new DataAccessException("Exception caught in HbVpidSeqGenerator.getTransactionManager.", (Exception)((Object)e));
        }
    }

    private void configureTransactionManagerLookup() {
        try {
            String txnMgrLookup = HBSessionFactory.getConfiguration().getProperty("hibernate.transaction.manager_lookup_class");
            if (StringAndCollectionTools.isEmpty(txnMgrLookup)) {
                logger.warn((Object)"No TransactionManagerLookup class configured in Hibernate.");
            } else {
                Class<?> txnMgrLookupClass = Class.forName(txnMgrLookup);
                this.transactionManagerLookup = (TransactionManagerLookup)txnMgrLookupClass.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)EXCEPTION_MSG, (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)EXCEPTION_MSG, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)EXCEPTION_MSG, (Throwable)e);
        }
    }

    private long readNextValue(Connection conn) throws SQLException {
        long result;
        PreparedStatement qps = conn.prepareStatement(this.query);
        try {
            try {
                ResultSet rs = qps.executeQuery();
                if (!rs.next()) {
                    String err = "Could not read sequence value - you need to populate the table: PS_VPID_SEQ";
                    logger.error((Object)"Could not read sequence value - you need to populate the table: PS_VPID_SEQ");
                    throw new DataAccessException("Could not read sequence value - you need to populate the table: PS_VPID_SEQ");
                }
                result = rs.getLong(1);
                rs.close();
            }
            catch (SQLException e) {
                logger.error((Object)" Could not read a sequence value from table: PS_VPID_SEQ", (Throwable)e);
                throw e;
            }
        }
        finally {
            qps.close();
        }
        return result;
    }

    private void updateNextValue(Connection conn, long currentValue, long nextValue) throws SQLException {
        PreparedStatement ups = conn.prepareStatement(this.update);
        try {
            try {
                ups.setLong(1, nextValue);
                ups.setLong(2, currentValue);
                ups.executeUpdate();
            }
            catch (SQLException sqle) {
                logger.error((Object)" could not update sequence value in: PS_VPID_SEQ", (Throwable)sqle);
                throw sqle;
            }
        }
        finally {
            ups.close();
        }
    }

    private void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error((Object)EXCEPTION_MSG, (Throwable)e);
            }
        }
    }

    private void resume(TransactionManager tm, Transaction surroundingTransaction) {
        if (surroundingTransaction != null) {
            try {
                tm.resume(surroundingTransaction);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)" HbVpidSeqGenerator surrounding tx resumed");
                }
            }
            catch (InvalidTransactionException e) {
                logger.error((Object)EXCEPTION_MSG, (Throwable)e);
                throw new DataAccessException((Exception)((Object)e));
            }
            catch (SystemException e) {
                logger.error((Object)EXCEPTION_MSG, (Throwable)e);
                throw new DataAccessException((Exception)((Object)e));
            }
        }
    }
}

