/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.QualifiedIdentifierImpl;
import gov.va.med.person.idmgmt.VPID;
import gov.va.med.person.idmgmt.common.IPersonVPID;
import gov.va.med.person.idmgmt.common.ISSN;
import gov.va.med.person.idmgmt.db.AbstractHbDAO;
import gov.va.med.person.idmgmt.db.IVpidDAO;
import gov.va.med.person.idmgmt.db.PSDaoFactory;
import gov.va.med.person.idmgmt.db.PersonIdentityQuery;
import gov.va.med.person.idmgmt.db.hb.PersonVPID;
import gov.va.med.person.idmgmt.db.hb.PersonVPIDLight;
import gov.va.med.person.idmgmt.db.hb.SystemOfInterest;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.exceptions.NPIException;
import gov.va.med.person.idmgmt.exceptions.PSIMException;
import gov.va.med.person.idmgmt.exceptions.VPIDException;
import gov.va.med.person.idmgmt.factory.QualifiedIdentifierFactory;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.person.idmgmt.util.PSIMSettings;
import gov.va.med.term.access.IdentifierType;
import gov.va.med.term.access.SSNType;
import gov.va.med.term.access.SSNVerificationStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.expression.Order;
import org.apache.log4j.Logger;

public final class HbVpidDAO
extends AbstractHbDAO
implements IVpidDAO {
    private static final Logger logger = Logger.getLogger(HbVpidDAO.class);
    private static final String HQL_BY_STATUS_AND_TYPE = "SELECT distinct vp.vpid FROM PersonVPID vp   INNER JOIN vp.personCorrelationsStore pc    INNER JOIN pc.personTrait pt   INNER JOIN pt.historyStore pth   INNER JOIN pt.ssnsStore ssn   INNER JOIN ssn.historyStore ssnh  WHERE  pc.identifierTypeId = :idTypeId    AND vp.idState = 'P'    AND pc.status = 'A'    AND pth.active = 1    AND pth.updateStatus = 'A'    AND ssnh.active = 1    AND ssnh.ssnTypeId = :ssnTypeId    AND ssnh.ssnVerificationStatusId = :ssnVerStatusId ";
    private static final String HQL_BY_STATUS_TYPE_AND_CORR = "SELECT distinct vp.vpid FROM PersonVPID vp   INNER JOIN vp.personCorrelationsStore pc    INNER JOIN pc.personTrait pt   INNER JOIN pt.historyStore pth   INNER JOIN pt.ssnsStore ssn   INNER JOIN ssn.historyStore ssnh  WHERE  pc.systemOfInterest.id = :psoiId   AND vp.idState = 'P'    AND pc.status = 'A'    AND pth.active = 1    AND pth.updateStatus = 'A'    AND ssnh.active = 1    AND ssnh.ssnTypeId = :ssnTypeId    AND ssnh.ssnVerificationStatusId = :ssnVerStatusId ";

    @Override
    public PersonVPID[] obtainVpidsByQuery(PersonIdentityQuery pIdQuery) {
        return this.executeQuery(pIdQuery).toArray(new PersonVPID[0]);
    }

    @Override
    public IQualifiedIdentifier[] obtainVpidsBySSNVerificationStatus(ISSN[] ssns) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbVpidDAO.obtainVpidsBySSNVerificationStatus ");
        }
        IQualifiedIdentifier[] qualIdent = null;
        ArrayList results = new ArrayList();
        try {
            int i = 0;
            while (i < ssns.length) {
                results.addAll(this.obtainVpidsByVerificationStatus(ssns[i]));
                ++i;
            }
            qualIdent = new QualifiedIdentifierImpl[results.size()];
            i = 0;
            while (i < qualIdent.length) {
                String vpid = (String)results.get(i);
                qualIdent[i] = QualifiedIdentifierFactory.create(vpid, "NI", "USVHA");
                ++i;
            }
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.obtainVpidsBySSNVerificationStatus Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (PSIMException e) {
            logger.error((Object)"PSIMException caught!", (Throwable)((Object)e));
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (VPIDException e) {
            logger.error((Object)"VPIDException caught!", (Throwable)e);
            throw new DataAccessException(e);
        }
        catch (NPIException e) {
            logger.error((Object)"VPIDException caught!", (Throwable)e);
            throw new DataAccessException(e);
        }
        return qualIdent;
    }

    @Override
    public IQualifiedIdentifier[] obtainVpidsBySSNVerificationStatus(ISSN[] ssns, String stationNumber) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbVpidDAO.obtainVpidsBySSNVerificationStatus (stationNumber) ");
        }
        IQualifiedIdentifier[] qualIdent = null;
        ArrayList results = new ArrayList();
        try {
            int i = 0;
            while (i < ssns.length) {
                results.addAll(this.obtainVpidsByVerificationStatus(ssns[i], stationNumber));
                ++i;
            }
            qualIdent = new QualifiedIdentifierImpl[results.size()];
            i = 0;
            while (i < qualIdent.length) {
                String vpid = (String)results.get(i);
                qualIdent[i] = QualifiedIdentifierFactory.create(vpid, "NI", "USVHA");
                ++i;
            }
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.obtainVpidsBySSNVerificationStatus Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (PSIMException e) {
            logger.error((Object)"PSIMException caught!", (Throwable)((Object)e));
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (VPIDException e) {
            logger.error((Object)"VPIDException caught!", (Throwable)e);
            throw new DataAccessException(e);
        }
        catch (NPIException e) {
            logger.error((Object)"VPIDException caught!", (Throwable)e);
            throw new DataAccessException(e);
        }
        return qualIdent;
    }

    @Override
    public int obtainCount(PersonIdentityQuery pIdQuery) {
        return this.executeQuery(pIdQuery).size();
    }

    private Collection obtainVpidsByVerificationStatus(ISSN ssn) throws HibernateException {
        try {
            IdentifierType ni = IdentifierType.factory.obtainByCode("NI");
            SSNType type = SSNType.factory.obtainByCode(ssn.getSsnType());
            SSNVerificationStatus status = SSNVerificationStatus.factory.obtainByCode(Integer.valueOf(ssn.getSsnVerificationStatus()));
            if (type == null || status == null || ni == null) {
                return Collections.EMPTY_LIST;
            }
            Session session = HBSessionFactory.currentSession();
            Query query = session.createQuery(HQL_BY_STATUS_AND_TYPE);
            query.setString("idTypeId", ni.getKeyString());
            query.setString("ssnTypeId", type.getKeyString());
            query.setString("ssnVerStatusId", status.getKeyString());
            this.setMaxReturn(query);
            List list = query.list();
            return list;
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.obtainVpidsByQuery Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    private void setMaxReturn(Query query) {
        int maxReturn = Integer.valueOf(PSIMSettings.getInstance().getValue(PSDaoFactory.class, "VPIDMaxReturn", "10000"));
        query.setMaxResults(maxReturn);
        query.setFetchSize(maxReturn);
    }

    private Collection obtainVpidsByVerificationStatus(ISSN ssn, String stationNumber) throws HibernateException {
        try {
            SSNType type = SSNType.factory.obtainByCode(ssn.getSsnType());
            SSNVerificationStatus status = SSNVerificationStatus.factory.obtainByCode(Integer.valueOf(ssn.getSsnVerificationStatus()));
            SystemOfInterest soi = PSDaoFactory.instance().getSystemOfInterestDAO().obtainBySiteCode(stationNumber);
            if (type == null || status == null || soi == null) {
                return Collections.EMPTY_LIST;
            }
            Session session = HBSessionFactory.currentSession();
            Query query = session.createQuery(HQL_BY_STATUS_TYPE_AND_CORR);
            query.setLong("psoiId", soi.getId().longValue());
            query.setString("ssnTypeId", type.getKeyString());
            query.setString("ssnVerStatusId", status.getKeyString());
            this.setMaxReturn(query);
            List list = query.list();
            return list;
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.obtainVpidsByQuery Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public PersonVPID obtainByVpid(VPID vpid) {
        return this.obtainByVpid(vpid.getVPID().getIdentifier());
    }

    @Override
    public PersonVPID obtainByVpid(String vpid) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" ***HbVpidDAO.obtainByVpid: " + vpid));
        }
        PersonVPID personVPID = null;
        try {
            Session session = HBSessionFactory.currentSession();
            String fullICNVPID = VPID.padIcn(vpid);
            personVPID = (PersonVPID)session.createQuery("from PersonVPID vpid where vpid.vpid = :value").setString("value", fullICNVPID).uniqueResult();
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.obtainByVpid Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        return personVPID;
    }

    @Override
    public PersonVPID[] obtainBySurvivingVPIDs(IPersonVPID[] vpids) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbVpidDAO.obtainBysurvivingVPIDs ");
        }
        if (vpids == null || vpids.length == 0) {
            return new PersonVPID[0];
        }
        PersonVPID[] results = null;
        try {
            Session session = HBSessionFactory.currentSession();
            List list = session.createCriteria(PersonVPID.class).add(Expression.in((String)"survivingVPID", (Object[])vpids)).list();
            results = list.toArray(new PersonVPID[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.obtainBysurvivingVPIDs Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        return results;
    }

    @Override
    public PersonVPID obtainByVpid(IQualifiedIdentifier vpidId) {
        return this.obtainByVpid(vpidId.getIdentifier());
    }

    @Override
    public void update(PersonVPID personVPID) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"*** HbVpidDAO.update(personVPID) entered.");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            if (personVPID.isNew()) {
                personVPID.setAuditInfo(this.createAuditInfo());
                session.save((Object)personVPID);
            } else {
                session.update((Object)personVPID);
            }
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.update Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public void update(PersonVPIDLight personVPIDLight) {
        try {
            Session session = HBSessionFactory.currentSession();
            session.update((Object)personVPIDLight);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.update Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public PersonVPID obtainFromKeyString(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbVpidDAO.obtainFromKeyString ");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            return (PersonVPID)session.createQuery("from PersonVPID obj where obj.id = :value").setString("value", key).uniqueResult();
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.obtainFromKeyString Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public PersonVPID[] obtain() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbVpidDAO.obtain ");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            List list = session.createCriteria(PersonVPID.class).addOrder(Order.asc((String)"id")).list();
            return list.toArray(new PersonVPID[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.obtain Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public void delete(IPersonVPID personVPID) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" ***HbVpidDAO.delete(personVPID) entered: " + personVPID.getVpid()));
        }
        try {
            Session session = HBSessionFactory.currentSession();
            session.delete((Object)personVPID);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.delete Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public synchronized PersonVPID[] obtainVpidsByQuery(String sql, Map sqlValues) {
        return this.obtainVpidListByQuery(sql, sqlValues).toArray(new PersonVPID[0]);
    }

    @Override
    public synchronized List obtainVpidListByQuery(String sql, Map sqlValues) {
        PersonIdentityQuery pIdQuery = new PersonIdentityQuery();
        pIdQuery.setQuery(sql);
        pIdQuery.setQueryValues(sqlValues);
        return this.executeQuery(pIdQuery);
    }

    private List executeQuery(PersonIdentityQuery pIdQuery) {
        Map sqlValues = pIdQuery.getQueryValues();
        String sql = pIdQuery.getQuery();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbVpidDAO.obtainVpidListByQuery");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            Query query = session.createSQLQuery(sql, null, PersonVPID.class);
            if (pIdQuery.isFirstResultValid()) {
                query.setFirstResult(pIdQuery.getFirstResult());
            }
            if (pIdQuery.isMaxResultsValid()) {
                query.setMaxResults(pIdQuery.getMaxResults());
                query.setFetchSize(pIdQuery.getMaxResults());
            }
            for (Map.Entry entry : sqlValues.entrySet()) {
                query.setString((String)entry.getKey(), (String)entry.getValue());
            }
            return query.list();
        }
        catch (HibernateException e) {
            logger.error((Object)" HbVpidDAO.obtainVpidsByQuery Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public List getPersonVPIDLight(Set vpidList) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(PersonVPIDLight.class);
            criteria.add(Expression.in((String)"vpid", (Collection)vpidList));
            criteria.addOrder(Order.asc((String)"vpid"));
            criteria.setFetchSize(500);
            criteria.setMaxResults(500);
            List listResult = criteria.list();
            return listResult;
        }
        catch (HibernateException e) {
            e.printStackTrace();
            logger.error((Object)(" HbVpidDAO.getIdState obtaining PersonVPIDLight List for VPIDS: " + vpidList), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)" HbVpidDAO.getIdState Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining PersonVPIDLight List: ", e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error((Object)" HbVpidDAO.getIdState Error: ", e);
            throw new DataAccessException("Exception obtaining PersonVPIDLight List: " + e.getMessage());
        }
    }

    @Override
    public List getTopICNList(Long lastPKId, int maxResultSize) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(PersonVPIDLight.class);
            criteria.add((Criterion)Expression.gt((String)"id", (Object)lastPKId));
            criteria.add((Criterion)Expression.eq((String)"idState", (Object)"P"));
            criteria.addOrder(Order.asc((String)"id"));
            criteria.setFetchSize(maxResultSize);
            criteria.setMaxResults(maxResultSize);
            List listResult = criteria.list();
            return listResult;
        }
        catch (HibernateException e) {
            e.printStackTrace();
            logger.error((Object)("HbVpidDAO.getTopICNList from: " + lastPKId), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("HbVpidDAO.getTopICNList from: " + lastPKId), (Throwable)e);
            throw new DataAccessException("HbVpidDAO.getTopICNList from: " + lastPKId, e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error((Object)" HbVpidDAO.getIdState Error: ", e);
            throw new DataAccessException("HbVpidDAO.getTopICNList from: " + lastPKId + "-" + e.getMessage());
        }
    }

    @Override
    public PersonVPIDLight obtainPersonVPIDLight(String icnVpidValue) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(PersonVPIDLight.class);
            String fullICNVPID = VPID.padIcn(icnVpidValue);
            criteria.add((Criterion)Expression.eq((String)"vpid", (Object)fullICNVPID));
            return (PersonVPIDLight)criteria.uniqueResult();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            logger.error((Object)("HbVpidDAO.obtainPersonVPIDLight from: " + icnVpidValue), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("HbVpidDAO.obtainPersonVPIDLight from: " + icnVpidValue), (Throwable)e);
            throw new DataAccessException("HbVpidDAO.obtainPersonVPIDLight from: " + icnVpidValue, e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error((Object)" HbVpidDAO.obtainPersonVPIDLight Error: ", e);
            throw new DataAccessException("HbVpidDAO.obtainPersonVPIDLight from: " + icnVpidValue + "-" + e.getMessage());
        }
    }
}

