/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.db.AbstractHbDAO;
import gov.va.med.person.idmgmt.db.ISystemOfInterestDAO;
import gov.va.med.person.idmgmt.db.PSDaoFactory;
import gov.va.med.person.idmgmt.db.hb.SystemOfInterest;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.person.idmgmt.sds.IdmInstitution;
import gov.va.med.person.idmgmt.sds.SDSDelegate;
import gov.va.med.person.idmgmt.util.PSIMSettings;
import java.util.List;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.expression.Order;
import org.apache.log4j.Logger;

public class HbSystemOfInterestDAO
extends AbstractHbDAO
implements ISystemOfInterestDAO {
    private static final Logger logger = Logger.getLogger(HbSystemOfInterestDAO.class);
    private static final String PSIM_NODE = PSIMSettings.getInstance().getValue(PSDaoFactory.class, "cacheRegionPrefix");
    private static final String QUERY = "from SystemOfInterest soi where soi.institutionId = :value";
    private static final String VALUE = "value";

    @Override
    public void update(SystemOfInterest soi) {
        try {
            Session session = HBSessionFactory.currentSession();
            if (soi.getId() == null) {
                session.save((Object)soi);
            } else {
                session.update((Object)soi);
            }
        }
        catch (Exception e) {
            logger.error((Object)(" HbSystemOfInterestDAO.update Error: " + soi), (Throwable)e);
            throw new DataAccessException("Exception saving HbSystemOfInterestDAO: " + soi, e);
        }
    }

    @Override
    public SystemOfInterest getSystemOfInterest(Long psoiid) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(SystemOfInterest.class);
            criteria.add((Criterion)Expression.eq((String)"id", (Object)psoiid));
            return (SystemOfInterest)criteria.uniqueResult();
        }
        catch (Exception e) {
            logger.error((Object)" HbSystemOfInterestDAO.getSystemOfInterestList Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining MessageLogList from Message Log: ", e);
        }
    }

    @Override
    public List getSystemOfInterestList(String name, String description, long institutionId, String siteCode, boolean exactMatch) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(SystemOfInterest.class);
            if (name != null && name.trim().length() > 0) {
                if (exactMatch) {
                    criteria.add((Criterion)Expression.eq((String)"name", (Object)name));
                } else {
                    criteria.add((Criterion)Expression.like((String)"name", (Object)("%" + name + "%")));
                }
            }
            if (description != null && description.trim().length() > 0) {
                if (exactMatch) {
                    criteria.add((Criterion)Expression.eq((String)"description", (Object)description));
                } else {
                    criteria.add((Criterion)Expression.like((String)"description", (Object)("%" + description + "%")));
                }
            }
            if (institutionId > 0L) {
                criteria.add((Criterion)Expression.eq((String)"institutionId", (Object)new Long(institutionId)));
            }
            if (siteCode != null && siteCode.trim().length() > 0) {
                SystemOfInterest psoi = this.obtainBySiteCode(siteCode);
                if (psoi != null) {
                    criteria.add(Expression.or((Criterion)Expression.eq((String)"id", (Object)psoi.getId()), (Criterion)Expression.eq((String)"auditInfo.createdBy", (Object)siteCode)));
                } else {
                    criteria.add((Criterion)Expression.eq((String)"auditInfo.createdBy", (Object)siteCode));
                }
            }
            int maxSOIFetch = new Integer(PSIMSettings.getInstance().getValue(PSDaoFactory.class, "maxSOIFetch", "5000"));
            criteria.addOrder(Order.desc((String)"id"));
            criteria.setFetchSize(maxSOIFetch);
            criteria.setMaxResults(maxSOIFetch);
            List listResult = criteria.list();
            return listResult;
        }
        catch (Exception e) {
            logger.error((Object)" HbSystemOfInterestDAO.getSystemOfInterestList Error: ", (Throwable)e);
            throw new DataAccessException("Exception searching SystemOfInterest: ", e);
        }
    }

    @Override
    public SystemOfInterest obtainBySiteCode(String siteCode) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(SystemOfInterest.class);
            SystemOfInterest dbSoi = null;
            String dbSiteCode = "";
            String dbSiteName = "";
            IdmInstitution inst = SDSDelegate.getInstitutionByStationNumber(siteCode);
            if (inst == null) {
                criteria.add((Criterion)Expression.eq((String)"auditInfo.createdBy", (Object)siteCode));
                dbSoi = (SystemOfInterest)criteria.uniqueResult();
                if (dbSoi != null) {
                    dbSiteCode = dbSoi.getAuditInfo().getCreatedBy();
                    dbSiteName = dbSoi.getName();
                }
            } else {
                criteria.add((Criterion)Expression.eq((String)"institutionId", (Object)inst.getId()));
                dbSoi = (SystemOfInterest)criteria.uniqueResult();
                if (dbSoi != null) {
                    dbSiteCode = inst.getStationNumber();
                    dbSiteName = inst.getName();
                } else {
                    criteria = session.createCriteria(SystemOfInterest.class);
                    criteria.add((Criterion)Expression.eq((String)"auditInfo.createdBy", (Object)siteCode));
                    dbSoi = (SystemOfInterest)criteria.uniqueResult();
                    if (dbSoi != null) {
                        dbSiteCode = dbSoi.getAuditInfo().getCreatedBy();
                        dbSiteName = dbSoi.getName();
                    }
                }
            }
            if (dbSoi != null) {
                dbSoi.setSiteCode(dbSiteCode);
                dbSoi.setSiteName(dbSiteName);
            }
            SystemOfInterest systemOfInterest = dbSoi;
            return systemOfInterest;
        }
        catch (HibernateException e) {
            logger.error((Object)" HbSystemOfInterestDAO.obtainByInstitution Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"*** HbSystemOfInterestDAO.obtainByInstitution - exited.");
            }
        }
    }

    @Override
    public List obtainByAFOID(String afOID) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(SystemOfInterest.class);
            criteria.add((Criterion)Expression.eq((String)"afoid", (Object)afOID));
            return criteria.list();
        }
        catch (Exception e) {
            logger.error((Object)" HbSystemOfInterestDAO.obtainByAFOID Error: ", (Throwable)e);
            throw new DataAccessException(e);
        }
    }
}

