/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.common.IPersonNameHistory;
import gov.va.med.person.idmgmt.db.AbstractHbDAO;
import gov.va.med.person.idmgmt.db.INameHistoryDAO;
import gov.va.med.person.idmgmt.db.hb.PersonNameHistory;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import org.apache.log4j.Logger;

public class HbNameHistoryDAO
extends AbstractHbDAO
implements INameHistoryDAO {
    private static final Logger logger = Logger.getLogger(HbNameHistoryDAO.class);

    @Override
    public PersonNameHistory[] obtainNameHistory(String firstName, String lastName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbNameHistoryDAO.obtainNameHistory ");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            List list = session.createCriteria(IPersonNameHistory[].class).add(Expression.and((Criterion)Expression.eq((String)"firstName", (Object)firstName), (Criterion)Expression.eq((String)"lastName", (Object)lastName))).list();
            return list.toArray(new PersonNameHistory[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbNameHistoryDAO.obtainNameHistory Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public void update(PersonNameHistory personNameHistory) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbNameHistoryDAO.update(personNameHistory) entered.");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            if (personNameHistory.isNew()) {
                personNameHistory.setAuditInfo(this.createAuditInfo());
                session.save((Object)personNameHistory);
                personNameHistory.onSave();
            } else {
                session.update((Object)personNameHistory);
            }
        }
        catch (HibernateException e) {
            logger.error((Object)" HbNameHistoryDAO.update Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }
}

