/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.db.AbstractHbDAO;
import gov.va.med.person.idmgmt.db.INameDAO;
import gov.va.med.person.idmgmt.db.hb.PersonName;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.apache.log4j.Logger;

public class HbNameDAO
extends AbstractHbDAO
implements INameDAO {
    private static final Logger logger = Logger.getLogger(HbNameDAO.class);

    @Override
    public PersonName obtainById(Long id) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbNameDAO.obtainById ");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            PersonName result = (PersonName)session.createQuery("from PersonName obj where obj.propName = :value").setLong("value", id.longValue()).uniqueResult();
            return result;
        }
        catch (HibernateException e) {
            logger.error((Object)" HbNameDAO.obtainById Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public void update(PersonName personName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbNameDAO.update(personName) entered.");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            if (personName.isNew()) {
                personName.setAuditInfo(this.createAuditInfo());
                session.save((Object)personName);
                personName.onSave();
            } else {
                session.update((Object)personName);
            }
        }
        catch (HibernateException e) {
            logger.error((Object)" HbNameDAO.update Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }
}

