/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.ISaveableMessage;
import gov.va.med.person.idmgmt.PersonIdentityImpl;
import gov.va.med.person.idmgmt.db.AbstractHbDAO;
import gov.va.med.person.idmgmt.db.IMessageLogDAO;
import gov.va.med.person.idmgmt.db.hb.MessageLog;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.person.idmgmt.maint.messaging.hl7.MessageHolder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.expression.Order;
import org.apache.log4j.Logger;

public class HbMessageLogDAO
extends AbstractHbDAO
implements IMessageLogDAO {
    private static final Logger logger = Logger.getLogger(HbMessageLogDAO.class);

    @Override
    public MessageLog getMessageAck(String msgNumber) {
        MessageLog message = null;
        List ackList = this.getMessageAckList(msgNumber);
        if (ackList != null && ackList.size() > 0) {
            message = (MessageLog)ackList.get(0);
        }
        return message;
    }

    @Override
    public List getMessageAckList(String msgNumber) {
        try {
            MessageLog origMessage = this.obtainByMessageNumber(msgNumber);
            Query query = HBSessionFactory.currentSession().createQuery("from MessageLog msg where msg.originalMessageId = :value");
            query.setFetchSize(10);
            query.setMaxResults(10);
            query.setLong("value", origMessage.getId().longValue());
            List ackList = query.list();
            return ackList;
        }
        catch (HibernateException e) {
            logger.error((Object)(" HbMessageLogDAO.getMessageAck obtaining Message Ack from Message Log: " + msgNumber), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbMessageLogDAO.getMessageAck Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining Message Ack from Message Log: ", e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbMessageLogDAO.getMessageAck Error: ", e);
            throw new DataAccessException("Exception obtaining Message Ack from Message Log: " + e.getMessage());
        }
    }

    @Override
    public MessageLog obtainByMessageId(Long msgId) {
        try {
            MessageLog message = (MessageLog)HBSessionFactory.currentSession().createQuery("from MessageLog msg where msg.id = :value").setLong("value", msgId.longValue()).uniqueResult();
            return message;
        }
        catch (HibernateException e) {
            logger.error((Object)(" HbMessageLogDAO.obtainByMessageId: " + msgId), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbMessageLogDAO.obtainByMessageId Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining MessageLog by ID: " + msgId, e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbMessageLogDAO.obtainByMessageId Error: ", e);
            throw new DataAccessException("Exception obtaining MessageLog:" + msgId + e.getMessage());
        }
    }

    @Override
    public MessageLog obtainByMessageNumber(String msgNumber) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" ***HbMessageLogDAO.obtainByMessageNumber: " + msgNumber));
        }
        try {
            MessageLog message = (MessageLog)HBSessionFactory.currentSession().createQuery("from MessageLog msg where msg.messageNumber = :value").setString("value", msgNumber).uniqueResult();
            return message;
        }
        catch (HibernateException e) {
            logger.error((Object)(" HbMessageLogDAO.obtainByMessageNumber: " + msgNumber), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbMessageLogDAO.obtain Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining MessageLog: ", e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbMessageLogDAO.obtain Error: ", e);
            throw new DataAccessException("Exception obtaining MessageLog: " + e.getMessage());
        }
    }

    @Override
    public void deleteMessageLogByMessageNumber(String mcid) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(MessageLog.class);
            criteria.add((Criterion)Expression.eq((String)"messageNumber", (Object)mcid));
            MessageLog msglog = (MessageLog)criteria.uniqueResult();
            if (msglog != null) {
                session.delete((Object)msglog);
            }
        }
        catch (Exception e) {
            logger.error((Object)" HbMessageLogDAO.deleteMessageLogByMessageNumber Error: ", (Throwable)e);
            throw new DataAccessException("Exception deleting MessageLog from Message Log: " + mcid, e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbMessageLogDAO.deleteMessageLogByMessageNumber Error: ", e);
            throw new DataAccessException("Exception deleting MessageLog from Message Log: " + mcid + e.getMessage());
        }
    }

    @Override
    public List getMessageLogListByMCIDPrefix(String mcidPrefix) {
        return this.getMessageLogListByMCIDPrefix(mcidPrefix, null, 1000);
    }

    @Override
    public List getMessageLogListByMCIDPrefix(String mcidPrefix, Long startPKId, int maxResults) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(MessageLog.class);
            criteria.add((Criterion)Expression.like((String)"messageNumber", (Object)mcidPrefix));
            if (startPKId != null) {
                if (startPKId.intValue() == -1) {
                    criteria.addOrder(Order.desc((String)"id"));
                } else {
                    criteria.addOrder(Order.asc((String)"id"));
                    criteria.add((Criterion)Expression.ge((String)"id", (Object)startPKId));
                }
            } else {
                criteria.addOrder(Order.asc((String)"id"));
            }
            criteria.setFetchSize(maxResults);
            criteria.setMaxResults(maxResults);
            List listResult = criteria.list();
            return listResult;
        }
        catch (HibernateException e) {
            logger.error((Object)(" HbMessageLogDAO.getMessageLogList obtaining MessageLogList from Message Log: " + mcidPrefix), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbMessageLogDAO.getMessageLogList Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining MessageLogList from Message Log: ", e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbMessageLogDAO.getMessageLogList Error: ", e);
            throw new DataAccessException("Exception obtaining MessageLogList from Message Log: " + e.getMessage());
        }
    }

    @Override
    public int getMessageLogCountByMCIDPrefix(String mcidPrefix) {
        try {
            Session session = HBSessionFactory.currentSession();
            String sql = "SELECT COUNT(ml.id) FROM MessageLog ml WHERE ml.messageNumber like :mcidPrefix";
            Query query = session.createQuery("SELECT COUNT(ml.id) FROM MessageLog ml WHERE ml.messageNumber like :mcidPrefix");
            query.setString("mcidPrefix", String.valueOf(mcidPrefix) + "%");
            Integer mlCount = (Integer)query.uniqueResult();
            return mlCount;
        }
        catch (HibernateException e) {
            logger.error((Object)(" HbMessageLogDAO.getMessageLogList obtaining MessageLogList from Message Log: " + mcidPrefix), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbMessageLogDAO.getMessageLogList Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining MessageLogList from Message Log: ", e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbMessageLogDAO.getMessageLogList Error: ", e);
            throw new DataAccessException("Exception obtaining MessageLogList from Message Log: " + e.getMessage());
        }
    }

    @Override
    public List getMessageLogList(Date logDateFrom, Date logDateTo, int topSize) {
        return this.getMessageLogList(logDateFrom, logDateTo, topSize, false);
    }

    @Override
    public List getMessageLogList(Date logDateFrom, Date logDateTo, int topSize, boolean includeAcks) {
        return this.getMessageLogList(logDateFrom, logDateTo, topSize, null, includeAcks);
    }

    @Override
    public List getMessageLogList(Date logDateFrom, Date logDateTo, int topSize, Long startPKId, boolean includeAcks) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(MessageLog.class);
            if (!includeAcks) {
                criteria.add(Expression.isNull((String)"originalMessageId"));
            }
            if (logDateFrom != null && logDateTo != null) {
                criteria.add(Expression.between((String)"auditInfo.created", (Object)logDateFrom, (Object)logDateTo));
                criteria.addOrder(Order.asc((String)"auditInfo.created"));
            } else if (startPKId != null) {
                criteria.add((Criterion)Expression.ge((String)"id", (Object)startPKId));
                criteria.addOrder(Order.asc((String)"id"));
            } else {
                criteria.addOrder(Order.desc((String)"id"));
            }
            criteria.setFetchSize(topSize);
            criteria.setMaxResults(topSize);
            List listResult = criteria.list();
            return listResult;
        }
        catch (HibernateException e) {
            logger.error((Object)(" HbMessageLogDAO.getMessageLogList obtaining MessageLogList from Message Log: " + logDateFrom), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbMessageLogDAO.getMessageLogList Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining MessageLogList from Message Log: ", e);
        }
        catch (Throwable e) {
            String errMsg = this.getThrowableErrMsg(e);
            System.err.println("[DEV_INFO][HBMESSAGELOGDAO]====================");
            System.err.println(errMsg);
            e.printStackTrace();
            System.err.println("===============================================");
            logger.error((Object)" HbMessageLogDAO.getMessageLogList Error: ", e);
            throw new DataAccessException("Exception obtaining MessageLogList from Message Log: " + errMsg);
        }
    }

    @Override
    public List getDeploymentMessages() {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(MessageLog.class);
            criteria.addOrder(Order.asc((String)"id"));
            criteria.add((Criterion)Expression.like((String)"messageNumber", (Object)"2.2.1"));
            List listResult = criteria.list();
            return listResult;
        }
        catch (HibernateException e) {
            logger.error((Object)" HbMessageLogDAO.getDeploymentMessages obtaining getDeploymentMessages from Message Log: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbMessageLogDAO.getDeploymentMessages Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining getDeploymentMessages from Message Log: ", e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbMessageLogDAO.getDeploymentMessages Error: ", e);
            throw new DataAccessException("Exception obtaining getDeploymentMessages from Message Log: " + e.getMessage());
        }
    }

    @Override
    public int getMessageLogCount(Date logDateFrom, Date logDateTo) {
        try {
            int ret = -1;
            Session session = HBSessionFactory.currentSession();
            String sql = "select count(ml.messageNumber) from MessageLog ml WHERE RECORD_CREATED_DATE>:ml.Start AND RECORD_CREATED_DATE<:ml.End AND REFERENCE_PS_MESSAGE_LOG_ID is null";
            Query query = session.createQuery(sql);
            query.setDate("ml.Start", logDateFrom);
            query.setDate("ml.End", logDateTo);
            Integer count = (Integer)query.uniqueResult();
            if (count != null) {
                ret = count;
            }
            return ret;
        }
        catch (HibernateException e) {
            logger.error((Object)(" HbMessageLogDAO.getMessageAck obtaining Message Ack from Message Log: " + logDateFrom), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbMessageLogDAO.getMessageAck Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining Message Ack from Message Log: ", e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbMessageLogDAO.getMessageAck Error: ", e);
            throw new DataAccessException("Exception obtaining Message Ack from Message Log: " + e.getMessage());
        }
    }

    @Override
    public List getMessageLogList(Set correlationList) {
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(MessageLog.class);
            criteria.add(Expression.in((String)"personCorrelation", (Collection)correlationList));
            criteria.addOrder(Order.asc((String)"id"));
            criteria.setMaxResults(100);
            List listResult = criteria.list();
            return listResult;
        }
        catch (HibernateException e) {
            e.printStackTrace();
            logger.error((Object)(" HbMessageLogDAO.getMessageLogList obtaining Message List for Correlations: " + correlationList), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)" HbMessageLogDAO.getMessageLogList Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining Message List: ", e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error((Object)" HbMessageLogDAO.getMessageLogList Error: ", e);
            throw new DataAccessException("Exception obtaining Message List: " + e.getMessage());
        }
    }

    @Override
    public boolean isMessageReceived(String msgNumber) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" ***HbMessageLogDAO.isMessageReceived: " + msgNumber));
        }
        try {
            Integer count = (Integer)HBSessionFactory.currentSession().createQuery("select count(*) from MessageLog msg where msg.messageNumber = :value").setString("value", msgNumber).uniqueResult();
            return count > 0;
        }
        catch (HibernateException e) {
            logger.error((Object)(" HbMessageLogDAO.isMessageReceived: " + msgNumber), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public void update(MessageLog message) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbMessageLogDAO.update(MessageLog) entered.");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            if (message.isNew()) {
                message.setAuditInfo(this.createAuditInfo());
                session.save((Object)message);
            } else {
                session.update((Object)message);
            }
        }
        catch (HibernateException e) {
            String msg = this.getHL7Message(message);
            logger.error((Object)(" HbMessageLogDAO.update Error: " + msg), (Throwable)e);
            throw new DataAccessException("Exception saving MessageLog: " + msg, (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = this.getHL7Message(message);
            logger.error((Object)(" HbMessageLogDAO.update Error: " + msg), (Throwable)e);
            throw new DataAccessException("Exception saving MessageLog: " + msg, e);
        }
        catch (Throwable e) {
            String msg = this.getHL7Message(message);
            logger.error((Object)(" HbMessageLogDAO.update Error: " + msg), e);
            throw new DataAccessException("Exception saving MessageLog: " + msg);
        }
    }

    @Override
    public MessageLog[] obtain() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbMessageLogDAO.obtain ");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            List list = session.createCriteria(MessageLog.class).list();
            return list.toArray(new MessageLog[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbMessageLogDAO.obtain Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbMessageLogDAO.obtain Error: ", (Throwable)e);
            throw new DataAccessException("Exception obtaining MessageLog: ", e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbMessageLogDAO.obtain Error: ", e);
            throw new DataAccessException("Exception obtaining MessageLog: " + e.getMessage());
        }
    }

    private String getHL7Message(MessageLog message) {
        Object o = message.getMessage();
        String msg = "Message Type: " + message.getMessage().getClass().getName() + ", CorrelationId: ";
        if (message.getPersonCorrelationId() != null) {
            msg = String.valueOf(msg) + message.getPersonCorrelationId().toString();
        }
        if (o instanceof PersonIdentityImpl) {
            PersonIdentityImpl pi = (PersonIdentityImpl)o;
            msg = String.valueOf(msg) + ", PersonIdentityImpl: " + pi.getVPID().getIdentifier();
        } else if (o instanceof ISaveableMessage) {
            ISaveableMessage sm = (ISaveableMessage)o;
            msg = String.valueOf(msg) + ", " + sm.getSerializableMessage().toString();
        } else if (o instanceof MessageHolder) {
            MessageHolder mh = (MessageHolder)o;
            msg = String.valueOf(msg) + ", " + mh.getEncodedMessage();
        }
        return msg;
    }
}

