/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.db.AbstractHbDAO;
import gov.va.med.person.idmgmt.db.IIdsAppDAO;
import gov.va.med.person.idmgmt.db.hb.AbstractIdsAppEntity;
import gov.va.med.person.idmgmt.db.hb.IdsAppAnswer;
import gov.va.med.person.idmgmt.db.hb.IdsAppClient;
import gov.va.med.person.idmgmt.db.hb.IdsAppNotes;
import gov.va.med.person.idmgmt.db.hb.IdsAppQuestion;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import java.util.Date;
import java.util.List;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.expression.Order;
import org.apache.log4j.Logger;

public class HbIdsAppDAO
extends AbstractHbDAO
implements IIdsAppDAO {
    private static final Logger logger = Logger.getLogger(HbIdsAppDAO.class);

    @Override
    public void update(AbstractIdsAppEntity entity) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" ***HbIdsAppDAO.update(entity) entered for ." + entity));
        }
        try {
            Session session = HBSessionFactory.currentSession();
            if (entity.isNew()) {
                session.save((Object)entity);
            } else {
                session.update((Object)entity);
            }
        }
        catch (HibernateException e) {
            logger.error((Object)" HbIdsAppDAO.update HB Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    private IdsAppAnswer getUniqueAnswer(String query) {
        IdsAppAnswer answer = null;
        try {
            Session session = HBSessionFactory.currentSession();
            Object result = session.createQuery(query).uniqueResult();
            if (result != null) {
                answer = (IdsAppAnswer)result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return answer;
    }

    @Override
    public IdsAppAnswer getAnswerById(String id) {
        return this.getUniqueAnswer("FROM IdsAppAnswer WHERE id = " + id);
    }

    @Override
    public IdsAppAnswer[] getAnswersByClient(IdsAppClient client) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbIdsAppDAO.getAnswersByClient");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            List list = session.createCriteria(IdsAppAnswer.class).add((Criterion)Expression.eq((String)"client", (Object)client)).list();
            return list.toArray(new IdsAppAnswer[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbIdsAppDAO.getAnswersByClient Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public IdsAppAnswer[] getAnswersByQuestion(IdsAppQuestion question) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbIdsAppDAO.getAnswersByQuestion");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            List list = session.createCriteria(IdsAppAnswer.class).add((Criterion)Expression.eq((String)"question", (Object)question)).list();
            return list.toArray(new IdsAppAnswer[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbIdsAppDAO.getAnswersByQuestion Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public IdsAppAnswer getAnswerByQuestionAndClient(IdsAppQuestion question, IdsAppClient client) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbIdsAppDAO.getAnswerByQuestionAndClient");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            IdsAppAnswer answer = (IdsAppAnswer)session.createCriteria(IdsAppAnswer.class).add((Criterion)Expression.eq((String)"question", (Object)question)).add((Criterion)Expression.eq((String)"client", (Object)client)).uniqueResult();
            return answer;
        }
        catch (HibernateException e) {
            logger.error((Object)" HbIdsAppDAO.getAnswersByQuestion Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public IdsAppQuestion getQuestionById(String id) {
        return this.getUniqueQuestion("FROM IdsAppQuestion WHERE id = " + id);
    }

    @Override
    public IdsAppQuestion[] getQuestions() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbIdsAppDAO.getQuestionsByCategory");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            List list = session.createCriteria(IdsAppQuestion.class).addOrder(Order.asc((String)"category")).addOrder(Order.asc((String)"subcategory")).addOrder(Order.asc((String)"orderValue")).list();
            return list.toArray(new IdsAppQuestion[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbIdsAppDAO.getQuestionsByCategory Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public IdsAppQuestion[] getQuestionsByCategory(String category, String subcategory) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbIdsAppDAO.getQuestionsByCategory");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            List list = session.createCriteria(IdsAppQuestion.class).add((Criterion)Expression.eq((String)"category", (Object)category)).add((Criterion)Expression.eq((String)"subcategory", (Object)subcategory)).addOrder(Order.asc((String)"category")).addOrder(Order.asc((String)"subcategory")).addOrder(Order.asc((String)"orderValue")).list();
            return list.toArray(new IdsAppQuestion[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbIdsAppDAO.getQuestionsByCategory Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    private IdsAppQuestion getUniqueQuestion(String query) {
        IdsAppQuestion question = null;
        try {
            Session session = HBSessionFactory.currentSession();
            Object result = session.createQuery(query).uniqueResult();
            if (result != null) {
                question = (IdsAppQuestion)result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return question;
    }

    public IdsAppClient[] getFakeClientsForTestingWeb() {
        IdsAppClient[] clients = new IdsAppClient[3];
        IdsAppClient fmc = new IdsAppClient();
        fmc.setDateRegistered(new Date(System.currentTimeMillis()));
        fmc.setLastContacted(new Date(System.currentTimeMillis()));
        fmc.setName("FMC");
        fmc.setNotes("FMC can only do EJB communication");
        fmc.setPoc("Jeff Tander");
        fmc.setRating(new Long(2L));
        fmc.setRegisteredFlag(true);
        this.update(fmc);
        IdsAppClient healthEVet = new IdsAppClient();
        healthEVet.setDateRegistered(new Date(System.currentTimeMillis()));
        healthEVet.setLastContacted(new Date(System.currentTimeMillis()));
        healthEVet.setName("Health E Vet");
        healthEVet.setNotes("Webservice communication is in Beta.");
        healthEVet.setPoc("Ryan Davis");
        healthEVet.setRating(new Long(7L));
        healthEVet.setRegisteredFlag(true);
        this.update(healthEVet);
        IdsAppClient imaging = new IdsAppClient();
        imaging.setDateRegistered(new Date(System.currentTimeMillis()));
        imaging.setLastContacted(new Date(System.currentTimeMillis()));
        imaging.setName("Imaging");
        imaging.setNotes("Updarading to Java 6");
        imaging.setPoc("Michel Cogen");
        imaging.setRating(new Long(9L));
        imaging.setRegisteredFlag(false);
        this.update(imaging);
        clients[0] = fmc;
        clients[1] = healthEVet;
        clients[2] = imaging;
        return clients;
    }

    @Override
    public IdsAppClient[] getClients() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbIdsAppDAO.getClients");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            List list = session.createCriteria(IdsAppClient.class).addOrder(Order.asc((String)"name")).list();
            return list.toArray(new IdsAppClient[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbIdsAppDAO.getClients: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public IdsAppClient getClientById(String id) {
        return this.getUniqueClient("FROM IdsAppClient WHERE id = " + id);
    }

    @Override
    public IdsAppClient getClientByName(String name) {
        return this.getUniqueClient("FROM IdsAppClient WHERE name = '" + name + "'");
    }

    private IdsAppClient getUniqueClient(String query) {
        IdsAppClient client = null;
        try {
            Session session = HBSessionFactory.currentSession();
            Object result = session.createQuery(query).uniqueResult();
            if (result != null) {
                client = (IdsAppClient)result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return client;
    }

    @Override
    public IdsAppNotes[] getNotesByTypeAndClient(String noteType, IdsAppClient client, int maxResults) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbIdsAppDAO.getNotesByTypeAndClient");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            Criteria criteria = session.createCriteria(IdsAppNotes.class);
            criteria.add((Criterion)Expression.eq((String)"noteType", (Object)noteType));
            if (client != null) {
                criteria.add((Criterion)Expression.eq((String)"client", (Object)client));
            }
            criteria.addOrder(Order.desc((String)"auditInfo.created"));
            if (maxResults > 0) {
                criteria.setFetchSize(maxResults);
                criteria.setMaxResults(maxResults);
            }
            List list = criteria.list();
            return list.toArray(new IdsAppNotes[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbIdsAppDAO.getNotesByTypeAndClient Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }
}

