/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.IPersonIdentity;
import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.ISaveableMessage;
import gov.va.med.person.idmgmt.common.IdentityExceptionType;
import gov.va.med.person.idmgmt.db.AbstractHbDAO;
import gov.va.med.person.idmgmt.db.IExceptionDao;
import gov.va.med.person.idmgmt.db.PSDaoFactory;
import gov.va.med.person.idmgmt.db.hb.DbIdentityException;
import gov.va.med.person.idmgmt.db.hb.DbIdentityTask;
import gov.va.med.person.idmgmt.db.hb.SystemOfInterest;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.term.access.IdentifierType;
import gov.va.med.term.access.IdentityEventType;
import gov.va.med.term.access.IdentityTaskStatusType;
import java.util.Date;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.apache.log4j.Logger;

public class HbExceptionDao
extends AbstractHbDAO
implements IExceptionDao {
    private static final Logger logger = Logger.getLogger(HbExceptionDao.class);
    protected static SystemOfInterest defaultSoi;
    protected static IdentifierType defaultIdType;
    private static final String INITIAL_STATUS = "New";

    @Override
    public DbIdentityException logException(IPersonIdentity identity, String message, String event, String exceptionType, String secondVpid) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"logException(identity) entered.");
        }
        DbIdentityException exception = new DbIdentityException();
        exception.setAdditionalInfo(message);
        if (identity != null && identity.getVPID() != null) {
            if (identity.getVPID().getIdentifier() != null) {
                exception.setVpid1(identity.getVPID().getIdentifier());
            }
            if (identity.getVPID().getIdentifierType() != null) {
                exception.setIdentifierType(this.getIdentifierType(identity.getVPID().getIdentifierType()));
            } else {
                IdentifierType type = this.getDefaultIdType();
                exception.setIdentifierType(type);
            }
        } else {
            IdentifierType type = this.getDefaultIdType();
            exception.setIdentifierType(type);
        }
        exception.setIdentityEventType(this.getIdentityEventType(event));
        exception.setIdentityExceptionType(this.getIdentityExceptionType(exceptionType));
        exception.setMessageControlId(this.getMessageControlId(identity));
        exception.setRequestingSitePersonId(this.getRequestingSitePersonId(identity));
        exception.setSystemOfInterest(this.getSystemOfInterest(identity.getSendingFacility()));
        exception.setTaskTimeStamp(new Date());
        exception.setVpid2(secondVpid);
        this.update(exception);
        return exception;
    }

    @Override
    public DbIdentityException logException(IPersonIdentity identity, String message, String event, String exceptionType) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"logException(identity) entered.");
        }
        DbIdentityException exception = new DbIdentityException();
        exception.setAdditionalInfo(message);
        if (identity.getVPID() != null) {
            if (identity.getVPID().getIdentifierType() != null) {
                exception.setIdentifierType(this.getIdentifierType(identity.getVPID().getIdentifierType()));
            } else {
                IdentifierType type = this.getDefaultIdType();
                exception.setIdentifierType(type);
            }
        } else {
            IdentifierType type = this.getDefaultIdType();
            exception.setIdentifierType(type);
        }
        exception.setIdentityEventType(this.getIdentityEventType(event));
        exception.setIdentityExceptionType(this.getIdentityExceptionType(exceptionType));
        exception.setMessageControlId(this.getMessageControlId(identity));
        exception.setRequestingSitePersonId(this.getRequestingSitePersonId(identity));
        exception.setSystemOfInterest(this.getSystemOfInterest(identity.getSendingFacility()));
        exception.setTaskTimeStamp(new Date());
        if (identity.getVPID() != null && identity.getVPID().getIdentifier() != null) {
            exception.setVpid1(identity.getVPID().getIdentifier());
        }
        this.update(exception);
        return exception;
    }

    private SystemOfInterest getSystemOfInterest(String facility) {
        SystemOfInterest soi = null;
        if (facility != null) {
            soi = PSDaoFactory.instance().getSystemOfInterestDAO().obtainBySiteCode(facility);
        }
        if (soi == null) {
            soi = this.getDefaultSoi();
        }
        return soi;
    }

    private SystemOfInterest getDefaultSoi() {
        if (defaultSoi == null && (defaultSoi = PSDaoFactory.instance().getSystemOfInterestDAO().obtainBySiteCode("200PS")) == null) {
            logger.warn((Object)"Unable to obtain institution for 200PS");
        }
        return defaultSoi;
    }

    private String getRequestingSitePersonId(IPersonIdentity identity) {
        String id = null;
        if (identity != null && identity.getRequestingIdentifier() != null) {
            id = identity.getRequestingIdentifier().getIdentifier();
        }
        return id;
    }

    private String getMessageControlId(IPersonIdentity identity) {
        String mcid = null;
        if (identity instanceof ISaveableMessage) {
            mcid = ((ISaveableMessage)((Object)identity)).getMessageControlId();
        }
        return mcid;
    }

    private IdentityExceptionType getIdentityExceptionType(String exceptionType) {
        IdentityExceptionType type = null;
        if (exceptionType != null) {
            type = IdentityExceptionType.obtainByCode(exceptionType);
        }
        return type;
    }

    private IdentityEventType getIdentityEventType(String event) {
        IdentityEventType type = null;
        if (event != null) {
            type = IdentityEventType.factory.obtainByName(event);
        }
        return type;
    }

    private IdentifierType getIdentifierType(String identifierType) {
        IdentifierType type = null;
        if (identifierType != null) {
            type = IdentifierType.factory.obtainByCode(identifierType);
        }
        if (type == null) {
            type = this.getDefaultIdType();
        }
        return type;
    }

    private IdentifierType getDefaultIdType() {
        if (defaultIdType == null) {
            IdentifierType type = IdentifierType.factory.obtainByCode("U");
            if (type != null) {
                defaultIdType = type;
            } else {
                logger.warn((Object)"Unable to obtain identifier type for U (unspecified)");
            }
        }
        return defaultIdType;
    }

    @Override
    public void update(DbIdentityException exception) {
        try {
            Session session = HBSessionFactory.openSession();
            if (this.isContainerManagedTransactions()) {
                this.updateInCMT(exception, session);
            } else {
                this.updateNoCmt(exception, session);
            }
            session.close();
        }
        catch (HibernateException e) {
            logger.error((Object)" HbExceptionDao.update Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    private void updateNoCmt(DbIdentityException exception, Session session) {
        net.sf.hibernate.Transaction hbTxn = null;
        try {
            hbTxn = session.beginTransaction();
            if (exception.isNew()) {
                exception.setAuditInfo(this.createAuditInfo());
                session.save((Object)exception);
                this.createTask(exception, session);
            } else {
                session.update((Object)exception);
            }
            hbTxn.commit();
        }
        catch (Exception e) {
            try {
                if (hbTxn != null) {
                    hbTxn.rollback();
                }
                throw new DataAccessException(e);
            }
            catch (HibernateException ex) {
                throw new DataAccessException((Exception)((Object)ex));
            }
        }
    }

    private void updateInCMT(DbIdentityException exception, Session session) {
        TransactionManager cmtTxn = this.getTransactionManager();
        Transaction surroundingTransaction = null;
        net.sf.hibernate.Transaction hbTxn = null;
        try {
            try {
                surroundingTransaction = cmtTxn.suspend();
                cmtTxn.begin();
                hbTxn = session.beginTransaction();
                if (exception.isNew()) {
                    exception.setAuditInfo(this.createAuditInfo());
                    session.save((Object)exception);
                    this.createTask(exception, session);
                } else {
                    session.update((Object)exception);
                }
                hbTxn.commit();
                cmtTxn.commit();
            }
            catch (Exception e) {
                try {
                    if (hbTxn != null) {
                        hbTxn.rollback();
                    }
                    cmtTxn.rollback();
                    throw new DataAccessException(e);
                }
                catch (SystemException e1) {
                    throw new DataAccessException((Exception)((Object)e1));
                }
                catch (HibernateException ex) {
                    throw new DataAccessException((Exception)((Object)ex));
                }
            }
        }
        finally {
            this.resume(cmtTxn, surroundingTransaction);
        }
    }

    @Override
    public DbIdentityException logException(IQualifiedIdentifier identifier, String message, String event, String exceptionType) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"logException(identity) entered.");
        }
        DbIdentityException exception = new DbIdentityException();
        exception.setAdditionalInfo(message);
        exception.setIdentifierType(this.getIdentifierType(identifier.getIdentifierType()));
        exception.setIdentityEventType(this.getIdentityEventType(event));
        exception.setIdentityExceptionType(this.getIdentityExceptionType(exceptionType));
        exception.setTaskTimeStamp(new Date());
        if ("NI".equals(identifier.getIdentifierType())) {
            exception.setVpid1(identifier.getIdentifier());
        } else {
            exception.setRequestingSitePersonId(identifier.getIdentifier());
        }
        exception.setSystemOfInterest(this.getSystemOfInterest(identifier.getAssigningLocation()));
        this.update(exception);
        return exception;
    }

    private void createTask(DbIdentityException exception, Session session) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"createTask(exception, session) entered.");
            }
            DbIdentityTask task = null;
            task = new DbIdentityTask();
            task.setTrackingNumber(exception.getId().toString());
            task.setIdentityTaskStatusType(IdentityTaskStatusType.factory.obtainByName(INITIAL_STATUS));
            task.setIdentityException(exception);
            task.setAuditInfo(this.createAuditInfo());
            session.save((Object)task);
        }
        catch (HibernateException e) {
            logger.error((Object)("ERROR createTask(exception, session) " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
        }
    }
}

