/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.ISaveableMessage;
import gov.va.med.person.idmgmt.PersonIdentityImpl;
import gov.va.med.person.idmgmt.db.AbstractHbDAO;
import gov.va.med.person.idmgmt.db.IEventDAO;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.person.idmgmt.maint.event.Event;
import gov.va.med.person.idmgmt.maint.event.Queue;
import gov.va.med.person.idmgmt.maint.messaging.hl7.MessageHolder;
import java.io.Serializable;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.SerializationException;
import org.apache.log4j.Logger;

public class HbEventDAO
extends AbstractHbDAO
implements IEventDAO {
    private static final Logger logger = Logger.getLogger(HbEventDAO.class);
    private static final Event[] EMPTY_EVENTS = new Event[0];

    @Override
    public Event[] obtain(Queue queue, int max) {
        return this.obtain(queue, max, null, false);
    }

    @Override
    public Event[] obtain(Queue queue, int max, String fromPKId, boolean isDescendingOrder) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("*** HbEventDAO.obtain(queue[" + this.getQueueName(queue) + "], max[" + max + "]) entered."));
        }
        List list = null;
        try {
            Session session = HBSessionFactory.currentSession();
            String queryString = "from c in class " + Event.class + " where (queue_id = ?) and (isPending='1') ";
            if (fromPKId != null) {
                queryString = String.valueOf(queryString) + "and (id > ?) ";
            }
            queryString = isDescendingOrder ? String.valueOf(queryString) + "order by id DESC" : String.valueOf(queryString) + "order by id";
            Query query = session.createQuery(queryString);
            query.setParameter(0, (Object)queue.getId());
            if (fromPKId != null) {
                query.setParameter(1, (Object)fromPKId);
            }
            query.setFirstResult(0);
            query.setMaxResults(max);
            list = query.list();
            return list.toArray(new Event[list.size()]);
        }
        catch (SerializationException se) {
            logger.error((Object)" HbEventDAO.obtain serialization Error: ", (Throwable)se);
            return EMPTY_EVENTS;
        }
        catch (Exception e) {
            logger.error((Object)" HbEventDAO.obtain Error: ", (Throwable)e);
            throw new DataAccessException(e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbEventDAO.obtain Error: ", e);
            throw new DataAccessException("HbEventDAO obtain Error: " + e.getMessage());
        }
    }

    @Override
    public int count(Queue queue) {
        try {
            Session session = HBSessionFactory.currentSession();
            String query = "select count(*) from Event event where event.queue = :queue and isPending = 1";
            Integer count = (Integer)session.createQuery(query).setEntity("queue", (Object)queue).uniqueResult();
            return count;
        }
        catch (HibernateException e) {
            logger.error((Object)" HbEventDAO.count Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    private String getQueueName(Queue queue) {
        return queue != null ? queue.getName() : "null";
    }

    @Override
    public void update(Event event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbEventDAO.update(event) entered.");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            if (event.isNew()) {
                event.setAuditInfo(this.createAuditInfo());
                session.save((Object)event);
            } else {
                session.update((Object)event);
            }
        }
        catch (HibernateException e) {
            String msg = this.getHL7Message(event.getData());
            logger.error((Object)(" HbEventDAO.update Error: " + msg), (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = this.getHL7Message(event.getData());
            logger.error((Object)(" HbEventDAO.update Error: " + msg), (Throwable)e);
            throw new DataAccessException(e);
        }
        catch (Throwable e) {
            String msg = this.getHL7Message(event.getData());
            logger.error((Object)(" HbEventDAO.update Error: " + msg), e);
            throw new DataAccessException("HbEventDAO update exception: " + e.getMessage());
        }
    }

    private String getHL7Message(Serializable o) {
        String msg = "Message Type: " + o.getClass().getName();
        if (o instanceof PersonIdentityImpl) {
            PersonIdentityImpl pi = (PersonIdentityImpl)o;
            msg = String.valueOf(msg) + ", PersonIdentityImpl: " + pi.getVPID().getIdentifier();
        } else if (o instanceof ISaveableMessage) {
            ISaveableMessage sm = (ISaveableMessage)((Object)o);
            msg = String.valueOf(msg) + ", " + sm.getSerializableMessage().toString();
        } else if (o instanceof MessageHolder) {
            MessageHolder mh = (MessageHolder)o;
            msg = String.valueOf(msg) + ", " + mh.getEncodedMessage();
        }
        return msg;
    }

    @Override
    public Event obtainById(Integer id) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbEventDAO.obtainById ");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            Event result = (Event)session.createQuery("from Event obj where obj.id = :value").setLong("value", id.longValue()).uniqueResult();
            return result;
        }
        catch (HibernateException e) {
            logger.error((Object)" HbEventDAO.obtainById Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbEventDAO.obtainById Error: ", (Throwable)e);
            throw new DataAccessException(e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbEventDAO.obtainById Error: ", e);
            throw new DataAccessException("HbEventDAO obtainById Error: " + e.getMessage());
        }
    }

    @Override
    public void delete(Event event) {
        try {
            HBSessionFactory.currentSession().delete((Object)event);
        }
        catch (HibernateException e) {
            logger.error((Object)"HibernateException caught!", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)" HbEventDAO.delete Error: ", (Throwable)e);
            throw new DataAccessException(e);
        }
        catch (Throwable e) {
            logger.error((Object)" HbEventDAO.delete Error: ", e);
            throw new DataAccessException("HbEventDAO delete Error: " + e.getMessage());
        }
    }
}

