/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.common.IPersonCorrelation;
import gov.va.med.person.idmgmt.common.ISystemOfInterest;
import gov.va.med.person.idmgmt.db.AbstractHbDAO;
import gov.va.med.person.idmgmt.db.ICorrelationDAO;
import gov.va.med.person.idmgmt.db.hb.PersonCorrelation;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.person.idmgmt.sds.IdmAssigningAuthority;
import gov.va.med.term.access.IdentifierType;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import org.apache.log4j.Logger;

public class HbCorrelationDAO
extends AbstractHbDAO
implements ICorrelationDAO {
    private static final Logger logger = Logger.getLogger(HbCorrelationDAO.class);

    @Override
    public PersonCorrelation[] obtainBySurvivingCorrelation(IPersonCorrelation[] descendants) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbCorrelationDAO.obtainBySurvivingCorrelation ");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            List list = session.createCriteria(PersonCorrelation.class).add(Expression.in((String)"survivingCorrelation", (Object[])descendants)).list();
            return list.toArray(new PersonCorrelation[list.size()]);
        }
        catch (HibernateException e) {
            logger.error((Object)" HbCorrelationDAO.obtainBySurvivingCorrelation Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public void update(PersonCorrelation personCorrelation) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbCorrelationDAO.update(personCorrelation) entered.");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            if (personCorrelation.isNew()) {
                if (IdmAssigningAuthority.CODE_SOURCE_IDM.equalsIgnoreCase(personCorrelation.getIdmAssigningAuthority().getCodeSource())) {
                    personCorrelation.setAAOID(personCorrelation.getIdmAssigningAuthority().getCode());
                }
                personCorrelation.setAuditInfo(this.createAuditInfo());
                session.save((Object)personCorrelation);
                personCorrelation.onSave();
            } else {
                session.update((Object)personCorrelation);
            }
        }
        catch (HibernateException e) {
            logger.error((Object)" HbCorrelationDAO.update Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public PersonCorrelation obtainFromKeyString(String string) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***HbCorrelationDAO.obtainFromKeyString ");
        }
        try {
            Session session = HBSessionFactory.currentSession();
            PersonCorrelation result = (PersonCorrelation)session.createCriteria(IPersonCorrelation.class).add((Criterion)Expression.eq((String)"id", (Object)Long.valueOf(string))).uniqueResult();
            return result;
        }
        catch (HibernateException e) {
            logger.error((Object)" HbCorrelationDAO.obtainFromKeyString Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public PersonCorrelation[] obtainBySoiAndIdAndIDTypeAndStatus(ISystemOfInterest sysOfInterest, String identifier, IdentifierType idType, String status) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new StringBuffer(" ***HbCorrelationDAO.obtainBySoiAndIdAndIDTypeAndStatus, sysOfInterest=").append(sysOfInterest).append(", identifier=").append(identifier).append(", idType").append(idType).append(", status=").append(status).toString());
        }
        try {
            Session session = HBSessionFactory.currentSession();
            Criterion criteria = Expression.and((Criterion)Expression.eq((String)"systemOfInterest", (Object)sysOfInterest), (Criterion)Expression.eq((String)"altKey1", (Object)identifier));
            criteria = Expression.and((Criterion)criteria, (Criterion)Expression.eq((String)"identifierTypeId", (Object)idType.getId()));
            if (status != null && !"200ESR".equalsIgnoreCase(sysOfInterest.getSiteCode())) {
                criteria = Expression.and((Criterion)criteria, (Criterion)Expression.eq((String)"status", (Object)status));
            }
            logger.debug((Object)("criteria: " + criteria));
            List list = session.createCriteria(PersonCorrelation.class).add(criteria).list();
            PersonCorrelation[] result = list.toArray(new PersonCorrelation[list.size()]);
            logger.debug((Object)("obtainBySoiAndIdAndIDTypeAndStatus length: " + result.length));
            return result;
        }
        catch (HibernateException e) {
            logger.error((Object)" HbCorrelationDAO.obtainBySoiAndIdAndIDTypeAndStatus Error: ", (Throwable)e);
            throw new DataAccessException((Exception)((Object)e));
        }
    }
}

