/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import ca.uhn.hl7v2.model.Message;
import gov.va.med.person.exceptions.NoRecordFoundException;
import gov.va.med.person.exceptions.PSException;
import gov.va.med.person.idmgmt.Address;
import gov.va.med.person.idmgmt.IPersonIdentity;
import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.PersonIdentityImpl;
import gov.va.med.person.idmgmt.PersonIdentityResponse;
import gov.va.med.person.idmgmt.Phone;
import gov.va.med.person.idmgmt.common.IPersonVPID;
import gov.va.med.person.idmgmt.db.AbstractHbDAO;
import gov.va.med.person.idmgmt.db.IActiveCorrelationDAO;
import gov.va.med.person.idmgmt.db.PSDaoFactory;
import gov.va.med.person.idmgmt.db.hb.AliasSSNLink;
import gov.va.med.person.idmgmt.db.hb.PersonAddressHistory;
import gov.va.med.person.idmgmt.db.hb.PersonCorrelation;
import gov.va.med.person.idmgmt.db.hb.PersonNameHistory;
import gov.va.med.person.idmgmt.db.hb.PersonPhoneHistory;
import gov.va.med.person.idmgmt.db.hb.PersonTraitHistory;
import gov.va.med.person.idmgmt.db.hb.PersonVPID;
import gov.va.med.person.idmgmt.db.hb.SSNHistory;
import gov.va.med.person.idmgmt.db.hb.SystemOfInterest;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.factory.QualifiedIdentifierFactory;
import gov.va.med.person.idmgmt.factory.SSNFactory;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.person.idmgmt.types.ImpreciseDate;
import gov.va.med.person.idmgmt.util.PSIMSettings;
import gov.va.med.term.access.AddressType;
import gov.va.med.term.access.PersonCategory;
import gov.va.med.term.access.PhoneContactType;
import gov.va.med.term.access.State;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import org.apache.log4j.Logger;

public class HbActiveCorrelationDAO
extends AbstractHbDAO
implements IActiveCorrelationDAO {
    private static final Logger logger = Logger.getLogger(HbActiveCorrelationDAO.class);
    private static final long TWO_DAY_MILLISCONDS = 172800000L;
    private static final Integer FINALIZED_VERSION = new Integer(-1);

    @Override
    public IPersonIdentity[] getPrimaryViewHistory(String vpid, Date effDate, Date expDate, boolean includeDeprecated) throws PSException {
        PersonVPID origVpidObject;
        block9: {
            origVpidObject = PSDaoFactory.instance().getVpidDAO().obtainByVpid(vpid);
            if (origVpidObject != null) break block9;
            return null;
        }
        try {
            Long[] soiIdArray = new Long[]{new Long(47L), new Long(52L)};
            IPersonIdentity[] ipiArray = this.getCorrelationHistory(origVpidObject, vpid, soiIdArray, true, effDate, expDate, false);
            if (includeDeprecated && ipiArray.length > 0 && ipiArray[0].hasDeprecatedInfo()) {
                ArrayList<IPersonIdentity> fullDescList = new ArrayList<IPersonIdentity>();
                fullDescList.addAll(Arrays.asList(ipiArray));
                IPersonVPID activeVpidObject = origVpidObject;
                if (origVpidObject.getSurvivingVPID() != null) {
                    activeVpidObject = this.getSurvivingVpid(origVpidObject);
                }
                boolean hasMoreDescendents = false;
                List decendentCheckList = new ArrayList<PersonVPID>();
                decendentCheckList.add(activeVpidObject);
                do {
                    hasMoreDescendents = false;
                    if ((decendentCheckList = this.getDescendentList(decendentCheckList)) == null || decendentCheckList.size() <= 0) continue;
                    int d = 0;
                    while (d < decendentCheckList.size()) {
                        IPersonVPID descVpidObject = (IPersonVPID)decendentCheckList.get(d);
                        IPersonIdentity[] ipiDescArray = this.getCorrelationHistory(descVpidObject, descVpidObject.getVpid(), soiIdArray, true, effDate, expDate, true);
                        fullDescList.addAll(Arrays.asList(ipiDescArray));
                        ++d;
                    }
                    hasMoreDescendents = true;
                } while (hasMoreDescendents);
                ipiArray = fullDescList.toArray(new IPersonIdentity[fullDescList.size()]);
            }
            return ipiArray;
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (PSException pse) {
            throw pse;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PSException("[PSIM ERROR] getCorrelationHistory VPID: " + vpid, e);
        }
    }

    private List getDescendentList(List decendentCheckList) throws Exception {
        List newDescList = new ArrayList();
        int d = 0;
        while (d < decendentCheckList.size()) {
            Session session = HBSessionFactory.currentSession();
            String sql = "FROM PersonVPID vp where vp.survivingVPID=:vpid";
            Query query = session.createQuery(sql);
            IPersonVPID checkPersonVPID = (IPersonVPID)decendentCheckList.get(d);
            query.setLong("vpid", checkPersonVPID.getId().longValue());
            newDescList = query.list();
            ++d;
        }
        return newDescList;
    }

    @Override
    public IPersonIdentity[] getCorrelationHistory(IPersonVPID vpidObject, String sourceIdentifier, Long[] soiIdArray, boolean isPrimaryView, Date effDate, Date expDate, boolean includeDeprecated) throws PSException {
        try {
            Session session = HBSessionFactory.currentSession();
            Query query = null;
            String sql = "";
            boolean hasDeprecatedInfo = false;
            IPersonVPID activeVpidObject = vpidObject;
            if (vpidObject.getSurvivingVPID() != null) {
                hasDeprecatedInfo = true;
                if (!includeDeprecated) {
                    activeVpidObject = this.getSurvivingVpid(vpidObject);
                    if (isPrimaryView) {
                        sourceIdentifier = activeVpidObject.getVpid();
                    }
                }
            }
            Long activeVpid_id = activeVpidObject.getId();
            if (!hasDeprecatedInfo) {
                sql = "SELECT COUNT(vp.vpid) FROM PersonVPID vp WHERE vp.survivingVPID=:pvVpidId";
                query = session.createQuery(sql);
                query.setLong("pvVpidId", activeVpid_id.longValue());
                Integer survivingCount = (Integer)query.uniqueResult();
                if (survivingCount > 0) {
                    hasDeprecatedInfo = true;
                }
            }
            sql = "from PersonCorrelation pc where pc.personVPID=:pvVpidId AND pc.altKey1=:srcId AND pc.systemOfInterest IN(:sois)";
            query = session.createQuery(sql);
            query.setParameterList("sois", (Object[])soiIdArray);
            query.setString("srcId", sourceIdentifier);
            query.setLong("pvVpidId", activeVpid_id.longValue());
            PersonCorrelation pc = (PersonCorrelation)query.uniqueResult();
            if (pc == null) {
                throw new PSException("[VHA_IDM_SERVICE] getCorrelationHistory CORRELATION NOT FOUND: Src Id:" + sourceIdentifier + " - PersonVPID id:" + activeVpid_id);
            }
            Long trait_id = pc.getPersonTrait().getId();
            ArrayList<String> pccList = new ArrayList<String>();
            sql = "SELECT cc.categoryId from CorrelationCategory cc where cc.personCorrelation=:pcId AND cc.status='A'";
            query = session.createQuery(sql);
            query.setLong("pcId", pc.getId().longValue());
            List catList = query.list();
            int pcc = 0;
            while (pcc < catList.size()) {
                pccList.add(PersonCategory.factory.obtainFromKeyValue((Long)catList.get(pcc)).getCode());
                ++pcc;
            }
            IPersonIdentity[] piiArray = this.getCorrelationHistory(trait_id, isPrimaryView, effDate, expDate);
            int i = 0;
            while (i < piiArray.length) {
                this.mapVpid(activeVpidObject, (PersonIdentityImpl)piiArray[i]);
                this.mapCorrelation(pc, (PersonIdentityImpl)piiArray[i]);
                ((PersonIdentityImpl)piiArray[i]).setDeprecatedInfo(hasDeprecatedInfo);
                ((PersonIdentityImpl)piiArray[i]).setCategoryList(pccList);
                ++i;
            }
            return piiArray;
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (PSException pse) {
            throw pse;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PSException("[PSIM ERROR] getCorrelationHistory CORRELATION: " + isPrimaryView, e);
        }
    }

    private PersonIdentityImpl[] getCorrelationHistory(Long trait_id, boolean isPrimaryView, Date effDate, Date expDate) throws PSException {
        try {
            int maxReturn = 10;
            Session session = HBSessionFactory.currentSession();
            String sql = "from PersonTraitHistory pth where pth.owner=:pvTraitId";
            if (effDate != null) {
                sql = String.valueOf(sql) + " AND pth.effectiveDate <= :effDate";
            }
            if (expDate != null) {
                sql = String.valueOf(sql) + " AND pth.expirationDate >= :expDate";
            }
            sql = String.valueOf(sql) + " ORDER BY pth.effectiveDate DESC";
            Query query = session.createQuery(sql);
            query.setLong("pvTraitId", trait_id.longValue());
            query.setMaxResults(maxReturn);
            query.setFetchSize(maxReturn);
            if (effDate != null) {
                query.setDate("effDate", effDate);
            }
            if (expDate != null) {
                query.setDate("expDate", expDate);
            }
            List traitHistoryList = query.list();
            HashMap<Timestamp, PersonIdentityImpl> piiMap = new HashMap<Timestamp, PersonIdentityImpl>();
            Object[] effKeys = new Timestamp[traitHistoryList.size()];
            PersonIdentityImpl[] piiArray = new PersonIdentityImpl[traitHistoryList.size()];
            if (piiArray.length != 0) {
                int start;
                int piiCount = 0;
                int i = start = traitHistoryList.size() - 1;
                while (i > -1) {
                    PersonTraitHistory traitHistory = (PersonTraitHistory)traitHistoryList.get(i);
                    piiArray[piiCount] = new PersonIdentityImpl();
                    this.mapTraitHistory(traitHistory, piiArray[piiCount]);
                    piiMap.put(traitHistory.getEffectiveDate(), piiArray[piiCount]);
                    effKeys[piiCount] = traitHistory.getEffectiveDate();
                    ++piiCount;
                    --i;
                }
                sql = "SELECT pnh from PersonNameHistory pnh INNER JOIN pnh.owner as pn WHERE pn.personTrait=:pvTraitId AND pnh.effectiveDate IN(:effKeys)";
                query = session.createQuery(sql);
                query.setParameterList("effKeys", effKeys);
                query.setLong("pvTraitId", trait_id.longValue());
                List nameHistoryList = query.list();
                int i2 = 0;
                while (i2 < nameHistoryList.size()) {
                    PersonNameHistory nameHistory = (PersonNameHistory)nameHistoryList.get(i2);
                    if (piiMap.containsKey(nameHistory.getEffectiveDate())) {
                        this.mapName(nameHistory, (PersonIdentityImpl)piiMap.get(nameHistory.getEffectiveDate()));
                    }
                    ++i2;
                }
                sql = "SELECT ssnh from SSNHistory ssnh INNER JOIN ssnh.owner as ssn WHERE ssn.personTrait=:pvTraitId AND ssnh.ssnTypeId='1506641' AND ssnh.effectiveDate IN(:effKeys)";
                query = session.createQuery(sql);
                query.setParameterList("effKeys", effKeys);
                query.setLong("pvTraitId", trait_id.longValue());
                List ssnHistoryList = query.list();
                int i3 = 0;
                while (i3 < ssnHistoryList.size()) {
                    SSNHistory ssnHistory = (SSNHistory)ssnHistoryList.get(i3);
                    if (piiMap.containsKey(ssnHistory.getEffectiveDate())) {
                        ((PersonIdentityImpl)piiMap.get(ssnHistory.getEffectiveDate())).setSSN(SSNFactory.create(ssnHistory));
                    }
                    ++i3;
                }
                if (!isPrimaryView) {
                    this.setAddressPhoneHistory();
                }
            }
            return piiArray;
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PSException("[PSIM ERROR] getCorrelationHistory TRAIT: " + trait_id + "-" + isPrimaryView, e);
        }
    }

    private void setAddressPhoneHistory() {
    }

    @Override
    public void tagTraitHistories(Long trait_id, String modTag) {
        try {
            Session session = HBSessionFactory.currentSession();
            String sql = "from PersonTraitHistory pth where pth.owner=:pvTraitId and pth.active=1";
            Query query = session.createQuery(sql);
            query.setLong("pvTraitId", trait_id.longValue());
            PersonTraitHistory ptHist = (PersonTraitHistory)query.uniqueResult();
            ptHist.setVersion(FINALIZED_VERSION);
            sql = "SELECT pnh from PersonNameHistory pnh INNER JOIN pnh.owner as pn WHERE pn.personTrait=:pvTraitId and pnh.active=1";
            query = session.createQuery(sql);
            query.setLong("pvTraitId", trait_id.longValue());
            List nameList = query.list();
            PersonNameHistory nameHistory = null;
            int i = 0;
            while (i < nameList.size()) {
                nameHistory = (PersonNameHistory)nameList.get(i);
                nameHistory.setVersion(FINALIZED_VERSION);
                if (nameHistory.getAliasSSNLinks() != null && nameHistory.getAliasSSNLinks().size() > 0) {
                    ((AliasSSNLink)nameHistory.getAliasSSNLinks().iterator().next()).setVersion(FINALIZED_VERSION);
                }
                ++i;
            }
            sql = "SELECT ssnh from SSNHistory ssnh INNER JOIN ssnh.owner as ssn WHERE ssn.personTrait=:pvTraitId AND ssnh.active=1 AND (ssnh.ssnTypeId='1506641' or ssnh.ssnTypeId='1506642')";
            query = session.createQuery(sql);
            query.setLong("pvTraitId", trait_id.longValue());
            List ssnList = query.list();
            int ssn = 0;
            while (ssn < ssnList.size()) {
                SSNHistory ssnHist = (SSNHistory)ssnList.get(ssn);
                ssnHist.setVersion(FINALIZED_VERSION);
                ++ssn;
            }
            sql = "SELECT addh from PersonAddressHistory addh INNER JOIN addh.owner as add WHERE add.personTrait=:pvTraitId AND addh.isActive=1";
            query = session.createQuery(sql);
            query.setLong("pvTraitId", trait_id.longValue());
            List addList = query.list();
            int add = 0;
            while (add < addList.size()) {
                PersonAddressHistory addHist = (PersonAddressHistory)addList.get(add);
                addHist.setVersion(FINALIZED_VERSION);
                ++add;
            }
            sql = "SELECT phoneh from PersonPhoneHistory phoneh INNER JOIN phoneh.owner as phone WHERE phone.personTrait=:pvTraitId AND phoneh.isActive=1";
            query = session.createQuery(sql);
            query.setLong("pvTraitId", trait_id.longValue());
            List phoneList = query.list();
            int phn = 0;
            while (phn < phoneList.size()) {
                PersonPhoneHistory phoneHist = (PersonPhoneHistory)phoneList.get(phn);
                phoneHist.setVersion(FINALIZED_VERSION);
                ++phn;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public PersonIdentityResponse getCorrelations(IPersonVPID personVPID) throws NoRecordFoundException, PSException {
        return this.getCorrelations(personVPID, 0L, -1);
    }

    @Override
    public PersonIdentityResponse getCorrelations(IPersonVPID personVPID, long pcPkStart, int maxCorrelations) throws NoRecordFoundException, PSException {
        try {
            PersonIdentityImpl[] piiArray = null;
            Long lastCorPkId = new Long(0L);
            int totalCorrelations = 0;
            Session session = HBSessionFactory.currentSession();
            String sql = "from PersonCorrelation pc where pc.personVPID=:pvVpidId ";
            sql = String.valueOf(sql) + "AND pc.id>:pcPkId ORDER BY pc.id ASC";
            Query query = session.createQuery(sql);
            query.setLong("pcPkId", pcPkStart);
            query.setLong("pvVpidId", personVPID.getId().longValue());
            List pcList = query.list();
            if (pcList.size() > 0) {
                int implSize = pcList.size();
                totalCorrelations = pcList.size();
                if (maxCorrelations > 0 && implSize > maxCorrelations) {
                    implSize = maxCorrelations;
                }
                piiArray = new PersonIdentityImpl[implSize];
                int c = 0;
                while (c < implSize) {
                    piiArray[c] = new PersonIdentityImpl();
                    PersonCorrelation pc = (PersonCorrelation)pcList.get(c);
                    Long trait_id = pc.getPersonTrait().getId();
                    this.mapVpid(personVPID, piiArray[c]);
                    this.mapCorrelation(pc, piiArray[c]);
                    ArrayList<String> pccList = new ArrayList<String>();
                    sql = "SELECT cc.categoryId from CorrelationCategory cc where cc.personCorrelation=:pcId AND cc.status='A'";
                    query = session.createQuery(sql);
                    query.setLong("pcId", pc.getId().longValue());
                    List catList = query.list();
                    int pcc = 0;
                    while (pcc < catList.size()) {
                        pccList.add(PersonCategory.factory.obtainFromKeyValue((Long)catList.get(pcc)).getCode());
                        ++pcc;
                    }
                    piiArray[c].setCategoryList(pccList);
                    sql = "from PersonTraitHistory pth where pth.owner=:pvTraitId and pth.active=1";
                    query = session.createQuery(sql);
                    query.setLong("pvTraitId", trait_id.longValue());
                    PersonTraitHistory pthObject = (PersonTraitHistory)query.uniqueResult();
                    this.mapTraitHistory(pthObject, piiArray[c]);
                    sql = "SELECT pnh from PersonNameHistory pnh INNER JOIN pnh.owner as pn WHERE pn.personTrait=:pvTraitId and pnh.active=1";
                    query = session.createQuery(sql);
                    query.setLong("pvTraitId", trait_id.longValue());
                    this.mapName(query.list(), piiArray[c]);
                    sql = "SELECT ssnh from SSNHistory ssnh INNER JOIN ssnh.owner as ssn WHERE ssn.personTrait=:pvTraitId AND ssnh.active=1 AND (ssnh.ssnTypeId='1506641' or ssnh.ssnTypeId='1506642')";
                    query = session.createQuery(sql);
                    query.setLong("pvTraitId", trait_id.longValue());
                    List ssnList = query.list();
                    int ssn = 0;
                    while (ssn < ssnList.size()) {
                        SSNHistory ssnHist = (SSNHistory)ssnList.get(ssn);
                        piiArray[c].setSSN(SSNFactory.create(ssnHist));
                        ++ssn;
                    }
                    this.setAddressAndPhone(trait_id, piiArray[c]);
                    if (c == implSize - 1) {
                        lastCorPkId = pc.getId();
                    }
                    ++c;
                }
            } else if (pcPkStart > 0L) {
                totalCorrelations = 0;
                lastCorPkId = new Long(-1L);
            } else {
                throw new NoRecordFoundException("No Correlations found under ICN/VPID Id:" + personVPID);
            }
            return new PersonIdentityResponse(piiArray, lastCorPkId, totalCorrelations);
        }
        catch (PSException e) {
            e.printStackTrace();
            throw new PSException(String.valueOf(e.getMessage()) + " [VPID: " + personVPID.getVpid() + "]");
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (NoRecordFoundException nrfe) {
            throw nrfe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PSException("[PSIM ERROR] getCorrelations VPID: " + personVPID, e);
        }
    }

    @Override
    public PersonIdentityResponse getPersonIdentity(String vpid, boolean returnDeprecatedIndentity, boolean returnHistory, String checkStation) throws NoRecordFoundException, PSException {
        try {
            PersonIdentityImpl pii = new PersonIdentityImpl();
            Session session = HBSessionFactory.currentSession();
            String sql = "FROM PersonVPID vp where vp.vpid=:myVpid";
            Query query = session.createQuery(sql);
            query.setString("myVpid", vpid);
            PersonVPID origVpidObject = (PersonVPID)query.uniqueResult();
            if (origVpidObject == null) {
                String nrfMessage = "No VPID found for id " + vpid + " Parameter [Station]:" + checkStation;
                logger.error((Object)nrfMessage);
                throw new NoRecordFoundException(nrfMessage);
            }
            boolean hasDeprecatedInfo = false;
            IPersonVPID activeVpidObject = origVpidObject;
            if (origVpidObject.getSurvivingVPID() != null) {
                if (!returnDeprecatedIndentity) {
                    activeVpidObject = this.getSurvivingVpid(origVpidObject);
                }
                hasDeprecatedInfo = true;
            }
            this.mapVpid(activeVpidObject, pii);
            Long activeVpid_id = activeVpidObject.getId();
            if (!hasDeprecatedInfo) {
                sql = "SELECT COUNT(vp.vpid) FROM PersonVPID vp WHERE vp.survivingVPID=:pvVpidId";
                query = session.createQuery(sql);
                query.setLong("pvVpidId", activeVpid_id.longValue());
                Integer survivingCount = (Integer)query.uniqueResult();
                if (survivingCount > 0) {
                    hasDeprecatedInfo = true;
                }
            }
            pii.setDeprecatedInfo(hasDeprecatedInfo);
            sql = "from PersonCorrelation pc where pc.personVPID=:pvVpidId AND pc.systemOfInterest IN('47','52')";
            query = session.createQuery(sql);
            query.setLong("pvVpidId", activeVpid_id.longValue());
            PersonCorrelation pc = (PersonCorrelation)query.uniqueResult();
            Long trait_id = pc.getPersonTrait().getId();
            this.mapCorrelation(pc, pii);
            ArrayList<String> pccList = new ArrayList<String>();
            sql = "SELECT cc.categoryId from CorrelationCategory cc where cc.personCorrelation=:pcId AND cc.status='A'";
            query = session.createQuery(sql);
            query.setLong("pcId", pc.getId().longValue());
            List catList = query.list();
            int pcc = 0;
            while (pcc < catList.size()) {
                pccList.add(PersonCategory.factory.obtainFromKeyValue((Long)catList.get(pcc)).getCode());
                ++pcc;
            }
            pii.setCategoryList(pccList);
            int checkStationCount = 0;
            SystemOfInterest checkStationSOI = null;
            if (checkStation != null && checkStation.length() > 0 && (checkStationSOI = PSDaoFactory.instance().getSystemOfInterestDAO().obtainBySiteCode(checkStation)) != null) {
                sql = "select count(*) from PersonCorrelation pc where pc.personVPID=:pvVpidId AND pc.systemOfInterest=:checkStation";
                query = session.createQuery(sql);
                query.setLong("pvVpidId", activeVpid_id.longValue());
                query.setLong("checkStation", checkStationSOI.getId().longValue());
                checkStationCount = (Integer)query.uniqueResult();
            }
            long traitId = trait_id;
            sql = "from PersonTraitHistory pth where pth.owner=:pvTraitId and pth.active=1";
            query = session.createQuery(sql);
            query.setLong("pvTraitId", traitId);
            logger.info((Object)("^^^^^^ OWNER TRAIT ID IS " + traitId));
            PersonTraitHistory pthObject = (PersonTraitHistory)query.uniqueResult();
            this.mapTraitHistory(pthObject, pii);
            sql = "SELECT count(pth.updateStatus) from PersonCorrelation pc, PersonTraitHistory pth WHERE pth.owner=pc.personTrait AND pc.personVPID=:pvVpidId AND pc.status='A' AND pth.updateStatus='P' and pth.active=1";
            query = session.createQuery(sql);
            query.setLong("pvVpidId", activeVpid_id.longValue());
            Integer updateCount = (Integer)query.uniqueResult();
            if (updateCount > 0) {
                pii.setUpdatePending(true);
                pii.setUpdateStatus("P");
            } else {
                pii.setUpdatePending(false);
            }
            sql = "SELECT pnh from PersonNameHistory pnh INNER JOIN pnh.owner as pn WHERE pn.personTrait=:pvTraitId and pnh.active=1";
            query = session.createQuery(sql);
            query.setLong("pvTraitId", trait_id.longValue());
            this.mapName(query.list(), pii);
            sql = "SELECT ssnh from SSNHistory ssnh INNER JOIN ssnh.owner as ssn WHERE ssn.personTrait=:pvTraitId AND ssnh.active=1 AND (ssnh.ssnTypeId='1506641' or ssnh.ssnTypeId='1506642')";
            query = session.createQuery(sql);
            query.setLong("pvTraitId", trait_id.longValue());
            List ssnList = query.list();
            int ssn = 0;
            while (ssn < ssnList.size()) {
                SSNHistory ssnHist = (SSNHistory)ssnList.get(ssn);
                pii.setSSN(SSNFactory.create(ssnHist));
                ++ssn;
            }
            this.setAddressAndPhone(trait_id, pii);
            if (returnHistory) {
                IPersonIdentity[] piiArray = this.getCorrelationHistory(trait_id, true, null, null);
                int i = 0;
                while (i < piiArray.length) {
                    this.mapVpid(activeVpidObject, (PersonIdentityImpl)piiArray[i]);
                    this.mapCorrelation(pc, (PersonIdentityImpl)piiArray[i]);
                    ((PersonIdentityImpl)piiArray[i]).setDeprecatedInfo(hasDeprecatedInfo);
                    ++i;
                }
                pii.setHistory(piiArray);
            }
            return new PersonIdentityResponse(pii, activeVpidObject, checkStationCount, checkStationSOI);
        }
        catch (PSException e) {
            e.printStackTrace();
            throw new PSException(String.valueOf(e.getMessage()) + " [VPID: " + vpid + "]");
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (NoRecordFoundException nrfe) {
            throw nrfe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PSException("[PSIM ERROR] getPersonIdentity VPID: " + vpid, e);
        }
    }

    private void setAddressAndPhone(long traitId, PersonIdentityImpl pii) throws PSException {
        try {
            Session session = HBSessionFactory.currentSession();
            String sql = "SELECT addh from PersonAddressHistory addh INNER JOIN addh.owner as add WHERE add.personTrait=:pvTraitId AND addh.isActive=1";
            Query query = session.createQuery(sql);
            query.setLong("pvTraitId", traitId);
            this.mapAddress(query.list(), pii);
            sql = "SELECT phoneh from PersonPhoneHistory phoneh INNER JOIN phoneh.owner as phone WHERE phone.personTrait=:pvTraitId AND phoneh.isActive=1";
            query = session.createQuery(sql);
            query.setLong("pvTraitId", traitId);
            this.mapPhones(query.list(), pii);
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PSException(e);
        }
    }

    @Override
    public HashMap getPersonIdentity(IQualifiedIdentifier[] iqiList) throws NoRecordFoundException, PSException {
        String vpidStr = "";
        try {
            HashMap<IQualifiedIdentifier, Object> iqiMap = new HashMap<IQualifiedIdentifier, Object>(iqiList.length);
            Session session = HBSessionFactory.currentSession();
            String sqlWhere = "";
            int i = 0;
            while (i < iqiList.length) {
                if (iqiList[i].getAssigningLocation() != null) {
                    SystemOfInterest corrSoi = PSDaoFactory.instance().getSystemOfInterestDAO().obtainBySiteCode(iqiList[i].getAssigningLocation());
                    if (corrSoi != null) {
                        sqlWhere = String.valueOf(sqlWhere) + "(pc.altKey1='" + iqiList[i].getIdentifier() + "' AND pc.systemOfInterest='" + corrSoi.getId() + "') OR ";
                    } else {
                        iqiMap.put(iqiList[i], "Invalid Assigning Location!");
                    }
                } else {
                    iqiMap.put(iqiList[i], "Invalid Qualified Identifier!");
                }
                ++i;
            }
            if (sqlWhere.length() != 0) {
                sqlWhere = sqlWhere.substring(0, sqlWhere.length() - 4);
                String sql = "from PersonCorrelation pc where pc.status='A' AND (" + sqlWhere + ")";
                System.out.println("SQL:" + sql);
                Query query = session.createQuery(sql);
                List pcList = query.list();
                if (iqiList.length != pcList.size()) {
                    System.out.println("Not all correlations Found!");
                }
                boolean updatePending = false;
                PersonIdentityImpl[] piiArray = new PersonIdentityImpl[pcList.size()];
                int c = 0;
                while (c < pcList.size()) {
                    PersonCorrelation pc = (PersonCorrelation)pcList.get(c);
                    vpidStr = pc.getPersonVPID().getVpid();
                    piiArray[c] = new PersonIdentityImpl();
                    this.mapCorrelation(pc, piiArray[c]);
                    ArrayList<String> pccList = new ArrayList<String>();
                    sql = "SELECT cc.categoryId from CorrelationCategory cc where cc.personCorrelation=:pcId AND cc.status='A'";
                    query = session.createQuery(sql);
                    query.setLong("pcId", pc.getId().longValue());
                    List catList = query.list();
                    int pcc = 0;
                    while (pcc < catList.size()) {
                        pccList.add(PersonCategory.factory.obtainFromKeyValue((Long)catList.get(pcc)).getCode());
                        ++pcc;
                    }
                    piiArray[c].setCategoryList(pccList);
                    long traitId = pc.getPersonTrait().getId();
                    sql = "from PersonTraitHistory pth where pth.owner=:pvTraitId and pth.active=1";
                    query = session.createQuery(sql);
                    query.setLong("pvTraitId", traitId);
                    PersonTraitHistory pthObject = (PersonTraitHistory)query.uniqueResult();
                    this.mapTraitHistory(pthObject, piiArray[c]);
                    if (c == 0) {
                        sql = "SELECT count(pth.updateStatus) from PersonCorrelation pc, PersonTraitHistory pth WHERE pth.owner=pc.personTrait AND pc.personVPID=:pvVpidId AND pc.status='A' AND pth.updateStatus='P' and pth.active=1";
                        query = session.createQuery(sql);
                        query.setLong("pvVpidId", pc.getPersonVPID().getId().longValue());
                        Integer updateCount = (Integer)query.uniqueResult();
                        if (updateCount > 0) {
                            updatePending = true;
                        }
                    }
                    piiArray[c].setUpdatePending(updatePending);
                    if (updatePending) {
                        piiArray[c].setUpdateStatus("P");
                    }
                    sql = "SELECT pnh from PersonNameHistory pnh INNER JOIN pnh.owner as pn WHERE pn.personTrait=:pvTraitId and pnh.active=1";
                    query = session.createQuery(sql);
                    query.setLong("pvTraitId", pc.getPersonTrait().getId().longValue());
                    this.mapName(query.list(), piiArray[c]);
                    sql = "SELECT ssnh from SSNHistory ssnh INNER JOIN ssnh.owner as ssn WHERE ssn.personTrait=:pvTraitId AND ssnh.active=1 AND (ssnh.ssnTypeId='1506641' or ssnh.ssnTypeId='1506642')";
                    query = session.createQuery(sql);
                    query.setLong("pvTraitId", pc.getPersonTrait().getId().longValue());
                    List ssnList = query.list();
                    int ssn = 0;
                    while (ssn < ssnList.size()) {
                        SSNHistory ssnHist = (SSNHistory)ssnList.get(ssn);
                        piiArray[c].setSSN(SSNFactory.create(ssnHist));
                        ++ssn;
                    }
                    String stationNumber = pc.getSystemOfInterest().getSiteCode();
                    IQualifiedIdentifier pcIQI = QualifiedIdentifierFactory.create(pc.getAltKey1(), pc.getIdentifierType().getCode(), pc.getIdmAssigningAuthority().getCode(), stationNumber);
                    iqiMap.put(pcIQI, piiArray[c]);
                    ++c;
                }
            }
            return iqiMap;
        }
        catch (PSException e) {
            e.printStackTrace();
            throw new PSException(String.valueOf(e.getMessage()) + " [VPID: " + vpidStr + "]");
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw new DataAccessException((Exception)((Object)e));
        }
        catch (NoRecordFoundException nrfe) {
            throw nrfe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PSException("[IDM ERROR] getPersonIdentity IQI Array: ", e);
        }
    }

    private IPersonVPID getSurvivingVpid(IPersonVPID vpid) throws Exception {
        return this.getSurvivingVpid(vpid, new HashSet());
    }

    private IPersonVPID getSurvivingVpid(IPersonVPID vpid, HashSet path) throws Exception {
        if (vpid == null || !"D".equalsIgnoreCase(vpid.getIdState())) {
            return vpid;
        }
        if (path.contains(vpid.getId())) {
            throw new Exception("CORRUPT DATA EXCEPTION: Cyclical VPID Data. " + path.toString());
        }
        path.add(vpid.getId());
        return this.getSurvivingVpid(vpid.getSurvivingVPID(), path);
    }

    private void mapVpid(IPersonVPID vpid, PersonIdentityImpl pii) throws Exception {
        String vpidStation = "200M";
        if (vpid.getVpid().charAt(6) != '1') {
            vpidStation = "200PS";
        }
        Date expDate = null;
        Date effDate = vpid.getAuditInfo().getCreated();
        if (vpid.getOriginalCreationDate() != null) {
            effDate = vpid.getOriginalCreationDate();
        }
        if ("D".equals(vpid.getIdState())) {
            expDate = vpid.getAuditInfo().getUpdated();
        }
        IQualifiedIdentifier vpidIQI = QualifiedIdentifierFactory.create(vpid.getVpid(), "NI", "USVHA", vpidStation, vpidStation, effDate, expDate);
        pii.setVPID(vpidIQI);
        pii.setIDState(vpid.getIdState());
    }

    private void mapCorrelation(PersonCorrelation correlation, PersonIdentityImpl pii) throws Exception {
        String idType = correlation.getIdentifierType().getCode();
        String assignAuth = correlation.getIdmAssigningAuthority().getCode();
        String stationNumber = correlation.getSystemOfInterest().getSiteCode();
        IQualifiedIdentifier reqIdentifier = QualifiedIdentifierFactory.create(correlation.getAltKey1(), idType, assignAuth, stationNumber);
        pii.setRequestingIdentifier(reqIdentifier);
        pii.setCorrelationStatus(correlation.getStatus());
        pii.setSendingApplicationName(correlation.getAltKey5());
        String facilityName = correlation.getSystemOfInterest().getSiteName();
        pii.setSendingFacility(facilityName);
        String processingID = PSIMSettings.getInstance().getValue(Message.class, "processingID");
        pii.setProcessingID(processingID);
        pii.setTraitStatus(correlation.getAltKey4());
        if (correlation.getIdTheftRecordFlag() != null) {
            if (correlation.getIdTheftRecordFlag() == 1) {
                pii.setCategory(-20110311, "TRUE");
            } else if (correlation.getIdTheftRecordFlag() == 0) {
                pii.setCategory(-20110311, "FALSE");
            }
        }
    }

    private void setAuditInfo(PersonTraitHistory traitHistory, PersonIdentityImpl pii) {
        Timestamp eventTimestamp = traitHistory.getEventTimestamp();
        if (eventTimestamp == null) {
            eventTimestamp = new Timestamp(traitHistory.getAuditInfo().getCreated().getTime());
        }
        pii.setAuditEventTimestamp(eventTimestamp);
        String eventInfo = traitHistory.getEventPersonID();
        if (eventInfo != null) {
            String key = eventInfo.substring(0, 3);
            String value = eventInfo.substring(4);
            int indexOfColon = eventInfo.indexOf(":");
            if (indexOfColon > -1) {
                value = eventInfo.substring(0, indexOfColon);
                if ("null".equals(value)) {
                    value = null;
                }
                key = "IEN";
            }
            if ("IEN".equalsIgnoreCase(key)) {
                if (value != null) {
                    try {
                        IQualifiedIdentifier ienId = QualifiedIdentifierFactory.create(value, "EI", "USVHA");
                        pii.setAuditIdentifier(ienId);
                    }
                    catch (Exception exception) {}
                }
            } else if ("UID".equalsIgnoreCase(key)) {
                pii.setAuditUserId(value);
            }
        }
    }

    private void mapTraitHistory(PersonTraitHistory traitHistory, PersonIdentityImpl pii) throws PSException {
        if (traitHistory == null) {
            throw new PSException("Inconsistent Data found for person trait identity.");
        }
        this.setAuditInfo(traitHistory, pii);
        pii.setUpdateStatus(traitHistory.getUpdateStatus());
        if (traitHistory.getDob() != null) {
            pii.setDateOfBirth(new ImpreciseDate(traitHistory.getDob()));
        }
        if (traitHistory.getGender() != null) {
            pii.setGender(traitHistory.getGender().getCode());
        }
        pii.setMothersMaidenName(traitHistory.getMothersMaiden());
        pii.setPlaceOfBirthCity(traitHistory.getPobCity());
        pii.setUpdateStatus(traitHistory.getUpdateStatus());
        if (traitHistory.getPobState() != null) {
            pii.setPlaceOfBirthState(traitHistory.getPobState().getPostalName());
        }
        if (traitHistory.getPobCountry() != null) {
            pii.setPlaceOfBirthCountry(traitHistory.getPobCountry().getAlpha3Code());
        }
        if (traitHistory.getMultiBirthInd() != null) {
            pii.setMultiBirth(traitHistory.getMultiBirth());
        }
        if (traitHistory.getDataman() != null) {
            String dataMan = String.valueOf(traitHistory.getDataman()) + "^^^^^END NOT USED";
            String[] mviFlds = dataMan.split("\\^");
            String tin = mviFlds[0];
            pii.setCategory(-201108111, tin);
            String fin = mviFlds[1];
            pii.setCategory(-201108112, fin);
            String roiSigned = mviFlds[2];
            pii.setCategory(-201108101, roiSigned);
            String ipp = mviFlds[3];
            pii.setCategory(-201108102, ipp);
            String idState = mviFlds[4];
            pii.setCategory(-201108113, idState);
        }
    }

    private void mapName(List nameList, PersonIdentityImpl pii) {
        PersonNameHistory nameHistory = null;
        int i = 0;
        while (i < nameList.size()) {
            nameHistory = (PersonNameHistory)nameList.get(i);
            this.mapName(nameHistory, pii);
            ++i;
        }
    }

    private void mapName(PersonNameHistory nameHistory, PersonIdentityImpl pii) {
        int nameIndex = 0;
        if ("L".equalsIgnoreCase(nameHistory.getNameType().getCode())) {
            nameIndex = 0;
        } else {
            if (pii.getNumberOfNames() == 0) {
                pii.setLastName(0, "STUB");
            }
            nameIndex = pii.getNumberOfNames();
        }
        pii.setNameType(nameIndex, nameHistory.getNameType().getCode());
        pii.setLastName(nameIndex, nameHistory.getLastName());
        pii.setFirstName(nameIndex, nameHistory.getFirstName());
        pii.setMiddleName(nameIndex, nameHistory.getMiddleName());
        pii.setPrefix(nameIndex, nameHistory.getNamePrefix());
        pii.setSuffix(nameIndex, nameHistory.getNameSuffix());
        if (nameHistory.getAliasSSNLinks() != null && nameHistory.getAliasSSNLinks().size() > 0) {
            pii.setAliasSSN(nameIndex, SSNFactory.create(((AliasSSNLink)nameHistory.getAliasSSNLinks().iterator().next()).getAliasSSN()));
        }
    }

    private void mapPhones(List phoneList, PersonIdentityImpl pii) {
        int i = 0;
        while (i < phoneList.size()) {
            PersonPhoneHistory phoneHistory = (PersonPhoneHistory)phoneList.get(i);
            this.mapPhone(phoneHistory, pii);
            ++i;
        }
    }

    private void mapPhone(PersonPhoneHistory phoneHistory, PersonIdentityImpl pii) {
        Phone phone = new Phone();
        phone.setArea(phoneHistory.getArea());
        phone.setCountryCode(phoneHistory.getCountryCode());
        phone.setExtension(phoneHistory.getExtension());
        phone.setNumber(phoneHistory.getNumber());
        PhoneContactType phoneTypeId = PhoneContactType.factory.obtainFromKeyValue(phoneHistory.getPhoneTypeId());
        if (phoneTypeId != null) {
            phone.setPhoneType(phoneTypeId.getName());
            try {
                pii.addPhone(phone);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }

    private void mapAddress(List addressList, PersonIdentityImpl pii) {
        int i = 0;
        while (i < addressList.size()) {
            PersonAddressHistory addHistory = (PersonAddressHistory)addressList.get(i);
            this.mapAddress(addHistory, pii);
            ++i;
        }
    }

    private void mapAddress(PersonAddressHistory addHistory, PersonIdentityImpl pii) {
        Address address = new Address();
        address.setAddrLine1(addHistory.getAddrLine1());
        address.setAddrLine2(addHistory.getAddrLine2());
        address.setAddrLine3(addHistory.getAddrLine3());
        address.setCity(addHistory.getCity());
        address.setZip(addHistory.getZip());
        address.setBadAddressCode(addHistory.getBadAddressCode());
        address.setBadAddressText(addHistory.getBadAddressText());
        address.setAddrType(AddressType.factory.obtainFromKeyValue(addHistory.getAddressTypeId()).getCode());
        State state = State.factory.obtainFromKeyValue(addHistory.getStateId());
        if (state != null) {
            address.setState(state.getPostalName());
            try {
                pii.addAddress(address);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }

    private String showTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    private class MatchResponse {
        private PersonIdentityImpl responsePii;
        private int responseStartIndex;

        MatchResponse(PersonIdentityImpl responsePii, int responseStartIndex) {
            this.responsePii = responsePii;
            this.responseStartIndex = responseStartIndex;
        }

        PersonIdentityImpl getPIIMatch() {
            return this.responsePii;
        }

        int getStartIndex() {
            return this.responseStartIndex;
        }
    }
}

