/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db;

import gov.va.med.person.idmgmt.db.PSDaoFactory;
import gov.va.med.person.idmgmt.db.hb.AuditInfo;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.person.idmgmt.util.IConstants;
import gov.va.med.person.idmgmt.util.StringAndCollectionTools;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.transaction.TransactionManagerLookup;
import org.apache.log4j.Logger;

public abstract class AbstractHbDAO
implements IConstants {
    private static final Logger logger = Logger.getLogger(AbstractHbDAO.class);
    public static final String USERID = "PSIMUSR";
    protected static final String EXCEPTION_MSG = "Exception caught!";
    protected TransactionManagerLookup transactionManagerLookup;

    public AbstractHbDAO() {
        this.configureTransactionManagerLookup();
    }

    protected String getUserId() {
        String user = PSDaoFactory.instance().getAuditInfo();
        if (user == null || user.trim().length() == 0) {
            user = USERID;
        }
        return user;
    }

    protected AuditInfo createAuditInfo() {
        Date currDate = new Date(System.currentTimeMillis());
        AuditInfo auditInfo = new AuditInfo(currDate, this.getUserId(), currDate, this.getUserId());
        return auditInfo;
    }

    protected boolean isContainerManagedTransactions() {
        return HBSessionFactory.isContainerManagedTransactions();
    }

    protected TransactionManager getTransactionManager() {
        try {
            return this.transactionManagerLookup.getTransactionManager(new Properties());
        }
        catch (HibernateException e) {
            logger.error((Object)"Exception caught in HbVpidSeqGenerator.getTransactionManager.", (Throwable)e);
            throw new DataAccessException("Exception caught in HbVpidSeqGenerator.getTransactionManager.", (Exception)((Object)e));
        }
    }

    protected void configureTransactionManagerLookup() {
        try {
            String txnMgrLookup = HBSessionFactory.getConfiguration().getProperty("hibernate.transaction.manager_lookup_class");
            if (StringAndCollectionTools.isEmpty(txnMgrLookup)) {
                logger.warn((Object)"No TransactionManagerLookup class configured in Hibernate.");
            } else {
                Class<?> txnMgrLookupClass = Class.forName(txnMgrLookup);
                this.transactionManagerLookup = (TransactionManagerLookup)txnMgrLookupClass.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)EXCEPTION_MSG, (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)EXCEPTION_MSG, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)EXCEPTION_MSG, (Throwable)e);
        }
    }

    protected void resume(TransactionManager tm, Transaction surroundingTransaction) {
        if (surroundingTransaction != null) {
            try {
                tm.resume(surroundingTransaction);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)" HbVpidSeqGenerator surrounding tx resumed");
                }
            }
            catch (InvalidTransactionException e) {
                logger.error((Object)EXCEPTION_MSG, (Throwable)e);
                throw new DataAccessException((Exception)((Object)e));
            }
            catch (SystemException e) {
                logger.error((Object)EXCEPTION_MSG, (Throwable)e);
                throw new DataAccessException((Exception)((Object)e));
            }
        }
    }

    public String getThrowableErrMsg(Throwable err) {
        int errLineCount;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        String dateTime = sdf.format(new Date());
        String errMsg = "";
        String newLine = "\n";
        errMsg = "[ERROR][" + dateTime + "]" + err.getMessage() + newLine;
        if (err.getCause() != null) {
            errMsg = String.valueOf(errMsg) + "[CAUSE]" + err.getCause().getMessage() + newLine;
        }
        if ((errLineCount = err.getStackTrace().length) > 5) {
            errLineCount = 5;
        }
        int i = 0;
        while (i < errLineCount) {
            errMsg = String.valueOf(errMsg) + err.getStackTrace()[i].toString() + newLine;
            ++i;
        }
        errMsg = String.valueOf(errMsg) + "[ERROR][END]" + newLine;
        return errMsg;
    }
}

