/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt;

import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.QualifiedIdentifierImpl;
import gov.va.med.person.idmgmt.exceptions.VPIDException;
import gov.va.med.person.idmgmt.util.IConstants;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VPID
implements IConstants,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String regex_ = "([0-9]{16}|[0-9]{10})V([0-9]{6})([0-9]{6}){0,1}";
    private static Pattern cpat_ = Pattern.compile("([0-9]{16}|[0-9]{10})V([0-9]{6})([0-9]{6}){0,1}");
    private static final int SEQ = 1;
    private static final int CHK = 2;
    private static final int ENCODE = 3;
    private static final String PAD = "000000";
    private String value;
    private String vpidSeq;
    private String vpidChkDigit;
    private String vpidEncode;
    private static final char vpidDelim = 'V';
    private static int[][][] cdigit;

    static {
        int[][][] nArrayArray = new int[6][][];
        int[][] nArrayArray2 = new int[10][];
        int[] nArray = new int[16];
        nArray[0] = 4;
        nArray[1] = 9;
        nArray[2] = 7;
        nArray[3] = 4;
        nArray[4] = 4;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[8] = 9;
        nArray[9] = 9;
        nArray[10] = 7;
        nArray[11] = 7;
        nArray[12] = 8;
        nArray[13] = 4;
        nArray[14] = 6;
        nArray[15] = 8;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 5;
        nArray2[2] = 6;
        nArray2[3] = 5;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 3;
        nArray2[8] = 6;
        nArray2[9] = 5;
        nArray2[10] = 3;
        nArray2[11] = 5;
        nArray2[12] = 7;
        nArray2[13] = 6;
        nArray2[14] = 5;
        nArray2[15] = 5;
        nArrayArray2[1] = nArray2;
        int[] nArray3 = new int[16];
        nArray3[0] = 9;
        nArray3[1] = 4;
        nArray3[2] = 2;
        nArray3[4] = 3;
        nArray3[5] = 7;
        nArray3[6] = 5;
        nArray3[7] = 1;
        nArray3[8] = 7;
        nArray3[9] = 1;
        nArray3[11] = 9;
        nArray3[13] = 3;
        nArray3[14] = 2;
        nArray3[15] = 2;
        nArrayArray2[2] = nArray3;
        int[] nArray4 = new int[16];
        nArray4[0] = 3;
        nArray4[1] = 2;
        nArray4[2] = 1;
        nArray4[3] = 7;
        nArray4[4] = 7;
        nArray4[6] = 6;
        nArray4[7] = 9;
        nArray4[8] = 2;
        nArray4[9] = 4;
        nArray4[10] = 1;
        nArray4[11] = 1;
        nArray4[12] = 3;
        nArray4[13] = 8;
        nArray4[14] = 1;
        nArrayArray2[3] = nArray4;
        int[] nArray5 = new int[16];
        nArray5[0] = 2;
        nArray5[1] = 3;
        nArray5[2] = 3;
        nArray5[3] = 9;
        nArray5[4] = 5;
        nArray5[5] = 9;
        nArray5[6] = 9;
        nArray5[7] = 2;
        nArray5[8] = 3;
        nArray5[9] = 8;
        nArray5[10] = 6;
        nArray5[12] = 1;
        nArray5[13] = 9;
        nArray5[14] = 8;
        nArray5[15] = 1;
        nArrayArray2[4] = nArray5;
        int[] nArray6 = new int[16];
        nArray6[0] = 1;
        nArray6[1] = 6;
        nArray6[2] = 8;
        nArray6[3] = 2;
        nArray6[5] = 6;
        nArray6[6] = 1;
        nArray6[7] = 7;
        nArray6[8] = 4;
        nArray6[9] = 3;
        nArray6[10] = 5;
        nArray6[11] = 4;
        nArray6[12] = 4;
        nArray6[13] = 2;
        nArray6[14] = 3;
        nArray6[15] = 3;
        nArrayArray2[5] = nArray6;
        int[] nArray7 = new int[16];
        nArray7[0] = 7;
        nArray7[1] = 8;
        nArray7[2] = 9;
        nArray7[3] = 1;
        nArray7[4] = 2;
        nArray7[5] = 2;
        nArray7[7] = 8;
        nArray7[8] = 1;
        nArray7[9] = 6;
        nArray7[10] = 8;
        nArray7[11] = 6;
        nArray7[12] = 9;
        nArray7[15] = 4;
        nArrayArray2[6] = nArray7;
        int[] nArray8 = new int[16];
        nArray8[0] = 6;
        nArray8[1] = 7;
        nArray8[3] = 8;
        nArray8[4] = 8;
        nArray8[5] = 8;
        nArray8[6] = 3;
        nArray8[7] = 4;
        nArray8[8] = 5;
        nArray8[9] = 2;
        nArray8[10] = 4;
        nArray8[11] = 3;
        nArray8[12] = 5;
        nArray8[13] = 1;
        nArray8[14] = 4;
        nArray8[15] = 6;
        nArrayArray2[7] = nArray8;
        int[] nArray9 = new int[16];
        nArray9[1] = 1;
        nArray9[2] = 5;
        nArray9[3] = 6;
        nArray9[4] = 6;
        nArray9[5] = 3;
        nArray9[6] = 8;
        nArray9[7] = 5;
        nArray9[10] = 9;
        nArray9[11] = 2;
        nArray9[12] = 2;
        nArray9[13] = 5;
        nArray9[14] = 9;
        nArray9[15] = 7;
        nArrayArray2[8] = nArray9;
        nArrayArray2[9] = new int[]{8, 5, 4, 3, 9, 5, 7, 6, 8, 7, 2, 8, 6, 7, 7, 9};
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[10][];
        int[] nArray10 = new int[16];
        nArray10[0] = 4;
        nArray10[1] = 7;
        nArray10[2] = 3;
        nArray10[3] = 4;
        nArray10[4] = 6;
        nArray10[7] = 1;
        nArray10[8] = 2;
        nArray10[9] = 9;
        nArray10[10] = 5;
        nArray10[11] = 6;
        nArray10[12] = 2;
        nArray10[13] = 6;
        nArray10[14] = 1;
        nArray10[15] = 1;
        nArrayArray3[0] = nArray10;
        int[] nArray11 = new int[16];
        nArray11[1] = 1;
        nArray11[2] = 9;
        nArray11[3] = 2;
        nArray11[4] = 2;
        nArray11[5] = 6;
        nArray11[6] = 4;
        nArray11[7] = 7;
        nArray11[8] = 9;
        nArray11[9] = 8;
        nArray11[10] = 4;
        nArray11[11] = 9;
        nArray11[12] = 7;
        nArray11[13] = 8;
        nArray11[15] = 7;
        nArrayArray3[1] = nArray11;
        int[] nArray12 = new int[16];
        nArray12[0] = 2;
        nArray12[1] = 6;
        nArray12[2] = 4;
        nArray12[3] = 8;
        nArray12[4] = 9;
        nArray12[5] = 2;
        nArray12[6] = 8;
        nArray12[7] = 6;
        nArray12[8] = 7;
        nArray12[10] = 9;
        nArray12[11] = 3;
        nArray12[12] = 5;
        nArray12[14] = 8;
        nArray12[15] = 4;
        nArrayArray3[2] = nArray12;
        int[] nArray13 = new int[16];
        nArray13[0] = 8;
        nArray13[2] = 5;
        nArray13[3] = 1;
        nArray13[4] = 3;
        nArray13[5] = 8;
        nArray13[6] = 2;
        nArray13[7] = 3;
        nArray13[8] = 4;
        nArray13[9] = 1;
        nArray13[12] = 9;
        nArray13[13] = 1;
        nArray13[14] = 3;
        nArrayArray3[3] = nArray13;
        int[] nArray14 = new int[16];
        nArray14[0] = 5;
        nArray14[1] = 3;
        nArray14[2] = 7;
        nArray14[4] = 7;
        nArray14[5] = 9;
        nArray14[6] = 9;
        nArray14[7] = 9;
        nArray14[8] = 6;
        nArray14[9] = 2;
        nArray14[10] = 1;
        nArray14[11] = 2;
        nArray14[12] = 8;
        nArray14[13] = 9;
        nArray14[14] = 4;
        nArray14[15] = 8;
        nArrayArray3[4] = nArray14;
        int[] nArray15 = new int[16];
        nArray15[0] = 1;
        nArray15[1] = 9;
        nArray15[2] = 8;
        nArray15[3] = 5;
        nArray15[4] = 1;
        nArray15[5] = 5;
        nArray15[6] = 1;
        nArray15[8] = 5;
        nArray15[9] = 7;
        nArray15[10] = 2;
        nArray15[11] = 8;
        nArray15[12] = 6;
        nArray15[13] = 7;
        nArray15[14] = 7;
        nArray15[15] = 9;
        nArrayArray3[5] = nArray15;
        int[] nArray16 = new int[16];
        nArray16[0] = 9;
        nArray16[1] = 5;
        nArray16[2] = 1;
        nArray16[3] = 9;
        nArray16[4] = 5;
        nArray16[5] = 4;
        nArray16[6] = 6;
        nArray16[7] = 5;
        nArray16[9] = 6;
        nArray16[10] = 3;
        nArray16[11] = 4;
        nArray16[12] = 1;
        nArray16[13] = 3;
        nArray16[14] = 9;
        nArray16[15] = 2;
        nArrayArray3[6] = nArray16;
        int[] nArray17 = new int[16];
        nArray17[0] = 3;
        nArray17[1] = 4;
        nArray17[3] = 3;
        nArray17[4] = 8;
        nArray17[5] = 1;
        nArray17[6] = 3;
        nArray17[7] = 4;
        nArray17[8] = 8;
        nArray17[9] = 5;
        nArray17[10] = 6;
        nArray17[11] = 5;
        nArray17[12] = 4;
        nArray17[13] = 2;
        nArray17[14] = 5;
        nArray17[15] = 5;
        nArrayArray3[7] = nArray17;
        int[] nArray18 = new int[16];
        nArray18[0] = 7;
        nArray18[1] = 2;
        nArray18[2] = 6;
        nArray18[3] = 6;
        nArray18[5] = 3;
        nArray18[6] = 7;
        nArray18[7] = 8;
        nArray18[8] = 1;
        nArray18[9] = 4;
        nArray18[10] = 7;
        nArray18[11] = 1;
        nArray18[13] = 4;
        nArray18[14] = 6;
        nArray18[15] = 3;
        nArrayArray3[8] = nArray18;
        nArrayArray3[9] = new int[]{6, 8, 2, 7, 4, 7, 5, 2, 3, 3, 8, 7, 3, 5, 2, 6};
        nArrayArray[1] = nArrayArray3;
        int[][] nArrayArray4 = new int[10][];
        int[] nArray19 = new int[16];
        nArray19[0] = 8;
        nArray19[1] = 5;
        nArray19[2] = 2;
        nArray19[3] = 3;
        nArray19[4] = 2;
        nArray19[5] = 7;
        nArray19[6] = 3;
        nArray19[7] = 4;
        nArray19[8] = 6;
        nArray19[9] = 3;
        nArray19[10] = 6;
        nArray19[11] = 1;
        nArray19[12] = 6;
        nArray19[13] = 4;
        nArray19[14] = 5;
        nArrayArray4[0] = nArray19;
        int[] nArray20 = new int[16];
        nArray20[0] = 9;
        nArray20[1] = 7;
        nArray20[2] = 3;
        nArray20[3] = 9;
        nArray20[4] = 9;
        nArray20[5] = 6;
        nArray20[7] = 7;
        nArray20[8] = 5;
        nArray20[9] = 9;
        nArray20[10] = 4;
        nArray20[11] = 5;
        nArray20[12] = 1;
        nArray20[13] = 8;
        nArray20[14] = 6;
        nArray20[15] = 2;
        nArrayArray4[1] = nArray20;
        int[] nArray21 = new int[16];
        nArray21[0] = 1;
        nArray21[1] = 4;
        nArray21[2] = 4;
        nArray21[3] = 5;
        nArray21[6] = 4;
        nArray21[7] = 2;
        nArray21[8] = 2;
        nArray21[9] = 6;
        nArray21[10] = 1;
        nArray21[11] = 2;
        nArray21[12] = 8;
        nArray21[13] = 9;
        nArray21[14] = 8;
        nArray21[15] = 6;
        nArrayArray4[2] = nArray21;
        int[] nArray22 = new int[16];
        nArray22[0] = 4;
        nArray22[1] = 1;
        nArray22[3] = 6;
        nArray22[4] = 3;
        nArray22[5] = 3;
        nArray22[6] = 7;
        nArray22[7] = 6;
        nArray22[8] = 8;
        nArray22[9] = 8;
        nArray22[10] = 3;
        nArray22[11] = 8;
        nArray22[12] = 3;
        nArray22[13] = 1;
        nArray22[14] = 1;
        nArray22[15] = 4;
        nArrayArray4[3] = nArray22;
        int[] nArray23 = new int[16];
        nArray23[2] = 9;
        nArray23[4] = 5;
        nArray23[5] = 1;
        nArray23[6] = 5;
        nArray23[7] = 3;
        nArray23[8] = 4;
        nArray23[10] = 5;
        nArray23[11] = 7;
        nArray23[12] = 7;
        nArray23[13] = 2;
        nArray23[14] = 9;
        nArray23[15] = 3;
        nArrayArray4[4] = nArray23;
        nArrayArray4[5] = new int[]{3, 6, 6, 2, 6, 4, 6, 8, 7, 1, 7, 4, 2, 7, 7, 9};
        int[] nArray24 = new int[16];
        nArray24[0] = 5;
        nArray24[1] = 8;
        nArray24[2] = 1;
        nArray24[3] = 4;
        nArray24[4] = 7;
        nArray24[5] = 2;
        nArray24[6] = 8;
        nArray24[8] = 1;
        nArray24[9] = 7;
        nArray24[10] = 2;
        nArray24[11] = 3;
        nArray24[14] = 4;
        nArray24[15] = 8;
        nArrayArray4[6] = nArray24;
        int[] nArray25 = new int[16];
        nArray25[0] = 2;
        nArray25[1] = 9;
        nArray25[2] = 7;
        nArray25[3] = 7;
        nArray25[4] = 4;
        nArray25[5] = 9;
        nArray25[6] = 9;
        nArray25[7] = 1;
        nArray25[8] = 3;
        nArray25[9] = 5;
        nArray25[11] = 9;
        nArray25[12] = 9;
        nArray25[13] = 6;
        nArray25[15] = 1;
        nArrayArray4[7] = nArray25;
        int[] nArray26 = new int[16];
        nArray26[0] = 7;
        nArray26[1] = 2;
        nArray26[2] = 8;
        nArray26[3] = 1;
        nArray26[4] = 8;
        nArray26[5] = 5;
        nArray26[6] = 1;
        nArray26[7] = 5;
        nArray26[9] = 2;
        nArray26[10] = 9;
        nArray26[12] = 5;
        nArray26[13] = 3;
        nArray26[14] = 2;
        nArray26[15] = 7;
        nArrayArray4[8] = nArray26;
        nArrayArray4[9] = new int[]{6, 3, 5, 8, 1, 8, 2, 9, 9, 4, 8, 6, 4, 5, 3, 5};
        nArrayArray[2] = nArrayArray4;
        int[][] nArrayArray5 = new int[10][];
        int[] nArray27 = new int[16];
        nArray27[0] = 5;
        nArray27[2] = 3;
        nArray27[3] = 6;
        nArray27[4] = 4;
        nArray27[6] = 6;
        nArray27[7] = 7;
        nArray27[8] = 1;
        nArray27[9] = 6;
        nArray27[10] = 4;
        nArray27[11] = 3;
        nArray27[12] = 5;
        nArray27[13] = 5;
        nArray27[14] = 6;
        nArray27[15] = 6;
        nArrayArray5[0] = nArray27;
        int[] nArray28 = new int[16];
        nArray28[1] = 9;
        nArray28[2] = 7;
        nArray28[3] = 7;
        nArray28[4] = 1;
        nArray28[5] = 3;
        nArray28[6] = 4;
        nArray28[7] = 5;
        nArray28[8] = 2;
        nArray28[9] = 9;
        nArray28[10] = 6;
        nArray28[11] = 6;
        nArray28[12] = 9;
        nArray28[13] = 6;
        nArray28[14] = 7;
        nArray28[15] = 1;
        nArrayArray5[1] = nArray28;
        nArrayArray5[2] = new int[]{2, 3, 5, 5, 9, 2, 5, 6, 4, 4, 8, 1, 3, 4, 2, 4};
        int[] nArray29 = new int[16];
        nArray29[0] = 4;
        nArray29[1] = 5;
        nArray29[2] = 4;
        nArray29[3] = 1;
        nArray29[5] = 4;
        nArray29[6] = 2;
        nArray29[7] = 4;
        nArray29[8] = 6;
        nArray29[9] = 7;
        nArray29[10] = 5;
        nArray29[11] = 2;
        nArray29[13] = 1;
        nArray29[14] = 5;
        nArray29[15] = 3;
        nArrayArray5[3] = nArray29;
        int[] nArray30 = new int[16];
        nArray30[0] = 7;
        nArray30[1] = 1;
        nArray30[2] = 2;
        nArray30[3] = 3;
        nArray30[4] = 6;
        nArray30[5] = 6;
        nArray30[6] = 3;
        nArray30[9] = 5;
        nArray30[10] = 9;
        nArray30[11] = 8;
        nArray30[12] = 2;
        nArray30[13] = 9;
        nArray30[14] = 9;
        nArray30[15] = 2;
        nArrayArray5[4] = nArray30;
        int[] nArray31 = new int[16];
        nArray31[0] = 3;
        nArray31[1] = 4;
        nArray31[3] = 4;
        nArray31[4] = 8;
        nArray31[5] = 8;
        nArray31[6] = 9;
        nArray31[7] = 9;
        nArray31[8] = 9;
        nArray31[10] = 7;
        nArray31[12] = 4;
        nArray31[13] = 2;
        nArrayArray5[5] = nArray31;
        nArrayArray5[6] = new int[]{6, 7, 6, 9, 2, 5, 1, 3, 5, 8, 2, 4, 8, 3, 8, 5};
        int[] nArray32 = new int[16];
        nArray32[0] = 1;
        nArray32[1] = 8;
        nArray32[2] = 8;
        nArray32[3] = 8;
        nArray32[4] = 3;
        nArray32[5] = 7;
        nArray32[7] = 2;
        nArray32[8] = 3;
        nArray32[9] = 2;
        nArray32[10] = 3;
        nArray32[11] = 9;
        nArray32[12] = 7;
        nArray32[14] = 4;
        nArray32[15] = 9;
        nArrayArray5[7] = nArray32;
        int[] nArray33 = new int[16];
        nArray33[0] = 9;
        nArray33[1] = 6;
        nArray33[2] = 9;
        nArray33[4] = 5;
        nArray33[5] = 1;
        nArray33[6] = 7;
        nArray33[7] = 1;
        nArray33[8] = 8;
        nArray33[9] = 3;
        nArray33[11] = 7;
        nArray33[12] = 1;
        nArray33[13] = 7;
        nArray33[14] = 1;
        nArray33[15] = 8;
        nArrayArray5[8] = nArray33;
        nArrayArray5[9] = new int[]{8, 2, 1, 2, 7, 9, 8, 8, 7, 1, 1, 5, 6, 8, 3, 7};
        nArrayArray[3] = nArrayArray5;
        int[][] nArrayArray6 = new int[10][];
        int[] nArray34 = new int[16];
        nArray34[0] = 4;
        nArray34[1] = 4;
        nArray34[3] = 2;
        nArray34[4] = 2;
        nArray34[5] = 9;
        nArray34[6] = 3;
        nArray34[7] = 2;
        nArray34[8] = 2;
        nArray34[9] = 6;
        nArray34[10] = 5;
        nArray34[11] = 1;
        nArray34[12] = 2;
        nArray34[13] = 7;
        nArray34[14] = 2;
        nArray34[15] = 7;
        nArrayArray6[0] = nArray34;
        int[] nArray35 = new int[16];
        nArray35[0] = 8;
        nArray35[1] = 3;
        nArray35[2] = 6;
        nArray35[3] = 9;
        nArray35[5] = 3;
        nArray35[6] = 9;
        nArray35[7] = 7;
        nArray35[8] = 4;
        nArray35[9] = 7;
        nArray35[10] = 6;
        nArray35[11] = 6;
        nArray35[12] = 4;
        nArray35[13] = 9;
        nArrayArray6[1] = nArray35;
        int[] nArray36 = new int[16];
        nArray36[0] = 2;
        nArray36[1] = 7;
        nArray36[2] = 1;
        nArray36[3] = 8;
        nArray36[4] = 3;
        nArray36[5] = 5;
        nArray36[6] = 2;
        nArray36[7] = 5;
        nArray36[8] = 1;
        nArray36[9] = 8;
        nArray36[10] = 9;
        nArray36[12] = 9;
        nArray36[13] = 3;
        nArray36[14] = 6;
        nArray36[15] = 2;
        nArrayArray6[2] = nArray36;
        int[] nArray37 = new int[16];
        nArray37[0] = 7;
        nArray37[2] = 5;
        nArray37[4] = 9;
        nArray37[5] = 4;
        nArray37[6] = 1;
        nArray37[7] = 1;
        nArray37[8] = 6;
        nArray37[9] = 1;
        nArray37[10] = 7;
        nArray37[11] = 8;
        nArray37[12] = 8;
        nArray37[13] = 2;
        nArray37[14] = 3;
        nArray37[15] = 4;
        nArrayArray6[3] = nArray37;
        int[] nArray38 = new int[16];
        nArray38[0] = 5;
        nArray38[1] = 1;
        nArray38[2] = 7;
        nArray38[3] = 7;
        nArray38[4] = 4;
        nArray38[5] = 6;
        nArray38[7] = 8;
        nArray38[8] = 7;
        nArray38[9] = 5;
        nArray38[10] = 2;
        nArray38[11] = 2;
        nArray38[12] = 1;
        nArray38[13] = 5;
        nArray38[14] = 4;
        nArray38[15] = 9;
        nArrayArray6[4] = nArray38;
        int[] nArray39 = new int[16];
        nArray39[0] = 1;
        nArray39[1] = 6;
        nArray39[2] = 9;
        nArray39[3] = 3;
        nArray39[4] = 6;
        nArray39[5] = 1;
        nArray39[6] = 8;
        nArray39[7] = 9;
        nArray39[9] = 4;
        nArray39[10] = 4;
        nArray39[11] = 3;
        nArray39[12] = 7;
        nArray39[14] = 1;
        nArray39[15] = 8;
        nArrayArray6[5] = nArray39;
        int[] nArray40 = new int[16];
        nArray40[1] = 9;
        nArray40[2] = 2;
        nArray40[3] = 1;
        nArray40[4] = 5;
        nArray40[6] = 4;
        nArray40[8] = 3;
        nArray40[9] = 9;
        nArray40[10] = 1;
        nArray40[11] = 7;
        nArray40[13] = 6;
        nArray40[14] = 7;
        nArray40[15] = 3;
        nArrayArray6[6] = nArray40;
        int[] nArray41 = new int[16];
        nArray41[0] = 9;
        nArray41[1] = 2;
        nArray41[2] = 8;
        nArray41[3] = 4;
        nArray41[4] = 8;
        nArray41[5] = 7;
        nArray41[6] = 7;
        nArray41[7] = 6;
        nArray41[8] = 5;
        nArray41[11] = 9;
        nArray41[12] = 3;
        nArray41[13] = 1;
        nArray41[14] = 8;
        nArray41[15] = 6;
        nArrayArray6[7] = nArray41;
        nArrayArray6[8] = new int[]{3, 5, 3, 6, 1, 8, 6, 3, 8, 3, 3, 5, 6, 8, 9, 5};
        nArrayArray6[9] = new int[]{6, 8, 4, 5, 7, 2, 5, 4, 9, 2, 8, 4, 5, 4, 5, 1};
        nArrayArray[4] = nArrayArray6;
        int[][] nArrayArray7 = new int[10][];
        nArrayArray7[0] = new int[]{6, 2, 8, 2, 7, 3, 3, 8, 4, 9, 2, 4, 4, 1, 6, 1};
        int[] nArray42 = new int[16];
        nArray42[0] = 8;
        nArray42[1] = 1;
        nArray42[2] = 9;
        nArray42[3] = 3;
        nArray42[4] = 1;
        nArray42[5] = 6;
        nArray42[6] = 7;
        nArray42[7] = 9;
        nArray42[8] = 2;
        nArray42[9] = 4;
        nArray42[10] = 7;
        nArray42[11] = 5;
        nArray42[12] = 9;
        nArray42[13] = 6;
        nArray42[14] = 2;
        nArrayArray7[1] = nArray42;
        int[] nArray43 = new int[16];
        nArray43[0] = 5;
        nArray43[1] = 3;
        nArray43[2] = 2;
        nArray43[3] = 9;
        nArray43[5] = 1;
        nArray43[6] = 9;
        nArray43[7] = 4;
        nArray43[8] = 8;
        nArray43[9] = 7;
        nArray43[10] = 4;
        nArray43[11] = 6;
        nArray43[12] = 3;
        nArray43[13] = 7;
        nArray43[14] = 8;
        nArray43[15] = 9;
        nArrayArray7[2] = nArray43;
        int[] nArray44 = new int[16];
        nArray44[1] = 7;
        nArray44[3] = 5;
        nArray44[4] = 8;
        nArray44[5] = 2;
        nArray44[6] = 6;
        nArray44[7] = 7;
        nArray44[8] = 6;
        nArray44[9] = 5;
        nArray44[11] = 7;
        nArray44[12] = 1;
        nArray44[13] = 9;
        nArray44[14] = 9;
        nArray44[15] = 4;
        nArrayArray7[3] = nArray44;
        int[] nArray45 = new int[16];
        nArray45[0] = 2;
        nArray45[1] = 9;
        nArray45[2] = 1;
        nArray45[3] = 4;
        nArray45[4] = 9;
        nArray45[5] = 9;
        nArray45[6] = 4;
        nArray45[8] = 1;
        nArray45[9] = 3;
        nArray45[10] = 9;
        nArray45[11] = 3;
        nArray45[13] = 2;
        nArray45[14] = 5;
        nArray45[15] = 6;
        nArrayArray7[4] = nArray45;
        int[] nArray46 = new int[16];
        nArray46[0] = 7;
        nArray46[2] = 3;
        nArray46[3] = 8;
        nArray46[4] = 6;
        nArray46[5] = 8;
        nArray46[7] = 1;
        nArray46[8] = 3;
        nArray46[10] = 5;
        nArray46[11] = 9;
        nArray46[12] = 2;
        nArray46[13] = 8;
        nArray46[14] = 3;
        nArray46[15] = 8;
        nArrayArray7[5] = nArray46;
        nArrayArray7[6] = new int[]{9, 6, 5, 6, 3, 4, 2, 6, 7, 6, 3, 2, 7, 4, 1, 3};
        int[] nArray47 = new int[16];
        nArray47[0] = 4;
        nArray47[1] = 8;
        nArray47[2] = 6;
        nArray47[3] = 7;
        nArray47[4] = 4;
        nArray47[5] = 5;
        nArray47[6] = 1;
        nArray47[7] = 3;
        nArray47[8] = 5;
        nArray47[9] = 1;
        nArray47[10] = 6;
        nArray47[11] = 1;
        nArray47[12] = 6;
        nArray47[13] = 3;
        nArray47[15] = 5;
        nArrayArray7[7] = nArray47;
        int[] nArray48 = new int[16];
        nArray48[0] = 3;
        nArray48[1] = 5;
        nArray48[2] = 4;
        nArray48[3] = 1;
        nArray48[4] = 5;
        nArray48[5] = 7;
        nArray48[6] = 5;
        nArray48[7] = 5;
        nArray48[8] = 9;
        nArray48[9] = 2;
        nArray48[10] = 8;
        nArray48[12] = 8;
        nArray48[13] = 5;
        nArray48[14] = 7;
        nArray48[15] = 7;
        nArrayArray7[8] = nArray48;
        int[] nArray49 = new int[16];
        nArray49[0] = 1;
        nArray49[1] = 4;
        nArray49[2] = 7;
        nArray49[4] = 2;
        nArray49[6] = 8;
        nArray49[7] = 2;
        nArray49[9] = 8;
        nArray49[10] = 1;
        nArray49[11] = 8;
        nArray49[12] = 5;
        nArray49[14] = 4;
        nArray49[15] = 2;
        nArrayArray7[9] = nArray49;
        nArrayArray[5] = nArrayArray7;
        cdigit = nArrayArray;
    }

    protected VPID() {
    }

    public VPID(String value) throws VPIDException {
        this.setVPID(value);
    }

    protected void setVPID(String value) throws VPIDException {
        if (value == null) {
            throw new NullPointerException();
        }
        Matcher m = cpat_.matcher(value);
        boolean rc = m.matches();
        if (rc) {
            this.vpidSeq = VPID.normalizeSeq(m.group(1));
            String cd = VPID.calculateCheckDigit(this.vpidSeq);
            if (!cd.equals(m.group(2))) {
                throw new VPIDException("Invalid VPID checkdigit: " + m.group(2));
            }
            this.vpidChkDigit = m.group(2);
            if (m.groupCount() == 3) {
                String encode = null;
                encode = m.group(3);
                if (encode == null) {
                    encode = PAD;
                }
                this.vpidEncode = encode;
            }
        } else {
            throw new VPIDException("Invalid VPID format: " + value);
        }
        this.value = String.valueOf(this.vpidSeq) + 'V' + this.vpidChkDigit + this.vpidEncode;
    }

    public VPID(String seq, String delim, String chkdigit, String encode) throws VPIDException {
        this(String.valueOf(seq) + delim + chkdigit + encode);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((VPID)o).value);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException(x);
        }
    }

    public String toString() {
        return this.value;
    }

    private static String normalizeSeq(String seqValue) throws VPIDException {
        StringBuffer buffer = new StringBuffer("0000000000000000");
        buffer.append(seqValue);
        String norm = buffer.substring(buffer.length() - 16);
        return norm;
    }

    private static String calculateCheckDigit(String vpidSeq) {
        String cdigits = "";
        int[] src = new int[16];
        int i = 0;
        while (i < 16) {
            src[i] = Integer.parseInt(vpidSeq.substring(i, i + 1));
            ++i;
        }
        int j = 0;
        while (j < 6) {
            int val = 0;
            int i2 = 0;
            while (i2 < 16) {
                val = (val + src[i2]) % 10;
                val = cdigit[j][val][i2];
                ++i2;
            }
            cdigits = cdigits.concat(String.valueOf(val));
            ++j;
        }
        return cdigits;
    }

    public IQualifiedIdentifier getVPID() {
        QualifiedIdentifierImpl aVpid = new QualifiedIdentifierImpl();
        aVpid.setIdentifier(this.value);
        aVpid.setIdentifierType("NI");
        aVpid.setAssigningAuthority("USVHA");
        if (aVpid.getIdentifier().charAt(6) == '1') {
            aVpid.setAssigningLocation("200M");
        } else {
            aVpid.setAssigningLocation("200PS");
        }
        return aVpid;
    }

    public IQualifiedIdentifier getVPID(String vpid) {
        QualifiedIdentifierImpl aVpid = new QualifiedIdentifierImpl();
        aVpid.setIdentifier(vpid);
        aVpid.setIdentifierType("NI");
        aVpid.setAssigningAuthority("USVHA");
        if (aVpid.getIdentifier().charAt(6) == '1') {
            aVpid.setAssigningLocation("200M");
        } else {
            aVpid.setAssigningLocation("200PS");
        }
        return aVpid;
    }

    public String getVpidSeq() {
        return this.vpidSeq;
    }

    public String getVpidDelim() {
        return Character.toString('V');
    }

    public String getVpidChk() {
        return this.vpidChkDigit;
    }

    public String getVpidEncode() {
        return this.vpidEncode;
    }

    private String getElement(int segment) {
        String s = null;
        Matcher m = cpat_.matcher(this.value);
        if (m.matches()) {
            s = m.group(segment);
        }
        return s;
    }

    public static String getShortVPID(String aVPID) {
        String result = aVPID;
        if (aVPID != null && aVPID.length() == 29 && aVPID.substring(0, 6).equalsIgnoreCase(PAD) && aVPID.substring(23, 29).equalsIgnoreCase(PAD)) {
            result = aVPID.substring(6, 23);
        }
        return result;
    }

    public static IQualifiedIdentifier getShortVPID(IQualifiedIdentifier aVPID) {
        QualifiedIdentifierImpl shortVPID = new QualifiedIdentifierImpl();
        shortVPID.setIdentifier(VPID.getShortVPID(aVPID.getIdentifier()));
        shortVPID.setIdentifierType(aVPID.getIdentifierType());
        shortVPID.setAssigningLocation(aVPID.getAssigningLocation());
        shortVPID.setAssigningAuthority(aVPID.getAssigningAuthority());
        shortVPID.setAssigningLocationName(aVPID.getAssigningLocationName());
        return shortVPID;
    }

    protected void setVpidSeq(String vpidSeq) throws IllegalArgumentException, VPIDException {
        String vpidSequence = null;
        if (vpidSeq == null) {
            throw new IllegalArgumentException("The value passed in cannot be null.");
        }
        vpidSequence = vpidSeq.length() == 10 ? PAD + vpidSeq : vpidSeq;
        if (vpidSequence.length() != 16) {
            throw new IllegalArgumentException("The value being passed in must be either 10 or 16 characters long.");
        }
        String chk = VPID.calculateCheckDigit(vpidSequence);
        this.setVPID(String.valueOf(vpidSeq) + "V" + chk + PAD);
    }

    public static String padIcn(String vpidStr) {
        if (!vpidStr.startsWith(PAD) || !vpidStr.endsWith(PAD)) {
            vpidStr = PAD + vpidStr + PAD;
        }
        return vpidStr;
    }
}

