/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt;

import gov.va.med.person.exceptions.PSException;
import gov.va.med.person.idmgmt.Address;
import gov.va.med.person.idmgmt.ClientDataFilterFactory;
import gov.va.med.person.idmgmt.CollectionFilter;
import gov.va.med.person.idmgmt.IPersonClass;
import gov.va.med.person.idmgmt.IPersonIdentity;
import gov.va.med.person.idmgmt.IProcessable;
import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.ISaveableMessage;
import gov.va.med.person.idmgmt.Phone;
import gov.va.med.person.idmgmt.common.ISSN;
import gov.va.med.person.idmgmt.exceptions.PSIMException;
import gov.va.med.person.idmgmt.types.ImpreciseDate;
import gov.va.med.person.idmgmt.types.MultipleBirthIndicator;
import gov.va.med.person.idmgmt.util.IConstants;
import gov.va.med.person.idmgmt.util.PersonNameUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PersonIdentityImpl
implements IPersonIdentity,
IProcessable,
ISaveableMessage,
IConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    private HashSet phoneSet = new HashSet();
    private HashSet addressSet = new HashSet();
    private Timestamp auditEventTimestamp;
    private String auditFirstName;
    private IQualifiedIdentifier auditIdentifier;
    private IQualifiedIdentifier nPI;
    private String auditLastName;
    private String auditMiddleName;
    private String auditPrefix;
    private ISSN auditSSN;
    private String auditSuffix;
    private IQualifiedIdentifier auditVPID;
    private ImpreciseDate dateOfBirth;
    private transient String dateOfDeath;
    private final ArrayList personNames = new ArrayList();
    private ArrayList category = new ArrayList();
    private String gender;
    private String idState;
    private String mothersMaidenName;
    private MultipleBirthIndicator multiBirth;
    private boolean hasDeprecatedInfo = false;
    private IQualifiedIdentifier originatingIdentifier;
    private String placeOfBirthCity;
    private String placeOfBirthCountry;
    private String placeOfBirthState;
    private String processingID;
    private String receivingApplicationName = "XUPS PMU";
    private IQualifiedIdentifier requestingIdentifier;
    private String sendingApplicationName;
    private String sendingFacility;
    private ISSN sSN;
    private IQualifiedIdentifier vpid;
    private final ArrayList personClassList = new ArrayList();
    private String providerTypeCodeIdentifier;
    private String providerTypeCodeCodingSystem;
    private String providerClassificationIdentifier;
    private String providerClassificationCodingSystem;
    private String providerSpecializationIdentifier;
    private String providerSpecializationCodingSystem;
    private Timestamp providerEffectiveDate;
    private Timestamp providerExpirationDate;
    private String updateStatus;
    private boolean updatePending;
    private String messageControlId = String.valueOf(String.valueOf(System.currentTimeMillis())) + String.valueOf(this.hashCode());
    private IPersonIdentity[] history;
    private String auditUserID;
    private Integer matchCount;
    private ArrayList aliasNameUtils = null;
    private String correlationStatus;
    private transient String ippLevel;
    private transient String roiSigned;
    private transient String traitStatus;
    private transient String AFOID = "";
    private transient String isIdTheftFlagValue = "";
    private transient String tin;
    private transient String fin;
    private transient String idStateHistorical;

    @Override
    public final String getSendingApplicationName() {
        return this.sendingApplicationName;
    }

    public final void setSendingApplicationName(String applicationName) {
        this.sendingApplicationName = applicationName;
    }

    @Override
    public final Timestamp getAuditEventTimestamp() {
        return this.auditEventTimestamp;
    }

    public final void setAuditEventTimestamp(Timestamp auditEventTimestamp) {
        this.auditEventTimestamp = auditEventTimestamp;
    }

    @Override
    public final String getAuditFirstName() {
        return this.auditFirstName;
    }

    public final void setAuditFirstName(String auditFirstName) {
        this.auditFirstName = auditFirstName;
    }

    @Override
    public final IQualifiedIdentifier getAuditIdentifier() {
        return this.auditIdentifier;
    }

    public final void setAuditIdentifier(IQualifiedIdentifier auditId) {
        this.auditIdentifier = auditId;
    }

    @Override
    public final String getAuditLastName() {
        return this.auditLastName;
    }

    public final void setAuditLastName(String auditLastName) {
        this.auditLastName = auditLastName;
    }

    @Override
    public final String getAuditMiddleName() {
        return this.auditMiddleName;
    }

    public final void setAuditMiddleName(String auditMiddleName) {
        this.auditMiddleName = auditMiddleName;
    }

    @Override
    public final String getAuditPrefix() {
        return this.auditPrefix;
    }

    public final void setAuditPrefix(String auditPrefix) {
        this.auditPrefix = auditPrefix;
    }

    @Override
    public final ISSN getAuditSSN() {
        return this.auditSSN;
    }

    public final void setAuditSSN(ISSN auditSSN) {
        this.auditSSN = auditSSN;
    }

    @Override
    public final String getAuditSuffix() {
        return this.auditSuffix;
    }

    public final void setAuditSuffix(String auditSuffix) {
        this.auditSuffix = auditSuffix;
    }

    @Override
    public final IQualifiedIdentifier getAuditVPID() {
        return this.auditVPID;
    }

    public final void setAuditVPID(IQualifiedIdentifier vpid) {
        this.auditVPID = vpid;
    }

    @Override
    public final String getCategory(int index) {
        if (-20101025 == index) {
            return this.AFOID;
        }
        if (-20110311 == index) {
            return this.isIdTheftFlagValue;
        }
        if (-201108101 == index) {
            return this.roiSigned;
        }
        if (-201108102 == index) {
            return this.ippLevel;
        }
        if (-201108111 == index) {
            return this.tin;
        }
        if (-201108112 == index) {
            return this.fin;
        }
        if (-201108113 == index) {
            return this.idStateHistorical;
        }
        if (-20110913 == index) {
            return this.dateOfDeath;
        }
        try {
            return String.valueOf(this.category.get(index));
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void setCategory(int index, String aCategory) {
        if (-20101025 == index) {
            this.AFOID = aCategory;
        } else if (-20110311 == index) {
            this.isIdTheftFlagValue = aCategory;
        } else if (-201108101 == index) {
            this.roiSigned = aCategory;
        } else if (-201108102 == index) {
            this.ippLevel = aCategory;
        } else if (-201108111 == index) {
            this.tin = aCategory;
        } else if (-201108112 == index) {
            this.fin = aCategory;
        } else if (-201108113 == index) {
            this.idStateHistorical = aCategory;
        } else if (-20110913 == index) {
            this.dateOfDeath = aCategory;
        } else {
            int size = this.category.size();
            if (index < 0 || index > size) {
                throw new IndexOutOfBoundsException();
            }
            if (index == size) {
                this.category.add(index, aCategory);
            }
            this.category.set(index, aCategory);
        }
    }

    @Override
    public final ImpreciseDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public final void setDateOfBirth(ImpreciseDate dob) {
        this.dateOfBirth = dob;
    }

    public final String getDateOfDeath() {
        return this.dateOfDeath;
    }

    public final void setDateOfDeath(String dod) {
        this.dateOfDeath = dod;
    }

    @Override
    public final String getFirstName(int index) {
        try {
            return ((PersonNameUtil)this.personNames.get(index)).getFirstName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void setFirstName(int index, String aFirstName) {
        this.ensureNameCapacity(index);
        ((PersonNameUtil)this.personNames.get(index)).setFirstName(aFirstName);
    }

    @Override
    public final String getGender() {
        return this.gender;
    }

    public final void setGender(String aGender) {
        this.gender = aGender == null ? null : aGender.toUpperCase();
    }

    @Override
    public String getIDState() {
        return this.idState;
    }

    public void setIDState(String idState) {
        if (!("P".equals(idState) || "T".equals(idState) || "D".equals(idState))) {
            StringBuffer msg = new StringBuffer(80);
            msg.append("Attempt to set an unknown ID State. ");
            msg.append("Value Passed in: ");
            msg.append(idState);
            if (this.vpid != null && this.vpid.getIdentifier() != null) {
                msg.append(", for VPID: ");
                msg.append(this.vpid.getIdentifier());
            }
            msg.append(", see gov.va.med.person.idmgmt.IPersonIdentity.getIDState(). ");
            Logger.getLogger(PersonIdentityImpl.class).error((Object)msg.toString());
            throw new IllegalArgumentException(msg.toString());
        }
        this.idState = idState;
    }

    @Override
    public final boolean isAdd() {
        return this.getVPID() == null;
    }

    @Override
    public boolean isDeprecated() {
        return "D".equals(this.getIDState());
    }

    @Override
    public final boolean isResolveDuplicate() {
        return false;
    }

    @Override
    public final boolean isResolveMismatch() {
        return false;
    }

    @Override
    public final boolean isUpdate() {
        return this.getVPID() != null;
    }

    @Override
    public final boolean isPrimary() {
        IQualifiedIdentifier requestingIdentifier = this.getRequestingIdentifier();
        if (requestingIdentifier != null) {
            String assigningLocation = requestingIdentifier.getAssigningLocation();
            if ("NI".equalsIgnoreCase(requestingIdentifier.getIdentifierType()) && ("200PS".equalsIgnoreCase(assigningLocation) || "200M".equalsIgnoreCase(assigningLocation))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final String getLastName(int index) {
        try {
            return ((PersonNameUtil)this.personNames.get(index)).getLastName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void setLastName(int index, String aLastName) {
        this.ensureNameCapacity(index);
        ((PersonNameUtil)this.personNames.get(index)).setLastName(aLastName);
    }

    @Override
    public final String getMiddleName(int index) {
        try {
            return ((PersonNameUtil)this.personNames.get(index)).getMiddleName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void setMiddleName(int index, String aMiddleName) {
        this.ensureNameCapacity(index);
        ((PersonNameUtil)this.personNames.get(index)).setMiddleName(aMiddleName);
    }

    @Override
    public final String getMothersMaidenName() {
        return this.mothersMaidenName;
    }

    public final void setMothersMaidenName(String aMothersMaidenName) {
        this.mothersMaidenName = aMothersMaidenName;
    }

    @Override
    public final String getNameType(int index) {
        try {
            return ((PersonNameUtil)this.personNames.get(index)).getNameTypeString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void setNameType(int index, String aNameType) {
        this.ensureNameCapacity(index);
        ((PersonNameUtil)this.personNames.get(index)).setNameTypeString(aNameType);
    }

    @Override
    public final int getNumberOfCategories() {
        return this.category.size();
    }

    public final void setCategoryList(ArrayList catList) {
        this.category = catList;
    }

    @Override
    public final int getNumberOfNames() {
        return this.personNames.size();
    }

    @Override
    public final IQualifiedIdentifier getOriginatingIdentifier() {
        return this.originatingIdentifier;
    }

    public final void setOriginatingIdentifier(IQualifiedIdentifier originatingIdentifier) {
        this.originatingIdentifier = originatingIdentifier;
    }

    @Override
    public final String getPlaceOfBirthCity() {
        return this.placeOfBirthCity;
    }

    public final void setPlaceOfBirthCity(String aPlaceOfBirthCity) {
        this.placeOfBirthCity = aPlaceOfBirthCity != null ? aPlaceOfBirthCity.toUpperCase() : aPlaceOfBirthCity;
    }

    @Override
    public final String getPlaceOfBirthState() {
        return this.placeOfBirthState;
    }

    public final void setPlaceOfBirthState(String aPlaceOfBirthState) {
        this.placeOfBirthState = aPlaceOfBirthState;
    }

    @Override
    public final String getPrefix(int index) {
        try {
            return ((PersonNameUtil)this.personNames.get(index)).getPrefix();
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void setPrefix(int index, String aPrefix) {
        this.ensureNameCapacity(index);
        ((PersonNameUtil)this.personNames.get(index)).setPrefix(aPrefix);
    }

    @Override
    public final String getProcessingID() {
        return this.processingID;
    }

    public final void setProcessingID(String aProcessingID) {
        this.processingID = aProcessingID;
    }

    @Override
    public final IQualifiedIdentifier getRequestingIdentifier() {
        return this.requestingIdentifier;
    }

    public final void setRequestingIdentifier(IQualifiedIdentifier localIdentifier) {
        this.requestingIdentifier = localIdentifier;
    }

    @Override
    public final ISSN getSSN() {
        return this.sSN;
    }

    @Override
    public final IQualifiedIdentifier getNPI() {
        return this.nPI;
    }

    public final void setSSN(ISSN ssn) {
        this.sSN = ssn;
    }

    @Override
    public String getAliasFirstName(int index) {
        if (this.aliasNameUtils == null) {
            this.aliasNameUtils = this.getAliasNameUtils();
        }
        if (index >= this.aliasNameUtils.size()) {
            return null;
        }
        return ((PersonNameUtil)this.aliasNameUtils.get(index)).getFirstName();
    }

    private ArrayList getAliasNameUtils() {
        ArrayList aliasNameLs = new ArrayList();
        int i = 0;
        while (i < this.personNames.size()) {
            PersonNameUtil pnu = (PersonNameUtil)this.personNames.get(i);
            if (pnu != null && "A".equals(pnu.getNameTypeString())) {
                aliasNameLs.add(this.personNames.get(i));
            }
            ++i;
        }
        Collections.sort(aliasNameLs, new Comparator(){

            public int compare(Object o1, Object o2) {
                PersonNameUtil n1 = (PersonNameUtil)o1;
                PersonNameUtil n2 = (PersonNameUtil)o2;
                if (n1.getEventTimestamp() != null && n2.getEventTimestamp() != null) {
                    return n2.getEventTimestamp().compareTo(n1.getEventTimestamp());
                }
                return 0;
            }
        });
        return aliasNameLs;
    }

    @Override
    public String getAliasLastName(int index) {
        if (this.aliasNameUtils == null) {
            this.aliasNameUtils = this.getAliasNameUtils();
        }
        if (index >= this.aliasNameUtils.size()) {
            return null;
        }
        return ((PersonNameUtil)this.aliasNameUtils.get(index)).getLastName();
    }

    @Override
    public String getAliasMiddleName(int index) {
        if (this.aliasNameUtils == null) {
            this.aliasNameUtils = this.getAliasNameUtils();
        }
        if (index >= this.aliasNameUtils.size()) {
            return null;
        }
        return ((PersonNameUtil)this.aliasNameUtils.get(index)).getMiddleName();
    }

    @Override
    public String getAliasPrefix(int index) {
        if (this.aliasNameUtils == null) {
            this.aliasNameUtils = this.getAliasNameUtils();
        }
        if (index >= this.aliasNameUtils.size()) {
            return null;
        }
        return ((PersonNameUtil)this.aliasNameUtils.get(index)).getPrefix();
    }

    @Override
    public String getAliasSuffix(int index) {
        if (this.aliasNameUtils == null) {
            this.aliasNameUtils = this.getAliasNameUtils();
        }
        if (index >= this.aliasNameUtils.size()) {
            return null;
        }
        return ((PersonNameUtil)this.aliasNameUtils.get(index)).getSuffix();
    }

    @Override
    public ISSN getAliasSSN(int index) {
        if (this.aliasNameUtils == null) {
            this.aliasNameUtils = this.getAliasNameUtils();
        }
        if (index >= this.aliasNameUtils.size()) {
            return null;
        }
        return ((PersonNameUtil)this.aliasNameUtils.get(index)).getAliasSSN();
    }

    @Override
    public int getNumberOfAliasNames() {
        if (this.aliasNameUtils == null) {
            this.aliasNameUtils = this.getAliasNameUtils();
        }
        return this.aliasNameUtils.size();
    }

    public final void setAliasSSN(int index, ISSN aliasSSN) {
        this.ensureNameCapacity(index);
        ((PersonNameUtil)this.personNames.get(index)).setAliasSSN(aliasSSN);
    }

    public final void setNPI(IQualifiedIdentifier npi) {
        this.nPI = npi;
    }

    @Override
    public final String getSuffix(int index) {
        try {
            return ((PersonNameUtil)this.personNames.get(index)).getSuffix();
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void setSuffix(int index, String aSuffix) {
        this.ensureNameCapacity(index);
        ((PersonNameUtil)this.personNames.get(index)).setSuffix(aSuffix);
    }

    @Override
    public final IQualifiedIdentifier getVPID() {
        return this.vpid;
    }

    @Override
    public final void setVPID(IQualifiedIdentifier qi) {
        this.vpid = qi;
    }

    @Override
    public MultipleBirthIndicator getMultiBirth() {
        return this.multiBirth;
    }

    public void setMultiBirth(String multiBirth) {
        this.multiBirth = new MultipleBirthIndicator(multiBirth);
    }

    public void setMultiBirth(MultipleBirthIndicator multiBirth) {
        this.multiBirth = multiBirth;
    }

    public void setMultiBirth(boolean multiBirth) {
        this.multiBirth = new MultipleBirthIndicator(multiBirth);
    }

    @Override
    public String getPlaceOfBirthCountry() {
        return this.placeOfBirthCountry;
    }

    public void setPlaceOfBirthCountry(String aPlaceOfBirthCountry) {
        this.placeOfBirthCountry = aPlaceOfBirthCountry;
    }

    @Override
    public String getReceivingApplicationName() {
        return this.receivingApplicationName;
    }

    public void setReceivingApplicationName(String receivingAppName) {
        this.receivingApplicationName = receivingAppName;
    }

    @Override
    public String getProviderClassificationCodingSystem() {
        return this.providerClassificationCodingSystem;
    }

    public void setProviderClassificationCodingSystem(String providerClassificationCodingSystem) {
        this.providerClassificationCodingSystem = providerClassificationCodingSystem;
    }

    @Override
    public String getProviderClassificationIdentifier() {
        return this.providerClassificationIdentifier;
    }

    public void setProviderClassificationIdentifier(String providerClassificationIdentifier) {
        this.providerClassificationIdentifier = providerClassificationIdentifier;
    }

    @Override
    public String getProviderSpecializationCodingSystem() {
        return this.providerSpecializationCodingSystem;
    }

    public void setProviderSpecializationCodingSystem(String providerSpecializationCodingSystem) {
        this.providerSpecializationCodingSystem = providerSpecializationCodingSystem;
    }

    @Override
    public String getProviderSpecializationIdentifier() {
        return this.providerSpecializationIdentifier;
    }

    public void setProviderSpecializationIdentifier(String providerSpecializationIdentifier) {
        this.providerSpecializationIdentifier = providerSpecializationIdentifier;
    }

    @Override
    public String getProviderTypeCodeCodingSystem() {
        return this.providerTypeCodeCodingSystem;
    }

    public void setProviderTypeCodeCodingSystem(String providerTypeCodeCodingSystem) {
        this.providerTypeCodeCodingSystem = providerTypeCodeCodingSystem;
    }

    @Override
    public String getProviderTypeCodeIdentifier() {
        return this.providerTypeCodeIdentifier;
    }

    public void setProviderTypeCodeIdentifier(String providerTypeCodeIdentifier) {
        this.providerTypeCodeIdentifier = providerTypeCodeIdentifier;
    }

    @Override
    public Timestamp getProviderEffectiveDate() {
        return this.providerEffectiveDate;
    }

    public void setProviderEffectiveDate(Timestamp providerEffectiveDate) {
        this.providerEffectiveDate = providerEffectiveDate;
    }

    @Override
    public Timestamp getProviderExpirationDate() {
        return this.providerExpirationDate;
    }

    public void setProviderExpirationDate(Timestamp providerExpirationDate) {
        this.providerExpirationDate = providerExpirationDate;
    }

    @Override
    public boolean hasProviderInfo() {
        boolean hasInfo = false;
        if (this.getProviderSpecializationIdentifier() != null || this.getNumberOfPersonClasses() > 0) {
            hasInfo = true;
        }
        return hasInfo;
    }

    @Override
    public boolean hasDeprecatedInfo() {
        return this.hasDeprecatedInfo;
    }

    public void setDeprecatedInfo(boolean deprecated) {
        this.hasDeprecatedInfo = deprecated;
    }

    @Override
    public String getUpdateStatus() {
        return this.updateStatus;
    }

    public void setUpdateStatus(String updateStatus) {
        this.updateStatus = updateStatus;
    }

    @Override
    public boolean isUpdatePending() {
        return this.updatePending;
    }

    public void setUpdatePending(boolean updatePending) {
        this.updatePending = updatePending;
    }

    @Override
    public String getMessageControlId() {
        return this.messageControlId;
    }

    public void setMessageControlId(String messageControlId) {
        this.messageControlId = messageControlId;
    }

    @Override
    public String getOriginalMessageControlId() {
        return null;
    }

    public void setAuditUserId(String userId) {
        this.auditUserID = userId;
    }

    @Override
    public String getAuditUserId() {
        return this.auditUserID;
    }

    @Override
    public Serializable getSerializableMessage() {
        return this;
    }

    @Override
    public String getSendingFacility() {
        return this.sendingFacility;
    }

    public void setSendingFacility(String sendingFacility) {
        this.sendingFacility = sendingFacility;
    }

    @Override
    public IPersonIdentity[] getHistory() throws PSIMException {
        return this.history;
    }

    public void setHistory(IPersonIdentity[] history) {
        this.history = history;
    }

    private void ensureNameCapacity(int index) throws IndexOutOfBoundsException {
        int size = this.personNames.size();
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        if (index == size) {
            this.personNames.add(new PersonNameUtil());
        }
    }

    public Integer getMatchCount() {
        return this.matchCount;
    }

    public void setMatchCount(Integer cnt) {
        this.matchCount = cnt;
    }

    @Override
    public String getCorrelationStatus() {
        return this.correlationStatus;
    }

    public void setCorrelationStatus(String correlationStatus) {
        this.correlationStatus = correlationStatus;
    }

    @Override
    public final int getNumberOfPersonClasses() {
        return this.personClassList.size();
    }

    @Override
    public IPersonClass getPersonClass(int personClassIndex) {
        IPersonClass retPersonClass = null;
        if (personClassIndex > -1 && personClassIndex < this.personClassList.size()) {
            retPersonClass = (IPersonClass)this.personClassList.get(personClassIndex);
        }
        return retPersonClass;
    }

    public int setPersonClass(IPersonClass personClass) {
        this.personClassList.add(personClass);
        return this.personClassList.size();
    }

    @Override
    public Address getAddress(String addressType) {
        Address address = null;
        CollectionFilter cf = new CollectionFilter();
        cf.addFilterCriteria(ClientDataFilterFactory.createAddressTypeFilter(addressType));
        Iterator itr = cf.filterCopy(this.addressSet).iterator();
        if (itr.hasNext()) {
            address = (Address)itr.next();
        }
        return address;
    }

    public void addAddress(Address address) throws PSException {
        String addressType = address.getAddrType();
        if ("N".equalsIgnoreCase(addressType) || "P".equalsIgnoreCase(addressType) || "BA".equalsIgnoreCase(addressType)) {
            String state = address.getState();
            if (state == null || state.trim().length() == 0 || "\"\"".equalsIgnoreCase(state)) {
                throw new PSException("Address:Invalid STATE[" + state + "].");
            }
        } else {
            throw new PSException("Address: Invalid Type [" + addressType + "].");
        }
        this.addressSet.add(address);
    }

    public void clearAddresses() {
        this.addressSet.clear();
    }

    public void clearPhones() {
        this.phoneSet.clear();
    }

    @Override
    public Phone getPhone(String phoneType) {
        Phone phone = null;
        CollectionFilter cf = new CollectionFilter();
        cf.addFilterCriteria(ClientDataFilterFactory.createPhoneTypeFilter(phoneType));
        Iterator itr = cf.filterCopy(this.phoneSet).iterator();
        if (itr.hasNext()) {
            phone = (Phone)itr.next();
        }
        return phone;
    }

    public void addPhone(Phone phone) throws PSException {
        String phoneType = phone.getPhoneType();
        if (phoneType == null || !"Home".equalsIgnoreCase(phoneType)) {
            throw new PSException("Phone Type Not Supported By IDM[" + phoneType + "].");
        }
        this.phoneSet.add(phone);
    }

    @Override
    public Address[] getAddresses() {
        return this.addressSet.toArray(new Address[this.addressSet.size()]);
    }

    @Override
    public Phone[] getPhones() {
        return this.phoneSet.toArray(new Phone[this.phoneSet.size()]);
    }

    public String getTraitStatus() {
        return this.traitStatus;
    }

    public void setTraitStatus(String traitStatus) {
        this.traitStatus = traitStatus;
    }
}

