/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt;

import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.QualifiedIdentifierImpl;
import gov.va.med.person.idmgmt.exceptions.NPIException;
import gov.va.med.person.idmgmt.util.IConstants;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class NPI
implements IConstants,
Cloneable,
Serializable {
    private static final String PREFIX_80840 = "80840";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(NPI.class);
    private String validNpi;
    private String npi;
    private String npiCheckDigit;
    private static final String ONE_STRING = "1";
    private static final String TWO_STRING = "2";
    private static final String EIGHT_STRING = "8";
    private static final String INVALID_FIRST_DIGIT = "Invalid NPI first digit: ";
    private static final String INVALID_CHECK_DIGIT = "Invalid NPI Check digit: ";
    private static final String VALID_CHECK_DIGIT = "valid NPI Check digit: ";
    private static final String INVALID_LENGTH = "Invalid length for NPI: ";
    private static final String MUST_BE_SIZE = " - must be 10 or 15 digits.";

    public NPI(String newNpi) throws NPIException {
        if ("\"\"".equals(newNpi) || "<NULL>".equals(newNpi) || "NOTSENT".equals(newNpi)) {
            return;
        }
        if (newNpi == null || newNpi.length() == 0) {
            throw new NPIException("NPI cannot be constructed with null value");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parameter value: " + newNpi));
        }
        if (newNpi.length() != 10 && newNpi.length() != 15) {
            logger.error((Object)(INVALID_LENGTH + newNpi + MUST_BE_SIZE));
            throw new NPIException(INVALID_LENGTH + newNpi + MUST_BE_SIZE);
        }
        if (newNpi.length() == 10 && !newNpi.startsWith(ONE_STRING) && !newNpi.startsWith(TWO_STRING)) {
            logger.error((Object)(INVALID_FIRST_DIGIT + newNpi.substring(0, 1)));
            throw new NPIException(INVALID_FIRST_DIGIT + newNpi.substring(0, 1));
        }
        if (newNpi.length() == 15) {
            if (!newNpi.startsWith(EIGHT_STRING)) {
                logger.error((Object)(INVALID_FIRST_DIGIT + newNpi.substring(0)));
                throw new NPIException("Invalid NPI first digit for id with US health application prefix: " + newNpi.substring(0, 1));
            }
            if (!newNpi.substring(5, 6).equals(ONE_STRING) && !newNpi.substring(5, 6).equals(TWO_STRING)) {
                logger.error((Object)(INVALID_FIRST_DIGIT + newNpi.substring(5, 6)));
                throw new NPIException(INVALID_FIRST_DIGIT + newNpi.substring(5, 6));
            }
        }
        if (this.isValidCheckDigit(newNpi)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(VALID_CHECK_DIGIT + newNpi.substring(newNpi.length() - 1)));
            }
        } else {
            logger.error((Object)(INVALID_CHECK_DIGIT + newNpi.substring(newNpi.length() - 1)));
            throw new NPIException(INVALID_CHECK_DIGIT + newNpi.substring(newNpi.length() - 1));
        }
        this.npi = newNpi.substring(0, newNpi.length() - 1);
        this.npiCheckDigit = newNpi.substring(newNpi.length() - 1);
        this.validNpi = newNpi;
    }

    public NPI(String ident, String chkdigit) throws NPIException {
        this(String.valueOf(ident) + chkdigit);
    }

    public boolean isValidCheckDigit(String npi) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" *** NPI.isValidCheckDigit ***");
            logger.debug((Object)("param npi: " + npi));
        }
        int sum = 0;
        int npiLen = npi.length();
        sum = npi.startsWith(PREFIX_80840) ? 0 : 24;
        boolean alternate = false;
        int n = 0;
        int i = npiLen - 1;
        while (i >= 0) {
            n = Integer.parseInt(npi.substring(i, i + 1));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate ^= true;
            --i;
        }
        return sum % 10 == 0;
    }

    public int hashCode() {
        return this.validNpi.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.validNpi.equals(((NPI)o).validNpi);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(70);
        sb.append(IConstants.ENDL);
        sb.append("Validated NPI: ");
        sb.append(this.validNpi);
        sb.append(IConstants.ENDL);
        sb.append("Identifier: ");
        sb.append(this.npi);
        sb.append(IConstants.ENDL);
        sb.append("Check Digit: ");
        sb.append(this.npiCheckDigit);
        return sb.toString();
    }

    public IQualifiedIdentifier getNPI() {
        QualifiedIdentifierImpl qiNPI = new QualifiedIdentifierImpl();
        qiNPI.setIdentifier(this.validNpi);
        qiNPI.setIdentifierType("NI");
        qiNPI.setAssigningAuthority("USVHA");
        qiNPI.setAssigningLocation("200M");
        return qiNPI;
    }

    public IQualifiedIdentifier getNPI(String npi) {
        QualifiedIdentifierImpl qiNPI = new QualifiedIdentifierImpl();
        qiNPI.setIdentifier(this.validNpi);
        qiNPI.setIdentifierType("NI");
        qiNPI.setAssigningAuthority("USVHA");
        qiNPI.setAssigningLocation("200M");
        return qiNPI;
    }

    public String getNpiNumber() {
        return this.npi;
    }

    public String getNpiChk() {
        return this.npiCheckDigit;
    }
}

