/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt;

import gov.va.med.person.idmgmt.Address;
import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.Phone;

public class ClientDataFilterFactory {
    public static FilterCriteria createAddressTypeFilter(String addressType) {
        return new AddressTypeFilter(addressType);
    }

    public static FilterCriteria createPhoneTypeFilter(String phoneType) {
        return new PhoneTypeFilter(phoneType);
    }

    private static class AddressTypeFilter
    implements FilterCriteria {
        String addressType;

        public AddressTypeFilter(String addressType) {
            this.addressType = addressType;
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof Address) {
                Address address = (Address)obj;
                boolean isMatch = this.addressType.equalsIgnoreCase(address.getAddrType());
                return isMatch;
            }
            return false;
        }
    }

    private static class PhoneTypeFilter
    implements FilterCriteria {
        String phoneType;

        public PhoneTypeFilter(String phoneType) {
            this.phoneType = phoneType;
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof Phone) {
                Phone phone = (Phone)obj;
                boolean isMatch = this.phoneType.equalsIgnoreCase(phone.getPhoneType());
                return isMatch;
            }
            return false;
        }
    }
}

