/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.exceptions;

import gov.va.med.soa.utils.exceptions.CommonServicesException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PSRemoteException
extends CommonServicesException {
    private static final long serialVersionUID = 7627295315884288813L;
    private String nestedStackTrace;

    public PSRemoteException() {
    }

    public PSRemoteException(String msg, Throwable nestedException) {
        super(msg);
        this.nestedStackTrace = this.getNestedStackTrace(nestedException);
    }

    public PSRemoteException(String msg) {
        super(msg);
    }

    public PSRemoteException(Throwable nestedException) {
        this.nestedStackTrace = this.getNestedStackTrace(nestedException);
    }

    private String getNestedStackTrace(Throwable nestedException) {
        if (nestedException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            out.println("Nested StackTrace:");
            nestedException.printStackTrace(out);
            out.close();
            return sw.toString();
        }
        return null;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        if (this.nestedStackTrace != null) {
            out.println();
            out.print(this.nestedStackTrace);
        }
    }

    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        if (this.nestedStackTrace != null) {
            out.println();
            out.print(this.nestedStackTrace);
        }
    }
}

