/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.log;

import gov.va.med.log.IdmLogData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class IdmLogEntry {
    public static final String TYPE_ERROR = "ERROR";
    String type;
    String queue;
    String metaInfo;
    String inboundMCID;
    int processLevel = -1;
    final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Date createDate = new Date();
    ArrayList<IdmLogData> idmLogDataList = new ArrayList();
    String stackTrace;

    public String getCreated() {
        return this.sdf.format(this.createDate);
    }

    public void setCreated(String created) {
        try {
            this.createDate = this.sdf.parse(created);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setProcesslevel(int processLevel) {
        this.processLevel = processLevel;
    }

    public ArrayList<IdmLogData> getIdmLogDataList() {
        return this.idmLogDataList;
    }

    public void addIdmLogData(IdmLogData idmLogData) {
        this.idmLogDataList.add(idmLogData);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(String metaInfo) {
        this.metaInfo = metaInfo;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getInboundMCID() {
        return this.inboundMCID;
    }

    public void setInboundMCID(String inboundMCID) {
        this.inboundMCID = inboundMCID;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void addStackTrace(Exception stackTrace) {
        this.stackTrace = this.stackTrace == null ? "" : String.valueOf(this.stackTrace) + "\nFollow-On Exception:\n";
        this.stackTrace = String.valueOf(this.stackTrace) + this.getExceptionString(stackTrace);
    }

    public String getXML() {
        String type = this.getType();
        if (type == null) {
            type = "";
        }
        String xml = "<IDMLOG_ENTRY type='" + type + "'>";
        xml = String.valueOf(xml) + "<CREATED>" + this.sdf.format(this.createDate) + "</CREATED>";
        if (this.metaInfo != null) {
            xml = String.valueOf(xml) + "<METAINFO>" + this.metaInfo + "</METAINFO>";
        }
        xml = String.valueOf(xml) + "<PROCLEVEL>" + this.processLevel + "</PROCLEVEL>";
        if (this.queue != null) {
            xml = String.valueOf(xml) + "<QUEUE>" + this.queue + "</QUEUE>";
        }
        if (this.inboundMCID != null) {
            xml = String.valueOf(xml) + "<INBOUND_MCID>" + this.inboundMCID + "</INBOUND_MCID>";
        }
        if (this.idmLogDataList != null && this.idmLogDataList.size() > 0) {
            xml = String.valueOf(xml) + "<IDMLOG_DATA>";
            for (IdmLogData data : this.idmLogDataList) {
                xml = String.valueOf(xml) + data.toXML();
            }
            xml = String.valueOf(xml) + "</IDMLOG_DATA>";
        }
        if (this.stackTrace != null) {
            xml = String.valueOf(xml) + "<STACKTRACE><![CDATA[" + this.stackTrace + "]]></STACKTRACE>";
        }
        xml = String.valueOf(xml) + "</IDMLOG_ENTRY>";
        return xml;
    }

    public String getExceptionString(Exception err) {
        String stackInfo = "";
        int errLineCount = err.getStackTrace().length;
        if (errLineCount > 5) {
            errLineCount = 5;
        }
        int i = 0;
        while (i < errLineCount) {
            stackInfo = String.valueOf(stackInfo) + err.getStackTrace()[i].toString() + "\n";
            ++i;
        }
        if (err.getCause() != null) {
            stackInfo = String.valueOf(stackInfo) + "[CAUSE]" + err.getCause().getMessage();
        }
        return stackInfo;
    }
}

