/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.log;

import org.apache.commons.lang.builder.ToStringBuilder;

public class IdmLogData {
    public static final String TYPE_HL7_24 = "HL724";
    public static final String TYPE_QUEUE = "QUEUE";
    public static final String TYPE_XML = "XML";
    public static final String SUBT_TYPE_INBOUND = "INBOUND";
    public static final String SUBT_TYPE_OUTBOUND = "OUTBOUND";
    String type = "";
    String subType = "";
    String logData;

    public IdmLogData(String type, String subType, String logData) {
        this.setType(type);
        this.setSubType(subType);
        this.logData = logData;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getData() {
        return this.logData;
    }

    public void setData(String logData) {
        this.logData = logData;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append((Object)this.type).append((Object)this.subType).append((Object)this.logData);
        return builder.toString();
    }

    public String toXML() {
        return this.toXML("DATA");
    }

    private String toXML(String tag) {
        StringBuffer xml = new StringBuffer();
        xml.append("<").append(tag);
        if (this.type != null && this.type.trim().length() > 0) {
            xml.append(" type='").append(this.type).append("'");
        }
        if (this.subType != null && this.subType.trim().length() > 0) {
            xml.append(" subtype='").append(this.subType).append("'");
        }
        xml.append(">");
        if (this.logData != null && this.logData.length() > 0) {
            xml.append("<![CDATA[");
            xml.append(this.logData);
            xml.append("]]>");
        }
        xml.append("</").append(tag).append(">");
        return xml.toString();
    }
}

