/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.log;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class ConstantRolloverFileAppender
extends RollingFileAppender {
    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        this.rollOver();
    }

    public void rollOver() {
        File file = new File(this.fileName);
        if (file.exists()) {
            this.closeFile();
            String prefix = this.fileName.substring(0, this.fileName.indexOf(".log"));
            String date = new SimpleDateFormat("yyyyMMddhhmmssSS").format(new Date(System.currentTimeMillis()));
            String random = Long.toString(Math.abs((long)new Random(System.currentTimeMillis()).nextInt() + Thread.currentThread().getId()));
            File target = new File(String.valueOf(prefix) + "_" + date + "_" + random + ".log");
            LogLog.debug((String)("Renaming file " + file + " to " + target));
            file.renameTo(target);
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }
}

