/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.j2ee;

import gov.vha.hvm.dsd.envelopes.Envelope;
import gov.vha.hvm.dsd.exceptions.HVMException;
import gov.vha.hvm.dsd.j2ee.AbstractDeliveryServiceMDB;
import java.util.Enumeration;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

public abstract class AbstractDeliveryServiceJMSMDB
extends AbstractDeliveryServiceMDB
implements MessageListener {
    public void onMessage(Message message) {
        try {
            Envelope envelope = this.createEnvelopeFromJMS(message);
            this.receiveMessage(envelope);
        }
        catch (HVMException hVMException) {
            throw new EJBException((Exception)hVMException);
        }
    }

    protected Envelope createEnvelopeFromJMS(Message message) throws HVMException {
        try {
            Properties properties = this.collectPropertiesFrom(message);
            byte[] byArray = this.readJMSData((BytesMessage)message);
            return Envelope.createFromRawData(byArray, properties);
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
            return null;
        }
    }

    protected byte[] readJMSData(BytesMessage bytesMessage) throws JMSException {
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[1024];
        int n = bytesMessage.readBytes(byArray2);
        while (n > 0) {
            byte[] byArray3 = byArray;
            byArray = new byte[byArray3.length + n];
            if (byArray3.length > 0) {
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            }
            System.arraycopy(byArray2, 0, byArray, byArray3.length, n);
            n = bytesMessage.readBytes(byArray2);
        }
        return byArray;
    }

    protected Properties collectPropertiesFrom(Message message) throws JMSException {
        Enumeration enumeration = message.getPropertyNames();
        Properties properties = new Properties();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = message.getStringProperty(string);
            properties.put(string, string2);
        }
        return properties;
    }
}

