/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.hl7;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import gov.vha.hvm.dsd.hl7.BatchFileMessage;
import gov.vha.hvm.dsd.hl7.BatchFilePipeParser;
import gov.vha.hvm.dsd.hl7.BatchFileXMLParser;
import gov.vha.hvm.dsd.hl7.BatchMessage;
import gov.vha.hvm.dsd.hl7.BatchPipeParser;
import gov.vha.hvm.dsd.hl7.BatchXMLParser;

public class HL7ParserFactory {
    private static final String MSH = "MSH";
    private static final String BHS = "BHS";
    private static final String FHS = "FHS";
    private static final String XML = "<?xml";
    private static final String BATCHXML = "<MESSAGEBATCH";
    private static final String BATCH = "<BATCH";
    private static final Parser er7Parser = new PipeParser();
    private static final Parser batchER7Parser = new BatchPipeParser();
    private static final Parser batchFileER7Parser = new BatchFilePipeParser();
    private static final Parser xmlParser = new DefaultXMLParser();
    private static final Parser batchXmlParser = new BatchXMLParser();
    private static final Parser batchFileXmlParser = new BatchFileXMLParser();

    public static Parser getParserFor(String string) throws EncodingNotSupportedException {
        if (string == null) {
            return null;
        }
        if (string.startsWith(MSH)) {
            return HL7ParserFactory.getMessageParser();
        }
        if (string.startsWith(XML)) {
            return HL7ParserFactory.getXMLParser(string);
        }
        if (string.startsWith(BHS)) {
            return HL7ParserFactory.getBatchParser();
        }
        if (string.startsWith(FHS)) {
            return HL7ParserFactory.getBatchFileParser();
        }
        throw new EncodingNotSupportedException("Unknown message format in " + string);
    }

    public static Parser getEncoderFor(Message message, String string) throws EncodingNotSupportedException {
        if (message == null) {
            return null;
        }
        if ("X".equals(string)) {
            return HL7ParserFactory.XMLEncoderFor(message);
        }
        if ("E".equals(string)) {
            return HL7ParserFactory.ER7EncoderFor(message);
        }
        throw new EncodingNotSupportedException("Unsupported encoding " + string);
    }

    private static Parser XMLEncoderFor(Message message) {
        if (message == null) {
            return null;
        }
        if (message instanceof BatchFileMessage) {
            return batchFileXmlParser;
        }
        if (message instanceof BatchMessage) {
            return batchXmlParser;
        }
        return xmlParser;
    }

    private static Parser ER7EncoderFor(Message message) {
        if (message == null) {
            return null;
        }
        if (message instanceof BatchFileMessage) {
            return batchFileER7Parser;
        }
        if (message instanceof BatchMessage) {
            return batchER7Parser;
        }
        return er7Parser;
    }

    private static Parser getMessageParser() {
        return er7Parser;
    }

    private static Parser getBatchParser() {
        return batchER7Parser;
    }

    private static Parser getBatchFileParser() {
        return batchFileER7Parser;
    }

    private static Parser getXMLParser(String string) {
        if (string.indexOf(BATCH) > 0) {
            return batchFileXmlParser;
        }
        if (string.indexOf(BATCHXML) > 0) {
            return batchXmlParser;
        }
        return xmlParser;
    }
}

