/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.util.XMLSerializer;
import gov.vha.hvm.dsd.hl7.BatchMessage;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatchXMLParser
extends DefaultXMLParser {
    private static String XMLHEADER = "<?xml version=\"1.0\" ecoding=\"UTF-8\"?>\n\n";

    public Document encodeDocument(Message message) throws HL7Exception {
        if (message == null) {
            return null;
        }
        if (message instanceof BatchMessage) {
            Document document = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element element = document.createElement("MESSAGEBATCH");
                this.encodeBatch((BatchMessage)message, document, element);
                document.appendChild(element);
            }
            catch (Exception exception) {
                throw new HL7Exception("Can't create XML document - " + exception.getClass().getName(), 207, (Throwable)exception);
            }
            return document;
        }
        return super.encodeDocument(message);
    }

    protected void encodeBatch(BatchMessage batchMessage, Document document, Element element) throws HL7Exception {
        Node node;
        Element element2;
        Element element3 = document.createElement("BHS");
        this.encode((Segment)batchMessage.getBHS(), element3);
        element.appendChild(element3);
        if (batchMessage.hasQRD()) {
            element2 = document.createElement("QRD");
            this.encode((Segment)batchMessage.getQRD(), element2);
            element.appendChild(element2);
        }
        if (batchMessage.hasQRF()) {
            element2 = document.createElement("QRF");
            this.encode((Segment)batchMessage.getQRF(), element2);
            element.appendChild(element2);
        }
        element2 = document.createElement("MESSAGES");
        Message[] messageArray = batchMessage.getMessages();
        StringBuffer stringBuffer = new StringBuffer();
        DefaultXMLParser defaultXMLParser = new DefaultXMLParser();
        for (int i = 0; i < messageArray.length; ++i) {
            node = defaultXMLParser.encodeDocument(messageArray[i]);
            stringBuffer.append(this.serialize((Document)node));
        }
        CDATASection cDATASection = document.createCDATASection(stringBuffer.toString());
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        node = document.createElement("BTS");
        this.encode((Segment)batchMessage.getBTS(), (Element)node);
        element.appendChild(node);
    }

    private String serialize(Document document) throws HL7Exception {
        return XMLSerializer.serialize((Document)document, (boolean)false);
    }

    public Message parseDocument(Document document, String string) throws HL7Exception {
        BatchMessage batchMessage = new BatchMessage();
        Element element = document.getDocumentElement();
        this.parseDocument(batchMessage, element);
        return batchMessage;
    }

    protected void parseDocument(BatchMessage batchMessage, Element element) throws HL7Exception {
        Element element2;
        this.addMessagesToBatch(batchMessage, element);
        NodeList nodeList = element.getElementsByTagName("BHS");
        if (nodeList.getLength() > 0) {
            element2 = (Element)nodeList.item(0);
            super.parse((Segment)batchMessage.getBHS(), element2);
        }
        if ((nodeList = element.getElementsByTagName("BTS")).getLength() > 0) {
            element2 = (Element)nodeList.item(0);
            super.parse((Segment)batchMessage.getBTS(), element2);
        }
        if ((nodeList = element.getElementsByTagName("QRD")).getLength() > 0) {
            element2 = (Element)nodeList.item(0);
            super.parse((Segment)batchMessage.getQRD(), element2);
        }
        if ((nodeList = element.getElementsByTagName("QRF")).getLength() > 0) {
            element2 = (Element)nodeList.item(0);
            super.parse((Segment)batchMessage.getQRF(), element2);
        }
    }

    private void addMessagesToBatch(BatchMessage batchMessage, Element element) throws HL7Exception {
        NodeList nodeList = element.getElementsByTagName("MESSAGES");
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                NodeList nodeList2 = element2.getChildNodes();
                String string = null;
                string = element2.getFirstChild().getNodeType() == 4 ? element2.getFirstChild().getNodeValue() : element2.getChildNodes().item(1).getNodeValue();
                this.parseMessageText(batchMessage, string);
            }
        }
    }

    private void parseMessageText(BatchMessage batchMessage, String string) throws HL7Exception {
        int n;
        DefaultXMLParser defaultXMLParser = new DefaultXMLParser();
        int n2 = 0;
        do {
            int n3;
            if ((n3 = string.indexOf(">", n2)) == -1) {
                throw new HL7Exception("Illegal XML in MESSAGES");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("</");
            stringBuffer.append(string.substring(n2 + 1, n3));
            stringBuffer.append(">");
            n3 = string.indexOf(stringBuffer.toString(), n2);
            if (n3 == -1) {
                throw new HL7Exception("No closing tag " + stringBuffer.toString() + " in MESSAGES");
            }
            n = n3 + stringBuffer.length();
            String string2 = string.substring(n2, n);
            Message message = defaultXMLParser.parse(string2);
            batchMessage.addMessage(message, false);
        } while ((n2 = n) < string.length());
    }
}

