/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.segment.BHS;
import ca.uhn.hl7v2.model.v24.segment.BTS;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.Escape;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.MessageIterator;
import ca.uhn.hl7v2.util.Terser;
import gov.vha.hvm.dsd.hl7.BatchMessage;
import java.util.StringTokenizer;

public class BatchPipeParser
extends Parser {
    protected static final String segDelim = "\r";
    static /* synthetic */ Class class$gov$vha$hvm$dsd$hl7$BatchMessage;

    public String getEncoding(String string) {
        String string2 = null;
        if (string.length() < 4) {
            return null;
        }
        boolean bl = true;
        if (!string.startsWith("BHS")) {
            return null;
        }
        char c = string.charAt(3);
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(segDelim), false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() <= 0) continue;
            if (Character.isWhitespace(string3.charAt(0))) {
                string3 = BatchPipeParser.stripLeadingWhitespace((String)string3);
            }
            if (string3.length() < 4 || string3.charAt(3) == c) continue;
            return null;
        }
        if (bl) {
            string2 = "VB";
        }
        return string2;
    }

    public boolean supportsEncoding(String string) {
        boolean bl = false;
        if (string.equals("VB")) {
            bl = true;
        }
        return bl;
    }

    public Message parse(String string) throws HL7Exception, EncodingNotSupportedException {
        EncodingCharacters encodingCharacters = BatchPipeParser.getEncodingChars(string);
        if (encodingCharacters == null) {
            throw new EncodingNotSupportedException("Message encoding not recognized by this parser.");
        }
        return this.parse(string, encodingCharacters);
    }

    protected Message parse(String string, EncodingCharacters encodingCharacters) throws HL7Exception, EncodingNotSupportedException {
        int n;
        BatchMessage batchMessage = new BatchMessage();
        BHS bHS = batchMessage.getBHS();
        String string2 = string.substring(0, string.indexOf(segDelim));
        BatchPipeParser.parseHeader((Segment)bHS, string2, encodingCharacters);
        BTS bTS = batchMessage.getBTS();
        int n2 = string.indexOf("BTS");
        if (n2 <= 0) {
            throw new HL7Exception("Batch has no BTS segment");
        }
        PipeParser.parse((Segment)bTS, (String)string.substring(n2), (EncodingCharacters)encodingCharacters);
        int n3 = 0;
        int n4 = string.indexOf("MSH", n3 + 3);
        PipeParser pipeParser = new PipeParser();
        while (n4 != n2) {
            n3 = n4;
            if ((n4 = string.indexOf("MSH", n3 + 3)) == -1) {
                n4 = n2;
            }
            String string3 = string.substring(n3, n4 - 1);
            batchMessage.addMessage(pipeParser.parse(string3), false);
        }
        int n5 = string.indexOf("QRD");
        if (n5 > 0) {
            n = string.indexOf(segDelim, n5);
            String string4 = string.substring(n5, n);
            PipeParser.parse((Segment)batchMessage.getQRD(), (String)string4, (EncodingCharacters)encodingCharacters);
        }
        if ((n = string.indexOf("QRF")) > 0) {
            int n6 = string.indexOf(segDelim, n);
            String string5 = string.substring(n, n6);
            PipeParser.parse((Segment)batchMessage.getQRF(), (String)string5, (EncodingCharacters)encodingCharacters);
        }
        return batchMessage;
    }

    private static EncodingCharacters getEncodingChars(String string) {
        return new EncodingCharacters(string.charAt(3), string.substring(4, 8));
    }

    public String encode(Message message, String string) throws HL7Exception {
        if (!this.supportsEncoding(string)) {
            throw new EncodingNotSupportedException("This parser does not support the " + string + " encoding");
        }
        return this.encode(message);
    }

    public String encode(Message message) throws HL7Exception {
        String string;
        if (message.getClass() != (class$gov$vha$hvm$dsd$hl7$BatchMessage == null ? (class$gov$vha$hvm$dsd$hl7$BatchMessage = BatchPipeParser.class$("gov.vha.hvm.dsd.hl7.BatchMessage")) : class$gov$vha$hvm$dsd$hl7$BatchMessage)) {
            throw new HL7Exception("This parser can only encode instances of BatchMessage");
        }
        BatchMessage batchMessage = (BatchMessage)message;
        BHS bHS = batchMessage.getBHS();
        BTS bTS = batchMessage.getBTS();
        String string2 = Terser.get((Segment)bHS, (int)1, (int)0, (int)1, (int)1);
        if (string2 == null) {
            throw new HL7Exception("Can't encode message: BHS-1 (field separator) is missing");
        }
        char c = '|';
        if (string2 != null && string2.length() > 0) {
            c = string2.charAt(0);
        }
        if ((string = Terser.get((Segment)bHS, (int)2, (int)0, (int)1, (int)1)) == null) {
            throw new HL7Exception("Can't encode message: BHS-2 (encoding characters) is missing");
        }
        if (string.length() != 4) {
            throw new HL7Exception("Encoding characters '" + string + "' invalid -- must be 4 characters", 102);
        }
        EncodingCharacters encodingCharacters = new EncodingCharacters(c, string);
        PipeParser pipeParser = new PipeParser();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BatchPipeParser.encodeHeader((Segment)bHS, encodingCharacters));
        stringBuffer.append(segDelim);
        if (batchMessage.hasQRD()) {
            stringBuffer.append(PipeParser.encode((Segment)batchMessage.getQRD(), (EncodingCharacters)encodingCharacters));
            stringBuffer.append(segDelim);
        }
        if (batchMessage.hasQRF()) {
            stringBuffer.append(PipeParser.encode((Segment)batchMessage.getQRF(), (EncodingCharacters)encodingCharacters));
            stringBuffer.append(segDelim);
        }
        Message[] messageArray = batchMessage.getMessages();
        for (int i = 0; i < messageArray.length; ++i) {
            stringBuffer.append(pipeParser.encode(messageArray[i]));
        }
        stringBuffer.append(PipeParser.encode((Segment)bTS, (EncodingCharacters)encodingCharacters));
        return stringBuffer.toString();
    }

    public Segment getCriticalResponseData(String string) throws HL7Exception {
        return null;
    }

    public String getAckID(String string) {
        return null;
    }

    public String getVersion(String string) throws HL7Exception {
        return null;
    }

    protected static void parseHeader(Segment segment, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        int n = 1;
        Terser.set((Segment)segment, (int)1, (int)0, (int)1, (int)1, (String)String.valueOf(encodingCharacters.getFieldSeparator()));
        String[] stringArray = PipeParser.split((String)string, (String)String.valueOf(encodingCharacters.getFieldSeparator()));
        for (int i = 1; i < stringArray.length; ++i) {
            boolean bl;
            String[] stringArray2 = PipeParser.split((String)stringArray[i], (String)String.valueOf(encodingCharacters.getRepetitionSeparator()));
            boolean bl2 = bl = i + n == 2;
            if (bl) {
                stringArray2 = new String[]{stringArray[i]};
            }
            for (int j = 0; j < stringArray2.length; ++j) {
                try {
                    StringBuffer stringBuffer = new StringBuffer("Parsing field ");
                    stringBuffer.append(i + n);
                    stringBuffer.append(" repetition ");
                    stringBuffer.append(j);
                    Type type = segment.getField(i + n, j);
                    if (bl) {
                        Terser.getPrimitive((Type)type, (int)1, (int)1).setValue(stringArray2[j]);
                        continue;
                    }
                    PipeParser.parse((Type)type, (String)stringArray2[j], (EncodingCharacters)encodingCharacters);
                    continue;
                }
                catch (HL7Exception hL7Exception) {
                    hL7Exception.setFieldPosition(i);
                    hL7Exception.setSegmentRepetition(MessageIterator.getIndex((Group)segment.getParent(), (Structure)segment).rep);
                    hL7Exception.setSegmentName(segment.getName());
                    throw hL7Exception;
                }
            }
        }
    }

    protected static String encodeHeader(Segment segment, EncodingCharacters encodingCharacters) throws HL7Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(segment.getName());
        stringBuffer.append(encodingCharacters.getFieldSeparator());
        int n = 2;
        int n2 = segment.numFields();
        for (int i = n; i <= n2; ++i) {
            Type[] typeArray = segment.getField(i);
            for (int j = 0; j < typeArray.length; ++j) {
                String string = PipeParser.encode((Type)typeArray[j], (EncodingCharacters)encodingCharacters);
                if (i == 2) {
                    string = Escape.unescape((String)string, (EncodingCharacters)encodingCharacters);
                }
                stringBuffer.append(string);
                if (j >= typeArray.length - 1) continue;
                stringBuffer.append(encodingCharacters.getRepetitionSeparator());
            }
            stringBuffer.append(encodingCharacters.getFieldSeparator());
        }
        return PipeParser.stripExtraDelimiters((String)stringBuffer.toString(), (char)encodingCharacters.getFieldSeparator());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

