/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import gov.vha.hvm.dsd.hl7.BatchFileMessage;
import gov.vha.hvm.dsd.hl7.BatchMessage;
import gov.vha.hvm.dsd.hl7.BatchXMLParser;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BatchFileXMLParser
extends BatchXMLParser {
    public Message parseDocument(Document document, String string) throws HL7Exception {
        Element element;
        BatchFileMessage batchFileMessage = new BatchFileMessage();
        Element element2 = document.getDocumentElement();
        this.addBatchMessagesToBatch(batchFileMessage, element2, string);
        NodeList nodeList = element2.getElementsByTagName("FHS");
        if (nodeList.getLength() > 0) {
            element = (Element)nodeList.item(0);
            super.parse((Segment)batchFileMessage.getFHS(), element);
        }
        if ((nodeList = element2.getElementsByTagName("FTS")).getLength() > 0) {
            element = (Element)nodeList.item(0);
            super.parse((Segment)batchFileMessage.getFTS(), element);
        }
        return batchFileMessage;
    }

    private void addBatchMessagesToBatch(BatchFileMessage batchFileMessage, Element element, String string) throws HL7Exception {
        NodeList nodeList = element.getElementsByTagName("MESSAGEBATCH");
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                BatchMessage batchMessage = new BatchMessage();
                super.parseDocument(batchMessage, element2);
                batchFileMessage.addBatch(batchMessage);
            }
        }
    }

    public Document encodeDocument(Message message) throws HL7Exception {
        if (message == null) {
            return null;
        }
        if (message instanceof BatchFileMessage) {
            Document document = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element element = document.createElement("BATCH");
                this.encodeBatchFile((BatchFileMessage)message, document, element);
                document.appendChild(element);
            }
            catch (Exception exception) {
                throw new HL7Exception("Can't create XML document - " + exception.getClass().getName(), 207, (Throwable)exception);
            }
            return document;
        }
        return super.encodeDocument(message);
    }

    private void encodeBatchFile(BatchFileMessage batchFileMessage, Document document, Element element) throws HL7Exception {
        Element element2 = document.createElement("FHS");
        this.encode((Segment)batchFileMessage.getFHS(), element2);
        element.appendChild(element2);
        BatchMessage[] batchMessageArray = batchFileMessage.getBatches();
        for (int i = 0; i < batchMessageArray.length; ++i) {
            Element element3 = document.createElement("MESSAGEBATCH");
            element.appendChild(element3);
            super.encodeBatch(batchMessageArray[i], document, element3);
        }
        Element element4 = document.createElement("FTS");
        this.encode((Segment)batchFileMessage.getFTS(), element4);
        element.appendChild(element4);
    }
}

