/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.v24.segment.FHS;
import ca.uhn.hl7v2.model.v24.segment.FTS;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import gov.vha.hvm.dsd.hl7.BatchFileMessage;
import gov.vha.hvm.dsd.hl7.BatchMessage;
import gov.vha.hvm.dsd.hl7.BatchPipeParser;

public class BatchFilePipeParser
extends BatchPipeParser {
    static /* synthetic */ Class class$gov$vha$hvm$dsd$hl7$BatchFileMessage;

    protected Message parse(String string, EncodingCharacters encodingCharacters) throws HL7Exception, EncodingNotSupportedException {
        BatchFileMessage batchFileMessage = new BatchFileMessage();
        FHS fHS = batchFileMessage.getFHS();
        String string2 = string.substring(0, string.indexOf("\r"));
        BatchFilePipeParser.parseHeader((Segment)fHS, string2, encodingCharacters);
        FTS fTS = batchFileMessage.getFTS();
        int n = string.indexOf("FTS");
        if (n <= 0) {
            throw new HL7Exception("Batch has no FTS segment");
        }
        PipeParser.parse((Segment)fTS, (String)string.substring(n), (EncodingCharacters)encodingCharacters);
        int n2 = 0;
        int n3 = string.indexOf("BHS", n2 + 3);
        while (n3 != n) {
            n2 = n3;
            if ((n3 = string.indexOf("BHS", n2 + 3)) == -1) {
                n3 = n;
            }
            String string3 = string.substring(n2, n3 - 1);
            batchFileMessage.addBatch((BatchMessage)super.parse(string3, encodingCharacters), false);
        }
        return batchFileMessage;
    }

    public String encode(Message message) throws HL7Exception {
        String string;
        if (message.getClass() != (class$gov$vha$hvm$dsd$hl7$BatchFileMessage == null ? (class$gov$vha$hvm$dsd$hl7$BatchFileMessage = BatchFilePipeParser.class$("gov.vha.hvm.dsd.hl7.BatchFileMessage")) : class$gov$vha$hvm$dsd$hl7$BatchFileMessage)) {
            throw new HL7Exception("This parser can only encode instances of BatchFileMessage");
        }
        BatchFileMessage batchFileMessage = (BatchFileMessage)message;
        FHS fHS = batchFileMessage.getFHS();
        FTS fTS = batchFileMessage.getFTS();
        String string2 = Terser.get((Segment)fHS, (int)1, (int)0, (int)1, (int)1);
        if (string2 == null) {
            throw new HL7Exception("Can't encode message: FHS-1 (field separator) is missing");
        }
        char c = '|';
        if (string2 != null && string2.length() > 0) {
            c = string2.charAt(0);
        }
        if ((string = Terser.get((Segment)fHS, (int)2, (int)0, (int)1, (int)1)) == null) {
            throw new HL7Exception("Can't encode message: FHS-2 (encoding characters) is missing");
        }
        if (string.length() != 4) {
            throw new HL7Exception("Encoding characters '" + string + "' invalid -- must be 4 characters", 102);
        }
        EncodingCharacters encodingCharacters = new EncodingCharacters(c, string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BatchFilePipeParser.encodeHeader((Segment)fHS, encodingCharacters));
        stringBuffer.append("\r");
        BatchMessage[] batchMessageArray = batchFileMessage.getBatches();
        for (int i = 0; i < batchMessageArray.length; ++i) {
            stringBuffer.append(super.encode((Message)batchMessageArray[i]));
            stringBuffer.append("\r");
        }
        stringBuffer.append(PipeParser.encode((Segment)fTS, (EncodingCharacters)encodingCharacters));
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

