/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.envelopes;

import gov.vha.hvm.dsd.envelopes.ByteEnvelope;
import gov.vha.hvm.dsd.envelopes.Envelope;
import gov.vha.hvm.dsd.envelopes.ErrorEnvelope;
import gov.vha.hvm.dsd.envelopes.HL7Envelope;
import gov.vha.hvm.dsd.exceptions.HVMException;
import java.util.Properties;

public abstract class MessageType {
    public static final MessageType BYTE = new MessageType("B", "Byte"){

        Envelope createEnvelopeFromData(byte[] byArray, Properties properties) {
            return ByteEnvelope.createFromData(byArray, properties);
        }

        byte[] createDataFromEnvelope(Envelope envelope) {
            return ((ByteEnvelope)envelope).getByteContent();
        }
    };
    public static final MessageType ERROR = new MessageType("R", "Error"){

        Envelope createEnvelopeFromData(byte[] byArray, Properties properties) {
            return ErrorEnvelope.createFromData(byArray, properties);
        }

        byte[] createDataFromEnvelope(Envelope envelope) {
            return ((ErrorEnvelope)envelope).getByteContent();
        }
    };
    public static final MessageType HL7ER7 = new MessageType("E", "HL7-ER7"){

        Envelope createEnvelopeFromData(byte[] byArray, Properties properties) throws HVMException {
            return HL7Envelope.createFromER7Message(new String(byArray), properties);
        }

        byte[] createDataFromEnvelope(Envelope envelope) throws HVMException {
            return ((HL7Envelope)envelope).asER7().getBytes();
        }
    };
    public static final MessageType HL7XML = new MessageType("X", "HL7-XML"){

        Envelope createEnvelopeFromData(byte[] byArray, Properties properties) throws HVMException {
            return HL7Envelope.createFromXMLMessage(new String(byArray), properties);
        }

        byte[] createDataFromEnvelope(Envelope envelope) throws HVMException {
            return ((HL7Envelope)envelope).asXML().getBytes();
        }
    };
    private static MessageType[] values = new MessageType[]{BYTE, HL7ER7, HL7XML, ERROR};
    private String value;
    private String description;

    private MessageType(String string, String string2) {
        this.value = string;
        this.description = string2;
    }

    public String toString() {
        return this.value;
    }

    public String displayString() {
        return this.description;
    }

    public static MessageType fromValue(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!MessageType.values[i].value.equals(string)) continue;
            return values[i];
        }
        return null;
    }

    abstract Envelope createEnvelopeFromData(byte[] var1, Properties var2) throws HVMException;

    abstract byte[] createDataFromEnvelope(Envelope var1) throws HVMException;
}

