/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.envelopes;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.Parser;
import gov.vha.hvm.dsd.envelopes.Envelope;
import gov.vha.hvm.dsd.envelopes.MessageType;
import gov.vha.hvm.dsd.exceptions.HVMException;
import gov.vha.hvm.dsd.hl7.HL7ParserFactory;
import java.io.PrintStream;
import java.util.Properties;

public class HL7Envelope
extends Envelope {
    private Message message = null;

    private HL7Envelope(Message message, Properties properties) {
        super(properties);
        this.message = message;
    }

    public boolean isValid() {
        return this.message != null;
    }

    public static HL7Envelope createFromMessage(Message message, MessageType messageType, Properties properties) {
        if (messageType == null) {
            throw new IllegalArgumentException("Must use a valid MessageFormat");
        }
        HL7Envelope hL7Envelope = new HL7Envelope(message, properties);
        hL7Envelope.setMessageFormat(messageType);
        return hL7Envelope;
    }

    public static HL7Envelope createFromER7Message(String string, Properties properties) throws HVMException {
        try {
            Message message = HL7ParserFactory.getParserFor(string).parse(string);
            HL7Envelope hL7Envelope = new HL7Envelope(message, properties);
            hL7Envelope.setMessageFormat(MessageType.HL7ER7);
            return hL7Envelope;
        }
        catch (EncodingNotSupportedException encodingNotSupportedException) {
            throw new HVMException(encodingNotSupportedException);
        }
        catch (HL7Exception hL7Exception) {
            throw new HVMException(hL7Exception);
        }
    }

    public static HL7Envelope createFromER7Message(String string) throws HVMException {
        return HL7Envelope.createFromER7Message(string, null);
    }

    public static HL7Envelope createFromXMLMessage(String string, Properties properties) throws HVMException {
        try {
            Message message = HL7ParserFactory.getParserFor(string).parse(string);
            HL7Envelope hL7Envelope = new HL7Envelope(message, properties);
            hL7Envelope.setMessageFormat(MessageType.HL7XML);
            return hL7Envelope;
        }
        catch (EncodingNotSupportedException encodingNotSupportedException) {
            throw new HVMException(encodingNotSupportedException);
        }
        catch (HL7Exception hL7Exception) {
            throw new HVMException(hL7Exception);
        }
    }

    public static HL7Envelope createFromXMLMessage(String string) throws HVMException {
        return HL7Envelope.createFromXMLMessage(string, null);
    }

    public String asER7() throws HVMException {
        if (this.isValid()) {
            try {
                Parser parser = HL7ParserFactory.getEncoderFor(this.getMessage(), "E");
                return parser.encode(this.message);
            }
            catch (HL7Exception hL7Exception) {
                throw new HVMException("Error encoding as ER7", hL7Exception);
            }
        }
        return null;
    }

    public String asXML() throws HVMException {
        if (this.isValid()) {
            try {
                Parser parser = HL7ParserFactory.getEncoderFor(this.getMessage(), "X");
                return parser.encode(this.message);
            }
            catch (HL7Exception hL7Exception) {
                throw new HVMException("Error encoding as XML", hL7Exception);
            }
        }
        return null;
    }

    public Message getMessage() {
        return this.message;
    }

    public byte[] getByteContent() throws HVMException {
        return this.getMessageType().createDataFromEnvelope(this);
    }

    public void dumpBody(PrintStream printStream) {
        printStream.print("   <body><![CDATA[");
        try {
            printStream.print(new String(this.getByteContent()));
        }
        catch (HVMException hVMException) {
            hVMException.printStackTrace(printStream);
        }
        printStream.println("]]></body>");
    }
}

