/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.envelopes;

import gov.vha.hvm.dsd.IDestination;
import gov.vha.hvm.dsd.envelopes.MessageType;
import gov.vha.hvm.dsd.exceptions.HVMException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public abstract class Envelope {
    public static final String DEFAULT_PRIORITY = "4";
    public static final String MESSAGEID = "hvm.envelope.msgid";
    public static final String ROLE = "hvm.envelope.role";
    public static final String PATIENTID = "hvm.envelope.patientid";
    public static final String FROM = "hvm.envelope.from";
    public static final String DESTINATION = "hvm.envelope.destination";
    public static final String REPLYTO = "hvm.envelope.replyto";
    public static final String COMPRESSED = "hvm.envelope.compressionlevel";
    public static final String HL7VERSION = "hvm.envelope.hl7version";
    public static final String MESSAGEFORMAT = "hvm.envelope.messageformat";
    public static final String COMMITACKREQUESTED = "hvm.envelope.commitackrequested";
    public static final String APPACKREQUESTED = "hvm.envelope.appackrequested";
    public static final String PRIORITY = "hvm.envelope.priority";
    private Properties properties = new Properties();
    static /* synthetic */ Class class$gov$vha$hvm$dsd$envelopes$Envelope$UUID;

    Envelope(Properties properties) {
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        if (!this.properties.containsKey(MESSAGEID)) {
            this.properties.setProperty(MESSAGEID, UUID.getUUID());
        }
    }

    public String getProperty(String string) {
        return this.getProperties().getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.getProperties().getProperty(string, string2);
    }

    public void setProperty(String string, String string2) {
        this.getProperties().setProperty(string, string2);
    }

    private Properties getProperties() {
        return this.properties;
    }

    public boolean hasProperty(String string) {
        if (string == null) {
            return false;
        }
        return this.getProperties().containsKey(string);
    }

    public String getMessageId() {
        return this.getProperty(MESSAGEID);
    }

    public boolean isCommitAckRequested() {
        return this.hasProperty(COMMITACKREQUESTED) && "TRUE".equalsIgnoreCase(this.getProperty(COMMITACKREQUESTED));
    }

    public void setCommitAckRequested(boolean bl) {
        if (bl) {
            this.setProperty(COMMITACKREQUESTED, "true");
        } else {
            this.getProperties().remove(COMMITACKREQUESTED);
        }
    }

    public boolean isAppAckRequested() {
        return this.hasProperty(APPACKREQUESTED) && "TRUE".equalsIgnoreCase(this.getProperty(COMMITACKREQUESTED));
    }

    public boolean isCompressed() {
        return "true".equals(this.getProperty(COMPRESSED, "false"));
    }

    public void setCompressed(boolean bl) {
        if (bl) {
            this.setProperty(COMPRESSED, "true");
        } else {
            this.getProperties().remove(COMPRESSED);
        }
    }

    public void setAppAckRequested(boolean bl) {
        if (bl) {
            this.setProperty(APPACKREQUESTED, "true");
        } else {
            this.getProperties().remove(APPACKREQUESTED);
        }
    }

    public void setSender(IDestination iDestination) {
        this.getProperties().put(FROM, iDestination);
    }

    public void setReplyTo(IDestination iDestination) {
        this.getProperties().put(REPLYTO, iDestination);
    }

    public void setDestination(IDestination iDestination) {
        this.getProperties().put(DESTINATION, iDestination);
    }

    public int getPriority() {
        return Integer.parseInt(this.getProperties().getProperty(PRIORITY, DEFAULT_PRIORITY));
    }

    public void setPriority(int n) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("Invalid Priority");
        }
        this.getProperties().put(PRIORITY, String.valueOf(n));
    }

    public abstract byte[] getByteContent() throws HVMException;

    public MessageType getMessageType() {
        return MessageType.fromValue(this.getProperty(MESSAGEFORMAT));
    }

    public void setMessageFormat(MessageType messageType) {
        this.setProperty(MESSAGEFORMAT, messageType.toString());
    }

    public abstract boolean isValid();

    public byte[] getDeflatedByteContent() throws HVMException {
        try {
            byte[] byArray = this.getByteContent();
            if (this.isCompressed()) {
                return Envelope.deflate(byArray);
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new HVMException("Error compressing envelope", iOException);
        }
    }

    public void dumpHeaders(PrintStream printStream) {
        printStream.println("   <header>");
        Iterator<Object> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.properties.get(string).toString();
            printStream.print("      <property name=\"");
            printStream.print(string);
            printStream.print("\">");
            printStream.print(string2);
            printStream.println("</property>");
        }
        printStream.println("   </header>");
    }

    public abstract void dumpBody(PrintStream var1);

    public static Envelope createFromRawData(byte[] byArray, Properties properties) throws HVMException {
        MessageType messageType = MessageType.fromValue(properties.getProperty(MESSAGEFORMAT));
        if (messageType != null) {
            boolean bl = "true".equals(properties.getProperty(COMPRESSED, "false"));
            byte[] byArray2 = byArray;
            if (bl) {
                try {
                    byArray2 = Envelope.inflate(byArray);
                }
                catch (IOException iOException) {
                    throw new HVMException("Compressed data malformed.", iOException);
                }
            }
            return messageType.createEnvelopeFromData(byArray2, properties);
        }
        return null;
    }

    static byte[] inflate(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[1024];
        byte[] byArray3 = new byte[]{};
        int n = inflaterInputStream.read(byArray2, 0, 1024);
        while (n > 0) {
            byte[] byArray4 = byArray3;
            byArray3 = new byte[byArray4.length + n];
            System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
            System.arraycopy(byArray2, 0, byArray3, byArray4.length, n);
            n = inflaterInputStream.read(byArray2, 0, 1024);
        }
        inflaterInputStream.close();
        return byArray3;
    }

    static byte[] deflate(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(9));
        deflaterOutputStream.write(byArray);
        deflaterOutputStream.finish();
        return byteArrayOutputStream.toByteArray();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class UUID {
        private static Random seeder = new SecureRandom();
        private static String fixed = UUID.getFixedPart();

        private UUID() {
        }

        private static String getFixedPart() {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                seeder.setSeed(System.currentTimeMillis());
                InetAddress inetAddress = InetAddress.getLocalHost();
                byte[] byArray = inetAddress.getAddress();
                String string = UUID.hexFormat(UUID.getInt(byArray), 8);
                String string2 = UUID.hexFormat((class$gov$vha$hvm$dsd$envelopes$Envelope$UUID == null ? (class$gov$vha$hvm$dsd$envelopes$Envelope$UUID = Envelope.class$("gov.vha.hvm.dsd.envelopes.Envelope$UUID")) : class$gov$vha$hvm$dsd$envelopes$Envelope$UUID).hashCode(), 8);
                stringBuffer.append("-");
                String string3 = string.substring(0, 4);
                stringBuffer2.append(string3);
                stringBuffer.append(string3);
                stringBuffer.append("-");
                String string4 = string.substring(4);
                stringBuffer2.append(string4);
                stringBuffer.append(string4);
                stringBuffer.append("-");
                String string5 = string2.substring(0, 4);
                stringBuffer2.append(string5);
                stringBuffer.append(string5);
                stringBuffer.append("-");
                String string6 = string2.substring(4);
                stringBuffer2.append(string6);
                stringBuffer.append(string6);
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                return "-UUID-error";
            }
        }

        private static synchronized String getUUID() {
            long l = System.currentTimeMillis();
            int n = (int)l & 0xFFFFFFFF;
            int n2 = seeder.nextInt();
            return UUID.hexFormat(n, 8) + fixed + UUID.hexFormat(n2, 8);
        }

        private static int getInt(byte[] byArray) {
            int n = 0;
            int n2 = 24;
            int n3 = 0;
            while (n2 >= 0) {
                int n4 = byArray[n3] & 0xFF;
                n += n4 << n2;
                n2 -= 8;
                ++n3;
            }
            return n;
        }

        private static String hexFormat(int n, int n2) {
            String string = Integer.toHexString(n);
            return UUID.padHex(string, n2) + string;
        }

        private static String padHex(String string, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            if (string.length() < n) {
                for (int i = 0; i < n - string.length(); ++i) {
                    stringBuffer.append("0");
                }
            }
            return stringBuffer.toString();
        }
    }
}

