/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.envelopes;

import gov.vha.hvm.dsd.envelopes.Base64;
import gov.vha.hvm.dsd.envelopes.Envelope;
import gov.vha.hvm.dsd.envelopes.MessageType;
import java.io.PrintStream;
import java.util.Properties;

public class ByteEnvelope
extends Envelope {
    private byte[] data;

    protected ByteEnvelope(byte[] byArray, Properties properties) {
        super(properties);
        this.data = byArray;
    }

    public static Envelope createFromData(byte[] byArray, Properties properties) {
        ByteEnvelope byteEnvelope = new ByteEnvelope(byArray, properties);
        byteEnvelope.setMessageFormat(MessageType.BYTE);
        return byteEnvelope;
    }

    public boolean isValid() {
        return this.data != null;
    }

    public byte[] getByteContent() {
        return this.data;
    }

    public void dumpBody(PrintStream printStream) {
        printStream.print("\t<body><![CDATA[");
        printStream.print(Base64.encodeBytes(this.getByteContent()));
        printStream.println("]]>\t</body>");
    }
}

