/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.delegates;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v24.message.ACK;
import gov.vha.hvm.dsd.IMessageFactoryService;
import gov.vha.hvm.dsd.envelopes.Envelope;
import gov.vha.hvm.dsd.envelopes.HL7Envelope;
import gov.vha.hvm.dsd.envelopes.MessageType;
import gov.vha.hvm.dsd.exceptions.HVMException;
import gov.vha.hvm.dsd.exceptions.OperationNotSupportedException;
import java.util.Properties;

public class SimpleHapiMessageFactory
implements IMessageFactoryService {
    private static final String HAPIBASE = "ca.uhn.hl7v2.model.v24.message.";

    public Message createMessage(String string) throws HVMException {
        try {
            Class<?> clazz = Class.forName(HAPIBASE + string);
            return (Message)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HVMException("Unknown messagetype: " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new HVMException("Unknown messagetype: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HVMException("Unknown messagetype: " + string);
        }
    }

    public Envelope createAppAckFor(Envelope envelope) throws HVMException {
        MessageType messageType = envelope.getMessageType();
        if (messageType == MessageType.HL7ER7 || messageType == MessageType.HL7XML) {
            return HL7Envelope.createFromMessage((Message)new ACK(), messageType, new Properties());
        }
        throw new OperationNotSupportedException("Currently only implemented for HL7 Messages");
    }
}

