/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd.delegates;

import gov.vha.hvm.dsd.IDestination;
import gov.vha.hvm.dsd.IEndpointLookupService;
import gov.vha.hvm.dsd.IErrorHandler;
import gov.vha.hvm.dsd.IMessageConsumer;
import gov.vha.hvm.dsd.delegates.IDeliveryServiceDelegate;
import gov.vha.hvm.dsd.envelopes.Envelope;
import gov.vha.hvm.dsd.envelopes.ErrorEnvelope;
import gov.vha.hvm.dsd.exceptions.HVMException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class BaseDeliveryServiceDelegate
implements IDeliveryServiceDelegate {
    protected Properties properties = null;
    protected IDestination sender = null;
    protected IErrorHandler errorHandler = null;
    protected List consumers = null;

    public void init(Properties properties) throws HVMException {
        if (properties == null) {
            throw new IllegalArgumentException("Must specify properties to initialize a DeliveryService delegate");
        }
        this.properties = properties;
        if (!properties.containsKey("hvm.dsd.appname")) {
            throw new IllegalArgumentException("All DeliveryService Delegates require the name of the client service in hvm.dsd.appname");
        }
        IEndpointLookupService iEndpointLookupService = this.getEndpointLookupService();
        if (iEndpointLookupService == null) {
            throw new HVMException("Delegate must provide a IEndpointLookupService");
        }
        this.sender = iEndpointLookupService.getDestination(properties.getProperty("hvm.dsd.appname"));
    }

    public void sendMessage(Envelope envelope, IDestination iDestination) throws HVMException {
        if (envelope != null && iDestination != null) {
            envelope.setSender(this.sender);
            envelope.setReplyTo(this.sender);
            envelope.setDestination(iDestination);
            this.deliverMessage(envelope);
        }
    }

    public void sendMessage(Envelope envelope, String string) throws HVMException {
        if (envelope != null && string != null) {
            IDestination iDestination = this.getEndpointLookupService().getDestination(string);
            this.sendMessage(envelope, iDestination);
        }
    }

    protected IDestination getSender() {
        return this.sender;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    public void addMessageConsumer(IMessageConsumer iMessageConsumer) {
        if (iMessageConsumer == null) {
            return;
        }
        if (this.consumers == null) {
            this.consumers = new ArrayList();
        }
        if (!this.consumers.contains(iMessageConsumer)) {
            this.consumers.add(iMessageConsumer);
        }
    }

    public void setErrorHandler(IErrorHandler iErrorHandler) {
        this.errorHandler = iErrorHandler;
    }

    protected void notifyErrorHandlers(ErrorEnvelope errorEnvelope) {
        if (this.errorHandler != null) {
            this.errorHandler.onError(errorEnvelope);
        }
    }

    protected void notifyConsumers(Envelope envelope) {
        if (this.consumers != null) {
            Iterator iterator = this.consumers.iterator();
            while (iterator.hasNext()) {
                try {
                    IMessageConsumer iMessageConsumer = (IMessageConsumer)iterator.next();
                    iMessageConsumer.receiveMessage(envelope);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

