/*
 * Decompiled with CFR 0.152.
 */
package gov.vha.hvm.dsd;

import gov.vha.hvm.dsd.IDeliveryService;
import gov.vha.hvm.dsd.delegates.IDeliveryServiceDelegate;
import gov.vha.hvm.dsd.exceptions.HVMException;
import java.util.HashMap;
import java.util.Properties;

public class DeliveryServiceDelegateFactory {
    private static HashMap instances = new HashMap();
    public static final String IDELIVERYSERVICE_DELEGATECLASS = "gov.vha.hvm.dsd.delegateclass";
    private static final String DEFAULT_DELEGATE_CLASS = "gov.vha.hvm.dsd.delegates.NullDeliveryServiceDelegate";

    public static IDeliveryService getDeliveryService(Properties properties) throws HVMException {
        String string = DeliveryServiceDelegateFactory.getDelegateClassname(properties);
        if (instances.containsKey(string)) {
            return (IDeliveryService)instances.get(string);
        }
        try {
            Class<?> clazz = Class.forName(string);
            IDeliveryServiceDelegate iDeliveryServiceDelegate = (IDeliveryServiceDelegate)clazz.newInstance();
            iDeliveryServiceDelegate.init(properties);
            instances.put(string, iDeliveryServiceDelegate);
            return iDeliveryServiceDelegate;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HVMException("Delegate class not found", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new HVMException("delegate class must have a public default constructor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HVMException("delegate class must have a public default constructor", illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw new HVMException("delegate class must implement the IDeliveryServiceDelegate interface", classCastException);
        }
    }

    private static String getDelegateClassname(Properties properties) {
        String string = System.getProperty(IDELIVERYSERVICE_DELEGATECLASS, DEFAULT_DELEGATE_CLASS);
        if (properties == null) {
            return string;
        }
        return properties.getProperty(IDELIVERYSERVICE_DELEGATECLASS, string);
    }
}

