/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.trigger;

import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.TargetedPersonTriggerEvent;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class PartialPersonTriggerEvent
extends TargetedPersonTriggerEvent {
    private static final long serialVersionUID = -2075833362750026969L;
    private Set keyedEntities = new HashSet();

    public PartialPersonTriggerEvent(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType, CommonTrigger.DispatchType dispatchType, PersonTrigger.DataType dataType) {
        super(destinationType, targetType, dispatchType, dataType);
    }

    public PartialPersonTriggerEvent(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType, CommonTrigger.DispatchType dispatchType, PersonTrigger.DataType dataType, Set entityKeys) {
        this(destinationType, targetType, dispatchType, dataType);
        this.setEntityKeys(entityKeys);
    }

    public Set getEntityKeys() {
        return this.keyedEntities;
    }

    public void addEntityKey(EntityKey key) {
        Validate.notNull((Object)key, (String)"EntityKey is null");
        this.keyedEntities.add(key);
    }

    public void addKeyedEntity(AbstractKeyedEntity keyedEntity) {
        Validate.notNull((Object)keyedEntity, (String)"AbstractKeyedEntity is null");
        EntityKey key = keyedEntity.getEntityKey();
        if (key == null) {
            this.keyedEntities.add(keyedEntity);
        } else {
            this.keyedEntities.add(key);
        }
    }

    public void setEntityKeys(Set entityKeys) {
        Validate.notNull((Object)entityKeys, (String)"entityKeys is null");
        this.keyedEntities = entityKeys;
    }

    @Override
    protected void preTrigger() {
        super.preTrigger();
        if (this.keyedEntities.isEmpty()) {
            return;
        }
        HashSet<EntityKey> keys = new HashSet<EntityKey>(this.keyedEntities.size());
        Iterator itr = this.keyedEntities.iterator();
        Object item = null;
        while (itr.hasNext()) {
            item = itr.next();
            if (item instanceof EntityKey) {
                keys.add((EntityKey)item);
                continue;
            }
            if (item instanceof AbstractKeyedEntity) {
                EntityKey key = ((AbstractKeyedEntity)item).getEntityKey();
                if (key != null) {
                    keys.add(key);
                    continue;
                }
                throw new IllegalStateException("PartialPersonTriggerEvent contains an AbstractKeyedEntity with a null EntityKey");
            }
            throw new IllegalStateException("PartialPersonTriggerEvent contains an item that is not an EntityKey nor is it an instance of AbstractKeyedEntity");
        }
        this.keyedEntities.clear();
        this.keyedEntities.addAll(keys);
    }
}

