/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.ESRRolePrincipalImpl;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.common.rule.service.MergeRuleService;
import gov.va.med.esr.service.UserAdminService;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.esr.service.impl.SecurityServiceImpl;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.security.LDAPService;
import gov.va.med.fw.security.RolePrincipal;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class UserAdminServiceImpl
extends SecurityServiceImpl
implements UserAdminService {
    public static final int CONST_SIGNATURE_CODE_LENGTH = 6;
    private LDAPService ldapService = null;
    private Map historyDAOs;
    private Map rolePermissionMap = null;
    private Map capabilityPermissionMap = null;
    private String ssoEnabled = null;
    private String ssoUsername = null;
    private String ssoLogoffUrl = null;
    private String ssoErrorUrl = null;
    private String encryptionKey = null;
    private String encryptionMethod = null;
    private MergeRuleService mergeRuleService = null;

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public String getSsoEnabled() {
        return this.ssoEnabled;
    }

    public void setSsoEnabled(String ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    @Override
    public String getSsoLogoffUrl() {
        return this.ssoLogoffUrl;
    }

    public void setSsoLogoffUrl(String ssoLogoffUrl) {
        this.ssoLogoffUrl = ssoLogoffUrl;
    }

    @Override
    public String getSsoErrorUrl() {
        return this.ssoErrorUrl;
    }

    public void setSsoErrorUrl(String ssoErrorUrl) {
        this.ssoErrorUrl = ssoErrorUrl;
    }

    @Override
    public String getSsoUsername() {
        return this.ssoUsername;
    }

    public void setSsoUsername(String ssoUsername) {
        this.ssoUsername = ssoUsername;
    }

    @Override
    public boolean isSsoEnforced() {
        return this.ssoEnabled.equalsIgnoreCase("Y");
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(String encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    public LDAPService getLdapService() {
        if (this.ldapService == null) {
            this.ldapService = (LDAPService)this.getApplicationContext().getBean("esrLDAPService");
        }
        return this.ldapService;
    }

    public void setLdapService(LDAPService ldapService) {
        this.ldapService = ldapService;
    }

    public Map getHistoryDAOs() {
        return this.historyDAOs;
    }

    public void setHistoryDAOs(Map historyDAOs) {
        this.historyDAOs = historyDAOs;
    }

    @Override
    public Map getCapabilityPermissionMap() {
        return this.capabilityPermissionMap == null ? new HashMap() : Collections.unmodifiableMap(this.capabilityPermissionMap);
    }

    @Override
    public Map getRolePermissionMap() {
        return this.rolePermissionMap == null ? new HashMap() : Collections.unmodifiableMap(this.rolePermissionMap);
    }

    public void setCapabilityPermissionMap(Map capabilityPermissionMap) {
        this.capabilityPermissionMap = capabilityPermissionMap;
    }

    public void setRolePermissionMap(Map rolePermissionMap) {
        this.rolePermissionMap = rolePermissionMap;
    }

    @Override
    public MergeRuleService getMergeRuleService() {
        return this.mergeRuleService;
    }

    @Override
    public void setMergeRuleService(MergeRuleService mergeRuleService) {
        this.mergeRuleService = mergeRuleService;
    }

    @Override
    public boolean isValidNetworkId(String userName) throws ServiceException {
        return this.getLDAPUserInfo(userName) != null;
    }

    @Override
    public ESRUserPrincipalImpl getLDAPUserInfo(String userName) throws ServiceException {
        return (ESRUserPrincipalImpl)this.getLdapService().getUserInfo(userName);
    }

    @Override
    public ESRUserPrincipalImpl getUserByName(String userName) throws ServiceException {
        return super.getUserByName(userName);
    }

    @Override
    public String encryptPassword(String clearText) throws ServiceException {
        return this.getPasswordEncryptionService().encryptPassword(clearText);
    }

    @Override
    public ESRUserPrincipalImpl updateUserProfile(ESRUserPrincipalImpl user) throws ServiceException {
        try {
            if (user.getEntityKey() != null) {
                ESRUserPrincipalImpl onFileUser = (ESRUserPrincipalImpl)this.getUserById(user.getEntityKey());
                this.ensureEntityChanged((AbstractEntity)user, (AbstractEntity)onFileUser);
                this.getSecurityDAO().evict(onFileUser);
            }
            this.getSecurityDAO().update(user);
        }
        catch (DAOException ex) {
            throw new ServiceException("User Account Update Failed for user" + user.getName(), (Throwable)ex);
        }
        return user;
    }

    @Override
    public ESRUserPrincipalImpl updateUserAccount(ESRUserPrincipalImpl user) throws ServiceException {
        try {
            if (user.getEntityKey() != null) {
                ESRUserPrincipalImpl onFileUser = (ESRUserPrincipalImpl)this.getUserById(user.getEntityKey());
                this.ensureEntityChanged((AbstractEntity)user, (AbstractEntity)onFileUser);
                this.getMergeRuleService().mergeUserAccount(user, onFileUser);
                this.getSecurityDAO().update(onFileUser);
            } else {
                this.getSecurityDAO().update(user);
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("User Account Update Failed for user" + user.getName(), (Throwable)ex);
        }
        return user;
    }

    @Override
    public ESRUserPrincipalImpl addUserAccount(ESRUserPrincipalImpl user) throws ServiceException {
        user.setAgreementSignatureCode(this.generateSignatureAgreementCode());
        user.setSignatureVerified(Boolean.FALSE);
        Date currentDate = this.getCurrentDate();
        user.setPasswordChangeDate(currentDate);
        user.setPasswordCreateDate(currentDate);
        user.setPassword(this.getEncryptedPassword(user.getPassword()));
        return this.updateUserAccount(user);
    }

    @Override
    public List getAllRoles() throws ServiceException {
        try {
            return this.getSecurityDAO().getAllRoles();
        }
        catch (DAOException daoe) {
            throw new ServiceException(" Could not retrive Roles ", (Throwable)daoe);
        }
    }

    @Override
    public List getAllCapabilitySets() throws ServiceException {
        try {
            return this.getSecurityDAO().getAllCapabilitySets();
        }
        catch (DAOException daoe) {
            throw new ServiceException(" Could not retrive CapabilitySets ", (Throwable)daoe);
        }
    }

    @Override
    public List getAllCapabilities() throws ServiceException {
        return this.getLookupService().findAll(Capability.class);
    }

    @Override
    public void addCapabilitySet(CapabilitySet capabilitySet) throws ServiceException {
        this.updateCapabilitySet(capabilitySet);
    }

    @Override
    public void updateCapabilitySet(CapabilitySet capabilitySet) throws ServiceException {
        try {
            if (capabilitySet.getEntityKey() != null) {
                CapabilitySet onFileCapabilitySet = this.getCapabilitySetById(capabilitySet.getEntityKey());
                this.ensureEntityChanged((AbstractEntity)capabilitySet, (AbstractEntity)onFileCapabilitySet);
                this.getSecurityDAO().evict(onFileCapabilitySet);
            }
            this.getSecurityDAO().update(capabilitySet);
        }
        catch (DAOException ex) {
            throw new ServiceException("Update of Capability Set " + capabilitySet.getName() + " Failed", (Throwable)ex);
        }
    }

    @Override
    public void addRole(RolePrincipal role) throws ServiceException {
        this.updateRole(role);
    }

    @Override
    public void updateRole(RolePrincipal role) throws ServiceException {
        try {
            ESRRolePrincipalImpl rolePrincipal;
            if (role instanceof ESRRolePrincipalImpl && (rolePrincipal = (ESRRolePrincipalImpl)role).getEntityKey() != null) {
                ESRRolePrincipalImpl onFileRolePrincipal = (ESRRolePrincipalImpl)this.getRoleById(rolePrincipal.getEntityKey());
                this.ensureEntityChanged((AbstractEntity)rolePrincipal, (AbstractEntity)onFileRolePrincipal);
                this.getSecurityDAO().evict(onFileRolePrincipal);
            }
            this.getSecurityDAO().update(role);
        }
        catch (DAOException ex) {
            throw new ServiceException("Update of Role " + role.getName() + " Failed", (Throwable)ex);
        }
    }

    @Override
    public ESRUserPrincipalImpl findUser(UserPrincipal user) throws ServiceException {
        Validate.notNull((Object)user, (String)"UserPrincipal can not be NULL.");
        try {
            return (ESRUserPrincipalImpl)this.getSecurityDAO().findUser(user);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error while searching the user prpfile Reason: ", (Throwable)ex);
        }
    }

    @Override
    public CapabilitySet getCapabilitySetById(EntityKey entityKey) throws ServiceException {
        return (CapabilitySet)this.getEntityByEntityKey(entityKey);
    }

    @Override
    public CapabilitySet getCapabilitySetByName(String name) throws ServiceException {
        try {
            return this.getSecurityDAO().findCapabilitySetByName(name);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error while searching for CapabilitySet ", (Throwable)ex);
        }
    }

    @Override
    public RolePrincipal getRoleById(EntityKey entityKey) throws ServiceException {
        return (RolePrincipal)this.getEntityByEntityKey(entityKey);
    }

    @Override
    public RolePrincipal getRoleByName(String name) throws ServiceException {
        try {
            return this.getSecurityDAO().findRoleByName(name);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error while searching for Role ", (Throwable)ex);
        }
    }

    @Override
    public void deleteCapabilitySet(CapabilitySet capabilitySet) throws ServiceException {
        this.delete(capabilitySet.getEntityKey());
    }

    @Override
    public void deleteRole(RolePrincipal rolePrincipal) throws ServiceException {
        this.delete(rolePrincipal.getEntityKey());
    }

    @Override
    public Set getHistoryChangeTimes(EntityKey entityKey) throws ServiceException {
        try {
            HistoryDAO historyDAO = this.getHistoryDAO(entityKey.getEntityClass().getName());
            return historyDAO.getHistoryChangeTimes(entityKey);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            HistoryDAO historyDAO = this.getHistoryDAO(event.getEntityKey().getEntityClass().getName());
            return historyDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List findDeletedRoles() throws ServiceException {
        try {
            HistoryDAO historyDAO = this.getHistoryDAO(ESRRolePrincipalImpl.class.getName());
            return historyDAO.getDeletedEntities(ESRRolePrincipalImpl.class);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to retrieve Deleted Roles", (Throwable)e);
        }
    }

    @Override
    public List findDeletedCapabilitySets() throws ServiceException {
        try {
            HistoryDAO historyDAO = this.getHistoryDAO(CapabilitySet.class.getName());
            return historyDAO.getDeletedEntities(CapabilitySet.class);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to retrieve Deleted Capability Sets", (Throwable)e);
        }
    }

    @Override
    public List findAllUsers() throws ServiceException {
        try {
            return this.getSecurityDAO().findAllUsers();
        }
        catch (DAOException e) {
            throw new ServiceException("Fialed to Retrieve User List", (Throwable)e);
        }
    }

    @Override
    public List findUsersByRoleName(String roleName) throws ServiceException {
        try {
            return this.getSecurityDAO().findUsersByRoleName(roleName);
        }
        catch (DAOException e) {
            throw new ServiceException("Fialed to Retrieve User List By role name", (Throwable)e);
        }
    }

    @Override
    public ESRUserPrincipalImpl findUserByName(String userName) throws ServiceException {
        try {
            return (ESRUserPrincipalImpl)this.getSecurityDAO().findUserByUsername(userName);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error while searching the user " + userName + " by userName: ", (Throwable)ex);
        }
    }

    @Override
    public List findUsersByCapabilityCode(String capabilityCode) throws ServiceException {
        try {
            return this.getSecurityDAO().findUsersByCapabilityCode(capabilityCode);
        }
        catch (DAOException e) {
            throw new ServiceException("Fialed to Retrieve User List By Capability name", (Throwable)e);
        }
    }

    @Override
    public Lookup getByCode(String userName) throws ServiceException {
        try {
            return this.getSecurityDAO().getByCode(userName);
        }
        catch (DAOException e) {
            throw new ServiceException("Fialed to Retrieve Users List", (Throwable)e);
        }
    }

    @Override
    public Lookup getByFullname(String userName) throws ServiceException {
        try {
            return this.getSecurityDAO().getByFullname(userName);
        }
        catch (DAOException e) {
            throw new ServiceException("Fialed to Retrieve Users List", (Throwable)e);
        }
    }

    @Override
    public List findUsersByFunctionalGroup(FunctionalGroup functionalGroup) throws ServiceException {
        try {
            return this.getSecurityDAO().findUsersByFunctionalGroup(functionalGroup);
        }
        catch (DAOException e) {
            throw new ServiceException("Fialed to Retrieve Users List", (Throwable)e);
        }
    }

    @Override
    public List findUsersByRoleAndFunctionalGroup(FunctionalGroup functionalGroup, String roleName) throws ServiceException {
        try {
            return this.getSecurityDAO().findUsersByRoleAndFunctionalGroup(functionalGroup, roleName);
        }
        catch (DAOException e) {
            throw new ServiceException("Fialed to Retrieve Users List", (Throwable)e);
        }
    }

    private void delete(EntityKey entityKey) throws ServiceException {
        Validate.notNull((Object)entityKey.getKeyValue(), (String)"Entity Key Value can not be NULL");
        Validate.notNull((Object)entityKey.getEntityClass(), (String)"Entity Class can not be NULL");
        try {
            this.getSecurityDAO().removeObject(entityKey);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error while retrieving entity of type: " + entityKey.getEntityClass().getName(), (Throwable)ex);
        }
    }

    private Object getEntityByEntityKey(EntityKey entityKey) throws ServiceException {
        Validate.notNull((Object)entityKey.getKeyValue(), (String)"Entity Key Value can not be NULL");
        Validate.notNull((Object)entityKey.getEntityClass(), (String)"Entity Class can not be NULL");
        try {
            return this.getSecurityDAO().getByKey(entityKey);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error while retrieving entity of type: " + entityKey.getEntityClass().getName(), (Throwable)ex);
        }
    }

    private String getEncryptedPassword(String clearTextPassword) {
        return clearTextPassword;
    }

    protected String generateSignatureAgreementCode() {
        byte[] randomDigits = new byte[6];
        SecureRandom secureRandom = new SecureRandom();
        for (int i = 0; i < 6; ++i) {
            randomDigits[i] = (byte)(secureRandom.nextInt(10) + 48);
        }
        return new String(randomDigits);
    }

    private HistoryDAO getHistoryDAO(String entityClassName) {
        return (HistoryDAO)this.getHistoryDAOs().get(entityClassName);
    }
}

