/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.DayOfMonth;
import gov.va.med.esr.common.model.lookup.DayOfQuarter;
import gov.va.med.esr.common.model.lookup.DayOfWeek;
import gov.va.med.esr.common.model.lookup.ReportPeriodType;
import gov.va.med.esr.common.model.lookup.ReportRunFrequency;
import gov.va.med.esr.common.model.lookup.ReportScheduleType;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.lookup.SystemParameterUnit;
import gov.va.med.esr.common.model.lookup.WeekOfMonth;
import gov.va.med.esr.common.model.report.CompletedReport;
import gov.va.med.esr.common.model.report.ReportDayOfWeek;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportPeriod;
import gov.va.med.esr.common.model.report.ReportSchedule;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.SimpleCompletedReport;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.esr.common.persistent.report.ReportDAO;
import gov.va.med.esr.common.report.data.CommonExtractFileCriteria;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.ReportFilter;
import gov.va.med.esr.service.StandardReportService;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.NoRecordFoundException;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.report.ReportService;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.scheduling.AuditableScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.scheduling.SchedulingService;
import gov.va.med.fw.security.SecurityService;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.Validate;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class StandardReportServiceImpl
extends AbstractComponent
implements StandardReportService,
AuditableScheduledProcess {
    public static final String ESR_COMMON_JOBS = "esr.common.jobs";
    public static final String ESR_COMMON_TRIGGERS = "esr.common.triggers";
    public static final String SCHEDULED_JOBS = "scheduledJobs";
    public static final String DEFAULT_AUDIT_NAME = "Job-ScheduledReport";
    public static final List<String> RETIRED_REPORTS = Arrays.asList("P8G 4", "EED 20", "EED 5", "EED 6", "EED 7", "BOS 1", "COR 1", "EED 3", "EED 13", "EED 14", "EED 15", "EED 16", "EED 17", "EED 18", "P8G 1", "P8G 2", "P8G 3", "P8G 4", "FTI 1", "VOA 02", "HBO1", "QM 10", "QM 11", "QM 12", "QM 13", "QM 17", "QM 19", "QM 20", "QM 21", "QM 22", "QM 23", "QM 25", "QM 26", "QM 27", "QM 28", "QM 29", "QM 3", "QM 30", "QM 7", "QM 8", "QM 9");
    private static final String EMPTY_SPACE = " ";
    private static final String PERIOD = ".";
    private static final String QUESTION_MARK = "?";
    private static final long serialVersionUID = 7440299997017245373L;
    private ReportDAO reportDAO = null;
    private ReportService reportService = null;
    private LookupService lookupService = null;
    private SchedulingService schedulingService = null;
    private String scheduledReportJobName = null;
    private SecurityService securityService;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.reportDAO, (String)"A report DAO must be configured");
        Validate.notNull((Object)this.reportService, (String)"A report service must be configured");
        Validate.notNull((Object)this.lookupService, (String)"A lookup service must be configured");
        Validate.notNull((Object)this.schedulingService, (String)"A scheduling service must be configured");
        Validate.notNull((Object)this.securityService, (String)"A securityService must be configured");
    }

    public void setReportDAO(ReportDAO reportDAO) {
        this.reportDAO = reportDAO;
    }

    protected ReportDAO getReportDAO() {
        return this.reportDAO;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public SchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public void setScheduledReportJobName(String scheduledReportJobName) {
        this.scheduledReportJobName = scheduledReportJobName;
    }

    @Override
    public List getStandardReports() throws ServiceException {
        List result = null;
        ArrayList<StandardReport> activeResult = new ArrayList<StandardReport>();
        try {
            result = this.lookupService.getAllStandardReports();
            if (result != null) {
                for (StandardReport stdReport : result) {
                    if (RETIRED_REPORTS.contains(stdReport.getCode())) continue;
                    activeResult.add(stdReport);
                }
            }
        }
        catch (Exception ex) {
            throw new ServiceException((Throwable)ex);
        }
        return activeResult;
    }

    @Override
    public List getStandardReports(UserPrincipal user) throws ServiceException {
        Validate.notNull((Object)user, (String)"A user principal must not be null");
        ArrayList<StandardReport> stdReports = new ArrayList<StandardReport>();
        List all = this.getStandardReports();
        if (all != null) {
            for (StandardReport stdReport : all) {
                if (!this.isUserPermittedToScheduleRunDeleteArchive(user, stdReport)) continue;
                stdReports.add(stdReport);
            }
        }
        return stdReports;
    }

    @Override
    public ReportSetup getReportSetup(EntityKey identifier) throws ServiceException {
        Validate.notNull((Object)identifier, (String)"A user principal must not be null");
        ReportSetup result = null;
        try {
            result = this.reportDAO.getReportSetup(identifier);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a list of report setup with identifier " + identifier.getKeyValueAsString(), (Throwable)e);
        }
        return result;
    }

    @Override
    public void saveReportSetup(ReportSetup reportSetup) throws ServiceException {
        Validate.notNull((Object)((Object)reportSetup), (String)"ReportSetup to save must not be null");
        try {
            this.reportDAO.saveReportSetup(reportSetup);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to save report setup with identifier " + reportSetup.getEntityKey().getKeyValueAsString(), (Throwable)e);
        }
    }

    @Override
    public CompletedReport getCompletedReport(EntityKey identifier) throws ServiceException {
        Validate.notNull((Object)identifier, (String)"A user principal must not be null");
        CompletedReport result = null;
        try {
            result = this.reportDAO.getCompletedReport(identifier);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a list of completed report with identifier " + identifier.getKeyValueAsString(), (Throwable)e);
        }
        return result;
    }

    @Override
    public void saveCompletedReport(CompletedReport completedReport) throws ServiceException {
        Validate.notNull((Object)((Object)completedReport), (String)"CompletedReport to save must not be null");
        try {
            this.reportDAO.saveCompletedReport(completedReport);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to save completed report with identifier " + completedReport.getEntityKey().getKeyValueAsString(), (Throwable)e);
        }
    }

    @Override
    public void generateReport(Map reportData) throws ServiceException {
        if (!reportData.containsKey("reportUser.id") && !reportData.containsKey("reportUser.login")) {
            throw new IllegalArgumentException("Either reportUser.id or reportUser.login is required");
        }
        if (!reportData.containsKey("reportSetup.id")) {
            throw new IllegalArgumentException("reportSetup.id is required");
        }
        UserPrincipal user = null;
        if (reportData.containsKey("reportUser.id")) {
            user = this.securityService.getUserById(CommonEntityKeyFactory.createUserPrincipalEntityKey((String)reportData.get("reportUser.id")));
        } else {
            user = new UserPrincipalImpl((String)reportData.get("reportUser.login"), (String)reportData.get("reportUser.password"));
            if (StringUtils.isBlank((String)user.getUserCredentials().getPassword())) {
                user.getUserCredentials().setAnonymous(true);
            }
        }
        ReportSetup setup = null;
        try {
            setup = this.reportDAO.getReportSetup(CommonEntityKeyFactory.createReportSetupEntityKey((String)reportData.get("reportSetup.id")));
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to retrieve ReportSetup from the database with id: " + reportData.get("reportSetup.id"));
        }
        this.computeScheduleStartEndDates(setup);
        this.generateReport(user, setup);
    }

    private void computeScheduleStartEndDates(ReportSetup setup) throws ServiceException {
        ReportParameterSet paramsSet = setup != null ? setup.getParameterSet() : null;
        ReportSchedule schedule = setup != null ? setup.getSchedule() : null;
        String frequency = schedule != null ? schedule.getRunFrequency().getCode() : "";
        Calendar[] startEndDates = null;
        if (StandardReport.CODE_IV_4.getCode().equals(setup.getReport().getCode())) {
            return;
        }
        if (StandardReport.CODE_QM_10.getCode().equals(setup.getReport().getCode())) {
            ReportPeriod reportPeriod;
            ReportPeriod reportPeriod2 = reportPeriod = paramsSet != null ? paramsSet.getReportPeriod() : null;
            if (reportPeriod == null) {
                reportPeriod = new ReportPeriod();
            }
            if (paramsSet != null) {
                paramsSet.setReportPeriod(reportPeriod);
            }
            try {
                if (ReportRunFrequency.QUARTERLY.getCode().equals(frequency)) {
                    reportPeriod.setType(this.lookupService.getReportPeriodTypeByCode(ReportPeriodType.CODE_QUARTERLY.getCode()));
                } else if (ReportRunFrequency.YEARLY.getCode().equals(frequency)) {
                    reportPeriod.setType(this.lookupService.getReportPeriodTypeByCode(ReportPeriodType.CODE_FISCAL_YEAR.getCode()));
                } else {
                    reportPeriod.setType(this.lookupService.getReportPeriodTypeByCode(ReportPeriodType.CODE_DATE_RANGE.getCode()));
                }
            }
            catch (Exception ex) {
                throw new ServiceException("Unable to set ReportPeriodType for the report ID: " + setup.getReport().getCode());
            }
        }
        if (ReportRunFrequency.DAILY_WEEKLY.getCode().equals(frequency)) {
            startEndDates = DateUtils.getStartEndDateForPreviousWeek((Date)DateUtils.getCurrentDate());
        } else if (ReportRunFrequency.MONTHLY.getCode().equals(frequency)) {
            startEndDates = DateUtils.getStartEndDateForPreviousMonth((Date)DateUtils.getCurrentDate());
        } else if (ReportRunFrequency.QUARTERLY.getCode().equals(frequency)) {
            startEndDates = DateUtils.getStartEndDateForPreviousQuarter((Date)DateUtils.getCurrentDate());
        } else if (ReportRunFrequency.YEARLY.getCode().equals(frequency)) {
            startEndDates = DateUtils.getStartEndDateForPreviousFiscalYear((Date)DateUtils.getCurrentDate());
        }
        if ((StandardReport.CODE_QM_28.getCode().equals(setup.getReport().getCode()) || StandardReport.CODE_QM_29.getCode().equals(setup.getReport().getCode()) || StandardReport.CODE_QM_30.getCode().equals(setup.getReport().getCode())) && startEndDates != null && startEndDates[0] != null) {
            startEndDates[0].setTime(DateUtils.getYesterdayDate());
        }
        if (startEndDates != null && paramsSet != null && startEndDates.length > 1) {
            if (StandardReport.CODE_EED_3.getCode().equals(setup.getReport().getCode())) {
                paramsSet.setAsOfDate(startEndDates[1].getTime());
            } else {
                paramsSet.setFromDate(startEndDates[0].getTime());
                paramsSet.setToDate(startEndDates[1].getTime());
            }
        }
    }

    @Override
    public void generateReport(UserPrincipal user, ReportSetup setup) throws ServiceException {
        Validate.notNull((Object)user, (String)"A user must not be null");
        Validate.notNull((Object)((Object)setup), (String)"A report setup must not be null");
        try {
            ReportConfiguration config = this.getReportConfiguration(user, setup);
            if (config != null && this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Generating Report [" + config.getReportID() + "]"));
            }
            this.reportService.generateReport(config);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to generate a report", (Throwable)e);
        }
    }

    @Override
    public void generateOPPReport(UserPrincipal user, CommonExtractFileCriteria criteria) throws ServiceException {
        Validate.notNull((Object)user, (String)"A user must not be null");
        Validate.notNull((Object)((Object)criteria), (String)"An OPP report criteria must not be null");
        try {
            ReportParameterSet param = new ReportParameterSet();
            param.setFileType(this.lookupService.getReportExportedTypeByCode(ReportExportedType.PDF.getCode()));
            String opp_type = criteria.getReportType().getCode();
            ReportSetup setup = new ReportSetup();
            setup.setReport(this.lookupService.getStandardReportByCode(opp_type));
            setup.setSetupUser(user instanceof ESRUserPrincipal ? (ESRUserPrincipal)user : null);
            setup.setParameterSet(param);
            criteria.setReportSetup(setup);
            criteria.setReportUser(user);
            ReportConfiguration config = this.getReportConfiguration(user, setup, criteria);
            config.setResourceMapping(criteria.getCriteria());
            config.setQueryCriteria((QueryCriteria)criteria);
            this.reportService.generateReport(config);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to generate a report", (Throwable)e);
        }
    }

    @Override
    public void scheduleReport(UserPrincipal user, ReportSetup setup) throws ServiceException {
        Validate.notNull((Object)((Object)setup), (String)"ReportSetup to save must not be null");
        try {
            ReportSchedule schedule = setup.getSchedule();
            ReportScheduleType type = schedule.getScheduleType();
            if (type != null) {
                this.reportDAO.saveReportSetup(setup);
                String schedule_type = schedule.getScheduleType().getCode();
                String frequency = schedule.getRunFrequency().getCode();
                String second = "0";
                String dayOfWeek = null;
                String dayOfMonth = null;
                String month = null;
                String year = "*";
                int hour_val = schedule.getHour();
                String hour = String.valueOf(hour_val == 24 ? 0 : hour_val);
                String minute = String.valueOf(schedule.getMinute());
                if (ReportRunFrequency.DAILY_WEEKLY.getCode().equals(frequency)) {
                    Iterator iterator;
                    Set days = schedule.getDaysOfWeek();
                    Iterator iterator2 = iterator = days != null ? days.iterator() : null;
                    while (iterator != null && iterator.hasNext()) {
                        ReportDayOfWeek dw = (ReportDayOfWeek)iterator.next();
                        if (dayOfWeek == null) {
                            dayOfWeek = DayOfWeek.Code.getByCode(dw.getDayOfWeek().getCode()).getAlias();
                            continue;
                        }
                        dayOfWeek = dayOfWeek + "," + DayOfWeek.Code.getByCode(dw.getDayOfWeek().getCode()).getAlias();
                    }
                } else if (ReportRunFrequency.MONTHLY.getCode().equals(frequency)) {
                    if (ReportScheduleType.DAY_OF_MONTH.getCode().equals(schedule_type)) {
                        dayOfMonth = DayOfMonth.Code.getByCode(schedule.getDayOfMonth().getCode()).getAlias();
                    } else {
                        dayOfWeek = DayOfWeek.Code.getByCode(schedule.getDayOfWeek().getCode()).getAlias() + WeekOfMonth.Code.getByCode(schedule.getWeekOfMonth().getCode()).getAlias();
                    }
                } else if (ReportRunFrequency.QUARTERLY.getCode().equals(frequency)) {
                    DayOfQuarter dq = schedule.getDayOfQuarter();
                    if (DayOfQuarter.CODE_FIRST.getCode().equals(dq.getCode())) {
                        month = "1,4,7,10";
                        dayOfMonth = "1";
                    } else {
                        month = "3,6,9,12";
                        dayOfMonth = "L";
                    }
                } else if (ReportRunFrequency.YEARLY.getCode().equals(frequency)) {
                    if (ReportScheduleType.WEEK_DAY_MONTH.getCode().equals(schedule_type)) {
                        dayOfWeek = DayOfWeek.Code.getByCode(schedule.getDayOfWeek().getCode()).getAlias() + WeekOfMonth.Code.getByCode(schedule.getWeekOfMonth().getCode()).getAlias();
                        month = schedule.getMonth().getCode();
                    } else {
                        month = schedule.getMonth().getCode();
                        dayOfMonth = schedule.getNumericDayOfMonth().toString();
                    }
                } else if (ReportRunFrequency.OTHER.getCode().equals(frequency)) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(schedule.getDateToGenerate());
                    year = String.valueOf(calendar.get(1));
                    month = String.valueOf(calendar.get(2) + 1);
                    dayOfMonth = String.valueOf(calendar.get(5));
                }
                StringBuffer cron = new StringBuffer();
                cron.append(second).append(EMPTY_SPACE).append(minute).append(EMPTY_SPACE).append(hour).append(EMPTY_SPACE).append(dayOfMonth == null ? QUESTION_MARK : dayOfMonth).append(EMPTY_SPACE).append(month == null ? "*" : month).append(EMPTY_SPACE).append(dayOfWeek == null ? QUESTION_MARK : dayOfWeek).append(EMPTY_SPACE).append(year);
                StringBuffer group_name = new StringBuffer(ESR_COMMON_JOBS);
                String name = this.getJobName(setup);
                JobDetail jobDetail = (JobDetail)this.getComponent(this.scheduledReportJobName);
                jobDetail.setName(name);
                jobDetail.setGroup(group_name.toString());
                JobDataMap data = jobDetail.getJobDataMap();
                HashMap<String, String> reportData = new HashMap<String, String>();
                EntityKey userKey = user.getEntityKey();
                if (userKey != null) {
                    reportData.put("reportUser.id", userKey.getKeyValueAsString());
                } else {
                    reportData.put("reportUser.login", user.getUserCredentials().getUserID());
                    reportData.put("reportUser.password", user.getUserCredentials().getPassword());
                }
                reportData.put("reportSetup.id", setup.getEntityKey().getKeyValueAsString());
                data.put("methodArguments", new Object[]{reportData});
                this.schedulingService.getScheduler().addJob(jobDetail, true);
                group_name = new StringBuffer(ESR_COMMON_TRIGGERS);
                CronTrigger trigger = new CronTrigger();
                trigger.setName(name);
                trigger.setGroup(group_name.toString());
                trigger.setJobName(jobDetail.getName());
                trigger.setJobGroup(jobDetail.getGroup());
                trigger.setCronExpression(cron.toString());
                trigger.setStartTime(Calendar.getInstance().getTime());
                trigger.setTimeZone(TimeZone.getDefault());
                Date runtime = this.schedulingService.schedule((Trigger)trigger);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Schedule a report to run at " + runtime + " using cron expression: " + cron.toString()));
                }
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to save report setup", (Throwable)e);
        }
        catch (SchedulerException e) {
            throw new ServiceException("Failed to obtain a schedule report", (Throwable)e);
        }
        catch (ParseException e) {
            throw new ServiceException("Failed to build a schedule's cron expression", (Throwable)e);
        }
    }

    private String getJobName(ReportSetup setup) {
        StringBuffer name = new StringBuffer(SCHEDULED_JOBS);
        name.append(PERIOD).append(setup.getSetupUser().getUserCredentials().getUserID()).append(PERIOD).append(setup.getReport().getCode()).append(PERIOD).append(setup.getEntityKey().getKeyValueAsString());
        return name.toString();
    }

    @Override
    public void cancelScheduledReport(EntityKey identifier, UserPrincipal user) throws NoRecordFoundException, ServiceException {
        Validate.notNull((Object)identifier, (String)"ReportSetup identifier must not be null");
        Validate.notNull((Object)identifier.getKeyValue(), (String)"ReportSetup identifier key can not be null.");
        ReportSetup setup = null;
        try {
            setup = this.reportDAO.getReportSetup(identifier);
            if (setup == null) {
                throw new NoRecordFoundException("ReportSetup does not exist for identifier: " + identifier.getKeyValueAsString());
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get report setup with identifier " + identifier.getKeyValueAsString(), (Throwable)e);
        }
        try {
            if (this.isUserPermittedToScheduleRunDeleteArchive(user, setup.getReport())) {
                this.schedulingService.unschedule(this.getJobName(setup), ESR_COMMON_TRIGGERS);
                this.reportDAO.deleteReportSetup(identifier);
            }
        }
        catch (SchedulerException e) {
            throw new ServiceException("Failed to unschedule triggers for report setup with identifier " + identifier.getKeyValueAsString(), (Throwable)e);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to delete report setup with identifier " + identifier.getKeyValueAsString(), (Throwable)e);
        }
    }

    protected ReportConfiguration getReportConfiguration(UserPrincipal user, ReportSetup setup) throws IOException {
        StandardReportCriteria criteria = new StandardReportCriteria();
        criteria.setReportSetup(setup);
        criteria.setReportUser(user);
        return this.getReportConfiguration(user, setup, criteria);
    }

    protected ReportConfiguration getReportConfiguration(UserPrincipal user, ReportSetup setup, StandardReportCriteria criteria) throws IOException {
        StandardReport report = setup.getReport();
        String id = report.getCode();
        String reportName = StringUtils.deleteWhitespace((String)id);
        ReportParameterSet parameterSet = setup.getParameterSet();
        ReportExportedType type = parameterSet != null ? parameterSet.getFileType() : null;
        ReportExportedType.Code code = type != null ? ReportExportedType.Code.getByCode((String)type.getCode()) : null;
        String formatCode = this.getLookupDesc((Lookup)(parameterSet != null ? parameterSet.getReportFormat() : null));
        String detailBy = this.getLookupDesc((Lookup)(parameterSet != null ? parameterSet.getDetailBy() : null));
        String detailFor = this.getLookupDesc((Lookup)(parameterSet != null ? parameterSet.getDetailFor() : null));
        StringBuffer output = new StringBuffer();
        output.append(id).append("-").append(report.getDescription());
        if (formatCode != null) {
            output.append("-").append(formatCode);
        }
        if (detailBy != null) {
            output.append("-").append(detailBy);
        }
        if (detailFor != null) {
            output.append("-").append(detailFor);
        }
        output.append(PERIOD).append(code != null ? code.getAlias().toLowerCase() : "");
        ReportConfiguration config = new ReportConfiguration(reportName, id, code, StringUtils.deleteWhitespace((String)output.toString()));
        config.setReportTitle("Enrollment System Report - " + reportName + " - " + report.getDescription());
        config.setReportUser(user);
        config.setQueryCriteria((QueryCriteria)criteria);
        config.setResourceMapping(criteria.getCriteria());
        return config;
    }

    private String getLookupDesc(Lookup lookup) {
        return lookup != null ? lookup.getDescription() : null;
    }

    protected boolean isUserPermittedToScheduleRunDeleteArchive(UserPrincipal user, StandardReport report) {
        Set rptCaps;
        Set set = rptCaps = report != null && report.getType() != null ? report.getType().getCapabilities() : null;
        if (rptCaps != null) {
            Iterator capIter = rptCaps.iterator();
            while (capIter.hasNext()) {
                String code = ((Capability)capIter.next()).getCode();
                if ("1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,4212,4219,4221".indexOf(code) == -1 || !user.isPermissionGranted(code)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isUserPermittedToInactivate(UserPrincipal user, SimpleCompletedReport report) {
        if (report.getUser() != null && user.getEntityKey().equals(report.getUser().getEntityKey()) || user.isPermissionGranted(Capability.SYSTEM_ADMINISTRATOR.getCode())) {
            return this.isUserPermittedToScheduleRunDeleteArchive(user, report.getStandardReport());
        }
        return false;
    }

    protected boolean isUserPermittedToDelete(UserPrincipal user, SimpleCompletedReport report) {
        if (report.getUser() != null && user.getEntityKey().equals(report.getUser().getEntityKey()) || user.isPermissionGranted(Capability.SYSTEM_ADMINISTRATOR.getCode()) || report.getInactivatedDate() != null) {
            return this.isUserPermittedToScheduleRunDeleteArchive(user, report.getStandardReport());
        }
        return false;
    }

    protected boolean isUserPermittedToView(UserPrincipal user, StandardReport report) {
        Set rptCaps;
        if (this.isViewCLEARReport(report, user)) {
            return true;
        }
        Set set = rptCaps = report != null && report.getType() != null ? report.getType().getCapabilities() : null;
        if (rptCaps != null) {
            Iterator capIter = rptCaps.iterator();
            while (capIter.hasNext()) {
                String code = ((Capability)capIter.next()).getCode();
                if ("1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,4213,4220,4222".indexOf(code) == -1 || !user.isPermissionGranted(code)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isViewCLEARReport(StandardReport rep, UserPrincipal user) {
        if (rep != null && rep.getType() != null && (StandardReport.CODE_CLR_01.getCode().equals(rep.getCode()) || StandardReport.CODE_CLR_02.getCode().equals(rep.getCode()))) {
            return user.isPermissionGranted(Capability.VIEW_ENROLLMENT_REPORTS.getCode());
        }
        return false;
    }

    @Override
    public SimpleCompletedReport getSimpleCompletedReport(EntityKey identifier) throws ServiceException {
        Validate.notNull((Object)identifier, (String)"SimpleCompletedReport identifier must not be null");
        SimpleCompletedReport result = null;
        try {
            result = this.getReportDAO().getSimpleCompletedReport(identifier);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get a SimpleCompletedReport report with identifier " + identifier.getKeyValueAsString(), (Throwable)e);
        }
        return result;
    }

    @Override
    public void deleteCompletedReport(EntityKey identifier, UserPrincipal user) throws NoRecordFoundException, ServiceException {
        Validate.notNull((Object)identifier, (String)"CompletedReport identifier must not be null");
        Validate.notNull((Object)identifier.getKeyValue(), (String)"CompletedReport identifier key can not be null.");
        SimpleCompletedReport simpleCompletedReport = this.getSimpleCompletedReport(identifier);
        if (simpleCompletedReport == null) {
            throw new NoRecordFoundException("SimpleCompletedReport does not exist for identifier: " + identifier.getKeyValueAsString());
        }
        try {
            if (!this.isUserPermittedToDelete(user, simpleCompletedReport)) {
                throw new ServiceException("User doesn't have permissions to delete a report: " + user.getName());
            }
            this.getReportDAO().deleteCompletedReport(identifier);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to delete SimpleCompletedReport with identifier " + identifier.getKeyValueAsString(), (Throwable)e);
        }
    }

    @Override
    public void inactivateCompletedReport(EntityKey identifier, UserPrincipal user) throws NoRecordFoundException, ServiceException, ReportException {
        Validate.notNull((Object)identifier, (String)"CompletedReport identifier must not be null");
        Validate.notNull((Object)identifier.getKeyValue(), (String)"CompletedReport identifier key can not be null.");
        CompletedReport completedReport = this.getCompletedReport(identifier);
        if (completedReport == null) {
            throw new NoRecordFoundException("CompletedReport does not exist for identifier: " + identifier.getKeyValueAsString());
        }
        if (completedReport.getInactivatedDate() != null) {
            throw new ReportException("This report is an inactive report");
        }
        try {
            if (!this.isUserPermittedToInactivate(user, completedReport)) {
                throw new ServiceException("User doesn't have permissions to inactivate a report:" + user.getName());
            }
            completedReport.setInactivatedDate(new Date());
            this.getReportDAO().saveCompletedReport(completedReport);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to inactivate CompletedReport with identifier " + identifier.getKeyValueAsString(), (Throwable)e);
        }
    }

    @Override
    public int inactivateCompletedReports(String updatedQueryString, String auditInfo, SystemParameter systemParameter) throws ServiceException {
        int noOfRecordsUpdated = 0;
        try {
            Date date = this.getSubtractedDate(systemParameter);
            if (date != null) {
                Date sysDate = new Date();
                Object[] params = new Object[]{sysDate, sysDate, auditInfo, date};
                if (updatedQueryString != null) {
                    noOfRecordsUpdated = this.getReportDAO().bulkUpdate(updatedQueryString, params);
                }
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Error during Inactivate Completed Reports data " + (Object)((Object)e));
        }
        return noOfRecordsUpdated;
    }

    @Override
    public int purgeCompletedReports(String purgeQueryString, String auditInfo, SystemParameter systemParameter) throws ServiceException {
        int noOfRecordsUpdated = 0;
        try {
            Date date = this.getSubtractedDate(systemParameter);
            if (date != null) {
                Object[] params = new Object[]{date};
                if (purgeQueryString != null) {
                    noOfRecordsUpdated = this.getReportDAO().bulkUpdate(purgeQueryString, params);
                }
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Error Purging Completed Reports data " + (Object)((Object)e));
        }
        return noOfRecordsUpdated;
    }

    private Date getSubtractedDate(SystemParameter parameter) {
        if (parameter == null) {
            return null;
        }
        SystemParameterUnit unit = parameter.getUnit();
        Date date = null;
        if (SystemParameterUnit.CODE_DAYS.getCode().equals(unit.getCode())) {
            date = DateUtils.getAddedDate((int)5, (int)(-Integer.parseInt(parameter.getValue())));
        } else if (SystemParameterUnit.CODE_WEEKS.getCode().equals(unit.getCode())) {
            date = DateUtils.getAddedDate((int)4, (int)(-Integer.parseInt(parameter.getValue())));
        } else if (SystemParameterUnit.CODE_MONTHS.getCode().equals(unit.getCode())) {
            date = DateUtils.getAddedDate((int)2, (int)(-Integer.parseInt(parameter.getValue())));
        }
        return date;
    }

    @Override
    public ReportFilter getCompletedReportFilter() throws ServiceException {
        ReportFilter reportFilter = new ReportFilter();
        try {
            reportFilter.setStandardReports(this.getReportDAO().getDistinctStandardReports());
            reportFilter.setReportFileTypes(this.getReportDAO().getDistinctReportExportTypes());
            Map counts = this.getReportDAO().getActiveInactiveReportsCount();
            reportFilter.setActiveReportsCount(counts.containsKey("activeReportsCount") ? (Integer)counts.get("activeReportsCount") : 0);
            reportFilter.setInactiveReportsCount(counts.containsKey("inactiveReportsCount") ? (Integer)counts.get("inactiveReportsCount") : 0);
        }
        catch (DAOException e) {
            throw new ServiceException("Error getting the standard reports " + (Object)((Object)e));
        }
        return reportFilter;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public String getAuditInfo(ScheduledProcessInvocationContext context) {
        return DEFAULT_AUDIT_NAME;
    }
}

