/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.report.ReportSetupLite;
import gov.va.med.esr.service.ReportFilterSearchQueryInfo;
import gov.va.med.esr.service.ScheduledReportService;
import gov.va.med.esr.service.impl.StandardReportServiceImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class ScheduledReportServiceImpl
extends StandardReportServiceImpl
implements ScheduledReportService {
    private static final long serialVersionUID = -6367870366143211518L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List search(SearchQueryInfo searchQueryInfo) throws ServiceException {
        ArrayList<ReportSetupLite> setups = new ArrayList<ReportSetupLite>();
        try {
            ReportFilterSearchQueryInfo searchCriteria = (ReportFilterSearchQueryInfo)searchQueryInfo;
            List rptItems = this.getReportDAO().searchScheduledReports(searchCriteria);
            if (rptItems != null && !rptItems.isEmpty()) {
                for (ReportSetupLite setup : rptItems) {
                    if (setup.getSetupUser() == null) {
                        setups.add(setup);
                        continue;
                    }
                    String triggerName = "scheduledJobs." + setup.getSetupUser().getName() + "." + setup.getReport().getCode() + "." + setup.getEntityKey().getKeyValueAsString();
                    try {
                        Date nextFireTime;
                        Trigger trigger = this.getSchedulingService().getTrigger(triggerName, "esr.common.triggers");
                        Date date = nextFireTime = trigger != null ? trigger.getNextFireTime() : null;
                        if (nextFireTime != null && (searchCriteria.getDateFrom() != null && nextFireTime.before(searchCriteria.getDateFrom()) || searchCriteria.getDateTo() != null && nextFireTime.after(searchCriteria.getDateTo()))) continue;
                        setup.setDateToGenerate(nextFireTime);
                        setups.add(setup);
                    }
                    catch (SchedulerException scEx) {
                        throw new ServiceException("Error getting trigger with Id: " + triggerName, (Throwable)scEx);
                    }
                }
            }
        }
        catch (DAOException e) {
            throw new ServiceException("ScheduledReports Search Failed.  searchQueryInfo: " + searchQueryInfo, (Throwable)e);
        }
        searchQueryInfo.setTotalNumberOfEntries(setups.size());
        return setups;
    }
}

