/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.batchprocess.PCMMImportData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.SourceDesignation;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.person.HealthCareProvider;
import gov.va.med.esr.common.model.person.PatientProviderAssignmentLite;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.PreferredFacilityLite;
import gov.va.med.esr.common.model.person.PreferredFacilityPerson;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.esr.common.persistent.person.HealthCareProviderDAO;
import gov.va.med.esr.common.persistent.person.PreferredFacilityDAO;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.MessageCaseTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.rule.RuleValidationException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StopWatchLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;

public class PreferredFacilityServiceImpl
extends AbstractRuleAwareServiceImpl
implements PreferredFacilityService {
    private PreferredFacilityDAO preferredFacilityDAO = null;
    private HealthCareProviderDAO providerDAO = null;
    private TriggerRouter triggerRouter;
    private boolean nightlyUpdate = false;
    private static final String INPUT_TRANSACTION_TYPE = "D";
    private CommsLogService commsLogService;
    private HandBookService handBookService;

    @Override
    public PreferredFacilityPerson findPreferredFacilityPerson(String dfn, String stationNumber) throws ServiceException {
        StopWatchLogger watch = null;
        if (this.logger.isDebugEnabled() && (watch = new StopWatchLogger(ClassUtils.getShortClassName(this.getClass()) + " findPreferredFacilityPerson")) != null) {
            watch.start();
        }
        PersonIdentityTraits traits = this.getPsDelegateService().getIdentityTraitsWithCompositeCall(dfn, stationNumber);
        VPIDEntityKey vpid = traits.getVpid();
        PreferredFacilityPerson pfPerson = null;
        try {
            pfPerson = this.preferredFacilityDAO.getPreferredFacilityPersonByVPID(vpid);
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to retrieve PreferredFacilityPerson by VPID", (Throwable)e);
        }
        finally {
            if (this.logger.isDebugEnabled() && watch != null) {
                watch.stopAndLog();
            }
        }
        pfPerson.setIdentityTraits(traits);
        return pfPerson;
    }

    @Override
    public PreferredFacilityPerson savePreferredFacilityPerson(PreferredFacilityPerson person) throws ServiceException {
        StopWatchLogger watch = null;
        if (this.logger.isDebugEnabled() && (watch = new StopWatchLogger(ClassUtils.getShortClassName(this.getClass()) + " savePreferredFacilityPerson")) != null) {
            watch.start();
        }
        try {
            this.preferredFacilityDAO.saveObject((Object)person);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to persist a person", (Throwable)e);
        }
        finally {
            if (this.logger.isDebugEnabled() && watch != null) {
                watch.stopAndLog();
            }
        }
        return person;
    }

    @Override
    public void processPCMMData(PCMMImportData incoming) throws ServiceException {
        PreferredFacilityPerson onFilePerson = this.findPreferredFacilityPerson(incoming.getPatientIEN(), incoming.getPatientSta3n());
        if (onFilePerson == null) {
            throw new ServiceException("Person not found for stationNumber = " + incoming.getPatientSta3n() + ", DFN = " + incoming.getPatientIEN());
        }
        boolean pfUpdated = false;
        HealthCareProvider provider = null;
        try {
            HashSet<VAFacility> pristinePFs = new HashSet<VAFacility>(this.getPreferredFacilityLiteSites(onFilePerson));
            VAFacility pristineMostRecentPF = onFilePerson.getMostRecentPreferredFacility();
            if (INPUT_TRANSACTION_TYPE.equals(incoming.getTransactionType())) {
                pfUpdated = this.deleteData(incoming, onFilePerson);
            } else {
                provider = this.addOrUpdateProvider(incoming);
                if (provider != null) {
                    this.getProviderDAO().saveObject((Object)provider);
                }
                this.addOrUpdateAssignment(incoming, onFilePerson, provider);
                pfUpdated = this.addOrUpdatePreferredFacility(incoming, onFilePerson);
            }
            this.setCalculatedMostRecentPreferredFacility(onFilePerson);
            this.savePreferredFacilityPerson(onFilePerson);
            if (this.isNightlyUpdate() && pfUpdated) {
                if (this.isAnyActivePFChanged(pristinePFs, this.getPreferredFacilityLiteSites(onFilePerson))) {
                    this.triggerHandBookInsert(onFilePerson);
                }
                if (this.isMostRecentParentPFChanged(pristineMostRecentPF, onFilePerson.getMostRecentPreferredFacility())) {
                    this.triggerZ11(onFilePerson.getPersonEntityKey(), onFilePerson.getIdentityTraits());
                }
            }
        }
        catch (RuleValidationException ex) {
            this.createAEWorkloadCase(onFilePerson, ex);
        }
        catch (Exception ex1) {
            if (ex1 instanceof ServiceException) {
                throw (ServiceException)((Object)ex1);
            }
            throw new ServiceException((Throwable)ex1);
        }
    }

    private boolean isAnyActivePFChanged(Set pristinePFs, Set resultPFs) throws ServiceException {
        boolean anyPFChanges = false;
        Iterator iter = resultPFs.iterator();
        while (iter.hasNext()) {
            if (pristinePFs.contains(iter.next())) continue;
            return true;
        }
        return anyPFChanges;
    }

    private boolean isMostRecentParentPFChanged(VAFacility pristineMostRecentPF, VAFacility mostRecentPF) throws ServiceException {
        VAFacility pristineParent = this.getPersonService().getParentSite(pristineMostRecentPF);
        VAFacility resultParent = this.getPersonService().getParentSite(mostRecentPF);
        return !(pristineParent == null ? resultParent == null : resultParent != null && pristineParent.getCode().equals(resultParent.getCode()));
    }

    private Set getParentActiveSites(Set preferredFacilities) throws ServiceException {
        Set activePFs = this.getActivePreferredFacilityLites(preferredFacilities);
        HashSet<VAFacility> parentSites = new HashSet<VAFacility>();
        VAFacility facility = null;
        VAFacility parentFacility = null;
        Iterator iter = activePFs.iterator();
        while (iter.hasNext()) {
            facility = ((PreferredFacilityLite)((Object)iter.next())).getFacility();
            parentFacility = this.getPersonService().getParentSite(facility);
            parentSites.add(parentFacility);
        }
        return parentSites;
    }

    @Override
    public void triggerZ11(PersonEntityKey key, PersonIdentityTraits traits) throws ServiceException {
        this.getTriggerRouter().processTriggerEvent(this.getTriggerEvent(key, traits));
    }

    public void triggerHandBookInsert(PreferredFacilityPerson person) throws ServiceException {
        this.getHandBookService().triggerHandBookPFInsert(person.getPersonEntityKey().getKeyValueAsString());
    }

    private HealthCareProvider addOrUpdateProvider(PCMMImportData incoming) throws ServiceException {
        HealthCareProvider onFileProvider = null;
        HealthCareProvider incomingProvider = incoming.getProvider();
        try {
            onFileProvider = this.getProviderDAO().findByPractitionerID(incoming.getPractitionerIENSta3n());
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to find provider by practitionerId: " + incoming.getPractitionerIENSta3n(), (Throwable)ex);
        }
        if (onFileProvider == null) {
            onFileProvider = incomingProvider;
        } else {
            this.getMergeRuleService().mergeHealthCareProvider(incomingProvider, onFileProvider);
        }
        return onFileProvider;
    }

    private boolean addOrUpdateAssignment(PCMMImportData incoming, PreferredFacilityPerson personLite, HealthCareProvider provider) throws ServiceException {
        boolean newPCP = false;
        PatientProviderAssignmentLite onFileAssignment = this.findAssignment(personLite, incoming.getPractitionerIENSta3n(), incoming.getPatientIENSta3n());
        PatientProviderAssignmentLite incomingAssignment = incoming.getProviderAssignment();
        incomingAssignment.setProvider(provider);
        if (onFileAssignment == null) {
            personLite.addProviderAssignment(incomingAssignment);
            newPCP = true;
        } else {
            this.getMergeRuleService().mergeProviderAssignment(incomingAssignment, onFileAssignment);
            newPCP = false;
        }
        return newPCP;
    }

    private boolean addOrUpdatePreferredFacility(PCMMImportData incoming, PreferredFacilityPerson personLite) throws ServiceException {
        boolean facilityUpdated = true;
        Set pfList = personLite.getPreferredFacilities();
        Set activePfs = this.getActivePreferredFacilityLites(pfList);
        if (activePfs.isEmpty()) {
            this.addPreferredFacility(personLite, incoming);
            return facilityUpdated;
        }
        PreferredFacilityLite pf2 = (PreferredFacilityLite)((Object)activePfs.iterator().next());
        SourceDesignation sd = pf2.getSourceDesignation();
        if (SourceDesignation.CODE_VISTA.getCode().equals(sd.getCode()) || SourceDesignation.CODE_ESR.getCode().equals(sd.getCode())) {
            pf2.setUnassignmentDate(new Date());
            this.addPreferredFacility(personLite, incoming);
            return facilityUpdated;
        }
        for (PreferredFacilityLite pf2 : activePfs) {
            if (!SourceDesignation.CODE_PCP_ACTIVE.getCode().equals(pf2.getSourceDesignation().getCode()) || !pf2.getFacility().getStationNumber().equals(incoming.getFacility().getStationNumber())) continue;
            return this.updatePreferredFacility(pf2, incoming);
        }
        this.addPreferredFacility(personLite, incoming);
        return facilityUpdated;
    }

    private boolean updatePreferredFacility(PreferredFacilityLite pf, PCMMImportData incoming) throws ServiceException {
        boolean recordUpdated = false;
        if (!DateUtils.isSameInstant((Date)pf.getAssignmentDate(), (Date)incoming.getAssignmentStartDate()) || !this.datesEqualIncludingNull(pf.getUnassignmentDate(), incoming.getAssignmentEndDate())) {
            pf.setAssignmentDate(incoming.getAssignmentStartDate());
            pf.setUnassignmentDate(incoming.getAssignmentEndDate());
            if (this.isPFActive(pf)) {
                pf.setSourceDesignation(this.getLookupService().getSourceDesignationByCode(SourceDesignation.CODE_PCP_ACTIVE.getCode()));
            } else {
                pf.setSourceDesignation(this.getLookupService().getSourceDesignationByCode(SourceDesignation.CODE_PCP_INACTIVE.getCode()));
            }
            recordUpdated = true;
        }
        return recordUpdated;
    }

    private void addPreferredFacility(PreferredFacilityPerson personLite, PCMMImportData incoming) throws ServiceException {
        PreferredFacilityLite pf = new PreferredFacilityLite();
        pf.setFacility(incoming.getFacility());
        pf.setAssignmentDate(incoming.getAssignmentStartDate());
        pf.setUnassignmentDate(incoming.getAssignmentEndDate());
        String sdCode = null;
        sdCode = this.isPFActive(pf) ? SourceDesignation.CODE_PCP_ACTIVE.getCode() : SourceDesignation.CODE_PCP_INACTIVE.getCode();
        pf.setSourceDesignation(this.getLookupService().getSourceDesignationByCode(sdCode));
        personLite.addPreferredFacility(pf);
    }

    private boolean deleteData(PCMMImportData incoming, PreferredFacilityPerson personLite) throws RuleValidationException, ServiceException {
        PatientProviderAssignmentLite assignment = this.findAssignment(personLite, incoming.getPractitionerIENSta3n(), incoming.getPatientIENSta3n());
        if (assignment != null) {
            personLite.removeProviderAssignment(assignment);
        }
        return this.deletePreferredFacility(personLite, incoming);
    }

    private boolean hasOtherPCPsAtFacility(PreferredFacilityPerson personLite, VAFacility facilityToDelete) {
        Set assginmentList = personLite.getProviderAssignments();
        for (PatientProviderAssignmentLite assignment : assginmentList) {
            if (!assignment.getFacility().getStationNumber().equals(facilityToDelete.getStationNumber())) continue;
            return true;
        }
        return false;
    }

    private boolean deletePreferredFacility(PreferredFacilityPerson personLite, PCMMImportData incoming) throws RuleValidationException {
        boolean pfDeleted = false;
        if (!this.hasOtherPCPsAtFacility(personLite, incoming.getFacility())) {
            Set personPfList = personLite.getPreferredFacilities();
            PreferredFacilityLite pf2 = null;
            for (PreferredFacilityLite pf2 : personPfList) {
                if (!pf2.getFacility().getStationNumber().equals(incoming.getFacility().getStationNumber())) continue;
                if (personPfList.size() == 1) {
                    throw new RuleValidationException("Cannot delete preferred facility " + incoming.getFacility().getStationNumber() + " for person " + personLite.getVPIDEntityKey().getKeyValueAsString() + ".  Person need to have at least one preferred facility.");
                }
                if (!SourceDesignation.CODE_PCP_ACTIVE.getCode().equals(pf2.getSourceDesignation().getCode()) && !SourceDesignation.CODE_PCP_INACTIVE.getCode().equals(pf2.getSourceDesignation().getCode())) continue;
                personLite.removePreferredFacility(pf2);
                pfDeleted = true;
                break;
            }
        }
        return pfDeleted;
    }

    private boolean datesEqualIncludingNull(Date date1, Date date2) {
        return date1 == null && date2 == null || date1 != null && date2 != null && DateUtils.isSameInstant((Date)date1, (Date)date2);
    }

    private PatientProviderAssignmentLite findAssignment(PreferredFacilityPerson personLite, String practionerId, String patientId) throws ServiceException {
        PatientProviderAssignmentLite assignment2 = null;
        for (PatientProviderAssignmentLite assignment2 : personLite.getProviderAssignments()) {
            if (!assignment2.getProvider().getPractitionerId().equals(practionerId)) continue;
            if (assignment2.getPatientId() != null && !assignment2.getPatientId().equals(patientId)) {
                throw new ServiceException("Found assignment with matching practitionerId, but patient Id mismatches.");
            }
            return assignment2;
        }
        return null;
    }

    private Set getActivePreferredFacilityLites(Set pfList) throws ServiceException {
        HashSet<PreferredFacilityLite> activePfs = new HashSet<PreferredFacilityLite>();
        PreferredFacilityLite pf2 = null;
        for (PreferredFacilityLite pf2 : pfList) {
            if (!this.isPFActive(pf2)) continue;
            activePfs.add(pf2);
        }
        return activePfs;
    }

    @Override
    public boolean hasActivePreferredFacility(Set pfList) throws ServiceException {
        for (PreferredFacilityLite pf : pfList) {
            if (!this.isPFActive(pf)) continue;
            return true;
        }
        return false;
    }

    public boolean isPFActive(PreferredFacilityLite pf) {
        Date currentDate = DateUtils.getCurrentDateTime();
        return pf.getUnassignmentDate() == null || pf.getUnassignmentDate().after(currentDate);
    }

    private TriggerEvent getTriggerEvent(PersonEntityKey key, PersonIdentityTraits traits) {
        PersonTriggerEvent triggerEvent = new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ELIGIBILITY);
        triggerEvent.setPersonId(key);
        triggerEvent.setIdentityTraits(traits);
        return triggerEvent;
    }

    public PreferredFacilityDAO getPreferredFacilityDAO() {
        return this.preferredFacilityDAO;
    }

    public void setPreferredFacilityDAO(PreferredFacilityDAO preferredFacilityDAO) {
        this.preferredFacilityDAO = preferredFacilityDAO;
    }

    public HealthCareProviderDAO getProviderDAO() {
        return this.providerDAO;
    }

    public void setProviderDAO(HealthCareProviderDAO providerDAO) {
        this.providerDAO = providerDAO;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    public boolean isNightlyUpdate() {
        return this.nightlyUpdate;
    }

    public void setNightlyUpdate(boolean nightlyUpdate) {
        this.nightlyUpdate = nightlyUpdate;
    }

    @Override
    public PreferredFacility getMostRecentPreferredFacility(Person person) {
        PreferredFacility mostRecent = null;
        Set pfList = person.getPreferredFacilities();
        for (PreferredFacility next : pfList) {
            if (!this.isMoreRecent(next, mostRecent)) continue;
            mostRecent = next;
        }
        return mostRecent;
    }

    private boolean isMoreRecent(PreferredFacilityLite next, PreferredFacilityLite mostRecent) {
        if (mostRecent == null) {
            return true;
        }
        boolean isMoreRecent = false;
        if (!this.isPFActive(mostRecent)) {
            if (this.isPFActive(next)) {
                isMoreRecent = true;
            } else if (next.getUnassignmentDate().after(mostRecent.getUnassignmentDate())) {
                isMoreRecent = true;
            }
        } else if (this.isPFActive(next) && next.getAssignmentDate().after(mostRecent.getAssignmentDate())) {
            isMoreRecent = true;
        }
        return isMoreRecent;
    }

    @Override
    public boolean hasPCPActiveOrESRPF(Person person) {
        Set pfList = person.getPreferredFacilities();
        for (PreferredFacility pf : pfList) {
            if (!this.isPFActive(pf) || !pf.getSourceDesignation().getCode().equals(SourceDesignation.CODE_PCP_ACTIVE.getCode()) && !pf.getSourceDesignation().getCode().equals(SourceDesignation.CODE_ESR.getCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPCPActivePF(Person person) {
        Set pfList = person.getPreferredFacilities();
        for (PreferredFacility pf : pfList) {
            if (!this.isPFActive(pf) || !pf.getSourceDesignation().getCode().equals(SourceDesignation.CODE_PCP_ACTIVE.getCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasVistaOrPCPInactivePF(Person person) {
        Set pfList = person.getPreferredFacilities();
        for (PreferredFacility pf : pfList) {
            if (!this.isPFActive(pf) || !pf.getSourceDesignation().getCode().equals(SourceDesignation.CODE_PCP_INACTIVE.getCode()) && !pf.getSourceDesignation().getCode().equals(SourceDesignation.CODE_VISTA.getCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public PreferredFacility getPreferredFacilityFromVista(Person person) {
        Set pfList = person.getPreferredFacilities();
        for (PreferredFacility pf : pfList) {
            if (!this.isPFActive(pf) || !pf.getSourceDesignation().getCode().equals(SourceDesignation.CODE_VISTA.getCode())) continue;
            return pf;
        }
        return null;
    }

    @Override
    public PreferredFacility getPreferredFacilityFromES(Person person) {
        Set pfList = person.getPreferredFacilities();
        for (PreferredFacility pf : pfList) {
            if (!this.isPFActive(pf) || !pf.getSourceDesignation().getCode().equals(SourceDesignation.CODE_ESR.getCode())) continue;
            return pf;
        }
        return null;
    }

    @Override
    public List getDisplayPreferredFacilities(Person person) {
        ArrayList<PreferredFacility> displayList = new ArrayList<PreferredFacility>();
        HashSet<PreferredFacility> activePCPPfs = new HashSet<PreferredFacility>();
        HashSet<PreferredFacility> activeOtherPfs = new HashSet<PreferredFacility>();
        PreferredFacility next2 = null;
        for (PreferredFacility next2 : person.getPreferredFacilities()) {
            if (!this.isPFActive(next2)) continue;
            if (next2.getSourceDesignation().getCode().equals(SourceDesignation.CODE_PCP_ACTIVE.getCode())) {
                activePCPPfs.add(next2);
                continue;
            }
            activeOtherPfs.add(next2);
        }
        if (!activePCPPfs.isEmpty()) {
            return new ArrayList(activePCPPfs);
        }
        PreferredFacility pf = null;
        if (!activeOtherPfs.isEmpty()) {
            for (PreferredFacility next2 : activeOtherPfs) {
                if (next2.getSourceDesignation().getCode().equals(SourceDesignation.CODE_ESR.getCode())) {
                    pf = next2;
                    continue;
                }
                if (!next2.getSourceDesignation().getCode().equals(SourceDesignation.CODE_VISTA.getCode()) || pf != null) continue;
                pf = next2;
            }
        }
        if (pf != null) {
            displayList.add(pf);
        } else {
            PreferredFacility mostRecent = this.getMostRecentPreferredFacility(person);
            if (mostRecent != null) {
                displayList.add(mostRecent);
            }
        }
        return displayList;
    }

    @Override
    public void addPreferredFacility(PreferredFacility incoming, Person onfilePerson, String sdCode) throws ServiceException {
        if (incoming != null) {
            PreferredFacility newPf = new PreferredFacility();
            newPf.setFacility(incoming.getFacility());
            newPf.setAssignmentDate(new Date());
            newPf.setUnassignmentDate(null);
            newPf.setSourceDesignation(this.getLookupService().getSourceDesignationByCode(sdCode));
            onfilePerson.addPreferredFacility(newPf);
        }
    }

    @Override
    public void setCalculatedMostRecentPreferredFacility(Person person) {
        PreferredFacility mostRecentPF = this.getMostRecentPreferredFacility(person);
        person.setMostRecentPreferredFacility(mostRecentPF == null ? null : mostRecentPF.getFacility());
    }

    private void setCalculatedMostRecentPreferredFacility(PreferredFacilityPerson personLite) {
        Set pfList = personLite.getPreferredFacilities();
        PreferredFacilityLite next2 = null;
        PreferredFacilityLite mostRecent = null;
        for (PreferredFacilityLite next2 : pfList) {
            if (!this.isMoreRecent(next2, mostRecent)) continue;
            mostRecent = next2;
        }
        personLite.setMostRecentPreferredFacility(mostRecent == null ? null : mostRecent.getFacility());
    }

    @Override
    public Set getActivePreferredFacilities(Set pfList) throws ServiceException {
        HashSet<PreferredFacility> activePfs = new HashSet<PreferredFacility>();
        PreferredFacility pf2 = null;
        for (PreferredFacility pf2 : pfList) {
            if (!this.isPFActive(pf2)) continue;
            activePfs.add(pf2);
        }
        return activePfs;
    }

    public Set getActivePreferredFacilitiesLite(Set pfList) throws ServiceException {
        HashSet<PreferredFacilityLite> activePfs = new HashSet<PreferredFacilityLite>();
        PreferredFacilityLite pf2 = null;
        for (PreferredFacilityLite pf2 : pfList) {
            if (!this.isPFActive(pf2)) continue;
            activePfs.add(pf2);
        }
        return activePfs;
    }

    private void createAEWorkloadCase(PreferredFacilityPerson p, RuleValidationException ex) throws ServiceException {
        WorkflowCaseInfo caseInfo = new WorkflowCaseInfo();
        FunctionalGroup caseGroup = this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.DQ.getCode());
        caseInfo.setGroupType(caseGroup);
        caseInfo.setCaseType(this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_APPLICATION_EXCEPTION.getCode()));
        caseInfo.setErrorMessage("PF assignment error, ESR user needs to determine appropriate PF. " + ex.getMessage());
        PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(p.getPersonEntityKey().getKeyValueAsString());
        caseInfo.setPersonEntityKey(personKey);
        this.createWorkloadCase(caseInfo, personKey);
    }

    private void createWorkloadCase(WorkflowCaseInfo caseInfo, PersonIdEntityKey personKey) throws ServiceException {
        MessageCaseTriggerEvent messageCaseTriggerEvent = new MessageCaseTriggerEvent();
        messageCaseTriggerEvent.setWorkflowCaseInfo(caseInfo);
        messageCaseTriggerEvent.setPersonId(personKey);
        this.triggerRouter.processTriggerEvent((TriggerEvent)messageCaseTriggerEvent);
    }

    public CommsLogService getCommsLogService() {
        return this.commsLogService;
    }

    public void setCommsLogService(CommsLogService commsLogService) {
        this.commsLogService = commsLogService;
    }

    public HandBookService getHandBookService() {
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }

    @Override
    public List getChildVAFacility(List parentIds) throws UnknownLookupTypeException, UnknownLookupCodeException {
        try {
            return this.getPreferredFacilityDAO().getChildVaFacility(parentIds);
        }
        catch (DAOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<VAFacility> getPreferredFacilitySites(Person person) throws ServiceException {
        Set pfList = person.getPreferredFacilities();
        Set activePfs = this.getActivePreferredFacilities(pfList);
        HashSet<VAFacility> pfSites = new HashSet<VAFacility>();
        ArrayList pfs = new ArrayList();
        if (!activePfs.isEmpty()) {
            pfs.addAll(activePfs);
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    PreferredFacility pf1 = (PreferredFacility)((Object)o1);
                    PreferredFacility pf2 = (PreferredFacility)((Object)o2);
                    if (pf1 == null || pf1.getAssignmentDate() == null) {
                        return -1;
                    }
                    if (pf2 == null || pf2.getAssignmentDate() == null) {
                        return 1;
                    }
                    return pf2.getAssignmentDate().compareTo(pf1.getAssignmentDate());
                }
            };
            Collections.sort(pfs, comparator);
            List first3pfsList = pfs.subList(0, Math.min(3, pfs.size()));
            for (PreferredFacility pf : first3pfsList) {
                pfSites.add(pf.getFacility());
            }
        } else if (person.getMostRecentPreferredFacility() != null) {
            pfSites.add(person.getMostRecentPreferredFacility());
        }
        return pfSites;
    }

    public Set<VAFacility> getPreferredFacilityLiteSites(PreferredFacilityPerson person) throws ServiceException {
        Set pfList = person.getPreferredFacilities();
        Set activePfs = this.getActivePreferredFacilitiesLite(pfList);
        HashSet<VAFacility> pfSites = new HashSet<VAFacility>();
        if (!activePfs.isEmpty()) {
            for (PreferredFacilityLite pf : activePfs) {
                pfSites.add(pf.getFacility());
            }
        } else if (person.getMostRecentPreferredFacility() != null) {
            pfSites.add(person.getMostRecentPreferredFacility());
        }
        return pfSites;
    }

    @Override
    public Set<VAFacility> getPFSites(Person person) throws ServiceException {
        Set pfList = person.getPreferredFacilities();
        Set activePfs = this.getActivePreferredFacilities(pfList);
        HashSet<VAFacility> pfSites = new HashSet<VAFacility>();
        if (!activePfs.isEmpty()) {
            for (PreferredFacility pf : activePfs) {
                pfSites.add(pf.getFacility());
            }
        } else if (person.getMostRecentPreferredFacility() != null) {
            pfSites.add(person.getMostRecentPreferredFacility());
        }
        return pfSites;
    }
}

