/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.batchprocess.AppointmentConversionResult;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.FullyQualifiedIdentity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonChangeLogEntry;
import gov.va.med.esr.common.model.person.PersonLockedReason;
import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.common.model.person.PersonUnmergeInfo;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.PreferredFacilityLite;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.esr.common.persistent.messaging.MessageLogEntryDAO;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.common.rule.service.EventRuleService;
import gov.va.med.esr.common.rule.service.MergeRuleService;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.EEResult;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.IdmServiceVO;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonLockedException;
import gov.va.med.esr.service.PersonMergeService;
import gov.va.med.esr.service.PersonSearchQueryInfo;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.PersonUnmergeService;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.esr.service.WorkflowService;
import gov.va.med.esr.service.external.person.PersonLinkInfo;
import gov.va.med.esr.service.external.person.PersonMoveInfo;
import gov.va.med.esr.service.external.person.PersonPrimaryViewInfo;
import gov.va.med.esr.service.impl.IdMSearchInfo;
import gov.va.med.esr.service.impl.IdmWebServiceDelegate;
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.NoRecordFoundException;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.service.TimeoutServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.service.transaction.TransactionTimestampManager;
import gov.va.med.fw.util.Reflector;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.TimeoutException;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.person.idmgmt.types.MultipleBirthIndicator;
import gov.va.med.ps.model.PatientIdentifier;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.Validate;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataIntegrityViolationException;

public class PersonServiceImpl
extends AbstractComponent
implements PersonService {
    private static final long serialVersionUID = 4813254511062147264L;
    public static final String ACTIVE_DUTY = "1";
    public static final String ALLIED_VETERAN = "2";
    public static final String COLLATERAL = "3";
    public static final String EMPLOYEE = "4";
    public static final String MILITARY_RETIREE = "5";
    public static final String NON_VETERAN_CODE = "6";
    public static final String NSC_VETERAN_CODE = "7";
    public static final String SC_VETERAN_CODE = "8";
    public static final String TRICARE = "9";
    private PersonDAO personDAO = null;
    private TransactionTimestampManager timestampManager;
    private String personMergeServiceName = null;
    private PersonMergeService personMergeService = null;
    private String personUnmergeServiceName = null;
    private PersonUnmergeService personUnmergeService = null;
    private LookupService lookupService = null;
    private PSDelegateService psDelegateService = null;
    private PersonHelperService helperService = null;
    private MessageLogEntryDAO messageLogEntryDAO = null;
    private Builder siteDataBuilder = null;
    private String eligibilityEnrollmentServiceName = null;
    private String eventRuleServiceName = null;
    private String mergeRuleServiceName = null;
    private IdmWebServiceDelegate idmServiceDelegate = null;
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;
    private EventRuleService eventRuleService = null;
    private MergeRuleService mergeRuleService = null;
    private RegistryService registryService = null;
    private DemographicService demographicService;
    private WorkflowService workflowService = null;
    private String registryServiceName = null;
    private boolean isDataClean = true;
    private boolean isUpdateIdentityTraits = true;

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.personMergeServiceName, (String)"Missing required personMergeServiceName");
        Validate.notNull((Object)this.personUnmergeServiceName, (String)"Missing required personUnmergeServiceName");
        Validate.notNull((Object)this.lookupService, (String)"Missing required lookup service");
        Validate.notNull((Object)this.personDAO, (String)"Missing required person DAO");
        Validate.notNull((Object)this.psDelegateService, (String)"Missing required PSDelegateService");
        Validate.notNull((Object)this.mergeRuleServiceName);
        Validate.notNull((Object)this.eligibilityEnrollmentServiceName);
        Validate.notNull((Object)this.eventRuleServiceName);
        Validate.notNull((Object)this.registryServiceName);
        Validate.notNull((Object)this.siteDataBuilder);
        Validate.notNull((Object)this.timestampManager, (String)"A timestampManager is required");
        Validate.notNull((Object)this.helperService);
    }

    @Override
    public Person save(Person incomingPerson) throws ServiceException {
        return this.save(incomingPerson, false);
    }

    @Override
    public Person save(Person incomingPerson, boolean overrideLocking) throws ServiceException {
        try {
            Validate.notNull((Object)((Object)incomingPerson), (String)"A person input must not be null.");
            boolean isNewPerson = false;
            if (incomingPerson.getPersonEntityKey() == null || incomingPerson.isJustAdded()) {
                isNewPerson = true;
            }
            if (!isNewPerson && !overrideLocking) {
                PersonLockedReason lockedReason;
                PersonIdentityTraits onFileTraits = incomingPerson.getIdentityTraits();
                if (onFileTraits == null) {
                    this.psDelegateService.getIdentityTraits(incomingPerson.getVPIDEntityKey());
                }
                if ((lockedReason = this.getPersonLockedReason(incomingPerson, onFileTraits)) != null) {
                    throw new PersonLockedException(lockedReason);
                }
            }
            this.personDAO.saveObject((Object)incomingPerson);
            return incomingPerson;
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to persist a person", (Throwable)e);
        }
    }

    @Override
    public void logChanges(Set personChangeLogEntries) throws ServiceException {
        Iterator itr = personChangeLogEntries != null ? personChangeLogEntries.iterator() : null;
        PersonChangeLogEntry log = null;
        try {
            while (itr != null && itr.hasNext()) {
                log = (PersonChangeLogEntry)((Object)itr.next());
                log.setSubmittedDate(this.timestampManager.getTransactionTimestamp());
                this.personDAO.saveObject((Object)log);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to persist PersonChangeLogEntry(s)", (Throwable)e);
        }
    }

    @Override
    public Person find(PersonIdentityTraits traits) throws ServiceException {
        VPIDEntityKey key = traits.getVpid();
        if (key == null) {
            Set results = null;
            results = traits.containsOnlySSN() ? this.psDelegateService.attendedSearch(traits, false) : this.psDelegateService.unattendedSearch(traits);
            if (results == null || results.size() == 0) {
                throw new NoRecordFoundException("PSIM search found zero records");
            }
            if (results.size() > 1) {
                throw new MaxRecordsExceededException(1, "Unable to retrieve a singular exact match from Idm Web Service for unattended search");
            }
            PersonIdentityTraits exactMatch = (PersonIdentityTraits)((Object)results.iterator().next());
            return this.doGetPerson(exactMatch.getVpid(), exactMatch, false);
        }
        return this.doGetPerson(key, traits, false);
    }

    @Override
    public VPIDEntityKey findVPIDOnly(PersonIdentityTraits traits) throws ServiceException {
        Set results = null;
        results = traits.containsOnlySSN() ? this.psDelegateService.attendedSearch(traits, false) : this.psDelegateService.unattendedSearch(traits);
        if (results.size() > 1) {
            throw new MaxRecordsExceededException(1, "Unable to retrieve a singular exact match from PSIM for unattended search");
        }
        if (results.size() == 0) {
            throw new NoRecordFoundException("PSIM search found zero records");
        }
        PersonIdentityTraits exactMatch = (PersonIdentityTraits)((Object)results.iterator().next());
        return exactMatch.getVpid();
    }

    @Override
    public Person getPerson(PersonEntityKey personID) throws ServiceException {
        return this.getPerson(personID, null);
    }

    @Override
    public Person getPerson(PersonEntityKey personID, PersonIdentityTraits traits) throws ServiceException {
        Validate.notNull((Object)personID, (String)"Null PersonEntityKey");
        try {
            Object[] params = null;
            params = traits == null ? new Object[]{personID} : new Object[]{personID, traits, false};
            Person person = (Person)((Object)Reflector.invoke((Object)this, (String)"doGetPerson", (Object[])params));
            if (personID.getVersion() != null && !personID.getVersion().equals(person.getVersion())) {
                throw new ServiceOptimisticLockException("Version number specified in PersonEntityKey does not match on file Person", null, (AbstractKeyedEntity)person);
            }
            return person;
        }
        catch (ServiceOptimisticLockException ole) {
            throw ole;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to retrieve Person", (Throwable)e);
        }
    }

    @Override
    public Person getPersonWithoutIdentityTraits(PersonEntityKey personID) throws ServiceException {
        Person person = null;
        try {
            person = this.personDAO.getByVPID((VPIDEntityKey)personID);
            if (person == null) {
                this.verifyAddStubRecord((VPIDEntityKey)personID, true);
                person = this.personDAO.getByVPID((VPIDEntityKey)personID);
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to getPerson by pk. Invalid personId.", (Throwable)ex);
        }
        catch (IllegalArgumentException iae) {
            throw new ServiceException("Invalid VPID", (Throwable)iae);
        }
        return person;
    }

    public Person doGetPerson(PersonIdEntityKey key) throws ServiceException {
        return this.doGetPerson(key, null, false);
    }

    @Override
    public Person get200ESRPerson(PersonEntityKey key) throws ServiceException {
        Person p = null;
        try {
            p = (Person)((Object)this.personDAO.getByKey((EntityKey)key));
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to getPerson by pk", (Throwable)ex);
        }
        if (p != null) {
            PersonIdentityTraits esrTraits = this.getESRCorrelation(p.getVPIDEntityKey());
            this.overlayIdentityTraits(p, esrTraits);
            p.setPersonLockedReason(this.getPersonLockedReason(p, esrTraits));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("PersonServiceImpl get200eSRPerson : person: " + (Object)((Object)p)));
            }
        }
        return p;
    }

    public Person doGetPerson(PersonIdEntityKey key, PersonIdentityTraits identityTraits, boolean compositeCall) throws ServiceException {
        Person p = null;
        try {
            p = (Person)((Object)this.personDAO.getByKey((EntityKey)key));
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to getPerson by pk", (Throwable)ex);
        }
        if (p != null) {
            if (identityTraits == null) {
                identityTraits = compositeCall ? this.psDelegateService.getIdentityTraitsWithCompositeCall(p.getVPIDEntityKey()) : this.psDelegateService.getIdentityTraits(p.getVPIDEntityKey());
            }
            this.overlayIdentityTraits(p, identityTraits);
            p.setPersonLockedReason(this.getPersonLockedReason(p, identityTraits));
        }
        return p;
    }

    private void overlayIdentityTraits(Person person, PersonIdentityTraits traits) {
        person.setIdentityTraits(traits);
    }

    public Person doGetPerson(VPIDEntityKey key) throws ServiceException {
        return this.doGetPerson(key, null, false);
    }

    @Override
    public Person getPersonWithCompositeCall(VPIDEntityKey key) throws ServiceException {
        return this.doGetPerson(key, null, true);
    }

    private Person doGetPerson(VPIDEntityKey key, PersonIdentityTraits identityTraits, boolean compositeCall) throws ServiceException {
        if (key == null) {
            return null;
        }
        try {
            VPIDEntityKey longFormAndSurvivingVPID;
            Person person;
            if (identityTraits == null) {
                identityTraits = compositeCall ? this.psDelegateService.getIdentityTraitsWithCompositeCall(key) : this.psDelegateService.getIdentityTraits(key);
            }
            if ((person = this.personDAO.getByVPID(longFormAndSurvivingVPID = CommonEntityKeyFactory.createVPIDEntityKey(((VPIDEntityKeyImpl)identityTraits.getVpid()).getLongVPID()))) == null) {
                this.verifyAddStubRecord(longFormAndSurvivingVPID, false);
                person = this.personDAO.getByVPID(longFormAndSurvivingVPID);
            }
            this.overlayIdentityTraits(person, identityTraits);
            person.setPersonLockedReason(this.getPersonLockedReason(person, identityTraits));
            return person;
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to retrieve Person by VPID", (Throwable)e);
        }
    }

    @Override
    public List search(PersonSearchQueryInfo personSearchQueryInfo, boolean isAttendedMode, boolean shouldRetrieveFullPerson, int maxResults) throws ServiceException {
        return this.search(personSearchQueryInfo, isAttendedMode, shouldRetrieveFullPerson, true, maxResults);
    }

    @Override
    public List search(PersonSearchQueryInfo personSearchQueryInfo, boolean isAttendedMode, boolean shouldRetrieveFullPerson, boolean enforceSecurity, int maxResults) throws ServiceException {
        ListOrderedMap results;
        block22: {
            results = new ListOrderedMap();
            try {
                VPIDEntityKey vpid = null;
                Iterator<Object> itr = null;
                if (StringUtils.isNotBlank((String)personSearchQueryInfo.getVpid())) {
                    try {
                        vpid = CommonEntityKeyFactory.createVPIDEntityKey(VPIDEntityKeyImpl.getLongVPID(personSearchQueryInfo.getVpid()));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    if (vpid == null) break block22;
                    try {
                        Person person = this.retrieveSearchResultPerson(vpid, null, null);
                        if (person != null) {
                            results.put((Object)person.getVPIDEntityKey(), (Object)person);
                        }
                        break block22;
                    }
                    catch (ServiceException e) {
                        if (!(e.getCause() instanceof gov.va.med.person.exceptions.NoRecordFoundException)) {
                            throw e;
                        }
                        break block22;
                    }
                }
                HashMap<VPIDEntityKey, PersonIdentityTraits> traitsKeyedByVPID = null;
                boolean noMatchFromPSIM = false;
                if (!(StringUtils.isBlank((String)personSearchQueryInfo.getGivenName()) && StringUtils.isBlank((String)personSearchQueryInfo.getMiddleName()) && StringUtils.isBlank((String)personSearchQueryInfo.getFamilyName()) && StringUtils.isBlank((String)personSearchQueryInfo.getUnformattedSsn()) && StringUtils.isBlank((String)personSearchQueryInfo.getDateOfBirth()) && personSearchQueryInfo.getSigi() == null && StringUtils.isBlank((String)personSearchQueryInfo.getGender()))) {
                    String dob;
                    PersonIdentityTraits searchCriteriaForTraits = new PersonIdentityTraits();
                    if (!(StringUtils.isBlank((String)personSearchQueryInfo.getFamilyName()) && StringUtils.isBlank((String)personSearchQueryInfo.getMiddleName()) && StringUtils.isBlank((String)personSearchQueryInfo.getGivenName()))) {
                        Name legalName = new Name();
                        legalName.setFamilyName(StringUtils.trimToNull((String)personSearchQueryInfo.getFamilyName()));
                        legalName.setGivenName(StringUtils.trimToNull((String)personSearchQueryInfo.getGivenName()));
                        legalName.setMiddleName(StringUtils.trimToNull((String)personSearchQueryInfo.getMiddleName()));
                        legalName.setType(this.lookupService.getNameTypeByCode(NameType.LEGAL_NAME.getName()));
                        searchCriteriaForTraits.addName(legalName);
                    }
                    SSN ssn = new SSN();
                    if (StringUtils.isNotEmpty((String)personSearchQueryInfo.getUnformattedSsn())) {
                        ssn.setType(this.getLookupService().getSSNTypeByCode(SSNType.CODE_ACTIVE.getName()));
                        ssn.setSsnText(StringUtils.trimToNull((String)SSN.formatSSN(personSearchQueryInfo.getUnformattedSsn())));
                    }
                    searchCriteriaForTraits.setSsn(ssn);
                    String gender = personSearchQueryInfo.getGender();
                    if (!StringUtils.isBlank((String)gender)) {
                        searchCriteriaForTraits.setGender(this.lookupService.getGenderByCode(personSearchQueryInfo.getGender()));
                    }
                    if (!StringUtils.isBlank((String)(dob = personSearchQueryInfo.getDateOfBirth()))) {
                        BirthRecord br = new BirthRecord();
                        br.setBirthDate(new ImpreciseDate(dob));
                        searchCriteriaForTraits.setBirthRecord(br);
                    }
                    Address permAddress = new Address();
                    permAddress.setLine1(personSearchQueryInfo.getAddress() != null ? personSearchQueryInfo.getAddress() : null);
                    permAddress.setCity(personSearchQueryInfo.getCity() != null ? personSearchQueryInfo.getCity() : null);
                    permAddress.setState(personSearchQueryInfo.getState() != null ? personSearchQueryInfo.getState() : null);
                    permAddress.setZipCode(personSearchQueryInfo.getZipCode() != null ? personSearchQueryInfo.getZipCode() : null);
                    permAddress.setPostalCode(personSearchQueryInfo.getPostalCode() != null ? personSearchQueryInfo.getPostalCode() : null);
                    permAddress.setCountry(personSearchQueryInfo.getCountry() != null ? personSearchQueryInfo.getCountry() : null);
                    permAddress.setPhoneNumber(personSearchQueryInfo.getHomePhoneNumber() != null ? personSearchQueryInfo.getHomePhoneNumber() : null);
                    searchCriteriaForTraits.addAddress(permAddress);
                    Set matchingTraits = null;
                    matchingTraits = isAttendedMode ? (personSearchQueryInfo.isAddAPerson() ? this.getIdmServiceDelegate().search(searchCriteriaForTraits, true) : this.psDelegateService.attendedSearch(searchCriteriaForTraits, enforceSecurity)) : this.psDelegateService.unattendedSearch(searchCriteriaForTraits);
                    itr = matchingTraits != null ? matchingTraits.iterator() : null;
                    traitsKeyedByVPID = new HashMap<VPIDEntityKey, PersonIdentityTraits>();
                    PersonIdentityTraits match = null;
                    while (itr != null && itr.hasNext()) {
                        match = (PersonIdentityTraits)((Object)itr.next());
                        traitsKeyedByVPID.put(match.getVpid(), match);
                    }
                    if (traitsKeyedByVPID.size() == 0) {
                        noMatchFromPSIM = true;
                    }
                }
                if (!noMatchFromPSIM) {
                    if (!StringUtils.isBlank((String)personSearchQueryInfo.getClaimFolderNumber()) || !StringUtils.isBlank((String)personSearchQueryInfo.getMilitaryServiceNumber())) {
                        List tempResults = this.personDAO.find(personSearchQueryInfo);
                        Person esrPerson = null;
                        itr = tempResults != null ? tempResults.iterator() : null;
                        HashSet<VPIDEntityKey> chosenVPIDs = new HashSet<VPIDEntityKey>();
                        while (itr != null && itr.hasNext()) {
                            esrPerson = (Person)((Object)itr.next());
                            vpid = esrPerson.getVPIDEntityKey();
                            if (traitsKeyedByVPID == null) {
                                this.doSearchPerson(results, maxResults, vpid, esrPerson, null, shouldRetrieveFullPerson, false);
                                continue;
                            }
                            if (!traitsKeyedByVPID.containsKey(vpid = (esrPerson = this.retrieveTraitsAndOverlayWithPerson(esrPerson, vpid)).getVPIDEntityKey()) || chosenVPIDs.contains(vpid)) continue;
                            chosenVPIDs.add(vpid);
                            this.doSearchPerson(results, maxResults, vpid, esrPerson, (PersonIdentityTraits)((Object)traitsKeyedByVPID.get(vpid)), shouldRetrieveFullPerson, false);
                        }
                    } else {
                        itr = traitsKeyedByVPID != null ? traitsKeyedByVPID.keySet().iterator() : null;
                        HashSet<VPIDEntityKey> chosenVPIDs = new HashSet<VPIDEntityKey>();
                        while (itr != null && itr.hasNext()) {
                            vpid = (VPIDEntityKey)itr.next();
                            PersonIdentityTraits matchingTraits = (PersonIdentityTraits)((Object)traitsKeyedByVPID.get(vpid));
                            VPIDEntityKey survivingVpid = matchingTraits.getVpid();
                            if (chosenVPIDs.contains(survivingVpid)) continue;
                            chosenVPIDs.add(survivingVpid);
                            this.doSearchPerson(results, maxResults, survivingVpid, null, matchingTraits, shouldRetrieveFullPerson, personSearchQueryInfo.isAddAPerson());
                        }
                    }
                }
            }
            catch (DAOException e) {
                throw new ServiceException("Unable to execute PersonDAO search against ADR", (Throwable)e);
            }
        }
        personSearchQueryInfo.setTotalNumberOfEntries(results.size());
        personSearchQueryInfo.setSearchTypePerformed("readAll");
        personSearchQueryInfo.setSortPerformed(false);
        return results.valueList();
    }

    @Override
    public VPIDEntityKey addPersonExplicit(Person incoming, IdMSearchInfo searchInfo) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"Add Person Explicitly with a NULL Person object");
        Validate.notNull((Object)searchInfo, (String)"Add Person Explicitly with a NULL IdMSearchInfo object");
        Validate.isTrue((boolean)searchInfo.isAddPersonExplicit(), (String)"Add Person Explicitly with a false addPersonExplicit flag");
        IdmServiceVO idmServiceVO = this.convertPersonToIdmServiceVO(incoming);
        VPIDEntityKey vpidEntityKey = this.getIdmServiceDelegate().addPerson(idmServiceVO, searchInfo);
        PersonEntityKey personKey = null;
        if (vpidEntityKey != null) {
            personKey = this.addPersonStub(vpidEntityKey, incoming.getVeteran(), incoming.getVOAIndicator());
            if (personKey == null) {
                throw new ServiceException("Failed to add person stub record for VPID:" + vpidEntityKey.getKeyValueAsString());
            }
            try {
                this.getPersonDAO().flush();
            }
            catch (DAOException dex) {
                throw new ServiceException("Failed to add person stub explicit and flush record for VPID:" + vpidEntityKey.getKeyValueAsString(), (Throwable)dex);
            }
        }
        String vpid = VPIDEntityKeyImpl.getLongVPID(vpidEntityKey.getKeyValueAsString());
        incoming.setVPIDValue(vpid);
        incoming.setIdentifier(personKey != null ? (BigDecimal)personKey.getKeyValue() : null);
        return vpidEntityKey;
    }

    @Override
    public VPIDEntityKey addPerson(IdmServiceVO idmServiceVO) throws ServiceException {
        VPIDEntityKey vpidEntityKey = this.getIdmServiceDelegate().addPerson(idmServiceVO, null);
        PersonEntityKey personKey = null;
        if (vpidEntityKey != null && (personKey = this.addPersonStub(vpidEntityKey)) == null) {
            throw new ServiceException("Failed to add person stub record for VPID:" + vpidEntityKey.getKeyValueAsString());
        }
        return vpidEntityKey;
    }

    @Override
    public PersonIdentityTraits getESRCorrelation(VPIDEntityKey vpid) throws ServiceException {
        return this.getIdmServiceDelegate().getESRCorrelation(vpid);
    }

    @Override
    public Person addESRCorrelation(Person onFile, Person incoming) throws ServiceException {
        try {
            if (!onFile.isEsrCorrelationAdded()) {
                this.addESRCorrelation(incoming);
                onFile.setEsrCorrelationAdded(true);
            }
            return onFile;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add ESR Correlation in PSIM", e);
        }
    }

    @Override
    public VPIDEntityKey addESRCorrelation(Person incomingPerson) throws ServiceException {
        VPIDEntityKey vpidKey = null;
        PersonIdentityTraits identityTraits = this.psDelegateService.getIdentityTraitsWithCompositeCall(incomingPerson.getVPIDEntityKey());
        if (identityTraits != null) {
            vpidKey = CommonEntityKeyFactory.createVPIDEntityKey(((VPIDEntityKeyImpl)identityTraits.getVpid()).getLongVPID());
        }
        if (vpidKey != null && "N".equals(identityTraits.has200ESRCorrelation())) {
            PersonEntityKey personKey = this.addPersonStub(vpidKey);
            if (personKey == null) {
                throw new ServiceException("Failed to add person stub record for VPID:" + vpidKey.getKeyValueAsString());
            }
            if (incomingPerson.getOfficialSsn() != null) {
                incomingPerson.getOfficialSsn().setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.NEW_RECORD.getCode()));
            }
            vpidKey = this.getIdmServiceDelegate().addCorrelation(this.convertPersonToIdmServiceVO(incomingPerson));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("PersonServiceImpl addCorrelation : 200ESR added for vpid: " + vpidKey));
            }
        }
        return vpidKey;
    }

    @Override
    public void checkAndAddESRCorrelation(Person person) throws ServiceException {
        if (person != null && (person.getEnrollmentDeterminations() == null || person.getEnrollmentDeterminations().size() == 0)) {
            this.addESRCorrelation(person);
        }
    }

    @Override
    public void updateProfileForESRCorrelation(IdmServiceVO idmServiceVO) throws ServiceException {
        this.getIdmServiceDelegate().updatePerson(idmServiceVO);
    }

    @Override
    public void updateProfileForESRCorrelation(Person incomingPerson) throws ServiceException {
        this.updateProfileForESRCorrelation(this.convertPersonToIdmServiceVO(incomingPerson));
    }

    @Override
    public void updateProfileForDeathEvent(Person incomingPerson) throws ServiceException {
        IdmServiceVO idmServiceVo = this.convertPersonToIdmServiceVO(incomingPerson);
        idmServiceVo.setDeathEvent(true);
        this.updateProfileForESRCorrelation(idmServiceVo);
    }

    @Override
    public void updateProfileForAAP(Person incomingPerson) throws ServiceException {
        IdmServiceVO idmServiceVo = this.convertPersonToIdmServiceVO(incomingPerson);
        idmServiceVo.setDeathRecord(null);
        this.updateProfileForESRCorrelation(idmServiceVo);
    }

    @Override
    public FullyQualifiedIdentity addPreferredFacilityCorrelation(Person incomingPerson, List<PatientIdentifier> correlations) throws ServiceException {
        PreferredFacilityLite incomingPF = null;
        if (!incomingPerson.getPreferredFacilities().isEmpty()) {
            Iterator iter = incomingPerson.getPreferredFacilities().iterator();
            incomingPF = (PreferredFacility)((Object)iter.next());
        }
        if (incomingPF != null && incomingPF.getFacility() != null) {
            IdmServiceVO vo;
            VAFacility primaryFacility = this.getParentSite(incomingPF.getFacility());
            if (correlations == null) {
                correlations = this.getIdmServiceDelegate().getCorrelationsByVPID(incomingPerson.getVPIDEntityKey());
            }
            if (correlations != null) {
                String personStationNumber = primaryFacility.getStationNumber();
                PatientIdentifier patientId2 = null;
                String correlationStationNumber = null;
                for (PatientIdentifier patientId2 : correlations) {
                    correlationStationNumber = patientId2.getStationNumber();
                    if (personStationNumber == null || !personStationNumber.equals(correlationStationNumber)) continue;
                    return new FullyQualifiedIdentity(patientId2.getIdentity(), correlationStationNumber);
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("PersonServiceImpl APTF : facility correlation adding for: " + (Object)((Object)incomingPerson)));
            }
            if ((vo = this.convertPersonToIdmServiceVO(incomingPerson)).getGender() != null) {
                if (!vo.getGender().getCode().equalsIgnoreCase(Gender.MALE.getCode()) && !vo.getGender().getCode().equalsIgnoreCase(Gender.FEMALE.getCode())) {
                    this.logger.info((Object)("Defaulting UNK Gender to M for APTF on person:" + incomingPerson.getPersonEntityKey().getKeyValueAsString()));
                    vo.setGender(this.lookupService.getGenderByCode(Gender.MALE.getName()));
                }
            } else {
                this.logger.info((Object)("Defaulting NULL Gender to M for APTF on person:" + incomingPerson.getPersonEntityKey().getKeyValueAsString()));
                vo.setGender(this.lookupService.getGenderByCode(Gender.MALE.getName()));
            }
            return this.getIdmServiceDelegate().addPreferredFacility(vo);
        }
        throw new ServiceException("Cannot add preferred facility, incomingPF is null");
    }

    @Override
    public FullyQualifiedIdentity addPreferredFacilityCorrelation(Person incomingPerson) throws ServiceException {
        return this.addPreferredFacilityCorrelation(incomingPerson, null);
    }

    @Override
    public VAFacility getParentSite(VAFacility preferredFacility) throws ServiceException {
        if (preferredFacility == null) {
            return null;
        }
        VAFacility facility = preferredFacility;
        if (Boolean.TRUE.equals(facility.isMfnzegRecipient())) {
            return facility;
        }
        if (facility.getParentId() == null) {
            return facility;
        }
        while (facility.getParentId() != null && facility.getParentId().compareTo(facility.getIdentifier()) != 0) {
            facility = this.getLookupService().getVAFacilityById(facility.getParentId());
            if (!Boolean.TRUE.equals(facility.isMfnzegRecipient())) continue;
            return facility;
        }
        throw new ServiceException("Sending site for facility " + preferredFacility.getStationNumber() + " cannot be found");
    }

    private Person doSearchPerson(ListOrderedMap results, int maxResults, VPIDEntityKey vpid, Person alreadyRetrievedPartialPerson, PersonIdentityTraits identityTraits, boolean shouldRetrieveFullPerson, boolean isAddPerson) throws ServiceException {
        Person retrievedPerson = null;
        if (maxResults > 0 && results != null && results.size() >= maxResults) {
            throw new MaxRecordsExceededException(maxResults, "Search exceeded requested limit of " + maxResults + " Persons");
        }
        retrievedPerson = shouldRetrieveFullPerson ? this.doGetPerson(vpid, identityTraits, false) : (isAddPerson ? this.convertTraitsToPerson(identityTraits) : this.retrieveSearchResultPerson(vpid, alreadyRetrievedPartialPerson, identityTraits));
        results.put((Object)retrievedPerson.getVPIDEntityKey(), (Object)retrievedPerson);
        return retrievedPerson;
    }

    public List search(SearchQueryInfo searchQueryInfo) throws ServiceException {
        if (!(searchQueryInfo instanceof PersonSearchQueryInfo)) {
            throw new ServiceException("searchQueryInfo is an instance of '" + searchQueryInfo.getClass().getName() + "' and must be an instance of 'PersonSearchQueryInfo'.");
        }
        return this.search((PersonSearchQueryInfo)searchQueryInfo, true, false, -1);
    }

    private Person retrieveSearchResultPerson(VPIDEntityKey vpid, Person incomingPerson, PersonIdentityTraits traits) throws ServiceException {
        Validate.notNull((Object)vpid, (String)"Need a non-null VPID");
        Person searchResultPerson = null;
        try {
            if (incomingPerson == null) {
                searchResultPerson = this.personDAO.getSearchResultsByVPID(vpid);
                if (searchResultPerson == null) {
                    this.verifyAddStubRecord(vpid, true);
                    searchResultPerson = this.personDAO.getSearchResultsByVPID(vpid);
                }
            } else {
                searchResultPerson = incomingPerson;
            }
            if (traits == null) {
                traits = this.psDelegateService.getIdentityTraits(vpid);
            }
            this.overlayIdentityTraits(searchResultPerson, traits);
            searchResultPerson.setPersonLockedReason(this.getPersonLockedReason(searchResultPerson, traits));
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to retrieve search result by VPID for ESR", (Throwable)e);
        }
        return searchResultPerson;
    }

    private Person retrieveTraitsAndOverlayWithPerson(Person person, VPIDEntityKey vpid) throws ServiceException {
        PersonIdentityTraits traits = this.psDelegateService.getIdentityTraits(vpid);
        try {
            person = this.personDAO.getSearchResultsByVPID(traits.getVpid());
            if (person == null) {
                this.verifyAddStubRecord(traits.getVpid(), false);
                person = this.personDAO.getSearchResultsByVPID(traits.getVpid());
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to retrieve Person by VPID for ESR", (Throwable)e);
        }
        this.overlayIdentityTraits(person, traits);
        return person;
    }

    private Person verifyNonDeprecatedSearchResult(Person person, VPIDEntityKey vpid, PersonIdentityTraits traits) throws ServiceException {
        Person nonDeprecatedPerson = person;
        traits = this.verifyNonDeprecatedIdentityTraits(vpid, traits);
        try {
            if (traits.isRetrievedWithDeprecatedVPID()) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Search Result Person found with deprecated VPID [" + vpid.getKeyValueAsString() + "] - must re-retrieve Search Result Person with surviving VPID [" + traits.getVpid().getKeyValueAsString() + "]"));
                }
                nonDeprecatedPerson = this.personDAO.getSearchResultsByVPID(traits.getVpid());
            }
            if (nonDeprecatedPerson == null) {
                this.verifyAddStubRecord(traits.getVpid(), false);
                nonDeprecatedPerson = this.personDAO.getSearchResultsByVPID(traits.getVpid());
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to retrieve Person by VPID for ESR", (Throwable)e);
        }
        this.overlayIdentityTraits(nonDeprecatedPerson, traits);
        return nonDeprecatedPerson;
    }

    private PersonIdentityTraits verifyNonDeprecatedIdentityTraits(VPIDEntityKey vpid, PersonIdentityTraits traits) throws ServiceException {
        PersonIdentityTraits nonDeprecatedTraits = traits;
        if (traits == null || traits.isDeprecated()) {
            nonDeprecatedTraits = this.psDelegateService.getIdentityTraits(vpid);
        }
        return nonDeprecatedTraits;
    }

    @Override
    public Person getPersonFromSiteData(PersonEntityKey personID, String status) throws ServiceException {
        Person siteData = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searching for site data with the specific person id " + personID));
            this.logger.debug((Object)("Received eligibility status from a site" + status));
        }
        Person person = this.getPerson(personID);
        try {
            HL7Message siteMessage = null;
            MessageLogEntryDAO dao = this.getMessageLogEntryDAO();
            MessageLogEntry mle = dao.findByReceivedEligiblityStatus(person, status);
            if (mle != null) {
                siteMessage = new HL7Message(mle.getBody());
            }
            if (siteMessage != null) {
                Builder builder = this.getSiteDataBuilder();
                siteData = (Person)((Object)builder.build((Object)new Object[]{(Person)((Object)person.clone()), siteMessage}));
                siteData.setSendingFacility(siteMessage.getSendingFacility());
            }
        }
        catch (DAOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to retrieve a site data due to exception: ", (Throwable)e);
            }
            throw new ServiceException("Failed to retrieve a site data due to exception: ", (Throwable)e);
        }
        catch (InvalidMessageException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to parse an original message ", (Throwable)e);
            }
            throw new ServiceException("Failed to parse an original message ", (Throwable)e);
        }
        catch (BuilderException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to build a person from site data", (Throwable)e);
            }
            throw new ServiceException("Failed to build a person from site data", (Throwable)e);
        }
        return siteData;
    }

    public PersonDAO getPersonDAO() {
        return this.personDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public String getPersonMergeServiceName() {
        return this.personMergeServiceName;
    }

    public void setPersonMergeServiceName(String personMergeServiceName) {
        this.personMergeServiceName = personMergeServiceName;
    }

    public PersonMergeService getPersonMergeService() {
        if (this.personMergeService == null) {
            this.personMergeService = (PersonMergeService)this.getApplicationContext().getBean(this.personMergeServiceName, PersonMergeService.class);
        }
        return this.personMergeService;
    }

    public String getPersonUnmergeServiceName() {
        return this.personUnmergeServiceName;
    }

    public void setPersonUnmergeServiceName(String personUnmergeServiceName) {
        this.personUnmergeServiceName = personUnmergeServiceName;
    }

    public PersonUnmergeService getPersonUnmergeService() {
        if (this.personUnmergeService == null) {
            this.personUnmergeService = (PersonUnmergeService)this.getApplicationContext().getBean(this.personUnmergeServiceName, PersonUnmergeService.class);
        }
        return this.personUnmergeService;
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        if (this.eligibilityEnrollmentService == null) {
            this.eligibilityEnrollmentService = (EligibilityEnrollmentService)this.getApplicationContext().getBean(this.getEligibilityEnrollmentServiceName(), EligibilityEnrollmentService.class);
        }
        return this.eligibilityEnrollmentService;
    }

    public String getEligibilityEnrollmentServiceName() {
        return this.eligibilityEnrollmentServiceName;
    }

    public void setEligibilityEnrollmentServiceName(String eligibilityEnrollmentServiceName) {
        this.eligibilityEnrollmentServiceName = eligibilityEnrollmentServiceName;
    }

    public EventRuleService getEventRuleService() {
        if (this.eventRuleService == null) {
            this.eventRuleService = (EventRuleService)this.getApplicationContext().getBean(this.getEventRuleServiceName(), EventRuleService.class);
        }
        return this.eventRuleService;
    }

    public String getEventRuleServiceName() {
        return this.eventRuleServiceName;
    }

    public void setEventRuleServiceName(String eventRuleServiceName) {
        this.eventRuleServiceName = eventRuleServiceName;
    }

    public MergeRuleService getMergeRuleService() {
        if (this.mergeRuleService == null) {
            this.mergeRuleService = (MergeRuleService)this.getApplicationContext().getBean(this.getMergeRuleServiceName(), MergeRuleService.class);
        }
        return this.mergeRuleService;
    }

    public String getMergeRuleServiceName() {
        return this.mergeRuleServiceName;
    }

    public void setMergeRuleServiceName(String mergeRuleServiceName) {
        this.mergeRuleServiceName = mergeRuleServiceName;
    }

    public void setPersonUnmergeService(PersonUnmergeService personUnmergeService) {
        this.personUnmergeService = personUnmergeService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public Builder getSiteDataBuilder() {
        return this.siteDataBuilder;
    }

    public void setSiteDataBuilder(Builder siteDataBuilder) {
        this.siteDataBuilder = siteDataBuilder;
    }

    public MessageLogEntryDAO getMessageLogEntryDAO() {
        return this.messageLogEntryDAO;
    }

    public void setMessageLogEntryDAO(MessageLogEntryDAO messageLogEntryDAO) {
        this.messageLogEntryDAO = messageLogEntryDAO;
    }

    @Override
    public void processExternalPersonLink(PersonLinkInfo linkInfo) throws ServiceException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ESR received an external person link event: " + linkInfo));
        }
        PersonMergeInfo info = new PersonMergeInfo();
        VPIDEntityKey deprecatedVPID = CommonEntityKeyFactory.createVPIDEntityKey(linkInfo.getDeprecatedVPID());
        VPIDEntityKey survivingVPID = CommonEntityKeyFactory.createVPIDEntityKey(linkInfo.getSurvivingVPID());
        PersonIdEntityKey deprecatedPersonIdEntityKey = CommonEntityKeyFactory.createPersonIdEntityKey(this.doGetPerson(deprecatedVPID).getPersonEntityKey().getKeyValueAsString());
        PersonIdEntityKey survivingPersonIdEntityKey = CommonEntityKeyFactory.createPersonIdEntityKey(this.doGetPerson(survivingVPID).getPersonEntityKey().getKeyValueAsString());
        if (deprecatedPersonIdEntityKey == null) {
            throw new ServiceException("Unable to retrieve Person for deprecatedVPID: " + linkInfo.getDeprecatedVPID());
        }
        if (survivingPersonIdEntityKey == null) {
            throw new ServiceException("Unable to retrieve Person for survivingVPID: " + linkInfo.getSurvivingVPID());
        }
        if (deprecatedPersonIdEntityKey.getKeyValueAsString().equals(survivingPersonIdEntityKey.getKeyValueAsString())) {
            throw new ServiceException("Unable to process merge for identical Person_ids for surviving vpid: " + linkInfo.getSurvivingVPID());
        }
        info.setDeprecatedPersonEntityKey(deprecatedPersonIdEntityKey);
        info.setPrimaryPersonEntityKey(survivingPersonIdEntityKey);
        this.getPersonMergeService().processPersonMergeInfo(info, deprecatedVPID, survivingVPID);
    }

    @Override
    public void processExternalPersonMove(PersonMoveInfo moveInfo) throws ServiceException {
        VAFacility facility;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ESR received an external person move event: " + moveInfo));
        }
        if ((facility = this.lookupService.getVaFacilityByCode(moveInfo.getStationNumber())).getType().getIsMedicalTreating()) {
            PersonUnmergeInfo info = new PersonUnmergeInfo();
            PersonIdEntityKey fromPersonIdEntityKey = CommonEntityKeyFactory.createPersonIdEntityKey(this.doGetPerson(CommonEntityKeyFactory.createVPIDEntityKey(moveInfo.getFromVpid())).getPersonEntityKey().getKeyValueAsString());
            PersonIdEntityKey toPersonIdEntityKey = CommonEntityKeyFactory.createPersonIdEntityKey(this.doGetPerson(CommonEntityKeyFactory.createVPIDEntityKey(moveInfo.getToVpid())).getPersonEntityKey().getKeyValueAsString());
            if (fromPersonIdEntityKey == null) {
                throw new ServiceException("Unable to retrieve Person for fromVPID: " + moveInfo.getFromVpid());
            }
            if (toPersonIdEntityKey == null) {
                throw new ServiceException("Unable to retrieve Person for toVPID: " + moveInfo.getToVpid());
            }
            info.setFromPersonEntityKey(fromPersonIdEntityKey);
            info.setToPersonEntityKey(toPersonIdEntityKey);
            info.setDfn(moveInfo.getDfn());
            info.setStationNumber(moveInfo.getStationNumber());
            this.getPersonUnmergeService().processPersonUnmergeInfo(info);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Ignoring IdM move event for non-medical treating facility: " + moveInfo));
        }
    }

    @Override
    public void processExternalPersonPrimaryview(PersonPrimaryViewInfo primaryviewInfo) throws ServiceException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ESR received an external person primary view event: " + primaryviewInfo));
        }
        VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey(primaryviewInfo.getVpid());
        PersonIdEntityKey personkey = CommonEntityKeyFactory.createPersonIdEntityKey(this.doGetPerson(key).getPersonEntityKey().getKeyValueAsString());
        PersonIdentityTraits traits = null;
        try {
            traits = this.getPsDelegateService().getIdentityTraits(key);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("IdM Web Service returned: " + (Object)((Object)traits)));
            }
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e) {
            throw new ServiceException("Unable to get IdentityTraits from PSIM for VPID: " + key.getKeyValueAsString(), (Throwable)e);
        }
        if (traits != null && traits.getDateOfDeathText() != null) {
            Date dod = null;
            try {
                dod = new SimpleDateFormat("yyyyMMdd").parse(traits.getDateOfDeathText());
            }
            catch (ParseException pe) {
                String errMsg = "Error in Person Notification for Primary View Update process - NCA Date of Death from IdM is not valid, the correct format is yyyyMMdd, but the value retrieved is " + traits.getDateOfDeathText() + ", vpid= " + key.getKeyValueAsString();
                this.createWorkloadCase(FunctionalGroup.DQ.getCode(), WkfCaseType.CODE_DEMOGRAPHICS.getCode(), null, errMsg, personkey);
                this.logger.error((Object)errMsg, (Throwable)pe);
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("IdM Web Service returned the traits and dod is send for processing " + dod));
            }
            Person person = null;
            try {
                person = this.doGetPerson(personkey, traits, false);
                if (person == null) {
                    this.verifyAddStubRecord(traits.getVpid(), false);
                    personkey = this.getPersonIdByVPID(traits.getVpid());
                    person = this.doGetPerson(personkey, traits, false);
                }
            }
            catch (TimeoutException ex) {
                throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
            }
            catch (Exception e) {
                throw new ServiceException("Unable to get person for VPID: " + key.getKeyValueAsString(), (Throwable)e);
            }
            this.getDemographicService().processDateOfDeathFromIdm(person, dod);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Date of death is null: IDM service returns null");
        }
    }

    @Override
    public Person processDataSyncFromHECLegacy(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A veteran must not be null");
        Person onFile = ((PersonService)this.getComponent("cachedPersonService")).getPerson((PersonEntityKey)person.getEntityKey());
        onFile.setVeteran(person.getVeteran());
        boolean fromUI = true;
        Person merged = this.getMergeRuleService().mergePerson(person, onFile, fromUI);
        Person calculated = this.getEligibilityEnrollmentService().assessEEImpact(merged, false);
        this.getEventRuleService().handleCommonPostEvents(calculated, fromUI);
        this.getRegistryService().linkPersonRegistries(calculated, onFile, fromUI);
        return this.save(calculated);
    }

    @Override
    public AppointmentConversionResult processAppointmentConversion(PersonEntityKey key) throws ServiceException {
        Validate.notNull((Object)key, (String)"A veteran must not be null");
        Person person = this.getPerson(key);
        Validate.notNull((Object)((Object)person.getEnrollmentDetermination()), (String)"A veteran's enrollment record must not be null");
        AppointmentConversionResult result = new AppointmentConversionResult();
        result.incrementCount(person.getEnrollmentDetermination());
        person.setAppointmentRequestDate(null);
        person.setAppointmentRequestResponse(null);
        this.getEventRuleService().manageMessageEvents(person);
        this.save(person);
        return result;
    }

    @Override
    public EEResult processEEForMigratedPerson(PersonEntityKey key) throws ServiceException {
        Validate.notNull((Object)key, (String)"A veteran must not be null");
        Person onFile = this.getPerson(key);
        EEResult result = null;
        Boolean migratedEE = onFile.getMigratedEE();
        if (Boolean.FALSE.equals(migratedEE)) {
            boolean fromUI = true;
            Person calculated = this.getEligibilityEnrollmentService().assessEEImpact(onFile, fromUI, false);
            this.getEventRuleService().handleCommonPostEvents(calculated, fromUI);
            this.getRegistryService().linkPersonRegistries(calculated, onFile, fromUI);
            result = new EEResult(this.save(calculated));
        } else if (Boolean.TRUE.equals(migratedEE)) {
            result = new EEResult(key);
        } else if (migratedEE == null) {
            throw new ServiceException("Can not (and will not) migrate EE data for a record that was not migrated to begin with");
        }
        return result;
    }

    private PersonLockedReason getPersonLockedReason(Person person, PersonIdentityTraits identityTraits) throws ServiceException {
        PersonLockedReason lockReason = null;
        if (identityTraits == null) {
            identityTraits = this.getPsDelegateService().getIdentityTraits(person.getVPIDEntityKey());
        }
        if (identityTraits.isHasPendingUpdates() && this.isDataClean) {
            lockReason = PersonLockedReason.PENDING_IDENTITY_TRAIT_UPDATES;
        } else if (identityTraits.isDeprecated()) {
            lockReason = PersonLockedReason.PERSON_DEPRECATED;
        } else if (person.getEnrollmentDetermination() == null) {
            lockReason = PersonLockedReason.PERSON_NO_ENROLLMENT_DETERMINATION;
        } else {
            boolean hasActiveMerge = this.getPersonMergeService().hasActiveMerge((PersonIdEntityKey)person.getPersonEntityKey());
            if (hasActiveMerge) {
                lockReason = PersonLockedReason.PERSON_MERGE_ACTIVE;
            }
        }
        return lockReason;
    }

    @Override
    public VPIDEntityKey getVPIDByPersonId(PersonIdEntityKey personId) throws ServiceException {
        if (personId == null) {
            return null;
        }
        VPIDEntityKey vpid = null;
        try {
            vpid = this.personDAO.getVPIDByPersonId(personId);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to getVPID by PersonId", (Throwable)ex);
        }
        return vpid;
    }

    @Override
    public PersonIdEntityKey getPersonIdByVPID(VPIDEntityKey vpid) throws ServiceException {
        PersonIdEntityKey personId = null;
        if (vpid == null) {
            return null;
        }
        try {
            personId = this.personDAO.getPersonIdByVPID(vpid);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to getVPID by PersonId", (Throwable)ex);
        }
        return personId;
    }

    @Override
    public PersonEntityKey addPersonStub(VPIDEntityKey vpid, Boolean isVeteran, Character voaInd) throws ServiceException {
        PersonIdEntityKey personKey = null;
        try {
            personKey = this.getPersonIdByVPID(vpid);
            if (personKey != null) {
                return personKey;
            }
            Person p = new Person();
            p.setVPIDValue(((VPIDEntityKeyImpl)vpid).getLongVPID());
            p.setSensitiveRecord(Boolean.FALSE);
            p.setVeteran(isVeteran);
            p.setVOAIndicator(voaInd);
            return (PersonEntityKey)this.personDAO.insertObject((Object)p);
        }
        catch (DAOException ex) {
            if (ex.getCause() instanceof DataIntegrityViolationException) {
                personKey = this.getPersonIdByVPID(vpid);
                return personKey;
            }
            throw new ServiceException("Failed to create Person stub for vpid " + vpid.getKeyValueAsString(), (Throwable)ex);
        }
    }

    @Override
    public PersonEntityKey addPersonStub(VPIDEntityKey vpid) throws ServiceException {
        return this.addPersonStub(vpid, Boolean.TRUE, null);
    }

    private void createWorkloadCase(String groupType, String caseType, String issueType, String description, PersonEntityKey key) throws ServiceException {
        Validate.notNull((Object)groupType, (String)"A Group type must not be null");
        Validate.notNull((Object)caseType, (String)"A case type must not be null");
        WorkflowCaseInfo caseInfo = new WorkflowCaseInfo();
        caseInfo.setPersonEntityKey(key);
        try {
            caseInfo.setErrorMessage(description);
            caseInfo.setGroupType(this.getLookupService().getFunctionalGroupByCode(groupType));
            caseInfo.setCaseType(this.getLookupService().getWkfCaseTypeByCode(caseType));
            if (StringUtils.isNotEmpty((String)issueType)) {
                caseInfo.setIssueType(this.getLookupService().getWkfIssueTypeByCode(issueType));
            }
            this.getWorkflowService().autoCreateCase(caseInfo);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Case description: " + description));
                this.logger.debug((Object)("Case type: " + caseType));
                this.logger.debug((Object)"Failed to create case due to ", (Throwable)e);
            }
            throw new ServiceException("Failed to create a case", (Throwable)e);
        }
    }

    @Override
    public void updateVOAIndicator(Person person) throws ServiceException {
        if (person == null) {
            return;
        }
        try {
            this.getPersonDAO().updateVOAIndicator(person);
        }
        catch (DAOException dex) {
            throw new ServiceException((Throwable)dex);
        }
    }

    private Person convertTraitsToPerson(PersonIdentityTraits source) throws ServiceException {
        if (source == null) {
            return null;
        }
        Person target = new Person(source.getVpid());
        target.addName(source.getLegalName());
        BirthRecord dob = source.getBirthRecord();
        MultipleBirthIndicator isMultipleBirth = source.getMultiBirth();
        if (isMultipleBirth != null) {
            dob.setMultipleBirth(new Boolean(isMultipleBirth.getValue()));
        }
        target.setBirthRecord(dob);
        target.setGender(source.getGender());
        target.addSsn(source.getSsn());
        target.setIdmMatchType(source.getIdmMatchType());
        return target;
    }

    private IdmServiceVO convertPersonToIdmServiceVO(Person source) throws ServiceException {
        String mothersMaidenName;
        IdmServiceVO idmServiceVO = new IdmServiceVO();
        idmServiceVO.setNames(source.getNames());
        SSN ssnOfficial = source.getOfficialSsn();
        if (ssnOfficial != null) {
            idmServiceVO.setSsn(ssnOfficial);
        }
        idmServiceVO.setGender(source.getGender());
        idmServiceVO.setBirthRecord(source.getBirthRecord());
        idmServiceVO.setDeathEvent(false);
        if (source.getDeathRecord() != null) {
            idmServiceVO.setDeathRecord(source.getDeathRecord());
            if (idmServiceVO.getDeathRecord().getDeathReportDate() == null) {
                idmServiceVO.getDeathRecord().setDeathReportDate(new Date());
            }
            if (idmServiceVO.getDeathRecord().getDeathDate() == null && idmServiceVO.getDeathRecord().getDataSource() == null && idmServiceVO.getDeathRecord().getLazarusDate() == null) {
                idmServiceVO.getDeathRecord().setLazarusDate(new ImpreciseDate(new Date()));
            }
        }
        idmServiceVO.setVpid(source.getVPIDEntityKey());
        String patientType = this.determinePatientType(source);
        idmServiceVO.setPatientType(patientType);
        idmServiceVO.setVeteran(Boolean.TRUE.equals(source.isVeteran()));
        idmServiceVO.setServiceConnected(false);
        PreferredFacilityLite incomingPF = null;
        if (!source.getPreferredFacilities().isEmpty()) {
            Iterator iter = source.getPreferredFacilities().iterator();
            incomingPF = (PreferredFacility)((Object)iter.next());
        }
        if (incomingPF != null && incomingPF.getFacility() != null) {
            idmServiceVO.setPreferredFacilty(this.getParentSite(incomingPF.getFacility()));
        }
        if ((mothersMaidenName = source.getMothersMaidenName()) != null && mothersMaidenName.length() > 0) {
            idmServiceVO.setMothersMaidenName(mothersMaidenName);
        }
        idmServiceVO.setAddresses(source.getAddresses());
        idmServiceVO.setPhones(source.getPhones());
        return idmServiceVO;
    }

    protected String determinePatientType(Person person) {
        String patientType = null;
        String primaryEligibilityCode = this.getPrimaryEligibilityCode(person);
        if (primaryEligibilityCode == null) {
            patientType = Boolean.TRUE.equals(person.isVeteran()) ? NSC_VETERAN_CODE : NON_VETERAN_CODE;
        } else if (Boolean.TRUE.equals(person.isVeteran())) {
            ServiceConnectionAward scAward = person.getServiceConnectionAward();
            patientType = scAward != null && Boolean.TRUE.equals(scAward.getServiceConnectedIndicator()) ? SC_VETERAN_CODE : NSC_VETERAN_CODE;
        } else if (primaryEligibilityCode.equals(EligibilityType.ALLIED_VETERAN.getCode())) {
            patientType = ALLIED_VETERAN;
        } else if (primaryEligibilityCode.equals(EligibilityType.COLLATERAL_OF_VETERAN.getCode())) {
            patientType = COLLATERAL;
        } else if (primaryEligibilityCode.equals(EligibilityType.EMPLOYEE.getCode())) {
            patientType = EMPLOYEE;
        } else if (primaryEligibilityCode.equals(EligibilityType.TRICARE_CHAMPUS.getCode())) {
            patientType = TRICARE;
        } else if (primaryEligibilityCode.equals(EligibilityType.CHAMPVA.getCode()) || primaryEligibilityCode.equals(EligibilityType.OTHER_FEDERAL_AGENCY.getCode()) || primaryEligibilityCode.equals(EligibilityType.SHARING_AGREEMENT.getCode())) {
            String periodOfService = this.getCurrentPeriodOfService(person);
            if (ServicePeriod.CODE_AIR_FORCE.getCode().equals(periodOfService) || ServicePeriod.CODE_ARMY.getCode().equals(periodOfService) || ServicePeriod.CODE_COAST_GUARD.getCode().equals(periodOfService) || ServicePeriod.CODE_NAVY.getCode().equals(periodOfService) || ServicePeriod.CODE_OPERATION_DESERT_SHIELD.getCode().equals(periodOfService)) {
                patientType = ACTIVE_DUTY;
            } else if (ServicePeriod.CODE_RETIRED_UNIFORMED_FORCES_CODE.getCode().equals(periodOfService)) {
                patientType = MILITARY_RETIREE;
            }
        } else {
            patientType = NON_VETERAN_CODE;
        }
        return patientType;
    }

    private String getCurrentPeriodOfService(Person person) {
        ServicePeriod period = this.getHelperService().getCurrentServicePeriod(person.getMilitaryService());
        return period != null ? period.getCode() : null;
    }

    private String getPrimaryEligibilityCode(Person person) {
        Eligibility primary;
        String primaryEligibilityCode = null;
        EnrollmentDetermination enrollment = person.getEnrollmentDetermination();
        if (enrollment != null && (primary = enrollment.getPrimaryEligibility()) != null) {
            EligibilityType type = primary.getType();
            primaryEligibilityCode = type != null ? type.getCode() : null;
        }
        return primaryEligibilityCode;
    }

    public boolean isDataClean() {
        return this.isDataClean;
    }

    public void setIsDataClean(boolean isDataClean) {
        this.isDataClean = isDataClean;
    }

    public boolean isUpdateIdentityTraits() {
        return this.isUpdateIdentityTraits;
    }

    public void setIsUpdateIdentityTraits(boolean isUpdateIdentityTraits) {
        this.isUpdateIdentityTraits = isUpdateIdentityTraits;
    }

    public TransactionTimestampManager getTimestampManager() {
        return this.timestampManager;
    }

    public void setTimestampManager(TransactionTimestampManager timestampManager) {
        this.timestampManager = timestampManager;
    }

    public RegistryService getRegistryService() {
        if (this.registryService == null) {
            this.registryService = (RegistryService)this.getApplicationContext().getBean(this.getRegistryServiceName(), RegistryService.class);
        }
        return this.registryService;
    }

    public String getRegistryServiceName() {
        return this.registryServiceName;
    }

    public void setRegistryServiceName(String registryServiceName) {
        this.registryServiceName = registryServiceName;
    }

    public IdmWebServiceDelegate getIdmServiceDelegate() {
        return this.idmServiceDelegate;
    }

    public void setIdmServiceDelegate(IdmWebServiceDelegate idmServiceDelegate) {
        this.idmServiceDelegate = idmServiceDelegate;
    }

    public PersonHelperService getHelperService() {
        return this.helperService;
    }

    public void setHelperService(PersonHelperService service) {
        this.helperService = service;
    }

    private DemographicService getDemographicService() {
        if (this.demographicService == null) {
            ApplicationContext context = this.getApplicationContext();
            this.demographicService = (DemographicService)context.getBean("demographicService");
        }
        return this.demographicService;
    }

    public WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            ApplicationContext context = this.getApplicationContext();
            this.workflowService = (WorkflowService)context.getBean("workflowService");
        }
        return this.workflowService;
    }

    private void verifyAddStubRecord(VPIDEntityKey vpid, boolean validateVpid) throws ServiceException {
        PersonIdentityTraits traits;
        if (vpid == null) {
            throw new ServiceException("Cannot create person stub record for NULL VPID");
        }
        if (validateVpid && (traits = this.psDelegateService.getIdentityTraits(vpid)) == null) {
            throw new ServiceException("Failed to create person stub record for new enrollment. Invalid VPID:" + vpid.getVPID());
        }
        PersonEntityKey personKey = this.addPersonStub(vpid);
        if (personKey == null) {
            throw new ServiceException("Failed to create person stub record for VPID:" + vpid.getVPID());
        }
    }
}

