/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.Decoration;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.EligibilityFactor;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityStatusPendVerfiReason;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.MilitaryServiceQueryStatus;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonTraits;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.SSNVerificationDetail;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.person.PersonTraitsDAO;
import gov.va.med.esr.common.persistent.person.SSNVerificationDetailDAO;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class PersonHelperServiceImpl
extends AbstractComponent
implements Serializable,
PersonHelperService {
    private static final long serialVersionUID = -4752320913353036219L;
    private LookupService lookupService = null;
    private DAOOperations genericDAO;
    private SSNVerificationDetailDAO ssnVerificationDetailDAO;
    private PersonTraitsDAO personTraitsDAO = null;
    private static final String CONTEXT_EE = "EE";
    private static final String CONTEXT_FINANCIALS = "FINANCIALS";
    private String systemParameterServiceName = null;
    private PSDelegateService psDelegateService = null;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.lookupService, (String)"A lookup service must be configured");
        Validate.notNull((Object)this.personTraitsDAO, (String)"A PersonTraitsDAO must be configured");
        Validate.notNull((Object)this.psDelegateService, (String)"Missing required PSDelegateService");
    }

    public DAOOperations getGenericDAO() {
        return this.genericDAO;
    }

    public void setGenericDAO(DAOOperations genericDAO) {
        this.genericDAO = genericDAO;
    }

    public SSNVerificationDetailDAO getSsnVerificationDetailDAO() {
        return this.ssnVerificationDetailDAO;
    }

    public void setSsnVerificationDetailDAO(SSNVerificationDetailDAO ssnVerificationDetailDAO) {
        this.ssnVerificationDetailDAO = ssnVerificationDetailDAO;
    }

    @Override
    public EnrollmentStatus getEnrollmentStatus(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        return person.getEnrollmentDetermination() != null ? person.getEnrollmentDetermination().getEnrollmentStatus() : null;
    }

    @Override
    public EnrollmentCategory getEnrollmentCategory(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        return this.getEnrollmentStatus(person) != null ? this.getEnrollmentStatus(person).getEnrollmentCategory() : null;
    }

    @Override
    public EligibilityStatusPendVerfiReason getEligStatusPendingVerficationReason(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        return person.getEligibilityVerification() != null ? person.getEligibilityVerification().getEligStatusPendingVerficationReason() : null;
    }

    @Override
    public EligibilityStatus getEligibilityStatus(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        return person.getEligibilityVerification() != null ? person.getEligibilityVerification().getEligibilityStatus() : null;
    }

    @Override
    public DecorationStatus getPurpleHeartStatus(Person person) throws ServiceException {
        PurpleHeart decoration = this.getPurpleHeart(person);
        return decoration != null && decoration instanceof PurpleHeart ? decoration.getStatus() : null;
    }

    @Override
    public Set getRatedDisabilities(Person person) {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        ServiceConnectionAward serviceConnectionAward = person.getServiceConnectionAward();
        return serviceConnectionAward != null ? serviceConnectionAward.getRatedDisabilities() : new HashSet();
    }

    @Override
    public MonetaryBenefit getAABenefit(Person person) throws ServiceException {
        return this.getMonetaryBenefit(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName(), person);
    }

    @Override
    public MonetaryBenefit getHouseboundBenefit(Person person) throws ServiceException {
        return this.getMonetaryBenefit(MonetaryBenefitType.CODE_HOUSEBOUND.getName(), person);
    }

    @Override
    public MonetaryBenefit getDisabilityBenefit(Person person) throws ServiceException {
        return this.getMonetaryBenefit(MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getName(), person);
    }

    @Override
    public MonetaryBenefit getVAPensionBenefit(Person person) throws ServiceException {
        return this.getMonetaryBenefit(MonetaryBenefitType.CODE_VA_PENSION.getName(), person);
    }

    @Override
    public SSN getSSN(String code, Person person) throws ServiceException {
        SSNType ssnType = this.getLookupService().getSSNTypeByCode(code);
        Set ssns = person.getSsns();
        if (ssns != null && ssnType != null) {
            for (SSN ssnValue : ssns) {
                if (!ssnValue.getType().getCode().equals(ssnType.getCode())) continue;
                return ssnValue;
            }
        }
        return null;
    }

    @Override
    public boolean isNonVeteranEligibilityCode(String code) {
        boolean equal = false;
        for (int i = 0; i < EligibilityType.NON_VETERANS.length; ++i) {
            if (!EligibilityType.NON_VETERANS[i].getName().equals(code)) continue;
            equal = true;
            break;
        }
        return equal;
    }

    @Override
    public Person uploadData(Person onSitePerson, Person onFilePerson) throws ServiceException {
        Validate.notNull((Object)((Object)onSitePerson), (String)"A person from a site must not be null");
        Validate.notNull((Object)((Object)onFilePerson), (String)"A person on file must not be null");
        this.mergeServiceConnectionAward(onSitePerson, onFilePerson);
        try {
            MonetaryBenefitAward siteBenefitAward = onSitePerson.getMonetaryBenefitAward();
            MonetaryBenefitAward onFileBenefitAward = onFilePerson.getMonetaryBenefitAward();
            if (siteBenefitAward != null && onFileBenefitAward != null) {
                onFilePerson.setMonetaryBenefitAward((MonetaryBenefitAward)((Object)siteBenefitAward.clone()));
            }
            IncompetenceRuling siteIncompetence = onSitePerson.getIncompetenceRuling();
            IncompetenceRuling onFileIncompetence = onFilePerson.getIncompetenceRuling();
            if (siteIncompetence != null && onFileIncompetence != null) {
                onFilePerson.setIncompetenceRuling((IncompetenceRuling)((Object)siteIncompetence.clone()));
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed to upload data", (Throwable)e);
        }
        return onFilePerson;
    }

    @Override
    public void setAACIndicator(String code, Person person) throws ServiceException {
        Validate.notNull((Object)code, (String)"An AAC Indicator code must not be NULL");
        this.setAACIndicator(this.lookupService.getAACIndicatorByCode(code), person);
    }

    public void setAACIndicator(AACIndicator code, Person person) throws ServiceException {
        Validate.notNull((Object)((Object)code), (String)"An AAC Indicator code must not be NULL");
        if (person.getEligibilityVerification() == null) {
            EligibilityVerification eligibilityVerification = new EligibilityVerification();
            person.setEligibilityVerification(eligibilityVerification);
        }
        person.getEligibilityVerification().setAacIndicator(code);
    }

    @Override
    public void setEligibilityStatus(String code, Person person) throws ServiceException {
        EligibilityVerification eligibility = person.getEligibilityVerification();
        if (eligibility == null) {
            eligibility = new EligibilityVerification();
            person.setEligibilityVerification(eligibility);
        }
        if (code != null) {
            eligibility.setEligibilityStatus(this.getLookupService().getEligibilityStatusByCode(code));
        } else {
            eligibility.setEligibilityStatus(null);
        }
    }

    @Override
    public void setEligStatusPendingVerficationReason(String code, Person person) throws ServiceException {
        EligibilityVerification eligibility = person.getEligibilityVerification();
        if (eligibility == null) {
            eligibility = new EligibilityVerification();
            person.setEligibilityVerification(eligibility);
        }
        if (code != null) {
            eligibility.setEligStatusPendingVerficationReason(this.getLookupService().getEligibilityStatusReasonByCode(code));
        } else {
            eligibility.setEligStatusPendingVerficationReason(null);
        }
    }

    @Override
    public void setEnrollmentStatus(String code, Person person) throws ServiceException {
        if (person.getEnrollmentDetermination() != null) {
            person.getEnrollmentDetermination().setEnrollmentStatus(this.lookupService.getEnrollmentStatusByCode(code));
        }
    }

    @Override
    public void setEnrollmentStatus(String code, EnrollmentDetermination enrollment) throws ServiceException {
        if (enrollment != null) {
            enrollment.setEnrollmentStatus(this.lookupService.getEnrollmentStatusByCode(code));
        }
    }

    @Override
    public void setInitialEnrollmentPriority(String code, EnrollmentDetermination enrollmentDetermination) throws ServiceException, IllegalArgumentException {
        Validate.notNull((Object)code, (String)"An enrollment priority group code must not be NULL");
        Validate.notNull((Object)((Object)enrollmentDetermination), (String)"An enrollment determination must not be null");
        enrollmentDetermination.setInitialPriorityGroup(this.getEnrollmentPriority(code));
    }

    @Override
    public void setInitialEnrollmentPrioritySubGroup(String code, EnrollmentDetermination enrollmentDetermination) throws ServiceException, IllegalArgumentException {
        Validate.notNull((Object)code, (String)"An enrollment priority sub group code must not be NULL");
        Validate.notNull((Object)((Object)enrollmentDetermination), (String)"An enrollment determination must not be null");
        enrollmentDetermination.setInitialPrioritySubGroup(this.lookupService.getEnrollmentPrioritySubGroupByCode(code));
    }

    @Override
    public void setPurpleHeartStatus(String code, Person person) throws ServiceException {
        PurpleHeart purpleHeart = this.getPurpleHeart(person);
        if (purpleHeart != null) {
            purpleHeart.setStatus(this.lookupService.getDecorationStatusByCode(code));
        }
    }

    @Override
    public MonetaryBenefit addVAPension(Person person) throws ServiceException {
        return this.addMonetaryBenefit(MonetaryBenefitType.CODE_VA_PENSION.getName(), person);
    }

    @Override
    public MonetaryBenefit addAABenefit(Person person) throws ServiceException {
        return this.addMonetaryBenefit(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName(), person);
    }

    @Override
    public void removeAABenefit(Person person) throws ServiceException {
        this.removeMonetaryBenefit(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName(), person);
    }

    @Override
    public MonetaryBenefit addHouseboundBenefit(Person person) throws ServiceException {
        return this.addMonetaryBenefit(MonetaryBenefitType.CODE_HOUSEBOUND.getName(), person);
    }

    @Override
    public void removeHouseboundBenefit(Person person) throws ServiceException {
        this.removeMonetaryBenefit(MonetaryBenefitType.CODE_HOUSEBOUND.getName(), person);
    }

    @Override
    public MonetaryBenefit addVADisability(Person person) throws ServiceException {
        return this.addMonetaryBenefit(MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getName(), person);
    }

    @Override
    public void setVerificationSource(String code, Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        EligibilityVerification eligibilityVerification = person.getEligibilityVerification();
        if (eligibilityVerification == null) {
            eligibilityVerification = new EligibilityVerification();
            person.setEligibilityVerification(eligibilityVerification);
        }
        EligibilityVerificationSource source = code != null ? this.lookupService.getEligibilityVerificationSourceByCode(code) : null;
        eligibilityVerification.setVerificationSource(source);
    }

    @Override
    public void setVerificationFacility(String code, Person person) throws ServiceException {
        Validate.notNull((Object)code, (String)"A verification facility code must not be NULL");
        VAFacility facility = this.lookupService.getVaFacilityByCode(code);
        this.setVerificationFacility(facility, person);
    }

    @Override
    public void setVerificationFacility(VAFacility facility, Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        EligibilityVerification eligibilityVerification = person.getEligibilityVerification();
        if (eligibilityVerification == null) {
            eligibilityVerification = new EligibilityVerification();
            person.setEligibilityVerification(eligibilityVerification);
        }
        eligibilityVerification.setVerificationFacility(facility);
    }

    @Override
    public void setVerificationMethod(String method, Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        EligibilityVerification eligibilityVerification = person.getEligibilityVerification();
        if (eligibilityVerification == null) {
            eligibilityVerification = new EligibilityVerification();
            person.setEligibilityVerification(eligibilityVerification);
        }
        eligibilityVerification.setVerificationMethod(method);
    }

    @Override
    public void setEligStatusPendingVerfReasonExplain(String eligStatusPendingVerfReasonExplain, Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        EligibilityVerification eligibilityVerification = person.getEligibilityVerification();
        if (eligibilityVerification == null) {
            eligibilityVerification = new EligibilityVerification();
            person.setEligibilityVerification(eligibilityVerification);
        }
        eligibilityVerification.setEligStatusPendingVerfReasonExplain(eligStatusPendingVerfReasonExplain);
    }

    @Override
    public void setEnrollmentPrioritySubGroup(String code, EnrollmentDetermination enrollmentDetermination) throws ServiceException {
        Validate.notNull((Object)code, (String)"An enrollment priority sub group code must not be NULL");
        Validate.notNull((Object)((Object)enrollmentDetermination), (String)"An enrollment determination must not be null");
        enrollmentDetermination.setPrioritySubGroup(this.getEnrollmentPrioritySubGroup(code));
    }

    @Override
    public void setEnrollmentPriority(String code, EnrollmentDetermination enrollmentDetermination) throws ServiceException {
        Validate.notNull((Object)code, (String)"An enrollment priority group code must not be NULL");
        Validate.notNull((Object)((Object)enrollmentDetermination), (String)"An enrollment determination must not be null");
        enrollmentDetermination.setPriorityGroup(this.getEnrollmentPriority(code));
    }

    @Override
    public Eligibility createEligibility(String code) throws ServiceException {
        Validate.notNull((Object)code, (String)"An eligibility code must not be NULL");
        Eligibility eligibility = new Eligibility();
        eligibility.setType(this.lookupService.getEligibilityTypeByCode(code));
        return eligibility;
    }

    @Override
    public Eligibility createOtherEligibility(String code) throws ServiceException {
        Validate.notNull((Object)code, (String)"An eligibility code must not be NULL");
        Eligibility eligibility = new Eligibility();
        eligibility.setFactor((EligibilityFactor)this.getLookupService().getByCode(EligibilityFactor.class, code));
        return eligibility;
    }

    @Override
    public void setEnrollmentCategory(String category, Person person) throws ServiceException {
        if (person.getEnrollmentDetermination() != null && person.getEnrollmentDetermination().getEnrollmentStatus() != null) {
            person.getEnrollmentDetermination().getEnrollmentStatus().setEnrollmentCategory(this.lookupService.getEnrollmentCategoryByCode(category));
        }
    }

    @Override
    public void setEnrollmentCategory(String category, EnrollmentDetermination enrollment) throws ServiceException {
        if (enrollment != null && enrollment.getEnrollmentStatus() != null) {
            enrollment.getEnrollmentStatus().setEnrollmentCategory(this.lookupService.getEnrollmentCategoryByCode(category));
        }
    }

    @Override
    public void setEnrollmentSource(String source, EnrollmentDetermination enrollment) throws ServiceException {
        Validate.notNull((Object)source, (String)"A source must not be null");
        enrollment.setCalculationSource(this.getLookupService().getEnrollmentSourceByCode(source));
    }

    @Override
    public void setFacilityReceivedFrom(String facility, EnrollmentDetermination enrollment) throws ServiceException {
        Validate.notNull((Object)((Object)enrollment), (String)"An enrollment must not be null");
        if (facility == null) {
            enrollment.setFacilityReceived(null);
        } else {
            enrollment.setFacilityReceived(this.getLookupService().getVaFacilityByStationNumber(facility));
        }
    }

    @Override
    public EnrollmentDetermination getEnrollmentDetermination(Person person) {
        return person.getEnrollmentDetermination();
    }

    @Override
    public PurpleHeart getPurpleHeart(Person person) {
        Set setOfDecoration;
        PurpleHeart purpleHeart = null;
        if (person != null && (setOfDecoration = person.getDecorations()) != null && setOfDecoration.size() > 0) {
            for (Decoration decoration : setOfDecoration) {
                if (decoration == null || !(decoration instanceof PurpleHeart)) continue;
                purpleHeart = (PurpleHeart)decoration;
                break;
            }
        }
        return purpleHeart;
    }

    @Override
    public ClinicalDetermination getClinicalDetermination(Class classObject, Person person) {
        if (person == null) {
            return null;
        }
        Set clinicalDeterminations = person.getClinicalDeterminations();
        ClinicalDetermination clinicalDetermination = null;
        if (clinicalDeterminations != null && clinicalDeterminations.size() > 0) {
            for (ClinicalDetermination temp : clinicalDeterminations) {
                if (temp == null || !((Object)((Object)temp)).getClass().isAssignableFrom(classObject)) continue;
                clinicalDetermination = temp;
                break;
            }
        }
        return clinicalDetermination;
    }

    @Override
    public void setRejectionRemark(String remark, PurpleHeart purpleHeart) throws ServiceException {
        Validate.notNull((Object)purpleHeart, (String)"A Purple Heart must not be null");
        purpleHeart.setRejectionRemark(this.getLookupService().getRejectionRemarkByCode(remark));
    }

    protected MonetaryBenefit addMonetaryBenefit(String code, Person person) throws ServiceException {
        MonetaryBenefit monetaryBenefit = this.getMonetaryBenefit(code, person);
        if (monetaryBenefit == null) {
            MonetaryBenefitAward monetaryBenefitAward = person.getMonetaryBenefitAward();
            if (monetaryBenefitAward == null) {
                monetaryBenefitAward = new MonetaryBenefitAward();
                person.setMonetaryBenefitAward(monetaryBenefitAward);
            }
            monetaryBenefit = this.createMonetaryBenefit(code);
            monetaryBenefitAward.addMonetaryBenefit(monetaryBenefit);
        }
        return monetaryBenefit;
    }

    protected void removeMonetaryBenefit(String code, Person person) throws ServiceException {
        MonetaryBenefit monetaryBenefit = this.getMonetaryBenefit(code, person);
        if (monetaryBenefit != null) {
            person.getMonetaryBenefitAward().removeMonetaryBenefit(monetaryBenefit);
        }
    }

    protected MonetaryBenefit getMonetaryBenefit(String type, Person person) throws ServiceException {
        MonetaryBenefitType mbt;
        Validate.notNull((Object)type, (String)"A type must not be null");
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        MonetaryBenefit mb = null;
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        if (mba != null && (mbt = this.lookupService.getMonetaryBenefitTypeByCode(type)) != null) {
            Set benefits = mba.getMonetaryBenefits();
            for (MonetaryBenefit benefit : benefits) {
                if (!benefit.getType().getCode().equals(mbt.getCode())) continue;
                mb = benefit;
                break;
            }
        }
        return mb;
    }

    protected MonetaryBenefit createMonetaryBenefit(String code) throws ServiceException {
        Validate.notNull((Object)code, (String)"A monetary benefit type code must not be null");
        MonetaryBenefit monetaryBenefit = new MonetaryBenefit();
        monetaryBenefit.setType(this.lookupService.getMonetaryBenefitTypeByCode(code));
        return monetaryBenefit;
    }

    protected IncompetenceRuling createIncompetenceRuling() {
        IncompetenceRuling incompetenceRuling = new IncompetenceRuling();
        return incompetenceRuling;
    }

    protected void mergeServiceConnectionAward(Person source, Person destination) {
        ServiceConnectionAward incoming = source.getServiceConnectionAward();
        ServiceConnectionAward onFile = destination.getServiceConnectionAward();
        if (incoming != null) {
            if (onFile == null) {
                onFile = new ServiceConnectionAward();
            }
            onFile.setPermanentAndTotal(incoming.isPermanentAndTotal());
            onFile.setServiceConnectedPercentage(incoming.getServiceConnectedPercentage());
            onFile.setUnemployable(incoming.isUnemployable());
            onFile.setAwardDate(incoming.getAwardDate() != null ? (ImpreciseDate)incoming.getAwardDate().clone() : null);
            Set currRatedDisabilities = onFile.getRatedDisabilities();
            Set inRatedDisabilities = incoming.getRatedDisabilities();
            if (inRatedDisabilities != null && inRatedDisabilities.size() > 0) {
                currRatedDisabilities.clear();
                for (RatedDisability ratedDisability : inRatedDisabilities) {
                    RatedDisability newRatedDisability = new RatedDisability();
                    newRatedDisability.setDisability(ratedDisability.getDisability());
                    newRatedDisability.setPercentage(ratedDisability.getPercentage());
                    newRatedDisability.setServiceConnected(ratedDisability.isServiceConnected());
                    currRatedDisabilities.add(newRatedDisability);
                }
            }
            destination.setServiceConnectionAward(onFile);
        } else {
            destination.setServiceConnectionAward(null);
        }
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public PersonTraitsDAO getPersonTraitsDAO() {
        return this.personTraitsDAO;
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public void setPersonTraitsDAO(PersonTraitsDAO personTraitsDAO) {
        this.personTraitsDAO = personTraitsDAO;
    }

    private EnrollmentPrioritySubGroup getEnrollmentPrioritySubGroup(String code) throws ServiceException {
        Validate.notNull((Object)code, (String)"An enrollment priority sub group code must not be NULL");
        return this.lookupService.getEnrollmentPrioritySubGroupByCode(code);
    }

    private EnrollmentPriorityGroup getEnrollmentPriority(String code) throws ServiceException {
        Validate.notNull((Object)code, (String)"An enrollment priority group code must not be NULL");
        return this.lookupService.getEnrollmentPriorityGroupByCode(code);
    }

    @Override
    public IncomeTest getCurrentIncomeTest(Person person) {
        return this.doGetCurrentIncomeTest(person, CONTEXT_FINANCIALS);
    }

    @Override
    public IncomeTest getCurrentIncomeTestForEE(Person person) {
        return this.doGetCurrentIncomeTest(person, CONTEXT_EE);
    }

    private IncomeTest doGetCurrentIncomeTest(Person person, String context) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1999, 10, 5);
        Date incomeTestCompletionDateTest = calendar.getTime();
        Map incomeTests = person.getIncomeTests();
        ArrayList incomeYears = new ArrayList(incomeTests.keySet());
        if (incomeYears == null || incomeYears.isEmpty()) {
            return null;
        }
        Collections.sort(incomeYears);
        for (int i = incomeYears.size() - 1; i >= 0; --i) {
            IncomeTestStatus incomeStatus;
            Integer incomeYear = (Integer)incomeYears.get(i);
            IncomeTest incomeTest = (IncomeTest)((Object)incomeTests.get(incomeYear));
            Date effectiveDate = incomeTest.getEffectiveDate();
            GregorianCalendar expiryDate = null;
            if (effectiveDate != null) {
                expiryDate = new GregorianCalendar();
                expiryDate.setTime(effectiveDate);
                expiryDate.add(1, 1);
            }
            Date incomeTestCompleted = incomeTest.getCompletedDate();
            MeansTestStatus meansTestStatus = incomeTest.getStatus();
            BigDecimal gmtThreshold = incomeTest.getGmtThresholdAmount();
            BigDecimal meansTestThreshold = incomeTest.getThresholdA();
            Boolean agreesToPayDeductable = incomeTest.getAgreesToPayDeductible();
            Boolean discloseFinancialInformation = incomeTest.getDiscloseFinancialInformation();
            Date today = new Date();
            if (effectiveDate != null && effectiveDate.getTime() > today.getTime()) continue;
            if (incomeTestCompleted != null && expiryDate != null && expiryDate.getTime().getTime() > today.getTime()) {
                return incomeTest;
            }
            if (meansTestStatus != null && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName().equals(meansTestStatus.getCode()) && incomeTestCompleted != null && incomeTestCompleted.after(incomeTestCompletionDateTest) && Boolean.TRUE.equals(agreesToPayDeductable)) {
                return incomeTest;
            }
            if (meansTestStatus != null && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName().equals(meansTestStatus.getCode()) && Boolean.TRUE.equals(agreesToPayDeductable) && Boolean.FALSE.equals(discloseFinancialInformation)) {
                return incomeTest;
            }
            if (meansTestStatus != null && MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName().equals(meansTestStatus.getCode()) && gmtThreshold != null && meansTestThreshold != null && gmtThreshold.compareTo(meansTestThreshold) <= 0 && incomeTestCompleted != null && incomeTestCompleted.after(incomeTestCompletionDateTest) && Boolean.TRUE.equals(agreesToPayDeductable) && Boolean.TRUE.equals(discloseFinancialInformation)) {
                return incomeTest;
            }
            if (CONTEXT_EE.equals(context) && (incomeStatus = IncomeTest.getIncomeTestStatusOfType(incomeTest.getStatuses(), IncomeTestType.CODE_MEANS_TEST)) != null && incomeStatus.getStatus() != null && incomeStatus.getDeterminedStatus() != null && MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED.getName().equals(incomeStatus.getStatus().getCode()) && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName().equals(incomeStatus.getDeterminedStatus().getCode())) {
                return incomeTest;
            }
            if (expiryDate != null && expiryDate.getTime().getTime() < today.getTime() && meansTestStatus != null && (MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName().equals(meansTestStatus.getCode()) || MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName().equals(meansTestStatus.getCode()) || MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName().equals(meansTestStatus.getCode())) && Boolean.FALSE.equals(agreesToPayDeductable)) {
                return incomeTest;
            }
            if (this.isCurrentByVfaCriteria(incomeTest, expiryDate, meansTestStatus, incomeTestCompleted, effectiveDate)) {
                return incomeTest;
            }
            return null;
        }
        return null;
    }

    @Override
    public IncomeTest getLatestIncomeTest(Person person) {
        Map incomeTests = person.getIncomeTests();
        ArrayList incomeYears = new ArrayList(incomeTests.keySet());
        if (incomeYears != null && !incomeYears.isEmpty()) {
            Collections.sort(incomeYears);
            return (IncomeTest)((Object)incomeTests.get(incomeYears.get(incomeYears.size() - 1)));
        }
        return null;
    }

    @Override
    public State getStateFromCodeOrName(String stateNameOrCode) throws ServiceException {
        State state = null;
        try {
            state = this.lookupService.getStateByCode(stateNameOrCode);
        }
        catch (ServiceException e) {
            state = this.lookupService.getStateByName(stateNameOrCode);
        }
        return state;
    }

    @Override
    public String getICNChecksum(String VPIDValue) {
        if (VPIDValue == null) {
            return null;
        }
        StringBuffer ICNCheckSum = new StringBuffer(VPIDValue);
        String paddedZeroes = "000000";
        if (ICNCheckSum.substring(0, 6).equals(paddedZeroes)) {
            ICNCheckSum = ICNCheckSum.delete(0, 6);
        }
        if (ICNCheckSum.substring(ICNCheckSum.length() - 6, ICNCheckSum.length()).equals(paddedZeroes)) {
            ICNCheckSum = ICNCheckSum.delete(ICNCheckSum.length() - 6, ICNCheckSum.length());
        }
        return ICNCheckSum.toString();
    }

    @Override
    public List sortLastVisitDateRecentToOld(Collection patientVisitSummaries) {
        ArrayList sortedPatientVisitSummaries = new ArrayList();
        if (patientVisitSummaries != null && !patientVisitSummaries.isEmpty()) {
            sortedPatientVisitSummaries.addAll(patientVisitSummaries);
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    Date date1 = pObject1 instanceof PatientVisitSummary ? ((PatientVisitSummary)((Object)pObject1)).getLastVisitDate() : null;
                    Date date2 = pObject2 instanceof PatientVisitSummary ? ((PatientVisitSummary)((Object)pObject2)).getLastVisitDate() : null;
                    return date1 != null && date2 != null ? -date1.compareTo(date2) : 0;
                }
            };
            Collections.sort(sortedPatientVisitSummaries, comparator);
        }
        return sortedPatientVisitSummaries;
    }

    @Override
    public ServicePeriod getCurrentServicePeriod(MilitaryService militaryService) {
        ServicePeriod servicePeriod = null;
        if (militaryService == null) {
            return null;
        }
        MilitaryServiceSiteRecord hecSiteRecord = militaryService.getHECMilitaryServiceSiteRecord();
        if (hecSiteRecord != null && hecSiteRecord.getServicePeriod() != null) {
            servicePeriod = hecSiteRecord.getServicePeriod();
        } else if (militaryService.getMilitaryServiceSiteRecords() != null && militaryService.getMilitaryServiceSiteRecords().size() == 1) {
            MilitaryServiceSiteRecord siteRecord = (MilitaryServiceSiteRecord)((Object)militaryService.getMilitaryServiceSiteRecords().iterator().next());
            servicePeriod = siteRecord.getServicePeriod();
        } else if (militaryService.getMilitaryServiceSiteRecords() != null && militaryService.getMilitaryServiceSiteRecords().size() > 1) {
            Set siteRecords = militaryService.getMilitaryServiceSiteRecords();
            ServicePeriod servicePeriodFromSites = this.getSameServicePeriod(siteRecords);
            servicePeriod = servicePeriodFromSites != null ? servicePeriodFromSites : this.getMostCurrentPOS(siteRecords);
        }
        return servicePeriod;
    }

    private ServicePeriod getMostCurrentPOS(Set siteRecords) {
        ArrayList<ServicePeriod> servicePeriods = new ArrayList<ServicePeriod>();
        int index = 0;
        int persianGulfServicePeriodPos = index++;
        int vietnamServicePeriodPos = index++;
        int koreanServicePeriodPos = index++;
        int worldWarTwoServicePeriodPos = index++;
        int merchantMarineServicePeriodPos = index++;
        int worldWarOneServicePeriodPos = index++;
        int spanishAmericanServicePeriodPos = index++;
        int postVietnamEraServicePeriodPos = index++;
        int postKoreanServicePeriodPos = index++;
        int preKoreanServicePeriodPos = index;
        for (int i = 0; i <= index; ++i) {
            servicePeriods.add(i, null);
        }
        for (MilitaryServiceSiteRecord siteRecord : siteRecords) {
            ServicePeriod currentServicePeriod = siteRecord.getServicePeriod();
            if (currentServicePeriod != null && ServicePeriod.CODE_PERSIAN_GULF_WAR.getCode().equals(currentServicePeriod.getCode())) {
                servicePeriods.add(persianGulfServicePeriodPos, currentServicePeriod);
                continue;
            }
            if (currentServicePeriod != null && ServicePeriod.CODE_VIETNAM_ERA.getCode().equals(currentServicePeriod.getCode())) {
                servicePeriods.add(vietnamServicePeriodPos, currentServicePeriod);
                continue;
            }
            if (currentServicePeriod != null && ServicePeriod.CODE_KOREAN.getCode().equals(currentServicePeriod.getCode())) {
                servicePeriods.add(koreanServicePeriodPos, currentServicePeriod);
                continue;
            }
            if (currentServicePeriod != null && ServicePeriod.CODE_WORLD_WAR_II.getCode().equals(currentServicePeriod.getCode())) {
                servicePeriods.add(worldWarTwoServicePeriodPos, currentServicePeriod);
                continue;
            }
            if (currentServicePeriod != null && ServicePeriod.CODE_MERCHANT_MARINE.getCode().equals(currentServicePeriod.getCode())) {
                servicePeriods.add(merchantMarineServicePeriodPos, currentServicePeriod);
                continue;
            }
            if (currentServicePeriod != null && ServicePeriod.CODE_WORLD_WAR_I.getCode().equals(currentServicePeriod.getCode())) {
                servicePeriods.add(worldWarOneServicePeriodPos, currentServicePeriod);
                continue;
            }
            if (currentServicePeriod != null && ServicePeriod.CODE_SPANISH_AMERICAN.getCode().equals(currentServicePeriod.getCode())) {
                servicePeriods.add(spanishAmericanServicePeriodPos, currentServicePeriod);
                continue;
            }
            if (currentServicePeriod != null && ServicePeriod.CODE_POST_VIETNAM.getCode().equals(currentServicePeriod.getCode())) {
                servicePeriods.add(postVietnamEraServicePeriodPos, currentServicePeriod);
                continue;
            }
            if (currentServicePeriod != null && ServicePeriod.CODE_POST_KOREAN.getCode().equals(currentServicePeriod.getCode())) {
                servicePeriods.add(postKoreanServicePeriodPos, currentServicePeriod);
                continue;
            }
            if (currentServicePeriod == null || !ServicePeriod.CODE_PRE_KOREAN.getCode().equals(currentServicePeriod.getCode())) continue;
            servicePeriods.add(preKoreanServicePeriodPos, currentServicePeriod);
        }
        ServicePeriod servicePeriod = null;
        for (ServicePeriod currentServicePeriod : servicePeriods) {
            if (currentServicePeriod == null) continue;
            servicePeriod = currentServicePeriod;
            break;
        }
        return servicePeriod;
    }

    private ServicePeriod getSameServicePeriod(Set militaryServiceSiteRecords) {
        ServicePeriod servicePeriod = null;
        boolean isSamePOS = true;
        ServicePeriod currentServicePeriod = null;
        ServicePeriod servicePeriodOrig = null;
        for (MilitaryServiceSiteRecord siteRecord : militaryServiceSiteRecords) {
            currentServicePeriod = siteRecord.getServicePeriod();
            if (currentServicePeriod != null && servicePeriodOrig == null) {
                servicePeriodOrig = currentServicePeriod;
                continue;
            }
            if (currentServicePeriod == null || servicePeriodOrig == null || currentServicePeriod.getCode().equals(servicePeriodOrig.getCode())) continue;
            isSamePOS = false;
            break;
        }
        if (isSamePOS) {
            servicePeriod = currentServicePeriod;
        }
        return servicePeriod;
    }

    @Override
    public PersonTraits getPersonTraitsByVPID(String VPID2) throws ServiceException {
        VPIDEntityKey vpidKey = CommonEntityKeyFactory.createVPIDEntityKey(VPID2);
        PersonIdentityTraits identityTraits = this.psDelegateService.getIdentityTraits(vpidKey);
        PersonTraits personTraits = new PersonTraits();
        personTraits.setTraits(identityTraits);
        return personTraits;
    }

    @Override
    public MilitaryServiceQueryStatus getMSDSQueryStatus(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        return person.getMilitaryService() != null ? person.getMilitaryService().getMilitaryServiceQueryStatus() : null;
    }

    @Override
    public IncomeTest getCurrentOrFutureIncomeTest(Person person, Person pristinePerson) {
        return this.doGetCurrentOrFutureIncomeTest(person, pristinePerson, CONTEXT_FINANCIALS);
    }

    private IncomeTest doGetCurrentOrFutureIncomeTest(Person person, Person pristinePerson, String context) {
        int i;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1999, 10, 5);
        Date incomeTestCompletionDateTest = calendar.getTime();
        Map incomeTests = person.getIncomeTests();
        Map pristineIncomeTests = pristinePerson.getIncomeTests();
        ArrayList incomeYears = new ArrayList(incomeTests.keySet());
        if (incomeYears == null || incomeYears.isEmpty()) {
            return null;
        }
        ArrayList pristineIncomeYears = new ArrayList(pristineIncomeTests.keySet());
        if (pristineIncomeYears == null || pristineIncomeYears.isEmpty()) {
            return null;
        }
        Collections.sort(incomeYears);
        Collections.sort(pristineIncomeYears);
        ArrayList incomingIncomeYears = new ArrayList(incomeTests.keySet());
        Collections.sort(incomingIncomeYears);
        incomingIncomeYears.removeAll(pristineIncomeYears);
        if (incomingIncomeYears == null || incomingIncomeYears.isEmpty()) {
            return null;
        }
        if (incomingIncomeYears.size() != 1) {
            return null;
        }
        Integer incomingIncomeYear = null;
        IncomeTest incomingIncomeTest = null;
        for (i = incomingIncomeYears.size() - 1; i >= 0; --i) {
            incomingIncomeYear = (Integer)incomingIncomeYears.get(i);
            incomingIncomeTest = (IncomeTest)((Object)incomeTests.get(incomingIncomeYear));
        }
        for (i = incomeYears.size() - 1; i >= 0; --i) {
            IncomeTestStatus incomeStatus;
            Integer incomeYear = (Integer)incomeYears.get(i);
            IncomeTest incomeTest = (IncomeTest)((Object)incomeTests.get(incomeYear));
            Date effectiveDate = incomeTest.getEffectiveDate();
            GregorianCalendar expiryDate = null;
            if (effectiveDate != null) {
                expiryDate = new GregorianCalendar();
                expiryDate.setTime(effectiveDate);
                expiryDate.add(1, 1);
            }
            Date incomeTestCompleted = incomeTest.getCompletedDate();
            MeansTestStatus meansTestStatus = incomeTest.getStatus();
            BigDecimal gmtThreshold = incomeTest.getGmtThresholdAmount();
            BigDecimal meansTestThreshold = incomeTest.getThresholdA();
            Boolean agreesToPayDeductable = incomeTest.getAgreesToPayDeductible();
            Boolean discloseFinancialInformation = incomeTest.getDiscloseFinancialInformation();
            Date today = new Date();
            if (effectiveDate != null && effectiveDate.getTime() > today.getTime()) {
                if (!incomeYear.equals(incomingIncomeYear) || incomeTest.isFutureTest() == null || !incomeTest.isFutureTest().booleanValue()) continue;
                return incomeTest;
            }
            if (incomeTestCompleted != null && expiryDate != null && expiryDate.getTime().getTime() > today.getTime()) {
                return incomeTest;
            }
            if (meansTestStatus != null && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName().equals(meansTestStatus.getCode()) && incomeTestCompleted != null && incomeTestCompleted.after(incomeTestCompletionDateTest) && Boolean.TRUE.equals(agreesToPayDeductable)) {
                return incomeTest;
            }
            if (meansTestStatus != null && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName().equals(meansTestStatus.getCode()) && Boolean.TRUE.equals(agreesToPayDeductable) && Boolean.FALSE.equals(discloseFinancialInformation)) {
                return incomeTest;
            }
            if (meansTestStatus != null && MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName().equals(meansTestStatus.getCode()) && gmtThreshold != null && meansTestThreshold != null && gmtThreshold.compareTo(meansTestThreshold) <= 0 && incomeTestCompleted != null && incomeTestCompleted.after(incomeTestCompletionDateTest) && Boolean.TRUE.equals(agreesToPayDeductable) && Boolean.TRUE.equals(discloseFinancialInformation)) {
                return incomeTest;
            }
            if (CONTEXT_EE.equals(context) && (incomeStatus = IncomeTest.getIncomeTestStatusOfType(incomeTest.getStatuses(), IncomeTestType.CODE_MEANS_TEST)) != null && incomeStatus.getStatus() != null && incomeStatus.getDeterminedStatus() != null && MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED.getName().equals(incomeStatus.getStatus().getCode()) && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName().equals(incomeStatus.getDeterminedStatus().getCode())) {
                return incomeTest;
            }
            if (expiryDate != null && expiryDate.getTime().getTime() < today.getTime() && meansTestStatus != null && (MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName().equals(meansTestStatus.getCode()) || MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName().equals(meansTestStatus.getCode()) || MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName().equals(meansTestStatus.getCode())) && Boolean.FALSE.equals(agreesToPayDeductable)) {
                return incomeTest;
            }
            if (this.isCurrentByVfaCriteria(incomeTest, expiryDate, meansTestStatus, incomeTestCompleted, effectiveDate)) {
                return incomeTest;
            }
            return null;
        }
        return null;
    }

    private boolean isCurrentByVfaCriteria(IncomeTest incomeTest, GregorianCalendar expiryDate, MeansTestStatus meansTestStatus, Date incomeTestCompleted, Date effectiveDate) {
        boolean futureFlag;
        Date vfaStartDate = null;
        try {
            SystemParameterService systemParameterService = (SystemParameterService)this.getComponent(this.getSystemParameterServiceName());
            vfaStartDate = systemParameterService.getVFAStartDate();
        }
        catch (Exception e) {
            this.logger.error((Object)"error retrieving VFA Start Date from systemParameterService");
        }
        boolean bl = futureFlag = incomeTest.getFutureTest() != null ? incomeTest.getFutureTest() : false;
        if (!futureFlag && incomeTestCompleted != null && vfaStartDate != null) {
            boolean mtStatusCriteriaMet = meansTestStatus != null && (MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getName().equals(meansTestStatus.getCode()) || MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName().equals(meansTestStatus.getCode()) || MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName().equals(meansTestStatus.getCode()) || MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName().equals(meansTestStatus.getCode()));
            GregorianCalendar vfaUmbrellaStartDate = null;
            if (vfaStartDate != null) {
                vfaUmbrellaStartDate = new GregorianCalendar();
                vfaUmbrellaStartDate.setTime(vfaStartDate);
                vfaUmbrellaStartDate.add(1, -1);
            }
            if (effectiveDate != null && vfaUmbrellaStartDate != null && effectiveDate.getTime() >= vfaUmbrellaStartDate.getTime().getTime()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addToSSNVerificationQueue(Person person) throws ServiceException {
        if (person == null || person.getEntityKey() == null) {
            return;
        }
        try {
            SSNVerificationDetail detail = this.getSsnVerificationDetailDAO().getSSNVerificationDetailByPersonId(new BigDecimal(person.getEntityKey().getKeyValueAsString()));
            if (detail == null) {
                detail = new SSNVerificationDetail();
                detail.setPersonId(new BigDecimal(person.getEntityKey().getKeyValueAsString()));
                this.getGenericDAO().insertObject((Object)detail);
            }
        }
        catch (DAOException dex) {
            throw new ServiceException((Throwable)dex);
        }
    }

    public PersonTraits getPersonIDsByVPID(String VPID2) throws ServiceException {
        VPIDEntityKey vpidKey = CommonEntityKeyFactory.createVPIDEntityKey(VPID2);
        PersonIdentityTraits identityTraits = this.psDelegateService.getIdentityTraits(vpidKey);
        PersonTraits personTraits = new PersonTraits();
        personTraits.setTraits(identityTraits);
        return personTraits;
    }

    @Override
    public String getVhicIdByVPID(String VPID2) throws ServiceException {
        VPIDEntityKey vpidKey = CommonEntityKeyFactory.createVPIDEntityKey(VPID2);
        String vhicId = this.psDelegateService.getVhicId(vpidKey);
        return vhicId;
    }

    public String getSystemParameterServiceName() {
        return this.systemParameterServiceName;
    }

    public void setSystemParameterServiceName(String systemParameterServiceName) {
        this.systemParameterServiceName = systemParameterServiceName;
    }
}

