/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.batchprocess.LoadVSSCDataResult;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.lookup.CampLejeuneChangeSource;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MilitaryServiceQueryStatus;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.rule.service.EventRuleService;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.MilitaryInfoService;
import gov.va.med.esr.service.MsdsResponseInfo;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.service.WorkflowService;
import gov.va.med.esr.service.impl.AbstractHistoricalInfoServiceImpl;
import gov.va.med.esr.service.impl.AddProxyPreferredFacilityException;
import gov.va.med.esr.service.impl.VOAApplicationServiceImpl;
import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class MilitaryInfoServiceImpl
extends AbstractHistoricalInfoServiceImpl
implements MilitaryInfoService {
    public static final String PUNCTUATION_CHARS = "[,.'`]";
    private static final long serialVersionUID = -76551275928447239L;
    private static final ImpreciseDate startday = new ImpreciseDate("19530801");
    private static final ImpreciseDate endday = new ImpreciseDate("19871231");
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;
    private RegistryService registryService = null;
    private WorkflowService workflowService = null;
    private TriggerEventCacheManager triggerEventCacheManager;
    private MessagingService messagingService = null;

    @Override
    public Set getHistoricalMilitaryServiceBySite(EntityKey key) throws ServiceException {
        return null;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Override
    public Person updateMilitaryServiceInformation(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An person to be updated must not be null ");
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson((PersonEntityKey)incoming.getEntityKey());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MilInfoServiceImpl updateSvcInfo : person: " + (Object)((Object)incoming)));
        }
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.validateEnrollmentDetermination(onFile);
        this.getEligibilityFactorRuleService().manageSpecialFactors(incoming, onFile);
        Person updated = this.getMilitaryRuleService().manageMilitaryService(incoming.getMilitaryService(), onFile);
        updated = this.getEligibilityEnrollmentService().assessEEImpact(updated, false);
        updated.setEligibleForClassIIDental(incoming.getEligibleForClassIIDental());
        if (incoming.getEligibleForClassIIDental() != null && Boolean.FALSE.equals(incoming.getEligibleForClassIIDental())) {
            updated.setClassIIDentalApplicationDueBefore(null);
        }
        this.getEventRuleService().manageMessageEvents(onFile);
        SHAD incomingShad = incoming.getShad();
        if (incomingShad != null && onFile != null && incomingShad.getRegistryTrait() == null) {
            RegistryType regType = (RegistryType)this.getLookupService().getByCode(RegistryType.class, RegistryType.CODE_SHAD_REGISTRY.getCode());
            this.getRegistryService().linkPersonRegistry(incomingShad, onFile.getShad(), incoming, onFile, regType, true);
        }
        EventRuleService eventRuleService = this.getEventRuleService();
        eventRuleService.manageHandBookEvents(updated);
        return personService.save(updated);
    }

    @Override
    public Person updateCalculatePeriodOfService(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An person to be calculated must not be null ");
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson((PersonEntityKey)incoming.getEntityKey());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MilInfoServiceImpl caclPdOfSvc : person: " + (Object)((Object)incoming)));
        }
        this.getMilitaryRuleService().calculatePeriodOfServiceForUI(incoming, (Person)((Object)onFile.clone()), "MS");
        return incoming;
    }

    @Override
    public LoadVSSCDataResult processVSSCData(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"Person must not be null ");
        LoadVSSCDataResult result = new LoadVSSCDataResult();
        this.getPersonService().checkAndAddESRCorrelation(incoming);
        if (incoming.getEnrollmentDetermination() == null) {
            result.incrementCountNewPersonRejected(incoming.getMilitaryService().getCombatEpisodes().size());
            return result;
        }
        Person onFile = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        Person updated = this.getMilitaryRuleService().processVSSCData(incoming.getMilitaryService(), onFile, result);
        updated = this.getEligibilityEnrollmentService().assessEEImpact(updated, false);
        this.getEventRuleService().manageMessageEvents(onFile);
        this.getEventRuleService().manageHandBookEvents(onFile);
        this.getPersonService().save(updated);
        return result;
    }

    @Override
    public Person processMSDSData(Person incoming) throws ServiceException {
        MsdsResponseInfo info = new MsdsResponseInfo();
        info.setEsrPerson(incoming);
        return this.processMSDSData(info);
    }

    @Override
    public Person processMSDSData(MsdsResponseInfo response) throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MilitaryInfoServiceImpl processMSDSData : response: " + ToStringBuilder.reflectionToString((Object)response, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
        }
        Validate.notNull((Object)response, (String)"The MSDS response info must not be null ");
        Person incoming = null;
        PersonService personService = this.getPersonService();
        Person onFile = null;
        if (response.getEsrPerson() != null) {
            incoming = response.getEsrPerson();
            onFile = personService.getPerson(incoming.getPersonEntityKey());
        } else {
            onFile = personService.getPerson(response.getPersonEntityKey());
            Validate.notNull((Object)((Object)onFile), (String)"A person to be updated must not be null ");
            incoming = (Person)((Object)onFile.clone());
        }
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"A person to be updated must not be null ");
        Person tempOnFile = (Person)((Object)onFile.clone());
        boolean terminate = this.getMilitaryRuleService().processMSDSData(incoming, tempOnFile, response);
        this.triggerEventCacheManager.removeTriggerEvents();
        if (!terminate) {
            this.getEligibilityEnrollmentService().assessEEImpact(tempOnFile, true);
            boolean improved = this.getMilitaryRuleService().evaluateMSDSImprovement(incoming, tempOnFile, response);
            if (improved) {
                boolean isError = this.getMilitaryRuleService().processMSDSData(incoming, onFile, response);
                this.getEligibilityEnrollmentService().assessEEImpact(onFile, true);
                if (!isError) {
                    onFile = this.getMilitaryRuleService().processMilitaryServiceNumbers(onFile);
                }
                this.getEventRuleService().processMessageEventsForMsds(onFile);
                this.getCommunicationRuleService().triggerAutomaticLetters(onFile, null, null);
                PurpleHeart resultPurpleHeart = onFile.getPurpleHeart();
                if (resultPurpleHeart != null && resultPurpleHeart.getRegistryTrait() == null) {
                    RegistryType regType = (RegistryType)this.getLookupService().getByCode(RegistryType.class, RegistryType.CODE_PH_REGISTRY.getCode());
                    this.getRegistryService().linkPersonRegistry(resultPurpleHeart, onFile.getPurpleHeart(), incoming, onFile, regType, false);
                }
            } else {
                MilitaryService ms = onFile.getMilitaryService();
                if (ms == null) {
                    ms = new MilitaryService();
                    onFile.setMilitaryService(ms);
                }
                onFile.getMilitaryService().setMilitaryServiceQueryStatus(this.getLookupService().getMilitaryServiceQueryStatusByCode(MilitaryServiceQueryStatus.MILITARY_SERVICE_DATA_RECEIVED.getCode()));
            }
        } else {
            this.getMilitaryRuleService().processMSDSData(incoming, onFile, response);
        }
        boolean hecRecordExists = false;
        if (onFile.getMilitaryService() != null) {
            if (onFile.getMilitaryService().getHECMilitaryServiceSiteRecord() == null || onFile.getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes().isEmpty()) {
                this.getEventRuleService().triggerCreateHecRecord(onFile);
            } else {
                hecRecordExists = true;
            }
        }
        if (hecRecordExists && this.handleCLELogic(onFile)) {
            onFile = this.getEligibilityEnrollmentService().assessEEImpact(onFile, false);
        }
        this.getEventRuleService().manageHandBookEvents(onFile);
        try {
            this.getMessagingService().postProcessVOASubmission(onFile, "MSDS_QUERY_RESPONSE", null);
        }
        catch (AddProxyPreferredFacilityException pfex) {
            this.logger.error((Object)("Process MSDS Query Response Error: Unable to add Proxy PF for a VOA Submission. person_id= " + onFile.getEntityKey().getKeyValueAsString()));
        }
        return personService.save(onFile);
    }

    @Override
    public Person processSeeding(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"Person must not be null ");
        Person onFile = this.getPersonService().getPerson(incoming.getPersonEntityKey());
        Person updated = this.getMilitaryRuleService().processSeedingMilitaryService(incoming.getMilitaryService(), onFile);
        return this.getPersonService().save(updated);
    }

    @Override
    public void processMSDSLogicForCLV(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"Person must not be null ");
        Person onFile = this.getPersonService().getPerson(incoming.getPersonEntityKey());
        if (this.handleCLELogic(onFile)) {
            onFile = this.getEligibilityEnrollmentService().assessEEImpact(onFile, false);
        }
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public TriggerEventCacheManager getTriggerEventCacheManager() {
        return this.triggerEventCacheManager;
    }

    public void setTriggerEventCacheManager(TriggerEventCacheManager triggerEventCacheManager) {
        this.triggerEventCacheManager = triggerEventCacheManager;
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    @Override
    public boolean calculateCLVeligibilitybyMSE(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"The Person must not be null");
        if (person.getMilitaryService() == null) {
            return false;
        }
        if (person.isVeteran() == null) {
            return false;
        }
        return this.isCLVeligibilitybyMSE(person.getMilitaryService().getMilitaryServiceSiteRecords(), person.isVeteran());
    }

    private boolean isCLVeligibilitybyMSE(Set<MilitaryServiceSiteRecord> mssrs, boolean isVeteran) throws ServiceException {
        long totalServiceDays = 0L;
        VAFacility site = null;
        for (MilitaryServiceSiteRecord mssr : mssrs) {
            site = mssr.getSite();
            if (site == null || !site.getStationNumber().equals(VAFacility.CODE_HEC.getName())) continue;
            Set mses = mssr.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode mse : mses) {
                if (mse.getDischargeType() == null || mse.getDischargeType().getCode().equals(DischargeType.CODE_BAD_CONDUCT.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_DISHONORABLE.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_OTHER_THAN_HONORABLE.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_DISHONORABLE_VA.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_UNDESIRABLE.getCode()) || !isVeteran) continue;
                if ((CommonDateUtils.isDateAfter(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate())) && (CommonDateUtils.isDateBefore(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(mse.getStartDate(), mse.getEndDate()).longValue();
                    continue;
                }
                if ((CommonDateUtils.isDateAfter(mse.getEndDate(), startday) || startday.equals((Object)mse.getEndDate())) && (CommonDateUtils.isDateBefore(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate())) && (CommonDateUtils.isDateBefore(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(startday, mse.getEndDate()).longValue();
                    continue;
                }
                if ((CommonDateUtils.isDateAfter(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate())) && (CommonDateUtils.isDateBefore(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(startday, endday).longValue();
                    continue;
                }
                if (!CommonDateUtils.isDateBefore(mse.getStartDate(), endday) && !endday.equals((Object)mse.getStartDate()) || !CommonDateUtils.isDateAfter(mse.getStartDate(), startday) && !startday.equals((Object)mse.getStartDate()) || !CommonDateUtils.isDateAfter(mse.getEndDate(), endday) && !endday.equals((Object)mse.getEndDate())) continue;
                totalServiceDays += CommonDateUtils.getDays(mse.getStartDate(), endday).longValue();
            }
        }
        return totalServiceDays >= 30L;
    }

    public boolean handleCLELogic(Person person) throws ServiceException, UnknownLookupTypeException {
        CampLejeuneVerification clv = person.getCampLejeuneVerification();
        if (person.getEnrollmentDetermination() != null && clv != null && clv.getSpecialFactorIndicator() != null && clv.getSpecialFactorIndicator().getCode().equals(Indicator.YES.getCode()) && !this.calculateCLVeligibilitybyMSE(person)) {
            if (VOAApplicationServiceImpl.VOA_IND_2.equals(person.getVOAIndicator())) {
                this.changeCLVToNo(person);
                this.createCLENotDeterminedWkItem(person, WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode(), "Veteran CL Eligibility cannot be determined");
                return true;
            }
            this.changeCLVToNo(person);
            if (clv.getCampLejeuneVerificationMethods().size() != 0) {
                this.createCLENotDeterminedWkItem(person, WkfCaseType.CODE_ELIGIBILITY_UPDATE.getCode(), "Camp Lejeune eligibility is not supported by MSE");
            }
            return true;
        }
        return false;
    }

    private void changeCLVToNo(Person person) throws ServiceException {
        CampLejeuneVerification clv = person.getCampLejeuneVerification();
        if (clv == null) {
            return;
        }
        clv.setSpecialFactorIndicator(this.getLookupService().getIndicatorByCode(Indicator.NO));
        clv.setChangeSite(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
        clv.setChangeSource(this.getLookupService().getCampLejeuneChangeSourceByCode(CampLejeuneChangeSource.CODE_HEC.getCode()));
    }

    private void createCLENotDeterminedWkItem(Person person, String caseType, String reason) throws ServiceException {
        this.getWorkflowService().autoCreateCase(person, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(caseType), null, reason);
    }
}

