/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.ee.IRS1095B;
import gov.va.med.esr.common.model.ee.MECPeriod;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.TransmissionStatus;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogData;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogDetailEntry;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogEntry;
import gov.va.med.esr.common.model.party.SimpleAddress;
import gov.va.med.esr.service.IRSWebServiceDelegate;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.impl.UTPasswordCallback;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.transport.common.gzip.GZIPFeature;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import us.gov.treasury.irs.common.BinaryFormatCodeType;
import us.gov.treasury.irs.common.ErrorMessageDetailType;
import us.gov.treasury.irs.common.TINRequestTypeCodeType;
import us.gov.treasury.irs.ext.aca.air._7.ACABulkBusinessHeaderRequestType;
import us.gov.treasury.irs.ext.aca.air._7.ACABulkReqTrnsmtStsReqGrpDtlType;
import us.gov.treasury.irs.ext.aca.air._7.ACATrnsmtManifestReqDtlType;
import us.gov.treasury.irs.ext.aca.air._7.BusinessAddressGrpType;
import us.gov.treasury.irs.ext.aca.air._7.BusinessNameType;
import us.gov.treasury.irs.ext.aca.air._7.CompanyInformationGrpType;
import us.gov.treasury.irs.ext.aca.air._7.CorrectedRecordInfoGrpType;
import us.gov.treasury.irs.ext.aca.air._7.EmployerCoveredIndividualType;
import us.gov.treasury.irs.ext.aca.air._7.ForeignAddressGrpType;
import us.gov.treasury.irs.ext.aca.air._7.Form1094BUpstreamDetailType;
import us.gov.treasury.irs.ext.aca.air._7.Form1095BUpstreamDetailType;
import us.gov.treasury.irs.ext.aca.air._7.IssuerInfoGrpType;
import us.gov.treasury.irs.ext.aca.air._7.MonthIndGrpType;
import us.gov.treasury.irs.ext.aca.air._7.OtherCompletePersonNameType;
import us.gov.treasury.irs.ext.aca.air._7.ResponsibleIndividualGrpType;
import us.gov.treasury.irs.ext.aca.air._7.StateType;
import us.gov.treasury.irs.ext.aca.air._7.TransmissionStatusCodeType;
import us.gov.treasury.irs.ext.aca.air._7.TransmissionTypeCdType;
import us.gov.treasury.irs.ext.aca.air._7.TransmitterErrorDetailGrpType;
import us.gov.treasury.irs.ext.aca.air._7.USAddressGrpType;
import us.gov.treasury.irs.ext.aca.air._7.VendorInformationGrpType;
import us.gov.treasury.irs.msg.form1094_1095bctransmittermessage.FormBCTrnsmtSubmissionDtlType;
import us.gov.treasury.irs.msg.form1094_1095btransmitterupstreammessage.Form109495BTrnsmtUpstreamType;
import us.gov.treasury.irs.msg.form1094_1095btransmitterupstreammessage.ObjectFactory;
import us.gov.treasury.irs.msg.irsacabulkrequesttransmitter.ACABulkRequestTransmitterResponseType;
import us.gov.treasury.irs.msg.irsacabulkrequesttransmitter.ACABulkRequestTransmitterType;
import us.gov.treasury.irs.msg.irstransmitterstatusrequest.ACABulkRequestTransmitterStatusDetailRequestType;
import us.gov.treasury.irs.msg.irstransmitterstatusrequest.ACABulkRequestTransmitterStatusDetailResponseType;
import us.gov.treasury.irs.srv.acabulkrequesttransmitterstatus.ACATransmitterStatusReqPortType;
import us.gov.treasury.irs.srv.gettransmitterbulkrequest.BulkRequestTransmitterPortType;

public class IRSWebServiceDelegateImpl
extends AbstractComponent
implements IRSWebServiceDelegate {
    private static final long serialVersionUID = 8534310803323475694L;
    private static final String EIN = "741612229";
    private static final String AATS_EIN = "000000211";
    private static final String AATS_CONTROL_EIN = "WORK";
    private static final String AATS_CONTROL_LEGAL_NAME = "WORK";
    private static final String LEGAL_NAME = "DEPARTMENT OF VETERANS AFFAIRS";
    private static final String BUSINESS_STREET_ADDRESS = "1800 G ST NW RM 402B";
    private static final String BUSINESS_CITY = "WASHINGTON";
    private static final String BUSINESS_STATE = "DC";
    private static final String BUSINESS_ZIP = "20460";
    private static final String BUSINESS_PHONE = "2022715400";
    private static final String FORM_TYPE_CODE = "1094/1095B";
    private static final long SUBMIT_TIMEOUT = 300000L;
    private static final int MAX_RETRY = 5;
    private static final String APP_ID = "SYS12";
    private static final String TYPE_CODE = "T";
    private static final String SUBMIT_ORIGINAL = "O";
    private static final String SUBMIT_CORRECTION = "C";
    private static final String SUBMIT_REPLACEMENT = "R";
    private static final String WSU_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static final String ACABUSINESSHEADER_NS = "urn:us:gov:treasury:irs:msg:acabusinessheader";
    private static final String ACABUSINESSHEADER_NS_ACK = "urn:us:gov:treasury:irs:msg:irstransmitterstatusrequest";
    private static final String ACATRANSMITTERMANIFESTREQDTL_NS = "urn:us:gov:treasury:irs:ext:aca:air:7.0";
    private static final BigInteger PAYER_COUNT = BigInteger.valueOf(1L);
    private String irsServiceBulkEndPoint = null;
    private String irsServiceStatusEndPoint = null;
    private LookupService lookupService = null;
    private String irsProcessingCode = null;
    private String tempFileLocation = null;
    DataHandler handler;
    DataHandler attachName;
    Attachment formDataFile;
    private String irsSignatureFile = null;
    private String transmissionControlCode = null;
    private String softwareId = null;
    private String clientSystemId = null;
    private String irsContactFname = null;
    private String irsContactLname = null;
    private String irsContactPhone = null;
    private DAOOperations genericDAO;

    @Override
    public String transmitOriginal(IrsTransmissionLogEntry transmission) throws ServiceException {
        return this.generateTransmitterBulkSubmission(transmission, null);
    }

    private ACABulkBusinessHeaderRequestType getBusinessHeader() throws ServiceException {
        us.gov.treasury.irs.ext.aca.air._7.ObjectFactory f = new us.gov.treasury.irs.ext.aca.air._7.ObjectFactory();
        ACABulkBusinessHeaderRequestType bHeader = f.createACABulkBusinessHeaderRequestType();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = sdf.format(new Date());
        XMLGregorianCalendar xmlCal = null;
        try {
            xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(date);
        }
        catch (DatatypeConfigurationException e) {
            this.logger.error((Object)"Data Type Error in IRS Transmit:", (Throwable)e);
        }
        UUID id = UUID.randomUUID();
        String utid = id + ":" + APP_ID + ":" + this.getTransmissionControlCode() + "::" + TYPE_CODE;
        bHeader.setTimestamp(xmlCal);
        bHeader.setUniqueTransmissionId(utid);
        return bHeader;
    }

    private String generateTransmitterBulkSubmission(IrsTransmissionLogEntry transmission, String originalReceipt) throws ServiceException {
        try {
            ErrorMessageDetailType error;
            ACABulkRequestTransmitterType filebody = new ACABulkRequestTransmitterType();
            ACATrnsmtManifestReqDtlType headerManifest = new ACATrnsmtManifestReqDtlType();
            this.setCommonHeader(transmission, headerManifest);
            if (transmission.getCorrectionInd().equalsIgnoreCase(SUBMIT_REPLACEMENT) && originalReceipt != null) {
                headerManifest.setOriginalReceiptId(StringUtils.split((String)originalReceipt, (String)"|")[0]);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS'Z'");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            String date = sdf.format(new Date());
            String fileName = "1094B_Request_" + this.getTransmissionControlCode() + "_" + date + ".xml";
            if (transmission.getIrsTransmissionLogData() == null || transmission.getIrsTransmissionLogData().size() <= 0 || transmission.getIrsTransmissionLogData().iterator().next().getRequestData() == null) {
                throw new ServiceException("Form Data file does not exist in IRS Bulk Submission Request");
            }
            ByteDataSource bulkFile = new ByteDataSource(transmission.getIrsTransmissionLogData().iterator().next().getRequestData().getBytes(), "text/xml;");
            bulkFile.setContentType("text/xml;");
            bulkFile.setName(fileName);
            this.handler = new DataHandler((DataSource)bulkFile);
            filebody.setVersion("1.0");
            filebody.setBulkExchangeFile(this.handler);
            headerManifest.setChecksumAugmentationNum(DigestUtils.md5Hex((byte[])transmission.getIrsTransmissionLogData().iterator().next().getRequestData().getBytes()));
            headerManifest.setAttachmentByteSizeNum(BigInteger.valueOf(transmission.getIrsTransmissionLogData().iterator().next().getRequestData().getBytes().length));
            headerManifest.setDocumentSystemFileNm(fileName);
            ACABulkBusinessHeaderRequestType busHeaderDetail = new ACABulkBusinessHeaderRequestType();
            busHeaderDetail = this.getBusinessHeader();
            Holder holder = new Holder((Object)busHeaderDetail);
            String responseStatus = "";
            String errorMsg = "";
            String status = "";
            String receiptId = "";
            GZIPFeature gz = new GZIPFeature();
            gz.setThreshold(0);
            gz.setForce(true);
            ArrayList<GZIPFeature> features = new ArrayList<GZIPFeature>();
            features.add(gz);
            JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
            factory.setAddress(this.getIrsServiceBulkEndPoint());
            factory.setServiceClass(BulkRequestTransmitterPortType.class);
            factory.setFeatures(features);
            JAXBDataBinding jxBinding = new JAXBDataBinding();
            factory.setDataBinding((DataBinding)jxBinding);
            BulkRequestTransmitterPortType port = (BulkRequestTransmitterPortType)factory.create();
            Client client = ClientProxy.getClient((Object)port);
            this.clientBulkRequestSetup(client);
            this.addSignature(client, true, true, true);
            ACABulkRequestTransmitterResponseType response = new ACABulkRequestTransmitterResponseType();
            try {
                response = port.bulkRequestTransmitter(filebody, null, null, holder, headerManifest);
                if (response == null) {
                    throw new ServiceException("IRS Transmit Request Failure: No Response Recieved");
                }
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                String exceptionDetails = sw.toString();
                this.logger.error((Object)("Exception during IRS bulk request service call:" + exceptionDetails));
                transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.FAILED.getCode()));
                transmission.setErrorDescription("No Receipt ID Provided in Submission Response");
                throw new ServiceException("IRS Transmit Request Failure:" + ex.getMessage());
            }
            receiptId = response.getReceiptId();
            if (response.getErrorMessageDetail() != null && (error = response.getErrorMessageDetail()) != null) {
                errorMsg = errorMsg + error.getErrorMessageCd() + ":";
                errorMsg = errorMsg + error.getErrorMessageTxt();
            }
            TransmissionStatusCodeType c = response.getTransmissionStatusCd();
            status = c.value();
            responseStatus = receiptId + "^" + status + "^" + errorMsg;
            return responseStatus;
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            String exceptionDetails = sw.toString();
            this.logger.error((Object)("Exception during IRS bulk request service call:" + exceptionDetails));
            transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.FAILED.getCode()));
            transmission.setErrorDescription("No Receipt ID Provided in Submission Response");
            throw new ServiceException("IRS Transmit Request Failure:" + ex.getMessage());
        }
    }

    private String buildXmlDocument(JAXBElement document) {
        Class<?> clazz = document.getValue().getClass();
        try {
            JAXBContext context = JAXBContext.newInstance((String)clazz.getPackage().getName());
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            StringWriter sw = new StringWriter();
            m.marshal((Object)document, (Writer)sw);
            String xml = sw.toString();
            return xml;
        }
        catch (JAXBException e) {
            this.logger.error((Object)("Error building xml doc " + (Object)((Object)e)));
            return null;
        }
    }

    @Override
    public String retransmitBatchSubmission(IrsTransmissionLogEntry transmission, String originalReceipt) throws ServiceException {
        return this.generateTransmitterBulkSubmission(transmission, originalReceipt);
    }

    @Override
    public String retransmitPersonSubmission(IrsTransmissionLogEntry transmission, String originalReceipt) throws ServiceException {
        return this.generateTransmitterBulkSubmission(transmission, originalReceipt);
    }

    @Override
    public void requestProcessingStatus(IrsTransmissionLogEntry transmission) throws ServiceException {
        if (transmission == null || transmission.getReceiptId() == null || transmission.getReceiptId().isEmpty()) {
            return;
        }
        String receipt = transmission.getReceiptId();
        try {
            ACABulkBusinessHeaderRequestType busHeaderDetail = new ACABulkBusinessHeaderRequestType();
            busHeaderDetail = this.getBusinessHeader();
            Holder holder = new Holder((Object)busHeaderDetail);
            ACABulkRequestTransmitterStatusDetailRequestType requestBody = new ACABulkRequestTransmitterStatusDetailRequestType();
            ACABulkReqTrnsmtStsReqGrpDtlType reqDetail = new ACABulkReqTrnsmtStsReqGrpDtlType();
            reqDetail.setReceiptId(receipt);
            requestBody.setACABulkReqTrnsmtStsReqGrpDtl(reqDetail);
            ACABulkRequestTransmitterStatusDetailResponseType response = new ACABulkRequestTransmitterStatusDetailResponseType();
            JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
            factory.setAddress(this.getIrsServiceStatusEndPoint());
            factory.setServiceClass(ACATransmitterStatusReqPortType.class);
            JAXBDataBinding jxBinding = new JAXBDataBinding();
            factory.setDataBinding((DataBinding)jxBinding);
            ACATransmitterStatusReqPortType port = (ACATransmitterStatusReqPortType)factory.create();
            Client client = ClientProxy.getClient((Object)port);
            client.getInInterceptors().add(new GZIPInInterceptor());
            this.addSignature(client, true, true, false);
            HTTPConduit http = (HTTPConduit)client.getConduit();
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setContentType("text/xml");
            httpClientPolicy.setAcceptEncoding("gzip,deflate");
            http.setClient(httpClientPolicy);
            try {
                response = port.getACATransmitterStatusReqOperation(requestBody, null, null, holder);
                if (response == null || response.getACABulkRequestTransmitterResponse() == null || response.getACABulkRequestTransmitterResponse().getTransmissionStatusCd() == null) {
                    this.logger.error((Object)"Exception during IRS request acknowlegement service call: No Response Returned");
                    return;
                }
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                String exceptionDetails = sw.toString();
                this.logger.error((Object)("Exception during IRS request acknowlegement service call:" + exceptionDetails));
                return;
            }
            TransmissionStatusCodeType respType = response.getACABulkRequestTransmitterResponse().getTransmissionStatusCd();
            transmission.setAckDate(((ACABulkBusinessHeaderRequestType)holder.value).getTimestamp().toGregorianCalendar().getTime());
            transmission.setAckId(((ACABulkBusinessHeaderRequestType)holder.value).getUniqueTransmissionId().split(":")[0]);
            if (respType == TransmissionStatusCodeType.PROCESSING) {
                return;
            }
            if (respType == TransmissionStatusCodeType.ACCEPTED) {
                transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.ACCEPTED.getCode()));
                transmission.setErrorDescription(null);
            } else if (respType == TransmissionStatusCodeType.NOT_FOUND) {
                transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.NOT_FOUND.getCode()));
                transmission.setErrorDescription("Requested Receipt ID Not Found");
            } else if (respType == TransmissionStatusCodeType.REJECTED) {
                DataHandler dh;
                transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.REJECTED.getCode()));
                if (response.getACABulkRequestTransmitterResponse().getErrorMessageDetail() != null) {
                    transmission.setErrorDescription(response.getACABulkRequestTransmitterResponse().getErrorMessageDetail().getErrorMessageCd() + ":" + response.getACABulkRequestTransmitterResponse().getErrorMessageDetail().getErrorMessageTxt());
                }
                String recordErr = "";
                if (response.getACABulkReqTrnsmtStsRespGrpDtl() != null && (dh = response.getACABulkReqTrnsmtStsRespGrpDtl().getBulkExchangeFile()) != null) {
                    List<TransmitterErrorDetailGrpType> errorList = this.getErrorsFromBulkFile(dh, transmission);
                    for (TransmitterErrorDetailGrpType curError : errorList) {
                        List errList = curError.getErrorMessageDetail();
                        if (errList == null || errList.size() <= 0) continue;
                        if (errList.size() == 1) {
                            ErrorMessageDetailType firstErr = (ErrorMessageDetailType)errList.get(0);
                            recordErr = firstErr.getErrorMessageCd() + ":" + firstErr.getErrorMessageTxt();
                        } else {
                            for (int i = 0; i < errList.size(); ++i) {
                                ErrorMessageDetailType cur = (ErrorMessageDetailType)errList.get(i);
                                recordErr = recordErr + cur.getErrorMessageCd();
                                recordErr = recordErr + ":";
                            }
                        }
                        recordErr = transmission.getErrorDescription() + ":" + recordErr;
                        if (recordErr.length() > 900) {
                            recordErr = recordErr.substring(0, 900) + " :TRUNCATED";
                        }
                        transmission.setErrorDescription(recordErr);
                    }
                }
            } else if (respType == TransmissionStatusCodeType.ACCEPTED_WITH_ERRORS || respType == TransmissionStatusCodeType.PARTIALLY_ACCEPTED) {
                transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.ACCEPTED_WITH_ERRORS.getCode()));
                transmission.setErrorDescription(null);
                DataHandler dh = response.getACABulkReqTrnsmtStsRespGrpDtl().getBulkExchangeFile();
                List<TransmitterErrorDetailGrpType> errorList = this.getErrorsFromBulkFile(dh, transmission);
                Iterator<TransmitterErrorDetailGrpType> errorIt = errorList.iterator();
                while (errorIt.hasNext()) {
                    try {
                        TransmitterErrorDetailGrpType curError = errorIt.next();
                        String uniqueId = curError.getUniqueRecordId();
                        if (uniqueId == null || uniqueId.isEmpty() || StringUtils.split((String)uniqueId, (String)"|").length < 3) {
                            this.logger.error((Object)("Invalid Unique Record Id encountered in IRS data file: " + uniqueId));
                            continue;
                        }
                        int sequence = Integer.valueOf(StringUtils.split((String)uniqueId, (String)"|")[2]);
                        List errList = curError.getErrorMessageDetail();
                        String recordErr = "";
                        if (errList == null || errList.size() <= 0) continue;
                        if (errList.size() == 1) {
                            ErrorMessageDetailType firstErr = (ErrorMessageDetailType)errList.get(0);
                            recordErr = firstErr.getErrorMessageCd() + ":" + firstErr.getErrorMessageTxt();
                        } else {
                            for (int i = 0; i < errList.size(); ++i) {
                                ErrorMessageDetailType cur = (ErrorMessageDetailType)errList.get(i);
                                recordErr = recordErr + cur.getErrorMessageCd();
                                recordErr = recordErr + ":";
                            }
                        }
                        if (recordErr.length() > 900) {
                            recordErr = recordErr.substring(0, 900) + " :TRUNCATED";
                        }
                        Set<IrsTransmissionLogDetailEntry> detailSet = transmission.getIrsTransmissionLogDetails();
                        for (IrsTransmissionLogDetailEntry cur : detailSet) {
                            if (cur.getRecordSequence() != sequence) continue;
                            String err = recordErr;
                            if (err.length() > 900) {
                                err = err.substring(0, 900) + " :TRUNCATED";
                            }
                            cur.setErrorDescription(err);
                        }
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)("Error processing form data file records: " + ex.getMessage()));
                    }
                }
            } else {
                transmission.setErrorDescription("Unknown Status Type Returned:" + respType.value());
                transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.FAILED.getCode()));
            }
        }
        catch (Exception e) {
            transmission.setErrorDescription("Unknown Error in Requesting Acknowledgements:" + e.getMessage());
            transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.FAILED.getCode()));
            this.logger.error((Object)("RPC Exception in IRSAcknolegement request: " + e.getMessage()));
        }
    }

    private List<TransmitterErrorDetailGrpType> getErrorsFromBulkFile(DataHandler dh, IrsTransmissionLogEntry transmission) {
        List errorList = null;
        try {
            FormBCTrnsmtSubmissionDtlType errRoot = new FormBCTrnsmtSubmissionDtlType();
            us.gov.treasury.irs.msg.form1094_1095bctransmittermessage.ObjectFactory rFac = new us.gov.treasury.irs.msg.form1094_1095bctransmittermessage.ObjectFactory();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{us.gov.treasury.irs.msg.form1094_1095bctransmittermessage.ObjectFactory.class});
            Unmarshaller m = context.createUnmarshaller();
            Marshaller ms = context.createMarshaller();
            ms.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter sw = new StringWriter();
            errRoot = (FormBCTrnsmtSubmissionDtlType)((JAXBElement)m.unmarshal(dh.getInputStream())).getValue();
            ms.marshal((Object)rFac.createFormBCTransmitterSubmissionDtl(errRoot), (Writer)sw);
            String responseXml = sw.toString();
            transmission.getIrsTransmissionLogData().iterator().next().setResponseData(responseXml);
            errorList = errRoot.getACATransmitterSubmissionDetail().getTransmitterErrorDetailGrp();
        }
        catch (JAXBException ex) {
            this.logger.error((Object)("Error parsing bulk error data file from IRS: " + ex.getMessage()));
        }
        catch (IOException ex) {
            this.logger.error((Object)("Error parsing bulk error data file from IRS: " + ex.getMessage()));
        }
        return errorList;
    }

    private String generateTestSsn() {
        String ssn = "000000";
        Random rand = new Random();
        int suffix = rand.nextInt(801) + 100;
        ssn = ssn + Integer.toString(suffix);
        return ssn;
    }

    private String getNameControl(String ssn) {
        String nameControl = "";
        if (ssn == null || ssn.length() != 9) {
            return nameControl;
        }
        String pos = ssn.substring(6, 7);
        String[] nameControls = new String[]{"HERR", "MART", "WILL", "SOUT", "GAVI", "DAVI", "NICH", "CAME", "JONE", "SCOT"};
        int nc = Integer.valueOf(pos);
        if (ssn.endsWith("00")) {
            --nc;
        }
        nameControl = nameControls[nc];
        return nameControl;
    }

    @Override
    public IrsTransmissionLogData buildRequestDataFile(List<IRS1095B> batch, String correctionInd, String taxYear, String originalReceipt, List<IRS1095B> errorList) throws ServiceException {
        Form1094BUpstreamDetailType transmitter = new Form1094BUpstreamDetailType();
        ObjectFactory f = new ObjectFactory();
        Form109495BTrnsmtUpstreamType rootContainer = f.createForm109495BTrnsmtUpstreamType();
        transmitter.setRecordType("String");
        transmitter.setLineNum(BigInteger.valueOf(0L));
        if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
            transmitter.setBusinessNameControlTxt("WORK");
        }
        IrsTransmissionLogData requestData = new IrsTransmissionLogData();
        String correctedInd = "0";
        if (correctionInd.equalsIgnoreCase(SUBMIT_CORRECTION)) {
            correctedInd = "1";
        }
        try {
            transmitter.setSubmissionId(PAYER_COUNT);
            transmitter.setTaxYr(DatatypeFactory.newInstance().newXMLGregorianCalendar(taxYear));
            BusinessNameType busName = new BusinessNameType();
            if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                busName.setBusinessNameLine1Txt("WORKDEPARTMENT OF VETERANS AFFAIRS");
            } else {
                busName.setBusinessNameLine1Txt(LEGAL_NAME);
            }
            transmitter.setBusinessName(busName);
            if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                transmitter.setEmployerEIN(AATS_EIN);
            } else {
                transmitter.setEmployerEIN(EIN);
            }
            OtherCompletePersonNameType name = new OtherCompletePersonNameType();
            name.setPersonFirstNm(this.getIrsContactFname());
            name.setPersonLastNm(this.getIrsContactLname());
            transmitter.setContactNameGrp(name);
            transmitter.setContactPhoneNum(this.getIrsContactPhone());
            BusinessAddressGrpType busAddress = new BusinessAddressGrpType();
            USAddressGrpType us = new USAddressGrpType();
            us.setAddressLine1Txt(BUSINESS_STREET_ADDRESS);
            us.setCityNm(BUSINESS_CITY);
            us.setUSStateCd(StateType.fromValue((String)BUSINESS_STATE));
            us.setUSZIPCd(BUSINESS_ZIP);
            busAddress.setUSAddressGrp(us);
            busAddress.setForeignAddressGrp(null);
            transmitter.setMailingAddressGrp(busAddress);
            Iterator<IRS1095B> it = batch.iterator();
            int pos = 1;
            while (it.hasNext()) {
                Form1095BUpstreamDetailType personDetail = new Form1095BUpstreamDetailType();
                String testSSN = this.generateTestSsn();
                String testNameControl = this.getNameControl(testSSN);
                IRS1095B cur = it.next();
                try {
                    personDetail.setRecordType("String");
                    personDetail.setLineNum(BigInteger.valueOf(0L));
                    personDetail.setRecordId(BigInteger.valueOf(pos));
                    personDetail.setCorrectedInd(correctedInd);
                    personDetail.setTaxYr(DatatypeFactory.newInstance().newXMLGregorianCalendar(taxYear));
                    ResponsibleIndividualGrpType rig = new ResponsibleIndividualGrpType();
                    if (cur.getSSN() != null && !cur.getSSN().isEmpty()) {
                        rig.setTINRequestTypeCd(TINRequestTypeCodeType.INDIVIDUAL_TIN);
                        if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                            rig.setSSN(testSSN);
                        } else {
                            rig.setSSN(cur.getSSN());
                        }
                    }
                    if (this.getDob(cur.getDOB()) != null) {
                        rig.setBirthDt(this.getDob(cur.getDOB()));
                    }
                    if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                        rig.setPersonNameControlTxt(testNameControl);
                    }
                    OtherCompletePersonNameType personName = new OtherCompletePersonNameType();
                    if (cur.getFirstName() != null) {
                        personName.setPersonFirstNm(cur.getFirstName());
                    } else {
                        personName.setPersonFirstNm(this.getIrsContactFname());
                    }
                    if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                        personName.setPersonLastNm(testNameControl + cur.getLastName());
                    } else {
                        personName.setPersonLastNm(cur.getLastName());
                    }
                    if (cur.getMiddleName() != null && !cur.getMiddleName().isEmpty()) {
                        personName.setPersonMiddleNm(cur.getMiddleName());
                    }
                    if (cur.getNameSuffix() != null && !cur.getNameSuffix().isEmpty()) {
                        personName.setSuffixNm(cur.getNameSuffix());
                    }
                    this.stripBadCharsAndEscapeXmlChars(personName);
                    rig.setResponsibleIndividualName(personName);
                    if (correctionInd.equalsIgnoreCase(SUBMIT_CORRECTION) && originalReceipt != null) {
                        CorrectedRecordInfoGrpType correction = new CorrectedRecordInfoGrpType();
                        correction.setCorrectedUniqueRecordId(originalReceipt);
                        correction.setCorrectedRecordPayeeName(personName);
                        if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                            correction.setCorrectedRecordPayeeTIN(testSSN);
                        } else {
                            correction.setCorrectedRecordPayeeTIN(cur.getSSN());
                        }
                        personDetail.setCorrectedRecordInfoGrp(correction);
                    }
                    BusinessAddressGrpType personAddress = new BusinessAddressGrpType();
                    boolean badAddress = false;
                    if (cur.getAddress() != null) {
                        ForeignAddressGrpType add;
                        if (cur.getAddress().getCountry() != null && cur.getAddress().getCountry().equals(Country.CODE_USA.getName()) || cur.getAddress().getState() != null && cur.getAddress().getZipCode() != null) {
                            add = new USAddressGrpType();
                            add.setAddressLine1Txt(cur.getAddress().getLine1() != null && cur.getAddress().getLine1().trim().length() > 0 ? cur.getAddress().getLine1() : busAddress.getUSAddressGrp().getAddressLine1Txt());
                            if (cur.getAddress().getLine2() != null && !cur.getAddress().getLine2().isEmpty()) {
                                add.setAddressLine2Txt(cur.getAddress().getLine2());
                            }
                            add.setCityNm(cur.getAddress().getCity() != null && cur.getAddress().getCity().trim().length() > 0 ? cur.getAddress().getCity() : busAddress.getUSAddressGrp().getCityNm());
                            if (cur.getAddress().getState() != null && cur.getAddress().getState().trim().length() > 0) {
                                try {
                                    add.setUSStateCd(StateType.fromValue((String)cur.getAddress().getState()));
                                }
                                catch (Exception ex) {
                                    badAddress = true;
                                }
                            } else {
                                add.setUSStateCd(busAddress.getUSAddressGrp().getUSStateCd());
                            }
                            add.setUSZIPCd(cur.getAddress().getZipCode() != null && cur.getAddress().getZipCode().trim().length() > 0 ? cur.getAddress().getZipCode() : busAddress.getUSAddressGrp().getUSZIPCd());
                            if (cur.getAddress().getZipPlus4() != null && !cur.getAddress().getZipPlus4().isEmpty()) {
                                add.setUSZIPExtensionCd(cur.getAddress().getZipPlus4());
                            }
                            this.stripBadCharsAndEscapeXmlChars(add);
                            personAddress.setUSAddressGrp((USAddressGrpType)add);
                            personAddress.setForeignAddressGrp(null);
                        } else {
                            add = new ForeignAddressGrpType();
                            add.setAddressLine1Txt(cur.getAddress().getLine1() != null && cur.getAddress().getLine1().trim().length() > 0 ? cur.getAddress().getLine1() : busAddress.getUSAddressGrp().getAddressLine1Txt());
                            if (cur.getAddress().getLine2() != null && !cur.getAddress().getLine2().isEmpty()) {
                                add.setAddressLine2Txt(cur.getAddress().getLine2());
                            }
                            add.setCityNm(cur.getAddress().getCity() != null && cur.getAddress().getCity().trim().length() > 0 ? cur.getAddress().getCity() : busAddress.getUSAddressGrp().getCityNm());
                            if (cur.getAddress().getCountry() != null && cur.getAddress().getCountry().trim().length() > 0) {
                                add.setCountryNm(cur.getAddress().getCountry());
                            } else {
                                badAddress = true;
                            }
                            add.setForeignPostalCd(cur.getAddress().getPostalCode());
                            if (cur.getAddress().getProvince() != null && !cur.getAddress().getProvince().isEmpty()) {
                                add.setForeignProvinceNm(cur.getAddress().getProvince());
                            }
                            this.stripBadCharsAndEscapeXmlChars(add);
                            personAddress.setForeignAddressGrp(add);
                            personAddress.setUSAddressGrp(null);
                        }
                    } else {
                        personAddress = busAddress;
                    }
                    if (personAddress.getUSAddressGrp() == null && personAddress.getForeignAddressGrp() == null || badAddress) {
                        personAddress = busAddress;
                    }
                    rig.setMailingAddressGrp(personAddress);
                    rig.setPolicyOriginCd(SUBMIT_CORRECTION);
                    personDetail.setResponsibleIndividualGrp(rig);
                    IssuerInfoGrpType issuer = new IssuerInfoGrpType();
                    issuer.setBusinessName(busName);
                    issuer.setContactPhoneNum(BUSINESS_PHONE);
                    if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                        issuer.setEIN(AATS_EIN);
                    } else {
                        issuer.setEIN(EIN);
                    }
                    issuer.setMailingAddressGrp(busAddress);
                    issuer.setTINRequestTypeCd(TINRequestTypeCodeType.BUSINESS_TIN);
                    if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                        issuer.setBusinessNameControlTxt("WORK");
                    }
                    personDetail.setIssuerInfoGrp(issuer);
                    EmployerCoveredIndividualType personInfo = new EmployerCoveredIndividualType();
                    if (this.getDob(cur.getDOB()) != null) {
                        personInfo.setBirthDt(this.getDob(cur.getDOB()));
                    }
                    personInfo.setCoveredIndividualName(personName);
                    if (cur.getSSN() != null && !cur.getSSN().isEmpty()) {
                        if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                            personInfo.setSSN(testSSN);
                        } else {
                            personInfo.setSSN(cur.getSSN());
                        }
                        personInfo.setTINRequestTypeCd(TINRequestTypeCodeType.INDIVIDUAL_TIN);
                    }
                    if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                        personInfo.setPersonNameControlTxt(testNameControl);
                    }
                    if (cur.getMecPeriod().isCoveredAll12Months()) {
                        personInfo.setCoveredIndividualAnnualInd("1");
                    } else {
                        personInfo.setCoveredIndividualAnnualInd("0");
                    }
                    MonthIndGrpType period = new MonthIndGrpType();
                    period.setJanuaryInd(cur.getMecPeriod().getCoverageMonths().containsKey("1") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("1") != false ? "1" : "0");
                    period.setFebruaryInd(cur.getMecPeriod().getCoverageMonths().containsKey("2") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("2") != false ? "1" : "0");
                    period.setMarchInd(cur.getMecPeriod().getCoverageMonths().containsKey("3") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("3") != false ? "1" : "0");
                    period.setAprilInd(cur.getMecPeriod().getCoverageMonths().containsKey("4") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("4") != false ? "1" : "0");
                    period.setMayInd(cur.getMecPeriod().getCoverageMonths().containsKey("5") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("5") != false ? "1" : "0");
                    period.setJuneInd(cur.getMecPeriod().getCoverageMonths().containsKey("6") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("6") != false ? "1" : "0");
                    period.setJulyInd(cur.getMecPeriod().getCoverageMonths().containsKey("7") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("7") != false ? "1" : "0");
                    period.setAugustInd(cur.getMecPeriod().getCoverageMonths().containsKey("8") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("8") != false ? "1" : "0");
                    period.setSeptemberInd(cur.getMecPeriod().getCoverageMonths().containsKey("9") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("9") != false ? "1" : "0");
                    period.setOctoberInd(cur.getMecPeriod().getCoverageMonths().containsKey("10") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("10") != false ? "1" : "0");
                    period.setNovemberInd(cur.getMecPeriod().getCoverageMonths().containsKey("11") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("11") != false ? "1" : "0");
                    period.setDecemberInd(cur.getMecPeriod().getCoverageMonths().containsKey("12") && (Boolean)cur.getMecPeriod().getCoverageMonths().get("12") != false ? "1" : "0");
                    personInfo.setCoveredIndividualMonthlyIndGrp(period);
                    if (personDetail.getCorrectedInd().equalsIgnoreCase("1")) {
                        if (personInfo.getCoveredIndividualAnnualInd().equalsIgnoreCase("1") || this.monthsRemaining(period)) {
                            personDetail.getCoveredIndividualGrp().add(personInfo);
                        }
                    } else {
                        personDetail.getCoveredIndividualGrp().add(personInfo);
                    }
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    String exceptionDetails = sw.toString();
                    if (exceptionDetails.contains("INVALID STATE CODE for US Address")) {
                        cur.setErrorText(exceptionDetails.substring(0, 59));
                    } else {
                        cur.setErrorText(exceptionDetails);
                    }
                    errorList.add(cur);
                    this.logger.error((Object)("Unknown Exception in building IRS data file entry for entry: " + (Object)((Object)cur) + " " + exceptionDetails));
                    it.remove();
                    continue;
                }
                transmitter.getForm1095BUpstreamDetail().add(personDetail);
                ++pos;
            }
            rootContainer.getForm1094BUpstreamDetail().add(transmitter);
            transmitter.setForm1095BAttachedCnt(BigInteger.valueOf(transmitter.getForm1095BUpstreamDetail().size()));
            String xml = this.buildXmlDocument(f.createForm109495BTransmittalUpstream(rootContainer));
            requestData.setRequestData(xml);
        }
        catch (DatatypeConfigurationException e) {
            this.logger.error((Object)("DataTypeError in BuildDataFile:" + e.getMessage()), (Throwable)e);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error in BuildDataFile:" + ex.getMessage()), (Throwable)ex);
        }
        return requestData;
    }

    private boolean monthsRemaining(MonthIndGrpType period) {
        return period.getJanuaryInd().equalsIgnoreCase("1") || period.getFebruaryInd().equalsIgnoreCase("1") || period.getMarchInd().equalsIgnoreCase("1") || period.getAprilInd().equalsIgnoreCase("1") || period.getMayInd().equalsIgnoreCase("1") || period.getJuneInd().equalsIgnoreCase("1") || period.getJulyInd().equalsIgnoreCase("1") || period.getAugustInd().equalsIgnoreCase("1") || period.getSeptemberInd().equalsIgnoreCase("1") || period.getOctoberInd().equalsIgnoreCase("1") || period.getNovemberInd().equalsIgnoreCase("1") || period.getDecemberInd().equalsIgnoreCase("1");
    }

    public void stripBadCharsAndEscapeXmlChars(Object obj) throws Exception {
        String charsToStripOut = "--|#";
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        String[] values = new String[]{""};
        Class[] methodParams = new Class[]{String.class};
        for (Field myField : fields) {
            if (!myField.getType().isAssignableFrom(String.class)) continue;
            String capitalizedFieldName = Character.toUpperCase(myField.getName().charAt(0)) + myField.getName().substring(1);
            try {
                Method getter = clazz.getMethod("get" + capitalizedFieldName, null);
                Method setter = clazz.getMethod("set" + capitalizedFieldName, methodParams);
                String fieldValue = (String)getter.invoke(obj, null);
                if (fieldValue == null || fieldValue.isEmpty()) continue;
                String oldFieldValue = "";
                for (int i = 0; !oldFieldValue.equals(fieldValue) && i < 5; ++i) {
                    oldFieldValue = fieldValue;
                    fieldValue = fieldValue.replaceAll(charsToStripOut, "");
                }
                values[0] = StringEscapeUtils.escapeXml((String)fieldValue);
                setter.invoke(obj, (Object[])values);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                this.logger.error((Object)("Unable to set address field:" + e.getMessage()), (Throwable)e);
            }
            catch (SecurityException e) {
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)("Unable to set address field:" + e.getMessage()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.logger.error((Object)("Unable to set address field:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private XMLGregorianCalendar getDob(String dob) {
        Date dt = null;
        try {
            if (dob != null && dob.length() > 3) {
                SimpleDateFormat f;
                if (dob.length() == 8) {
                    f = new SimpleDateFormat("yyyyMMdd");
                    dt = f.parse(dob);
                } else if (dob.length() == 6) {
                    f = new SimpleDateFormat("yyyyMM");
                    dt = f.parse(dob);
                } else if (dob.length() == 4) {
                    f = new SimpleDateFormat("yyyy");
                    dt = f.parse(dob);
                } else {
                    return null;
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(dt);
                XMLGregorianCalendar xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), 0);
                xmlDate.setTimezone(Integer.MIN_VALUE);
                return xmlDate;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    @Override
    public ArrayList<IRS1095B> convertAllEntries(String dataFile) {
        ArrayList<IRS1095B> listing = new ArrayList<IRS1095B>();
        String xml = dataFile;
        Form109495BTrnsmtUpstreamType result = (Form109495BTrnsmtUpstreamType)JAXB.unmarshal((Reader)new StringReader(xml), Form109495BTrnsmtUpstreamType.class);
        List details = ((Form1094BUpstreamDetailType)result.getForm1094BUpstreamDetail().get(0)).getForm1095BUpstreamDetail();
        Form1095BUpstreamDetailType entry = null;
        IRS1095B submission = null;
        MECPeriod period = new MECPeriod();
        HashMap coverageMonths = new HashMap();
        for (Form1095BUpstreamDetailType object : details) {
            entry = object;
            if (entry == null) continue;
            submission = new IRS1095B();
            submission.setSSN(entry.getResponsibleIndividualGrp().getSSN());
            if (entry.getResponsibleIndividualGrp().getBirthDt() != null) {
                submission.setDOB(entry.getResponsibleIndividualGrp().getBirthDt().toString());
            }
            SimpleAddress address = new SimpleAddress();
            if (entry.getResponsibleIndividualGrp().getMailingAddressGrp() != null) {
                USAddressGrpType add = entry.getResponsibleIndividualGrp().getMailingAddressGrp().getUSAddressGrp();
                if (add != null) {
                    address.setCity(add.getCityNm());
                    address.setLine1(add.getAddressLine1Txt());
                    address.setLine2(add.getAddressLine2Txt());
                    address.setState(add.getUSStateCd() != null ? add.getUSStateCd().name() : BUSINESS_STATE);
                    address.setZipCode(add.getUSZIPCd());
                    address.setZipPlus4(add.getUSZIPExtensionCd());
                } else {
                    ForeignAddressGrpType fadd = entry.getResponsibleIndividualGrp().getMailingAddressGrp().getForeignAddressGrp();
                    if (fadd != null) {
                        address.setCity(fadd.getCityNm());
                        address.setCountry(fadd.getCountryNm());
                        address.setLine1(fadd.getAddressLine1Txt());
                        address.setLine2(fadd.getAddressLine2Txt());
                        address.setPostalCode(fadd.getForeignPostalCd());
                        address.setProvince(fadd.getForeignProvinceNm());
                    }
                }
                submission.setAddress(address);
            }
            listing.add(submission);
        }
        return listing;
    }

    @Override
    public IRS1095B convertSingleEntry(IrsTransmissionLogData dataFile, int sequence) throws ServiceException {
        if (dataFile == null) {
            return new IRS1095B();
        }
        String xml = dataFile.getRequestData();
        Form1095BUpstreamDetailType entry = null;
        IRS1095B submission = null;
        MECPeriod period = new MECPeriod();
        HashMap<String, Boolean> coverageMonths = new HashMap<String, Boolean>();
        try {
            if (xml != null && !xml.isEmpty()) {
                Form109495BTrnsmtUpstreamType result = (Form109495BTrnsmtUpstreamType)JAXB.unmarshal((Reader)new StringReader(xml), Form109495BTrnsmtUpstreamType.class);
                List details = ((Form1094BUpstreamDetailType)result.getForm1094BUpstreamDetail().get(0)).getForm1095BUpstreamDetail();
                for (Form1095BUpstreamDetailType object : details) {
                    if (object.getRecordId().intValue() != sequence) continue;
                    entry = object;
                    break;
                }
                if (entry != null) {
                    submission = new IRS1095B();
                    SimpleAddress address = new SimpleAddress();
                    if (entry.getResponsibleIndividualGrp().getMailingAddressGrp() != null) {
                        USAddressGrpType add = entry.getResponsibleIndividualGrp().getMailingAddressGrp().getUSAddressGrp();
                        if (add != null && add.getUSStateCd() != null) {
                            address.setCity(add.getCityNm());
                            address.setLine1(add.getAddressLine1Txt());
                            address.setLine2(add.getAddressLine2Txt());
                            address.setState(add.getUSStateCd().name());
                            address.setZipCode(add.getUSZIPCd());
                            address.setZipPlus4(add.getUSZIPExtensionCd());
                        } else {
                            ForeignAddressGrpType fadd = entry.getResponsibleIndividualGrp().getMailingAddressGrp().getForeignAddressGrp();
                            if (fadd != null) {
                                address.setCity(fadd.getCityNm());
                                address.setCountry(fadd.getCountryNm());
                                address.setLine1(fadd.getAddressLine1Txt());
                                address.setLine2(fadd.getAddressLine2Txt());
                                address.setPostalCode(fadd.getForeignPostalCd());
                                address.setProvince(fadd.getForeignProvinceNm());
                            }
                        }
                        submission.setAddress(address);
                    }
                    period.setCoveredAll12Months(!((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualAnnualInd().equalsIgnoreCase("0"));
                    coverageMonths.put("1", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getJanuaryInd().equalsIgnoreCase("1"));
                    coverageMonths.put("2", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getFebruaryInd().equalsIgnoreCase("1"));
                    coverageMonths.put("3", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getMarchInd().equalsIgnoreCase("1"));
                    coverageMonths.put("4", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getAprilInd().equalsIgnoreCase("1"));
                    coverageMonths.put("5", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getMayInd().equalsIgnoreCase("1"));
                    coverageMonths.put("6", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getJuneInd().equalsIgnoreCase("1"));
                    coverageMonths.put("7", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getJulyInd().equalsIgnoreCase("1"));
                    coverageMonths.put("8", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getAugustInd().equalsIgnoreCase("1"));
                    coverageMonths.put("9", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getSeptemberInd().equalsIgnoreCase("1"));
                    coverageMonths.put("10", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getOctoberInd().equalsIgnoreCase("1"));
                    coverageMonths.put("11", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getNovemberInd().equalsIgnoreCase("1"));
                    coverageMonths.put("12", ((EmployerCoveredIndividualType)entry.getCoveredIndividualGrp().get(0)).getCoveredIndividualMonthlyIndGrp().getDecemberInd().equalsIgnoreCase("1"));
                    period.setCoverageMonths(coverageMonths);
                    submission.setMecPeriod(period);
                }
            }
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            String exceptionDetails = sw.toString();
            this.logger.error((Object)("Error converting XML data request to object: " + ex.getMessage() + exceptionDetails));
        }
        return submission;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public String getIrsProcessingCode() {
        return this.irsProcessingCode;
    }

    public void setIrsProcessingCode(String irsProcessingCode) {
        this.irsProcessingCode = irsProcessingCode;
    }

    public DAOOperations getGenericDAO() {
        return this.genericDAO;
    }

    public void setGenericDAO(DAOOperations genericDAO) {
        this.genericDAO = genericDAO;
    }

    public String getIrsSignatureFile() {
        return this.irsSignatureFile;
    }

    public void setIrsSignatureFile(String irsSignatureFile) {
        this.irsSignatureFile = irsSignatureFile;
    }

    public String getTransmissionControlCode() {
        return this.transmissionControlCode;
    }

    public void setTransmissionControlCode(String transmissionControlCode) {
        this.transmissionControlCode = transmissionControlCode;
    }

    public String getSoftwareId() {
        return this.softwareId;
    }

    public String getIrsContactFname() {
        return this.irsContactFname;
    }

    public void setIrsContactFname(String irsContactFname) {
        this.irsContactFname = irsContactFname;
    }

    public String getIrsContactLname() {
        return this.irsContactLname;
    }

    public void setIrsContactLname(String irsContactLname) {
        this.irsContactLname = irsContactLname;
    }

    public String getIrsContactPhone() {
        return this.irsContactPhone;
    }

    public void setIrsContactPhone(String irsContactPhone) {
        this.irsContactPhone = irsContactPhone;
    }

    public void setSoftwareId(String systemId) {
        this.softwareId = systemId;
    }

    private void setCommonHeader(IrsTransmissionLogEntry transmission, ACATrnsmtManifestReqDtlType headerManifest) {
        try {
            headerManifest.setPaymentYr(DatatypeFactory.newInstance().newXMLGregorianCalendar(transmission.getTaxYear()));
            Calendar prevYear = Calendar.getInstance();
            prevYear.add(1, -1);
            int curTaxYear = prevYear.get(1);
            if (Integer.valueOf(transmission.getTaxYear()) < curTaxYear) {
                headerManifest.setPriorYearDataInd("1");
            } else {
                headerManifest.setPriorYearDataInd("0");
            }
            if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                headerManifest.setEIN(AATS_EIN);
            } else {
                headerManifest.setEIN(EIN);
            }
            if (transmission.getCorrectionInd().equalsIgnoreCase(SUBMIT_ORIGINAL)) {
                headerManifest.setTransmissionTypeCd(TransmissionTypeCdType.O);
            } else if (transmission.getCorrectionInd().equalsIgnoreCase(SUBMIT_CORRECTION)) {
                headerManifest.setTransmissionTypeCd(TransmissionTypeCdType.C);
            } else {
                headerManifest.setTransmissionTypeCd(TransmissionTypeCdType.R);
            }
            headerManifest.setTestFileCd(this.getIrsProcessingCode());
            BusinessNameType busName = new BusinessNameType();
            if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                busName.setBusinessNameLine1Txt("WORKDEPARTMENT OF VETERANS AFFAIRS");
            } else {
                busName.setBusinessNameLine1Txt(LEGAL_NAME);
            }
            headerManifest.setTransmitterNameGrp(busName);
            OtherCompletePersonNameType name = new OtherCompletePersonNameType();
            name.setPersonFirstNm(this.getIrsContactFname());
            name.setPersonLastNm(this.getIrsContactLname());
            BusinessAddressGrpType busAddress = new BusinessAddressGrpType();
            USAddressGrpType us = new USAddressGrpType();
            us.setAddressLine1Txt(BUSINESS_STREET_ADDRESS);
            us.setCityNm(BUSINESS_CITY);
            us.setUSStateCd(StateType.fromValue((String)BUSINESS_STATE));
            us.setUSZIPCd(BUSINESS_ZIP);
            busAddress.setUSAddressGrp(us);
            busAddress.setForeignAddressGrp(null);
            CompanyInformationGrpType company = new CompanyInformationGrpType();
            if (this.getIrsProcessingCode().equalsIgnoreCase(TYPE_CODE)) {
                company.setCompanyNm("WORKDEPARTMENT OF VETERANS AFFAIRS");
            } else {
                company.setCompanyNm(LEGAL_NAME);
            }
            company.setContactNameGrp(name);
            company.setContactPhoneNum(this.getIrsContactPhone());
            company.setMailingAddressGrp(busAddress);
            headerManifest.setCompanyInformationGrp(company);
            VendorInformationGrpType inhouse = new VendorInformationGrpType();
            inhouse.setContactNameGrp(name);
            inhouse.setContactPhoneNum(this.getIrsContactPhone());
            inhouse.setVendorCd("I");
            headerManifest.setVendorInformationGrp(inhouse);
            headerManifest.setTotalPayerRecordCnt(PAYER_COUNT);
            headerManifest.setTotalPayeeRecordCnt(BigInteger.valueOf(transmission.getIrsTransmissionLogDetails().size()));
            headerManifest.setSoftwareId(this.getSoftwareId());
            headerManifest.setFormTypeCd(FORM_TYPE_CODE);
            headerManifest.setBinaryFormatCd(BinaryFormatCodeType.APPLICATION_XML);
        }
        catch (Exception e) {
            this.logger.error((Object)"Data Type Error in IRS Transmit: ", (Throwable)e);
        }
    }

    private void clientBulkRequestSetup(Client client) {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("ns1", "urn:us:gov:treasury:irs:msg:irsacabulkrequesttransmitter");
        nsMap.put("ns2", "urn:us:gov:treasury:irs:common");
        client.getRequestContext().put("soap.env.ns.map", nsMap);
        client.getRequestContext().put("mtom-enabled", Boolean.TRUE);
        client.getRequestContext().put("mtom-threshold", 100);
        client.getInInterceptors().add(new GZIPInInterceptor());
        client.getOutInterceptors().add(new GZIPOutInterceptor());
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setContentType("text/xml");
        httpClientPolicy.setAcceptEncoding("deflate");
        httpClientPolicy.setReceiveTimeout(300000L);
        httpClientPolicy.setConnectionTimeout(300000L);
        httpClientPolicy.setAutoRedirect(true);
        httpClientPolicy.setMaxRetransmits(5);
        http.setClient(httpClientPolicy);
    }

    private void addSignature(Client client, boolean busHeader, boolean timestamp, boolean manifest) {
        HashMap<String, String> signatureProps = new HashMap<String, String>();
        String sigparts = "";
        String businessElement = "";
        String statusBody = "";
        if (manifest) {
            businessElement = "{Element}{urn:us:gov:treasury:irs:msg:acabusinessheader}ACABusinessHeader;";
        } else {
            businessElement = "{Element}{urn:us:gov:treasury:irs:msg:irstransmitterstatusrequest}ACABusinessHeader;";
            statusBody = "{Element}{urn:us:gov:treasury:irs:msg:irstransmitterstatusrequest}ACABulkRequestTransmitterStatusDetailRequest;";
        }
        String timestampElement = "{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;";
        String manifestElement = "{Element}{urn:us:gov:treasury:irs:ext:aca:air:7.0}ACATransmitterManifestReqDtl;";
        if (busHeader) {
            sigparts = sigparts + businessElement;
        }
        if (timestamp) {
            sigparts = sigparts + timestampElement;
        }
        if (manifest) {
            sigparts = sigparts + manifestElement;
        }
        sigparts = sigparts + statusBody;
        signatureProps.put("action", "Timestamp Signature");
        signatureProps.put("user", "es-irs.va.gov");
        signatureProps.put("passwordCallbackClass", UTPasswordCallback.class.getName());
        signatureProps.put("signatureParts", sigparts);
        signatureProps.put("signatureAlgorithm", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        signatureProps.put("signatureKeyIdentifier", "X509KeyIdentifier");
        signatureProps.put("isBSPCompliant", "false");
        signatureProps.put("addInclusivePrefixes", "false");
        Properties cryptoProperties = new Properties();
        cryptoProperties.put("org.apache.ws.security.crypto.provider", "org.apache.ws.security.components.crypto.Merlin");
        cryptoProperties.put("org.apache.ws.security.crypto.merlin.keystore.password", System.getProperty("irs.sign.key"));
        cryptoProperties.put("org.apache.ws.security.crypto.merlin.file", this.getIrsSignatureFile());
        cryptoProperties.put("org.apache.ws.security.crypto.merlin.keystore.type", "jks");
        cryptoProperties.put("org.apache.ws.security.crypto.merlin.keystore.alias", "es-irs.va.gov");
        client.getRequestContext().put("cryptoProperties", cryptoProperties);
        client.getRequestContext().put("signaturePropRefId", "cryptoProperties");
        signatureProps.put("signaturePropRefId", "cryptoProperties");
        WSS4JOutInterceptor sec = new WSS4JOutInterceptor(signatureProps);
        client.getOutInterceptors().add(sec);
    }

    public String getClientSystemId() {
        return this.clientSystemId;
    }

    public void setClientSystemId(String clientSystemId) {
        this.clientSystemId = clientSystemId;
    }

    public String getTempFileLocation() {
        return this.tempFileLocation;
    }

    public void setTempFileLocation(String tempFileLocation) {
        this.tempFileLocation = tempFileLocation;
    }

    public String getIrsServiceBulkEndPoint() {
        return this.irsServiceBulkEndPoint;
    }

    public void setIrsServiceBulkEndPoint(String irsServiceBulkEndPoint) {
        this.irsServiceBulkEndPoint = irsServiceBulkEndPoint;
    }

    public String getIrsServiceStatusEndPoint() {
        return this.irsServiceStatusEndPoint;
    }

    public void setIrsServiceStatusEndPoint(String irsServiceStatusEndPoint) {
        this.irsServiceStatusEndPoint = irsServiceStatusEndPoint;
    }
}

